/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.tree;

import com.google.common.base.MoreObjects;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeLocation;
import io.prestosql.sql.tree.Statement;
import io.prestosql.sql.tree.Table;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class VacuumTable
extends Statement {
    private final Table table;
    private final boolean isFull;
    private final Optional<String> partition;
    private final boolean isAsync;

    public VacuumTable(Optional<NodeLocation> location, Table table, boolean isFull, Optional<String> partition, boolean isAsync) {
        super(location);
        this.table = Objects.requireNonNull(table, "table is null");
        this.isFull = isFull;
        this.partition = Objects.requireNonNull(partition, "partition is null");
        this.isAsync = isAsync;
    }

    public Table getTable() {
        return this.table;
    }

    public boolean isFull() {
        return this.isFull;
    }

    public boolean isAsync() {
        return this.isAsync;
    }

    public Optional<String> getPartition() {
        return this.partition;
    }

    @Override
    public List<? extends Node> getChildren() {
        return null;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.table, this.isFull, this.partition);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        VacuumTable o = (VacuumTable)obj;
        return Objects.equals(this.table, o.table) && this.isFull == o.isFull && Objects.equals(this.partition, o.partition);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("table", (Object)this.table).add("full", this.isFull).add("partition", this.partition).toString();
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitVacuumTable(this, context);
    }
}

