/*
 * Decompiled with CFR 0.152.
 */
package io.hetu.core.plugin.datacenter.pagesource;

import com.google.common.collect.ImmutableMap;
import io.airlift.log.Logger;
import io.prestosql.client.DataCenterClientSession;
import io.prestosql.client.DataCenterStatementClient;
import io.prestosql.spi.Page;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ConnectorPageSource;
import io.prestosql.spi.dynamicfilter.BloomFilterDynamicFilter;
import io.prestosql.spi.dynamicfilter.DynamicFilter;
import io.prestosql.spi.dynamicfilter.DynamicFilterSupplier;
import io.prestosql.spi.dynamicfilter.HashSetDynamicFilter;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import okhttp3.OkHttpClient;

public class DataCenterPageSource
implements ConnectorPageSource {
    private static final Logger LOGGER = Logger.get(DataCenterPageSource.class);
    private final long startTime;
    private final int numberOfColumns;
    private DataCenterStatementClient client;
    private long readBytes;
    private long lastMemoryUsage;
    private Queue<Page> pages = new LinkedList<Page>();
    private final Optional<DynamicFilterSupplier> dynamicFilterSupplier;
    private final Set<String> appliedDynamicFilters = new HashSet<String>();

    public DataCenterPageSource(OkHttpClient httpClient, DataCenterClientSession clientSession, String sql, String queryId, List<ColumnHandle> columns) {
        this(httpClient, clientSession, sql, queryId, columns, null);
    }

    public DataCenterPageSource(OkHttpClient httpClient, DataCenterClientSession clientSession, String sql, String queryId, List<ColumnHandle> columns, Optional<DynamicFilterSupplier> dynamicFilterSupplier) {
        this.startTime = System.nanoTime();
        this.client = DataCenterStatementClient.newStatementClient((OkHttpClient)httpClient, (DataCenterClientSession)clientSession, (String)sql, (String)queryId);
        this.numberOfColumns = columns.size();
        this.dynamicFilterSupplier = dynamicFilterSupplier;
    }

    public long getCompletedBytes() {
        return this.readBytes;
    }

    public long getReadTimeNanos() {
        return System.nanoTime() - this.startTime;
    }

    public boolean isFinished() {
        return this.pages.isEmpty() && !this.client.isRunning();
    }

    public Page getNextPage() {
        if (this.dynamicFilterSupplier.isPresent()) {
            this.applyDynamicFilters(this.dynamicFilterSupplier.get().getDynamicFilters());
        }
        if (!this.pages.isEmpty()) {
            return this.processPage(this.pages.poll());
        }
        if (this.client.isRunning()) {
            List pageList = this.client.getPages();
            if (pageList != null && !pageList.isEmpty()) {
                this.update(pageList);
                this.pages.addAll(pageList);
            }
            this.client.advance();
        }
        return null;
    }

    private void applyDynamicFilters(Map<ColumnHandle, DynamicFilter> dynamicFilters) {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (Map.Entry<ColumnHandle, DynamicFilter> entry : dynamicFilters.entrySet()) {
            if (this.appliedDynamicFilters.contains(entry.getKey().getColumnName())) continue;
            DynamicFilter df = entry.getValue();
            String columnName = entry.getKey().getColumnName();
            if (df instanceof HashSetDynamicFilter) {
                BloomFilterDynamicFilter bloomFilterDynamicFilter = BloomFilterDynamicFilter.fromHashSetDynamicFilter((HashSetDynamicFilter)((HashSetDynamicFilter)df));
                builder.put((Object)columnName, (Object)bloomFilterDynamicFilter.createSerializedBloomFilter());
                continue;
            }
            builder.put((Object)columnName, (Object)((BloomFilterDynamicFilter)df).getBloomFilterSerialized());
        }
        ImmutableMap newDynamicFilters = builder.build();
        if (!newDynamicFilters.isEmpty() && this.client.applyDynamicFilters((Map)newDynamicFilters)) {
            this.appliedDynamicFilters.addAll(newDynamicFilters.keySet());
        }
    }

    private Page processPage(Page page) {
        if (this.numberOfColumns == 0) {
            return new Page(page.getPositionCount(), new Block[0]);
        }
        return page;
    }

    private void update(List<Page> pageList) {
        long bytes = 0L;
        long memory = 0L;
        for (Page page : pageList) {
            bytes += page.getSizeInBytes();
            memory += page.getRetainedSizeInBytes();
        }
        this.readBytes += bytes;
        this.lastMemoryUsage = memory;
    }

    public long getSystemMemoryUsage() {
        return this.lastMemoryUsage;
    }

    public void close() throws IOException {
        this.client.close();
    }
}

