/*
 * Decompiled with CFR 0.152.
 */
package io.hetu.core.plugin.datacenter;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.hetu.core.plugin.datacenter.DataCenterColumn;
import io.hetu.core.plugin.datacenter.DataCenterColumnHandle;
import io.hetu.core.plugin.datacenter.DataCenterConfig;
import io.hetu.core.plugin.datacenter.DataCenterSqlQueryWriter;
import io.hetu.core.plugin.datacenter.DataCenterTable;
import io.hetu.core.plugin.datacenter.DataCenterTableHandle;
import io.hetu.core.plugin.datacenter.client.DataCenterClient;
import io.prestosql.spi.ErrorCodeSupplier;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.StandardErrorCode;
import io.prestosql.spi.connector.ColumnHandle;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.ConnectorMetadata;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.ConnectorTableMetadata;
import io.prestosql.spi.connector.ConnectorTableProperties;
import io.prestosql.spi.connector.Constraint;
import io.prestosql.spi.connector.LimitApplicationResult;
import io.prestosql.spi.connector.SchemaNotFoundException;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.connector.SchemaTablePrefix;
import io.prestosql.spi.connector.SubQueryApplicationResult;
import io.prestosql.spi.connector.TableNotFoundException;
import io.prestosql.spi.sql.SqlQueryWriter;
import io.prestosql.spi.statistics.TableStatistics;
import io.prestosql.spi.type.Type;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;

public class DataCenterMetadata
implements ConnectorMetadata {
    private static final int CATALOG_SPLIT_SIZE = 2;
    private static final int CATALOG_POSITION = 1;
    private final DataCenterClient dataCenterClient;
    private final boolean isQueryPushDownEnabled;
    private final long maxRemoteHeaderSize;

    public DataCenterMetadata(DataCenterClient dataCenterClient, DataCenterConfig dataCenterConfig) {
        this.dataCenterClient = Objects.requireNonNull(dataCenterClient, "client is null");
        this.isQueryPushDownEnabled = dataCenterConfig.isQueryPushDownEnabled();
        this.maxRemoteHeaderSize = dataCenterConfig.getRemoteHttpServerMaxRequestHeaderSize().toBytes();
    }

    private static String extractRemoteCatalog(ConnectorSession session) {
        if (!session.getCatalog().isPresent()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "catalog is not found in session");
        }
        String catalogName = (String)session.getCatalog().get();
        String[] subCatalogs = catalogName.split("\\.");
        if (subCatalogs.length == 2) {
            return subCatalogs[1];
        }
        return catalogName;
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return ImmutableList.copyOf(this.dataCenterClient.getSchemaNames(DataCenterMetadata.extractRemoteCatalog(session)));
    }

    public DataCenterTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        String catalog = DataCenterMetadata.extractRemoteCatalog(session);
        try {
            Set<String> tables = this.dataCenterClient.getTableNames(catalog, tableName.getSchemaName());
            if (!tables.contains(tableName.getTableName())) {
                return null;
            }
            return new DataCenterTableHandle(catalog, tableName.getSchemaName(), tableName.getTableName(), OptionalLong.empty());
        }
        catch (SchemaNotFoundException ex) {
            return null;
        }
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle tableHandle) {
        SchemaTableName schemaTableName = ((DataCenterTableHandle)tableHandle).toSchemaTableName();
        DataCenterTable table = this.dataCenterClient.getTable(DataCenterMetadata.extractRemoteCatalog(session), schemaTableName.getSchemaName(), schemaTableName.getTableName());
        if (table == null) {
            throw new TableNotFoundException(schemaTableName);
        }
        return new ConnectorTableMetadata(schemaTableName, table.getColumnsMetadata());
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> optionalSchemaName) {
        Set schemaNames = (Set)optionalSchemaName.map(ImmutableSet::of).orElseGet(() -> ImmutableSet.copyOf(this.dataCenterClient.getSchemaNames(DataCenterMetadata.extractRemoteCatalog(session))));
        String catalogName = DataCenterMetadata.extractRemoteCatalog(session);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String schemaName : schemaNames) {
            for (String tableName : this.dataCenterClient.getTableNames(catalogName, schemaName)) {
                builder.add((Object)new SchemaTableName(schemaName, tableName));
            }
        }
        return builder.build();
    }

    private List<SchemaTableName> listTables(ConnectorSession session, SchemaTablePrefix prefix) {
        if (!prefix.getTable().isPresent()) {
            return this.listTables(session, prefix.getSchema());
        }
        return ImmutableList.of((Object)prefix.toSchemaTableName());
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        DataCenterTableHandle dataCenterTableHandle = (DataCenterTableHandle)tableHandle;
        DataCenterTable table = this.dataCenterClient.getTable(DataCenterMetadata.extractRemoteCatalog(session), dataCenterTableHandle.getSchemaName(), dataCenterTableHandle.getTableName());
        if (table == null) {
            throw new TableNotFoundException(dataCenterTableHandle.toSchemaTableName());
        }
        ImmutableMap.Builder columnHandles = ImmutableMap.builder();
        int index = 0;
        for (ColumnMetadata column : table.getColumnsMetadata()) {
            columnHandles.put((Object)column.getName(), (Object)new DataCenterColumnHandle(column.getName(), column.getType(), index));
            ++index;
        }
        return columnHandles.build();
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        ImmutableMap.Builder columns = ImmutableMap.builder();
        String catalog = DataCenterMetadata.extractRemoteCatalog(session);
        for (SchemaTableName tableName : this.listTables(session, prefix)) {
            DataCenterTable table = this.dataCenterClient.getTable(catalog, tableName.getSchemaName(), tableName.getTableName());
            if (table == null) continue;
            columns.put((Object)tableName, table.getColumnsMetadata());
        }
        return columns.build();
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        return ((DataCenterColumnHandle)columnHandle).getColumnMetadata();
    }

    public boolean usesLegacyTableLayouts() {
        return false;
    }

    public ConnectorTableProperties getTableProperties(ConnectorSession session, ConnectorTableHandle table) {
        return new ConnectorTableProperties();
    }

    public Optional<LimitApplicationResult<ConnectorTableHandle>> applyLimit(ConnectorSession session, ConnectorTableHandle table, long limit) {
        DataCenterTableHandle handle = (DataCenterTableHandle)table;
        if (handle.getLimit().isPresent() && handle.getLimit().getAsLong() <= limit) {
            return Optional.empty();
        }
        handle = new DataCenterTableHandle(handle.getCatalogName(), handle.getSchemaName(), handle.getTableName(), OptionalLong.of(limit));
        return Optional.of(new LimitApplicationResult((Object)handle, true));
    }

    public Optional<SubQueryApplicationResult<ConnectorTableHandle>> applySubQuery(ConnectorSession session, ConnectorTableHandle handle, String subQuery, Map<String, Type> types) {
        if (!this.isQueryPushDownEnabled || (long)subQuery.getBytes(StandardCharsets.ISO_8859_1).length >= this.maxRemoteHeaderSize) {
            return Optional.empty();
        }
        Objects.requireNonNull(subQuery, "cannot apply null sub-query");
        DataCenterTableHandle tableHandle = (DataCenterTableHandle)handle;
        List<DataCenterColumn> columns = this.dataCenterClient.getColumns(subQuery);
        if (columns.isEmpty()) {
            return Optional.empty();
        }
        DataCenterTableHandle newTableHandle = new DataCenterTableHandle(tableHandle.getCatalogName(), tableHandle.getSchemaName(), tableHandle.getTableName(), OptionalLong.empty(), subQuery);
        ImmutableMap.Builder columnHandleBuilder = new ImmutableMap.Builder();
        ImmutableMap.Builder typesBuilder = new ImmutableMap.Builder();
        columns.forEach(column -> {
            columnHandleBuilder.put((Object)column.getName(), (Object)new DataCenterColumnHandle(column.getName(), column.getType(), 0));
            typesBuilder.put((Object)column.getName(), (Object)column.getType());
        });
        return Optional.of(new SubQueryApplicationResult((Object)newTableHandle, (Map)columnHandleBuilder.build(), (Map)typesBuilder.build()));
    }

    public Optional<SqlQueryWriter> getSqlQueryWriter() {
        if (!this.isQueryPushDownEnabled) {
            return Optional.empty();
        }
        return Optional.of(new DataCenterSqlQueryWriter());
    }

    public TableStatistics getTableStatistics(ConnectorSession session, ConnectorTableHandle tableHandle, Constraint constraint) {
        Map<String, ColumnHandle> columnHandles = this.getColumnHandles(session, tableHandle);
        String tableFullName = tableHandle.getSchemaPrefixedTableName();
        return this.dataCenterClient.getTableStatistics(tableFullName, columnHandles);
    }

    public boolean isExecutionPlanCacheSupported(ConnectorSession session, ConnectorTableHandle handle) {
        return true;
    }
}

