/*
 * Decompiled with CFR 0.152.
 */
package io.hetu.core.plugin.datacenter;

import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import io.airlift.security.pem.PemReader;
import io.hetu.core.plugin.datacenter.DataCenterConfig;
import io.hetu.core.plugin.datacenter.client.DataCenterClient;
import io.hetu.core.plugin.datacenter.client.DataCenterStatementClientFactory;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.prestosql.plugin.tpch.TpchPlugin;
import io.prestosql.server.testing.TestingPrestoServer;
import io.prestosql.spi.Plugin;
import io.prestosql.spi.PrestoException;
import io.prestosql.spi.type.TypeManager;
import io.prestosql.spi.type.testing.TestingTypeManager;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.PrivateKey;
import java.sql.SQLException;
import java.util.Base64;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import okhttp3.OkHttpClient;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestDataCenterClientAuth {
    private TypeManager typeManager = new TestingTypeManager();
    private TestingPrestoServer server;
    private byte[] defaultKey;
    private byte[] hmac222;
    private PrivateKey privateKey33;

    @BeforeClass
    public void setup() throws Exception {
        URL resource = this.getClass().getClassLoader().getResource("33.privateKey");
        Assert.assertNotNull((Object)resource, (String)"key directory not found");
        File keyDir = new File(resource.getFile()).getAbsoluteFile().getParentFile();
        this.defaultKey = Base64.getMimeDecoder().decode(Files.asCharSource((File)new File(keyDir, "default-key.key"), (Charset)StandardCharsets.US_ASCII).read().getBytes(StandardCharsets.US_ASCII));
        this.hmac222 = Base64.getMimeDecoder().decode(Files.asCharSource((File)new File(keyDir, "222.key"), (Charset)StandardCharsets.US_ASCII).read().getBytes(StandardCharsets.US_ASCII));
        this.privateKey33 = PemReader.loadPrivateKey((File)new File(keyDir, "33.privateKey"), Optional.empty());
        this.server = new TestingPrestoServer((Map)ImmutableMap.builder().put((Object)"http-server.authentication.type", (Object)"JWT").put((Object)"http.authentication.jwt.key-file", (Object)new File(keyDir, "${KID}.key").toString()).put((Object)"http-server.https.enabled", (Object)"true").put((Object)"http-server.https.keystore.path", (Object)Resources.getResource((String)"localhost.keystore").getPath()).put((Object)"http-server.https.keystore.key", (Object)"changeit").build());
        this.server.installPlugin((Plugin)new TpchPlugin());
        this.server.createCatalog("tpch", "tpch");
    }

    @AfterClass(alwaysRun=true)
    public void teardown() throws IOException {
        this.server.close();
    }

    @Test
    public void testSuccessDefaultKey() throws SQLException {
        String accessToken = Jwts.builder().setSubject("test").signWith(SignatureAlgorithm.HS512, this.defaultKey).compact();
        this.assertToken(accessToken);
    }

    @Test
    public void testSuccessHmac() throws SQLException {
        String accessToken = Jwts.builder().setSubject("test").setHeaderParam("kid", (Object)"222").signWith(SignatureAlgorithm.HS512, this.hmac222).compact();
        this.assertToken(accessToken);
    }

    @Test
    public void testSuccessPublicKey() throws SQLException {
        String accessToken = Jwts.builder().setSubject("test").setHeaderParam("kid", (Object)"33").signWith(SignatureAlgorithm.RS256, (Key)this.privateKey33).compact();
        this.assertToken(accessToken);
    }

    @Test(expectedExceptions={PrestoException.class}, expectedExceptionsMessageRegExp="tpch not found, failed to get schema names")
    public void testFailedNoToken() throws SQLException {
        this.assertToken(null);
    }

    @Test(expectedExceptions={PrestoException.class}, expectedExceptionsMessageRegExp="tpch not found, failed to get schema names")
    public void testFailedUnsigned() throws SQLException {
        String accessToken = Jwts.builder().setSubject("test").compact();
        this.assertToken(accessToken);
    }

    @Test(expectedExceptions={PrestoException.class}, expectedExceptionsMessageRegExp="tpch not found, failed to get schema names")
    public void testFailedBadHmacSignature() throws Exception {
        String accessToken = Jwts.builder().setSubject("test").signWith(SignatureAlgorithm.HS512, Base64.getEncoder().encodeToString("bad-key".getBytes(StandardCharsets.US_ASCII))).compact();
        this.assertToken(accessToken);
    }

    @Test(expectedExceptions={PrestoException.class}, expectedExceptionsMessageRegExp="tpch not found, failed to get schema names")
    public void testFailedWrongPublicKey() throws Exception {
        String accessToken = Jwts.builder().setSubject("test").setHeaderParam("kid", (Object)"42").signWith(SignatureAlgorithm.RS256, (Key)this.privateKey33).compact();
        this.assertToken(accessToken);
    }

    @Test(expectedExceptions={PrestoException.class}, expectedExceptionsMessageRegExp="tpch not found, failed to get schema names")
    public void testFailedUnknownPublicKey() throws Exception {
        String accessToken = Jwts.builder().setSubject("test").setHeaderParam("kid", (Object)"unknown").signWith(SignatureAlgorithm.RS256, (Key)this.privateKey33).compact();
        this.assertToken(accessToken);
    }

    private void assertToken(String accessToken) throws SQLException {
        String serverUri = "https://localhost:" + this.server.getHttpsAddress().getPort();
        DataCenterConfig config = new DataCenterConfig().setConnectionUrl(URI.create(serverUri)).setConnectionUser("test").setSsl(true).setAccessToken(accessToken).setSslTrustStorePath(Resources.getResource((String)"localhost.truststore").getPath()).setSslTrustStorePassword("changeit");
        OkHttpClient httpClient = DataCenterStatementClientFactory.newHttpClient((DataCenterConfig)config);
        try {
            DataCenterClient client = new DataCenterClient(config, httpClient, this.typeManager);
            Set schemaNames = client.getSchemaNames("tpch");
            Assert.assertTrue((boolean)schemaNames.contains("tiny"));
            Assert.assertEquals((int)schemaNames.size(), (int)9);
        }
        catch (Throwable t) {
            if (t.getCause() instanceof SQLException) {
                throw (SQLException)t.getCause();
            }
            throw t;
        }
        finally {
            httpClient.dispatcher().executorService().shutdown();
            httpClient.connectionPool().evictAll();
        }
    }
}

