/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.builder.test;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import io.airlift.concurrent.MoreFutures;
import io.prestosql.plugin.jdbc.BaseJdbcClient;
import io.prestosql.plugin.jdbc.BaseJdbcConfig;
import io.prestosql.plugin.jdbc.DriverConnectionFactory;
import io.prestosql.plugin.jdbc.JdbcClient;
import io.prestosql.plugin.jdbc.JdbcColumnHandle;
import io.prestosql.plugin.jdbc.JdbcHandleResolver;
import io.prestosql.plugin.jdbc.JdbcIdentity;
import io.prestosql.plugin.jdbc.JdbcMetadata;
import io.prestosql.plugin.jdbc.JdbcRecordSetProvider;
import io.prestosql.plugin.jdbc.JdbcSplit;
import io.prestosql.plugin.jdbc.JdbcSplitManager;
import io.prestosql.plugin.jdbc.JdbcTableHandle;
import io.prestosql.spi.connector.Connector;
import io.prestosql.spi.connector.ConnectorContext;
import io.prestosql.spi.connector.ConnectorFactory;
import io.prestosql.spi.connector.ConnectorHandleResolver;
import io.prestosql.spi.connector.ConnectorMetadata;
import io.prestosql.spi.connector.ConnectorRecordSetProvider;
import io.prestosql.spi.connector.ConnectorSession;
import io.prestosql.spi.connector.ConnectorSplitManager;
import io.prestosql.spi.connector.ConnectorSplitSource;
import io.prestosql.spi.connector.ConnectorTransactionHandle;
import io.prestosql.spi.connector.NotPartitionedPartitionHandle;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.sql.SqlQueryWriter;
import io.prestosql.spi.transaction.IsolationLevel;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.function.Function;

public final class InMemoryJdbcDatabase
implements AutoCloseable {
    private final Connection connection;
    private final JdbcClient jdbcClient;
    private final String schemaName;
    private final ConnectorFactory connectorFactory;

    public InMemoryJdbcDatabase(Driver driver, String connectionUrl, String connectorName, String schemaName, SqlQueryWriter queryWriter) throws SQLException {
        this(driver, connectionUrl, connectorName, schemaName, queryWriter, new BaseJdbcConfig(), new Properties());
    }

    public InMemoryJdbcDatabase(Driver driver, String connectionUrl, String connectorName, String schemaName, SqlQueryWriter queryWriter, BaseJdbcConfig baseJdbcConfig, Properties connectionProperties) throws SQLException {
        this.schemaName = schemaName;
        this.jdbcClient = new InMemoryJdbcClient(baseJdbcConfig, driver, connectionUrl, queryWriter, connectionProperties);
        this.connection = DriverManager.getConnection(connectionUrl, connectionProperties);
        this.connectorFactory = new InMemoryJdbcConnectorFactory(this.jdbcClient, connectorName);
    }

    public void createTables() throws SQLException {
        this.connection.createStatement().execute("CREATE SCHEMA " + this.schemaName);
        this.connection.createStatement().execute("CREATE TABLE " + this.schemaName + ".orders (orderkey bigint NOT NULL, custkey bigint NOT NULL, orderstatus varchar(1) NOT NULL, totalprice DOUBLE NOT NULL, orderdate date NOT NULL, orderpriority varchar(15) NOT NULL, clerk varchar(15) NOT NULL, shippriority integer NOT NULL, COMMENT varchar(79) NOT NULL) ");
        this.connection.createStatement().execute("CREATE TABLE " + this.schemaName + ".customer (custkey bigint NOT NULL, name varchar(25) NOT NULL, address varchar(40) NOT NULL, nationkey bigint NOT NULL, phone varchar(15) NOT NULL, acctbal DOUBLE NOT NULL, mktsegment varchar(10) NOT NULL, COMMENT varchar(117) NOT NULL) ");
        this.connection.createStatement().execute("CREATE TABLE " + this.schemaName + ".supplier (suppkey bigint NOT NULL, name varchar(25) NOT NULL, address varchar(40) NOT NULL, nationkey bigint NOT NULL, phone varchar(15) NOT NULL, acctbal DOUBLE NOT NULL, COMMENT varchar(101) NOT NULL) ");
        this.connection.createStatement().execute("CREATE TABLE " + this.schemaName + ".region (regionkey bigint NOT NULL, name varchar(25) NOT NULL, COMMENT varchar(152) NOT NULL) ");
        this.connection.createStatement().execute("CREATE TABLE " + this.schemaName + ".lineitem (orderkey bigint NOT NULL, partkey bigint NOT NULL, suppkey bigint NOT NULL, linenumber integer NOT NULL, quantity DOUBLE NOT NULL, extendedprice DOUBLE NOT NULL, discount DOUBLE NOT NULL, tax DOUBLE NOT NULL, returnflag varchar(1) NOT NULL, linestatus varchar(1) NOT NULL, shipdate date NOT NULL, commitdate date NOT NULL, receiptdate date NOT NULL, shipinstruct varchar(25) NOT NULL, shipmode varchar(10) NOT NULL, COMMENT varchar(44) NOT NULL) ");
        this.connection.createStatement().execute("CREATE TABLE " + this.schemaName + ".nation (nationkey bigint NOT NULL, name varchar(25) NOT NULL, regionkey bigint NOT NULL, COMMENT varchar(152) NOT NULL) ");
        this.connection.createStatement().execute("CREATE TABLE " + this.schemaName + ".part (partkey bigint NOT NULL, name varchar(55) NOT NULL, mfgr varchar(25) NOT NULL, brand varchar(10) NOT NULL, TYPE varchar(25) NOT NULL, SIZE integer NOT NULL, container varchar(10) NOT NULL, retailprice DOUBLE NOT NULL, COMMENT varchar(23) NOT NULL) ");
        this.connection.createStatement().execute("CREATE TABLE " + this.schemaName + ".partsupp (partkey bigint NOT NULL, suppkey bigint NOT NULL, availqty integer NOT NULL, supplycost DOUBLE NOT NULL, COMMENT varchar(199) NOT NULL)");
        this.connection.commit();
    }

    @Override
    public void close() throws SQLException {
        this.connection.close();
    }

    public Connection getConnection() {
        return this.connection;
    }

    public JdbcClient getJdbcClient() {
        return this.jdbcClient;
    }

    public ConnectorFactory getConnectorFactory() {
        return this.connectorFactory;
    }

    public JdbcTableHandle getTableHandle(ConnectorSession session, SchemaTableName table) {
        return this.jdbcClient.getTableHandle(JdbcIdentity.from(session), table).orElseThrow(() -> new IllegalArgumentException("table not found: " + table));
    }

    public JdbcSplit getSplit(ConnectorSession session, JdbcTableHandle table) {
        ConnectorSplitSource splits = this.jdbcClient.getSplits(JdbcIdentity.from(session), table);
        return (JdbcSplit)Iterables.getOnlyElement((Iterable)((ConnectorSplitSource.ConnectorSplitBatch)MoreFutures.getFutureValue((Future)splits.getNextBatch(NotPartitionedPartitionHandle.NOT_PARTITIONED, 1000))).getSplits());
    }

    public Map<String, JdbcColumnHandle> getColumnHandles(ConnectorSession session, JdbcTableHandle table) {
        return (Map)this.jdbcClient.getColumns(session, table).stream().collect(ImmutableMap.toImmutableMap(column -> column.getColumnMetadata().getName(), Function.identity()));
    }

    private static class InMemoryJdbcClient
    extends BaseJdbcClient {
        private final SqlQueryWriter sqlQueryWriter;

        public InMemoryJdbcClient(BaseJdbcConfig baseJdbcConfig, Driver driver, String connectionUrl, SqlQueryWriter sqlQueryWriter, Properties properties) {
            super(baseJdbcConfig, "\"", new DriverConnectionFactory(driver, connectionUrl, Optional.empty(), Optional.empty(), properties));
            this.sqlQueryWriter = sqlQueryWriter;
        }

        @Override
        public Optional<SqlQueryWriter> getSqlQueryWriter() {
            return Optional.ofNullable(this.sqlQueryWriter);
        }
    }

    private static class InMemoryJdbcConnectorFactory
    implements ConnectorFactory {
        private final JdbcClient jdbcClient;
        private final String name;

        private InMemoryJdbcConnectorFactory(JdbcClient jdbcClient, String name) {
            this.jdbcClient = jdbcClient;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public ConnectorHandleResolver getHandleResolver() {
            return new JdbcHandleResolver();
        }

        public Connector create(String catalogName, Map<String, String> config, ConnectorContext context) {
            return new Connector(){

                public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly) {
                    return new ConnectorTransactionHandle(){};
                }

                public ConnectorMetadata getMetadata(ConnectorTransactionHandle transactionHandle) {
                    return new JdbcMetadata(jdbcClient, false);
                }

                public ConnectorSplitManager getSplitManager() {
                    return new JdbcSplitManager(jdbcClient);
                }

                public ConnectorRecordSetProvider getRecordSetProvider() {
                    return new JdbcRecordSetProvider(jdbcClient);
                }
            };
        }
    }
}

