/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.builder.functioncall;

import io.prestosql.sql.builder.functioncall.FunctionWriterManager;
import io.prestosql.sql.builder.functioncall.functions.FunctionCallRewriter;
import io.prestosql.sql.builder.functioncall.functions.config.DefaultConnectorConfigFunctionRewriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class FunctionWriterManagerGroup {
    private static final Map<String, FunctionWriterManager> factoryInstances = new HashMap<String, FunctionWriterManager>(Collections.emptyMap());

    private FunctionWriterManagerGroup() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Optional<FunctionWriterManager> getFunctionWriterManagerInstance(String connectorName, String version) {
        Class<FunctionWriterManagerGroup> clazz = FunctionWriterManagerGroup.class;
        synchronized (FunctionWriterManagerGroup.class) {
            if (factoryInstances.containsKey(version)) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return Optional.of(factoryInstances.get(version));
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return Optional.empty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FunctionWriterManager newFunctionWriterManagerInstance(String connectorName, String version, Map<String, FunctionCallRewriter> functionCallRewriterMap, DefaultConnectorConfigFunctionRewriter connectorConfigFunctionRewriter) {
        Objects.requireNonNull(connectorName);
        Objects.requireNonNull(version);
        Objects.requireNonNull(connectorConfigFunctionRewriter);
        FunctionWriterManager instance = factoryInstances.get(version);
        if (instance != null) return instance;
        Class<FunctionWriterManagerGroup> clazz = FunctionWriterManagerGroup.class;
        synchronized (FunctionWriterManagerGroup.class) {
            if (factoryInstances.containsKey(version)) return factoryInstances.get(version);
            instance = new FunctionWriterManager(connectorName, version, functionCallRewriterMap, connectorConfigFunctionRewriter);
            factoryInstances.put(version, instance);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return instance;
        }
    }
}

