/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.builder;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.prestosql.spi.block.SortOrder;
import io.prestosql.spi.sql.SqlQueryWriter;
import io.prestosql.spi.sql.expression.Operators;
import io.prestosql.spi.sql.expression.OrderBy;
import io.prestosql.spi.sql.expression.QualifiedName;
import io.prestosql.spi.sql.expression.Selection;
import io.prestosql.spi.sql.expression.Time;
import io.prestosql.spi.sql.expression.Types;
import io.prestosql.sql.ExpressionFormatter;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;

public class BaseSqlQueryWriter
implements SqlQueryWriter {
    private static final String INTERNAL_FUNCTION_PREFIX = "$";
    private static final String DYNAMIC_FILTER_FUNCTION_NAME = "$internal$dynamic_filter_function";
    private final ThreadLocal<DecimalFormat> doubleFormatter = ThreadLocal.withInitial(() -> new DecimalFormat("0.###################E0###", new DecimalFormatSymbols(Locale.US)));
    private final Map<String, Integer> blacklistedFunctions;

    public BaseSqlQueryWriter() {
        this(Collections.emptyMap());
    }

    public BaseSqlQueryWriter(Map<String, Integer> blacklistedFunctions) {
        Objects.requireNonNull(blacklistedFunctions, "supportingFunctions cannot be null");
        this.blacklistedFunctions = blacklistedFunctions;
    }

    public String row(List<String> expressions) {
        return "ROW (" + Joiner.on((String)", ").join(expressions) + ")";
    }

    public String atTimeZone(String value, String timezone) {
        return value + " AT TIME ZONE " + timezone;
    }

    public String currentUser() {
        throw new UnsupportedOperationException("Cannot push CURRENT_USER to remote database");
    }

    public String currentPath() {
        throw new UnsupportedOperationException("Cannot push CURRENT_PATH to remote database");
    }

    public String currentTime(Time.Function function, Integer precision) {
        throw new UnsupportedOperationException("Cannot push current time functions to remote database");
    }

    public String extract(String expression, Time.ExtractField field) {
        return "EXTRACT(" + field + " FROM " + expression + ")";
    }

    public String booleanLiteral(boolean value) {
        return String.valueOf(value);
    }

    public String stringLiteral(String value) {
        return this.formatStringLiteral(value);
    }

    public String charLiteral(String value) {
        return "CHAR " + this.formatStringLiteral(value);
    }

    public String binaryLiteral(String hexValue) {
        return "X'" + hexValue + "'";
    }

    public String parameter(Optional<List<String>> parameters, int position) {
        if (parameters.isPresent()) {
            Preconditions.checkArgument((position < parameters.get().size() ? 1 : 0) != 0, (String)"Invalid parameter number %s.  Max value is %s", (int)position, (int)(parameters.get().size() - 1));
            return parameters.get().get(position);
        }
        return "?";
    }

    public String arrayConstructor(List<String> values) {
        return "ARRAY[" + Joiner.on((String)",").join(values) + "]";
    }

    public String subscriptExpression(String base, String index) {
        return base + "[" + index + "]";
    }

    public String longLiteral(long value) {
        return Long.toString(value);
    }

    public String doubleLiteral(double value) {
        return this.doubleFormatter.get().format(value);
    }

    public String decimalLiteral(String value) {
        return "DECIMAL '" + value + "'";
    }

    public String genericLiteral(String type, String value) {
        return type + " " + this.formatStringLiteral(value);
    }

    public String timeLiteral(String value) {
        return "TIME '" + value + "'";
    }

    public String timestampLiteral(String value) {
        return "TIMESTAMP '" + value + "'";
    }

    public String nullLiteral() {
        return "null";
    }

    public String intervalLiteral(Time.IntervalSign signLiteral, String value, Time.IntervalField startField, Optional<Time.IntervalField> endField) {
        String sign = signLiteral == Time.IntervalSign.NEGATIVE ? " - " : " ";
        StringBuilder builder = new StringBuilder().append("INTERVAL").append(sign).append("'").append(value).append("' ").append(startField);
        endField.ifPresent(field -> builder.append(" TO ").append(field));
        return builder.toString();
    }

    public String subqueryExpression(String query) {
        return "(" + query + ")";
    }

    public String exists(String subquery) {
        return "(EXISTS " + subquery + ")";
    }

    public String identifier(String value, boolean delimited) {
        if (!delimited) {
            return value;
        }
        return '\"' + value.replace("\"", "\"\"") + '\"';
    }

    public String lambdaArgumentDeclaration(String identifier) {
        return identifier;
    }

    public String dereferenceExpression(String base, String field) {
        return base + "." + field;
    }

    public String fieldReference(int fieldIndex) {
        return ":input(" + fieldIndex + ")";
    }

    public String functionCall(QualifiedName name, boolean distinct, List<String> argumentsList, Optional<String> orderBy, Optional<String> filter, Optional<String> window) {
        String functionName = this.formatQualifiedName(name);
        if (this.isBlacklistedFunction(functionName, argumentsList.size())) {
            if (DYNAMIC_FILTER_FUNCTION_NAME.equals(name.toString())) {
                return "true";
            }
            throw new UnsupportedOperationException("The connector does not support the function " + functionName);
        }
        StringBuilder builder = new StringBuilder();
        String arguments = this.joinExpressions(argumentsList);
        if (argumentsList.isEmpty() && "count".equalsIgnoreCase(name.getSuffix())) {
            arguments = "*";
        }
        if (distinct) {
            arguments = "DISTINCT " + arguments;
        }
        builder.append(this.formatQualifiedName(name)).append('(').append(arguments);
        orderBy.ifPresent(exp -> builder.append(' ').append((String)exp));
        builder.append(')');
        filter.ifPresent(exp -> builder.append(" FILTER ").append((String)exp));
        window.ifPresent(exp -> builder.append(" OVER ").append((String)exp));
        return builder.toString();
    }

    public String lambdaExpression(List<String> arguments, String body) {
        StringBuilder builder = new StringBuilder();
        builder.append('(');
        Joiner.on((String)", ").appendTo(builder, arguments);
        builder.append(") -> ");
        builder.append(body);
        return builder.toString();
    }

    public String bindExpression(List<String> values, String function) {
        return "\"$INTERNAL$BIND\"(" + Joiner.on((String)", ").join(values) + function + '(';
    }

    public String logicalBinaryExpression(Operators.LogicalOperator operator, String left, String right) {
        return this.formatBinaryExpression(operator.toString(), left, right);
    }

    public String notExpression(String value) {
        return "(NOT " + value + ")";
    }

    public String comparisonExpression(Operators.ComparisonOperator operator, String left, String right) {
        return this.formatBinaryExpression(operator.getValue(), left, right);
    }

    public String isNullPredicate(String value) {
        return "(" + value + " IS NULL)";
    }

    public String isNotNullPredicate(String value) {
        return "(" + value + " IS NOT NULL)";
    }

    public String nullIfExpression(String first, String second) {
        return "NULLIF(" + first + ", " + second + ')';
    }

    public String ifExpression(String condition, String trueValue, Optional<String> falseValue) {
        StringBuilder builder = new StringBuilder();
        builder.append("IF(").append(condition).append(", ").append(trueValue);
        falseValue.ifPresent(value -> builder.append(", ").append((String)value));
        builder.append(")");
        return builder.toString();
    }

    public String tryExpression(String innerExpression) {
        return "TRY(" + innerExpression + ")";
    }

    public String coalesceExpression(List<String> operands) {
        return "COALESCE(" + this.joinExpressions(operands) + ")";
    }

    public String arithmeticUnary(Operators.Sign sign, String value) {
        switch (sign) {
            case MINUS: {
                String separator = value.startsWith("-") ? " " : "";
                return "-" + separator + value;
            }
            case PLUS: {
                return "+" + value;
            }
        }
        throw new UnsupportedOperationException("Unsupported sign: " + sign);
    }

    public String arithmeticBinary(Operators.ArithmeticOperator operator, String left, String right) {
        return this.formatBinaryExpression(operator.getValue(), left, right);
    }

    public String likePredicate(String value, String pattern, Optional<String> escape) {
        StringBuilder builder = new StringBuilder();
        builder.append('(').append(value).append(" LIKE ").append(pattern);
        escape.ifPresent(val -> builder.append(" ESCAPE ").append((String)val));
        builder.append(')');
        return builder.toString();
    }

    public String allColumns(Optional<QualifiedName> prefix) {
        return prefix.map(name -> name + ".*").orElse("*");
    }

    public String cast(String expression, String type, boolean safe, boolean typeOnly) {
        return (safe ? "TRY_CAST" : "CAST") + "(" + expression + " AS " + this.toNativeType(type) + ")";
    }

    public String searchedCaseExpression(List<String> whenCaluses, Optional<String> defaultValue) {
        ImmutableList.Builder parts = ImmutableList.builder();
        parts.add((Object)"CASE");
        parts.addAll(whenCaluses);
        defaultValue.ifPresent(value -> parts.add((Object)"ELSE").add(value));
        parts.add((Object)"END");
        return "(" + Joiner.on((char)' ').join((Iterable)parts.build()) + ")";
    }

    public String simpleCaseExpression(String operand, List<String> whenCaluses, Optional<String> defaultValue) {
        ImmutableList.Builder parts = ImmutableList.builder();
        parts.add((Object)"CASE").add((Object)operand);
        parts.addAll(whenCaluses);
        defaultValue.ifPresent(value -> parts.add((Object)"ELSE").add(value));
        parts.add((Object)"END");
        return "(" + Joiner.on((char)' ').join((Iterable)parts.build()) + ")";
    }

    public String whenClause(String operand, String result) {
        return "WHEN " + operand + " THEN " + result;
    }

    public String betweenPredicate(String value, String min, String max) {
        return "(" + value + " BETWEEN " + min + " AND " + max + ")";
    }

    public String inPredicate(String value, String valueList) {
        return "(" + value + " IN " + valueList + ")";
    }

    public String inListExpression(List<String> values) {
        return "(" + this.joinExpressions(values) + ")";
    }

    public String filter(String value) {
        if ("false".equals(value)) {
            return "(WHERE 1=0)";
        }
        if ("true".equals(value)) {
            return "(WHERE 1=1)";
        }
        return "(WHERE " + value + ')';
    }

    public String groupByIdElement(List<List<String>> groSets) {
        ArrayList<List<String>> bewGroSet = new ArrayList<List<String>>();
        for (int i = groSets.size() - 1; i >= 0; --i) {
            bewGroSet.add(groSets.get(i));
        }
        return ((Object)bewGroSet).toString().replace('[', '(').replace(']', ')');
    }

    public String formatWindowColumn(String functionName, List<String> args, String windows) {
        String signatureStr = this.functionCall(new QualifiedName(Collections.singletonList(functionName)), false, args, Optional.empty(), Optional.empty(), Optional.empty());
        return " " + signatureStr + " OVER " + windows;
    }

    public String window(List<String> partitionBy, Optional<String> orderBy, Optional<String> frame) {
        ArrayList<String> parts = new ArrayList<String>();
        if (!partitionBy.isEmpty()) {
            parts.add("PARTITION BY " + this.joinExpressions(partitionBy));
        }
        orderBy.ifPresent(parts::add);
        frame.ifPresent(parts::add);
        return '(' + Joiner.on((char)' ').join(parts) + ')';
    }

    public String windowFrame(Types.WindowFrameType type, String start, Optional<String> end) {
        StringBuilder builder = new StringBuilder();
        builder.append(type.toString()).append(' ');
        if (end.isPresent()) {
            builder.append("BETWEEN ").append(start).append(" AND ").append(end.get());
        } else {
            builder.append(start);
        }
        return builder.toString();
    }

    public String frameBound(Types.FrameBoundType type, Optional<String> value) {
        switch (type) {
            case UNBOUNDED_PRECEDING: {
                return "UNBOUNDED PRECEDING";
            }
            case PRECEDING: {
                if (!value.isPresent()) {
                    throw new UnsupportedOperationException("Unsupported empty value in " + type);
                }
                return value.get() + " PRECEDING";
            }
            case CURRENT_ROW: {
                return "CURRENT ROW";
            }
            case FOLLOWING: {
                if (!value.isPresent()) {
                    throw new UnsupportedOperationException("Unsupported empty value in " + type);
                }
                return value.get() + " FOLLOWING";
            }
            case UNBOUNDED_FOLLOWING: {
                return "UNBOUNDED FOLLOWING";
            }
        }
        throw new IllegalArgumentException("unhandled type: " + type);
    }

    public String quantifiedComparisonExpression(Operators.ComparisonOperator operator, Types.Quantifier quantifier, String value, String subquery) {
        return "(" + value + ' ' + operator.getValue() + ' ' + quantifier + ' ' + subquery + ")";
    }

    public String groupingOperation(List<String> groupingColumns) {
        return "GROUPING (" + this.joinExpressions(groupingColumns) + ")";
    }

    public String formatStringLiteral(String literal) {
        return ExpressionFormatter.formatStringLiteral((String)literal);
    }

    public String joinExpressions(List<String> expressions) {
        return Joiner.on((String)", ").join(expressions);
    }

    public boolean isBlacklistedFunction(String qualifiedName, int noOfArgs) {
        if (qualifiedName.contains(INTERNAL_FUNCTION_PREFIX)) {
            return true;
        }
        Integer args = this.blacklistedFunctions.get(qualifiedName.toLowerCase(Locale.ENGLISH));
        return args != null && (args < 0 || args == noOfArgs);
    }

    public String orderBy(List<OrderBy> orders) {
        StringJoiner joiner = new StringJoiner(", ");
        for (OrderBy orderBy : orders) {
            StringJoiner orderItem = new StringJoiner(" ");
            orderItem.add(orderBy.getSymbol());
            SortOrder sortOrder = orderBy.getType();
            orderItem.add(sortOrder.isAscending() ? "ASC" : "DESC");
            orderItem.add(sortOrder.isNullsFirst() ? "NULLS FIRST" : "NULLS LAST");
            joiner.merge(orderItem);
        }
        return " ORDER BY " + joiner.toString();
    }

    public String qualifiedName(String tableName, String symbolName) {
        return tableName + "." + symbolName;
    }

    public String queryAlias(String id) {
        return "table" + id;
    }

    public String formatIdentifier(Optional<Map<String, Selection>> qualifiedNames, String identifier) {
        if (qualifiedNames.isPresent()) {
            identifier = qualifiedNames.get().get(identifier).getExpression();
        }
        return identifier;
    }

    public String formatQualifiedName(QualifiedName name) {
        return name.getParts().stream().map(identifier -> this.formatIdentifier(Optional.empty(), (String)identifier)).collect(Collectors.joining("."));
    }

    public String formatBinaryExpression(String operator, String left, String right) {
        return '(' + left + ' ' + operator + ' ' + right + ')';
    }

    public String toNativeType(String type) {
        return type;
    }

    public String select(List<Selection> symbols, String from) {
        if (symbols.size() == 0) {
            return "(SELECT * FROM " + from + ")";
        }
        StringJoiner selection = new StringJoiner(", ");
        for (Selection symbol : symbols) {
            if (symbol.isAliased()) {
                selection.add(symbol.getExpression() + " AS " + symbol.getAlias());
                continue;
            }
            selection.add(symbol.getExpression());
        }
        return "(SELECT " + selection.toString() + " FROM " + from + ")";
    }

    public String join(List<Selection> symbols, Types.JoinType type, String left, String leftId, String right, String rightId, List<String> criteria, Optional<String> filter) {
        StringBuilder builder = new StringBuilder();
        builder.append(left);
        builder.append(' ');
        builder.append(leftId);
        builder.append(' ');
        builder.append(type.getJoinLabel());
        builder.append(' ');
        builder.append(right);
        builder.append(' ');
        builder.append(rightId);
        builder.append(' ');
        if (!criteria.isEmpty() || filter.isPresent()) {
            builder.append(" ON ");
            StringJoiner joiner = new StringJoiner(" AND ");
            criteria.forEach(joiner::add);
            filter.ifPresent(joiner::add);
            builder.append(joiner.toString());
        }
        return this.select(symbols, builder.toString());
    }

    public String aggregation(List<Selection> symbols, Optional<List<String>> groupingKeysOp, Optional<String> groupIdElementOP, String from) {
        StringBuilder builder = new StringBuilder();
        builder.append(from);
        if (groupingKeysOp.isPresent()) {
            List<String> groupingKeys = groupingKeysOp.get();
            if (!groupingKeys.isEmpty()) {
                builder.append(" GROUP BY ");
                builder.append(Joiner.on((String)", ").join(groupingKeys));
            }
        } else if (groupIdElementOP.isPresent()) {
            String groupEleStr = groupIdElementOP.get();
            builder.append(" GROUP BY GROUPING SETS ");
            builder.append(groupEleStr);
        }
        return this.select(symbols, builder.toString());
    }

    public String limit(List<Selection> symbols, long count, String from) {
        return this.select(symbols, from + " LIMIT " + count);
    }

    public String filter(List<Selection> symbols, String predicate, String from) {
        if ("false".equals(predicate)) {
            return this.select(symbols, from + " WHERE 1=0 ");
        }
        if ("true".equals(predicate)) {
            return this.select(symbols, from + " WHERE 1=1 ");
        }
        return this.select(symbols, from + " WHERE " + predicate);
    }

    public String sort(List<Selection> symbols, List<OrderBy> orderings, String from) {
        return this.select(symbols, from + this.orderBy(orderings));
    }

    public String topN(List<Selection> symbols, List<OrderBy> orderings, long count, String from) {
        return this.select(symbols, from + this.orderBy(orderings) + " LIMIT " + count);
    }

    public String setOperator(List<Selection> symbols, Types.SetOperator type, List<String> relations) {
        StringBuilder builder = new StringBuilder();
        builder.append("  (");
        boolean first = true;
        for (String relation : relations) {
            builder.append(" ");
            builder.append(first ? "" : type.getLabel());
            builder.append(" ");
            builder.append(relation);
            first = false;
        }
        builder.append(") ");
        return this.select(symbols, builder.toString());
    }

    private static boolean isAsciiPrintable(int codePoint) {
        return codePoint < 127 && codePoint >= 32;
    }
}

