/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.client;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.hetu.core.transport.execution.buffer.SerializedPage;
import io.prestosql.client.Column;
import io.prestosql.client.QueryError;
import io.prestosql.client.QueryStatusInfo;
import io.prestosql.client.StatementStats;
import io.prestosql.client.Warning;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class DataCenterQueryResults
implements QueryStatusInfo {
    private final String id;
    private final URI infoUri;
    private final URI partialCancelUri;
    private final URI nextUri;
    private final List<Column> columns;
    private final List<SerializedPage> data;
    private final StatementStats stats;
    private final QueryError error;
    private final List<Warning> warnings;
    private final String updateType;
    private final boolean useHeaderInformation;

    @JsonCreator
    public DataCenterQueryResults(@JsonProperty(value="id") String id, @JsonProperty(value="infoUri") URI infoUri, @JsonProperty(value="partialCancelUri") URI partialCancelUri, @JsonProperty(value="nextUri") URI nextUri, @JsonProperty(value="columns") List<Column> columns, @JsonProperty(value="data") List<SerializedPage> data, @JsonProperty(value="stats") StatementStats stats, @JsonProperty(value="error") QueryError error, @JsonProperty(value="warnings") List<Warning> warnings, @JsonProperty(value="updateType") String updateType, @JsonProperty(value="useHeaderInformation") boolean useHeaderInformation) {
        this.id = Objects.requireNonNull(id, "id is null");
        this.infoUri = Objects.requireNonNull(infoUri, "infoUri is null");
        this.partialCancelUri = partialCancelUri;
        this.nextUri = nextUri;
        this.columns = columns != null ? ImmutableList.copyOf(columns) : null;
        this.data = data != null ? ImmutableList.copyOf(data) : null;
        Preconditions.checkArgument((data == null || columns != null ? 1 : 0) != 0, (Object)"data present without columns");
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.error = error;
        this.warnings = ImmutableList.copyOf((Collection)Objects.requireNonNull(warnings, "warnings is null"));
        this.updateType = updateType;
        this.useHeaderInformation = useHeaderInformation;
    }

    @Override
    @JsonProperty
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty
    public URI getInfoUri() {
        return this.infoUri;
    }

    @Override
    @Nullable
    @JsonProperty
    public URI getPartialCancelUri() {
        return this.partialCancelUri;
    }

    @Override
    @Nullable
    @JsonProperty
    public URI getNextUri() {
        return this.nextUri;
    }

    @Override
    @Nullable
    @JsonProperty
    public List<Column> getColumns() {
        return this.columns;
    }

    @Nullable
    @JsonProperty
    public List<SerializedPage> getData() {
        return this.data;
    }

    @Override
    @JsonProperty
    public StatementStats getStats() {
        return this.stats;
    }

    @Override
    @Nullable
    @JsonProperty
    public QueryError getError() {
        return this.error;
    }

    @Override
    @JsonProperty
    public List<Warning> getWarnings() {
        return this.warnings;
    }

    @Override
    @Nullable
    @JsonProperty
    public String getUpdateType() {
        return this.updateType;
    }

    @Override
    @Nullable
    @JsonProperty
    public Long getUpdateCount() {
        return null;
    }

    @JsonProperty
    public boolean getUseHeaderInformation() {
        return this.useHeaderInformation;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("infoUri", (Object)this.infoUri).add("partialCancelUri", (Object)this.partialCancelUri).add("nextUri", (Object)this.nextUri).add("columns", this.columns).add("hasData", this.data != null).add("stats", (Object)this.stats).add("error", (Object)this.error).add("updateType", (Object)this.updateType).add("updateCount", (Object)"").toString();
    }
}

