/*
 * Decompiled with CFR 0.152.
 */
package io.hetu.core.plugin.datacenter;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.prestosql.spi.connector.ConnectorTableHandle;
import io.prestosql.spi.connector.SchemaTableName;
import java.util.Objects;
import java.util.OptionalLong;

public final class DataCenterTableHandle
implements ConnectorTableHandle {
    private static final String SPLIT_DOT = ".";
    private final String catalogName;
    private final String schemaName;
    private final String tableName;
    private final OptionalLong limit;
    private final String subQuery;

    public DataCenterTableHandle(String catalogName, String schemaName, String tableName, OptionalLong limit) {
        this.catalogName = catalogName;
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.limit = Objects.requireNonNull(limit, "limit is null");
        this.subQuery = "";
    }

    @JsonCreator
    public DataCenterTableHandle(@JsonProperty(value="catalogName") String catalogName, @JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="limit") OptionalLong limit, @JsonProperty(value="subQuery") String subQuery) {
        this.catalogName = catalogName;
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.limit = Objects.requireNonNull(limit, "limit is null");
        this.subQuery = subQuery;
    }

    public ConnectorTableHandle createFrom(ConnectorTableHandle connectorTableHandle) {
        DataCenterTableHandle dataCenterTableHandle = (DataCenterTableHandle)connectorTableHandle;
        return new DataCenterTableHandle(this.catalogName, this.schemaName, dataCenterTableHandle.tableName, dataCenterTableHandle.getLimit(), dataCenterTableHandle.getSubQuery());
    }

    @JsonProperty
    public String getCatalogName() {
        return this.catalogName;
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public OptionalLong getLimit() {
        return this.limit;
    }

    public SchemaTableName toSchemaTableName() {
        return new SchemaTableName(this.schemaName, this.tableName);
    }

    public String getSchemaPrefixedTableName() {
        return this.catalogName + SPLIT_DOT + this.schemaName + SPLIT_DOT + this.tableName;
    }

    @JsonProperty
    public String getSubQuery() {
        return this.subQuery;
    }

    public int hashCode() {
        return Objects.hash(this.catalogName, this.schemaName, this.tableName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DataCenterTableHandle other = (DataCenterTableHandle)obj;
        return Objects.equals(this.catalogName, other.catalogName) && Objects.equals(this.schemaName, other.schemaName) && Objects.equals(this.tableName, other.tableName);
    }

    public String toString() {
        return this.catalogName + SPLIT_DOT + this.schemaName + SPLIT_DOT + this.tableName;
    }
}

