/*
 * Decompiled with CFR 0.152.
 */
package io.hetu.core.plugin.datacenter;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.ConfigSecuritySensitive;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;

public class DataCenterConfig {
    private static final int DEFAULT_HTTP_REQUEST_CONNECT_TIMEOUT_SECONDS = 30;
    private static final int DEFAULT_HTTP_REQUET_READ_TIMEOUT_SECONDS = 30;
    private static final int DEFAULT_CLIENT_TIMEOUT_MINUTES = 10;
    private static final int DEFAULT_METADATA_CACHE_MAX_SIZE = 10000;
    private static final int DEFAULT_MAX_ANTICIPATED_DELAY_MINUTES = 10;
    private static final int DEFAULT_MAX_IDLE_CONNECTIONS = 20;
    private URI connectionUrl;
    private String connectionUser;
    private String connectionPassword;
    private String remoteClusterId;
    private String socksProxy;
    private String httpProxy;
    private String applicationNamePrefix = "hetu-dc";
    private String accessToken;
    private boolean isSsl;
    private String sslKeyStorePath;
    private String sslKeyStorePassword;
    private String sslTrustStorePath;
    private String sslTrustStorePassword;
    private String kerberosConfigPath;
    private String kerberosCredentialCachePath;
    private String kerberosKeytabPath;
    private String kerberosPrincipal;
    private String kerberosRemoteServiceName;
    private String kerberosServicePrincipalPattern = "${SERVICE}@${HOST}";
    private boolean isKerberosUseCanonicalHostname;
    private String extraCredentials;
    private Duration httpRequestConnectTimeout = new Duration(30.0, TimeUnit.SECONDS);
    private Duration httpRequestReadTimeout = new Duration(30.0, TimeUnit.SECONDS);
    private Duration clientTimeout = new Duration(10.0, TimeUnit.MINUTES);
    private DataSize remoteHeaderSize = DataSize.valueOf((String)"4kB");
    private boolean isQueryPushDownEnabled = true;
    private Duration metadataCacheTtl = new Duration(1.0, TimeUnit.SECONDS);
    private long metadataCacheMaximumSize = 10000L;
    private boolean isMetadataCacheEnabled = true;
    private boolean isCompressionEnabled;
    private Duration maxAnticipatedDelay = new Duration(10.0, TimeUnit.MINUTES);
    private int maxIdleConnections = 20;
    private Duration updateThreshold = new Duration(1.0, TimeUnit.MINUTES);

    @NotNull
    public URI getConnectionUrl() {
        return this.connectionUrl;
    }

    public Duration getUpdateThreshold() {
        return this.updateThreshold;
    }

    @Config(value="hetu.dc.catalog.update.threshold")
    public DataCenterConfig setUpdateThreshold(Duration updateThreshold) {
        this.updateThreshold = updateThreshold;
        return this;
    }

    @Config(value="connection-url")
    public DataCenterConfig setConnectionUrl(URI connectionUrl) {
        this.connectionUrl = connectionUrl;
        return this;
    }

    public Duration getHttpRequestReadTimeout() {
        return this.httpRequestReadTimeout;
    }

    @Config(value="dc.http-request-readTimeout")
    @ConfigDescription(value="http request read timeout, default value is 30s")
    public DataCenterConfig setHttpRequestReadTimeout(Duration httpRequestReadTimeout) {
        this.httpRequestReadTimeout = httpRequestReadTimeout;
        return this;
    }

    public Duration getHttpRequestConnectTimeout() {
        return this.httpRequestConnectTimeout;
    }

    @Config(value="dc.http-request-connectTimeout")
    @ConfigDescription(value="http request connect timeout, default value is 30s")
    public DataCenterConfig setHttpRequestConnectTimeout(Duration httpRequestConnectTimeout) {
        this.httpRequestConnectTimeout = httpRequestConnectTimeout;
        return this;
    }

    public Duration getClientTimeout() {
        return this.clientTimeout;
    }

    @Config(value="dc.http-client-timeout")
    @ConfigDescription(value="Time until the client keeps retrying to fetch the data, default value is 10min")
    public DataCenterConfig setClientTimeout(Duration clientTimeout) {
        this.clientTimeout = clientTimeout;
        return this;
    }

    @Nullable
    public String getConnectionUser() {
        return this.connectionUser;
    }

    @Config(value="connection-user")
    public DataCenterConfig setConnectionUser(String connectionUser) {
        this.connectionUser = connectionUser;
        return this;
    }

    @Nullable
    public String getConnectionPassword() {
        return this.connectionPassword;
    }

    @Config(value="connection-password")
    @ConfigSecuritySensitive
    public DataCenterConfig setConnectionPassword(String connectionPassword) {
        this.connectionPassword = connectionPassword;
        return this;
    }

    @Nullable
    public String getRemoteClusterId() {
        return this.remoteClusterId;
    }

    @Config(value="dc.remote.cluster.id")
    public DataCenterConfig setRemoteClusterId(String tenant) {
        this.remoteClusterId = tenant;
        return this;
    }

    public String getSocksProxy() {
        return this.socksProxy;
    }

    @Config(value="dc.socksproxy")
    @ConfigDescription(value="SOCKS proxy host and port. Example: localhost:1080")
    public DataCenterConfig setSocksProxy(String socksProxy) {
        this.socksProxy = socksProxy;
        return this;
    }

    public String getHttpProxy() {
        return this.httpProxy;
    }

    @Config(value="dc.httpproxy")
    @ConfigDescription(value="HTTP proxy host and port. Example: localhost:8888")
    public DataCenterConfig setHttpProxy(String httpProxy) {
        this.httpProxy = httpProxy;
        return this;
    }

    public String getApplicationNamePrefix() {
        return this.applicationNamePrefix;
    }

    @Config(value="dc.application.name.prefix")
    @ConfigDescription(value="Prefix to append to any specified ApplicationName client info property, which is used to Set source name for the Hetu query. If neither this property nor ApplicationName are set, the source for the query will be hetu-dc")
    public DataCenterConfig setApplicationNamePrefix(String applicationNamePrefix) {
        this.applicationNamePrefix = applicationNamePrefix;
        return this;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    @Config(value="dc.accesstoken")
    @ConfigDescription(value="Access token for token based authentication")
    public DataCenterConfig setAccessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    public boolean isSsl() {
        return this.isSsl;
    }

    @Config(value="dc.ssl")
    @ConfigDescription(value="Use HTTPS for connections")
    public DataCenterConfig setSsl(boolean isSslParameter) {
        this.isSsl = isSslParameter;
        return this;
    }

    public String getSslKeyStorePath() {
        return this.sslKeyStorePath;
    }

    @Config(value="dc.ssl.keystore.path")
    @ConfigDescription(value="The location of the Java KeyStore file that contains the certificate and private key to use for authentication")
    public DataCenterConfig setSslKeyStorePath(String sslKeyStorePath) {
        this.sslKeyStorePath = sslKeyStorePath;
        return this;
    }

    public String getSslKeyStorePassword() {
        return this.sslKeyStorePassword;
    }

    @Config(value="dc.ssl.keystore.password")
    @ConfigSecuritySensitive
    public DataCenterConfig setSslKeyStorePassword(String sslKeyStorePassword) {
        this.sslKeyStorePassword = sslKeyStorePassword;
        return this;
    }

    public String getSslTrustStorePath() {
        return this.sslTrustStorePath;
    }

    @Config(value="dc.ssl.truststore.path")
    @ConfigDescription(value="The location of the Java TrustStore file that will be used to validate HTTPS server certificates")
    public DataCenterConfig setSslTrustStorePath(String sslTrustStorePath) {
        this.sslTrustStorePath = sslTrustStorePath;
        return this;
    }

    public String getSslTrustStorePassword() {
        return this.sslTrustStorePassword;
    }

    @Config(value="dc.ssl.truststore.password")
    @ConfigSecuritySensitive
    public DataCenterConfig setSslTrustStorePassword(String sslTrustStorePassword) {
        this.sslTrustStorePassword = sslTrustStorePassword;
        return this;
    }

    public String getKerberosConfigPath() {
        return this.kerberosConfigPath;
    }

    @Config(value="dc.kerberos.config.path")
    @ConfigDescription(value="Kerberos configuration file")
    public DataCenterConfig setKerberosConfigPath(String kerberosConfigPath) {
        this.kerberosConfigPath = kerberosConfigPath;
        return this;
    }

    public String getKerberosCredentialCachePath() {
        return this.kerberosCredentialCachePath;
    }

    @Config(value="dc.kerberos.credential.cachepath")
    @ConfigDescription(value="Kerberos credential cache")
    public DataCenterConfig setKerberosCredentialCachePath(String kerberosCredentialCachePath) {
        this.kerberosCredentialCachePath = kerberosCredentialCachePath;
        return this;
    }

    public String getKerberosKeytabPath() {
        return this.kerberosKeytabPath;
    }

    @Config(value="dc.kerberos.keytab.path")
    @ConfigDescription(value="Kerberos keytab file")
    public DataCenterConfig setKerberosKeytabPath(String kerberosKeytabPath) {
        this.kerberosKeytabPath = kerberosKeytabPath;
        return this;
    }

    public String getKerberosPrincipal() {
        return this.kerberosPrincipal;
    }

    @Config(value="dc.kerberos.principal")
    @ConfigDescription(value="The principal to use when authenticating to the Hetu coordinator")
    public DataCenterConfig setKerberosPrincipal(String kerberosPrincipal) {
        this.kerberosPrincipal = kerberosPrincipal;
        return this;
    }

    public String getKerberosRemoteServiceName() {
        return this.kerberosRemoteServiceName;
    }

    @Config(value="dc.kerberos.remote.service.name")
    @ConfigDescription(value="Hetu coordinator Kerberos service name. This parameter is required for Kerberos authentication")
    public DataCenterConfig setKerberosRemoteServiceName(String kerberosRemoteServiceName) {
        this.kerberosRemoteServiceName = kerberosRemoteServiceName;
        return this;
    }

    public String getKerberosServicePrincipalPattern() {
        return this.kerberosServicePrincipalPattern;
    }

    @Config(value="dc.kerberos.service.principal.pattern")
    @ConfigDescription(value="Hetu coordinator Kerberos service principal pattern. The default is ${SERVICE}@${HOST}.${SERVICE} is replaced with the value of KerberosRemoteServiceName and ${HOST} is replaced with the hostname of the coordinator (after canonicalization if enabled)")
    public DataCenterConfig setKerberosServicePrincipalPattern(String kerberosServicePrincipalPattern) {
        this.kerberosServicePrincipalPattern = kerberosServicePrincipalPattern;
        return this;
    }

    public boolean isKerberosUseCanonicalHostname() {
        return this.isKerberosUseCanonicalHostname;
    }

    @Config(value="dc.kerberos.use.canonical.hostname")
    @ConfigDescription(value="Use the canonical hostname of the Hetu coordinator for the Kerberos service principal by firstresolving the hostname to an IP address and then doing a reverse DNS lookup for that IP address.")
    public DataCenterConfig setKerberosUseCanonicalHostname(boolean isKerberosUseCanonicalHostnameParameter) {
        this.isKerberosUseCanonicalHostname = isKerberosUseCanonicalHostnameParameter;
        return this;
    }

    public String getExtraCredentials() {
        return this.extraCredentials;
    }

    @Config(value="dc.extra.credentials")
    @ConfigDescription(value="Extra credentials for connecting to external services. The extraCredentials is a list of key-value pairs. Example: foo:bar;abc:xyz will create credentials abc=xyz and foo=bar")
    public DataCenterConfig setExtraCredentials(String extraCredentials) {
        this.extraCredentials = extraCredentials;
        return this;
    }

    public boolean isQueryPushDownEnabled() {
        return this.isQueryPushDownEnabled;
    }

    @Config(value="dc.query.pushdown.enabled")
    @ConfigDescription(value="Enable sub-query push down to this data center. If this property is not set, by default sub-queries are pushed down")
    public DataCenterConfig setQueryPushDownEnabled(boolean isQueryPushDownEnabledParameter) {
        this.isQueryPushDownEnabled = isQueryPushDownEnabledParameter;
        return this;
    }

    public DataSize getRemoteHttpServerMaxRequestHeaderSize() {
        return this.remoteHeaderSize;
    }

    @Config(value="dc.remote-http-server.max-request-header-size")
    @ConfigDescription(value="This property should be equivalent to the value of http-server.max-request-header-size in the remote server")
    public DataCenterConfig setRemoteHttpServerMaxRequestHeaderSize(DataSize remoteHeaderSizeParameter) {
        this.remoteHeaderSize = remoteHeaderSizeParameter;
        return this;
    }

    public Duration getMetadataCacheTtl() {
        return this.metadataCacheTtl;
    }

    @Config(value="dc.metadata.cache.ttl")
    @ConfigDescription(value="Metadata Cache Ttl")
    public DataCenterConfig setMetadataCacheTtl(Duration metadataCacheTtl) {
        this.metadataCacheTtl = metadataCacheTtl;
        return this;
    }

    public Duration getMaxAnticipatedDelay() {
        return this.maxAnticipatedDelay;
    }

    @Config(value="dc.max.anticipated.delay")
    @ConfigDescription(value="Maximum anticipated delay between two requests for a query in the cluster. If the remote dc did not receive a request for more than this delay, it may cancel the query.")
    public DataCenterConfig setMaxAnticipatedDelay(Duration maxAnticipatedDelay) {
        this.maxAnticipatedDelay = maxAnticipatedDelay;
        return this;
    }

    public long getMetadataCacheMaximumSize() {
        return this.metadataCacheMaximumSize;
    }

    @Config(value="dc.metadata.cache.maximum.size")
    @ConfigDescription(value="Metadata Cache Maximum Size")
    public DataCenterConfig setMetadataCacheMaximumSize(long metadataCacheMaximumSize) {
        this.metadataCacheMaximumSize = metadataCacheMaximumSize;
        return this;
    }

    public boolean isMetadataCacheEnabled() {
        return this.isMetadataCacheEnabled;
    }

    @Config(value="dc.metadata.cache.enabled")
    @ConfigDescription(value="Metadata Cache Enabled")
    public DataCenterConfig setMetadataCacheEnabled(boolean isMetadataCacheEnabledParameter) {
        this.isMetadataCacheEnabled = isMetadataCacheEnabledParameter;
        return this;
    }

    public boolean isCompressionEnabled() {
        return this.isCompressionEnabled;
    }

    @Config(value="dc.http-compression")
    @ConfigDescription(value="whether use gzip compress response body, default value is false")
    public DataCenterConfig setCompressionEnabled(boolean isCompressionEnabledParameter) {
        this.isCompressionEnabled = isCompressionEnabledParameter;
        return this;
    }

    public int getMaxIdleConnections() {
        return this.maxIdleConnections;
    }

    @Config(value="dc.httpclient.maximum.idle.connections")
    @ConfigDescription(value="http client maximum idle connections")
    public DataCenterConfig setMaxIdleConnections(int maxIdleConnectionsParameter) {
        this.maxIdleConnections = maxIdleConnectionsParameter;
        return this;
    }
}

