/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.prestosql.sql.tree.AstVisitor;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.NodeLocation;
import io.prestosql.sql.tree.PrincipalSpecification;
import io.prestosql.sql.tree.QualifiedName;
import io.prestosql.sql.tree.Statement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class Revoke
extends Statement {
    private final boolean grantOptionFor;
    private final Optional<List<String>> privileges;
    private final boolean table;
    private final QualifiedName tableName;
    private final PrincipalSpecification grantee;

    public Revoke(boolean grantOptionFor, Optional<List<String>> privileges, boolean table, QualifiedName tableName, PrincipalSpecification grantee) {
        this(Optional.empty(), grantOptionFor, privileges, table, tableName, grantee);
    }

    public Revoke(NodeLocation location, boolean grantOptionFor, Optional<List<String>> privileges, boolean table, QualifiedName tableName, PrincipalSpecification grantee) {
        this(Optional.of(location), grantOptionFor, privileges, table, tableName, grantee);
    }

    private Revoke(Optional<NodeLocation> location, boolean grantOptionFor, Optional<List<String>> privileges, boolean table, QualifiedName tableName, PrincipalSpecification grantee) {
        super(location);
        this.grantOptionFor = grantOptionFor;
        Objects.requireNonNull(privileges, "privileges is null");
        this.privileges = privileges.map(ImmutableList::copyOf);
        this.table = table;
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.grantee = Objects.requireNonNull(grantee, "grantee is null");
    }

    public boolean isGrantOptionFor() {
        return this.grantOptionFor;
    }

    public Optional<List<String>> getPrivileges() {
        return this.privileges;
    }

    public boolean isTable() {
        return this.table;
    }

    public QualifiedName getTableName() {
        return this.tableName;
    }

    public PrincipalSpecification getGrantee() {
        return this.grantee;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitRevoke(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.grantOptionFor, this.privileges, this.table, this.tableName, this.grantee);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Revoke o = (Revoke)obj;
        return Objects.equals(this.grantOptionFor, o.grantOptionFor) && Objects.equals(this.privileges, o.privileges) && Objects.equals(this.table, o.table) && Objects.equals(this.tableName, o.tableName) && Objects.equals(this.grantee, o.grantee);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("grantOptionFor", this.grantOptionFor).add("privileges", this.privileges).add("table", this.table).add("tableName", (Object)this.tableName).add("grantee", (Object)this.grantee).toString();
    }
}

