/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.sql.parser;

import io.prestosql.sql.parser.AstBuilder;
import io.prestosql.sql.parser.CaseInsensitiveStream;
import io.prestosql.sql.parser.ErrorHandler;
import io.prestosql.sql.parser.IdentifierSymbol;
import io.prestosql.sql.parser.ParsingException;
import io.prestosql.sql.parser.ParsingOptions;
import io.prestosql.sql.parser.SqlBaseBaseListener;
import io.prestosql.sql.parser.SqlBaseLexer;
import io.prestosql.sql.parser.SqlBaseParser;
import io.prestosql.sql.parser.SqlParserOptions;
import io.prestosql.sql.tree.Expression;
import io.prestosql.sql.tree.Node;
import io.prestosql.sql.tree.PathSpecification;
import io.prestosql.sql.tree.Statement;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.inject.Inject;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.DefaultErrorStrategy;
import org.antlr.v4.runtime.InputMismatchException;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.misc.Pair;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;

public class SqlParser {
    private static final BaseErrorListener LEXER_ERROR_LISTENER = new BaseErrorListener(){

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String message, RecognitionException e) {
            throw new ParsingException(message, e, line, charPositionInLine);
        }
    };
    private static final ErrorHandler PARSER_ERROR_HANDLER = ErrorHandler.builder().specialRule(32, "<expression>").specialRule(33, "<expression>").specialRule(35, "<expression>").specialRule(36, "<expression>").specialRule(65, "<identifier>").specialRule(37, "<string>").specialRule(6, "<query>").specialRule(46, "<type>").specialToken(230, "<integer>").ignoredRule(67).build();
    private final EnumSet<IdentifierSymbol> allowedIdentifierSymbols;
    private boolean enhancedErrorHandlerEnabled;

    public SqlParser() {
        this(new SqlParserOptions());
    }

    @Inject
    public SqlParser(SqlParserOptions options) {
        Objects.requireNonNull(options, "options is null");
        this.allowedIdentifierSymbols = EnumSet.copyOf(options.getAllowedIdentifierSymbols());
        this.enhancedErrorHandlerEnabled = options.isEnhancedErrorHandlerEnabled();
    }

    @Deprecated
    public Statement createStatement(String sql) {
        return this.createStatement(sql, new ParsingOptions());
    }

    public Statement createStatement(String sql, ParsingOptions parsingOptions) {
        return (Statement)this.invokeParser("statement", sql, SqlBaseParser::singleStatement, parsingOptions);
    }

    @Deprecated
    public Expression createExpression(String expression) {
        return this.createExpression(expression, new ParsingOptions());
    }

    public Expression createExpression(String expression, ParsingOptions parsingOptions) {
        return (Expression)this.invokeParser("expression", expression, SqlBaseParser::standaloneExpression, parsingOptions);
    }

    public PathSpecification createPathSpecification(String expression) {
        return (PathSpecification)this.invokeParser("path specification", expression, SqlBaseParser::standalonePathSpecification, new ParsingOptions());
    }

    private Node invokeParser(String name, String sql, Function<SqlBaseParser, ParserRuleContext> parseFunction, ParsingOptions parsingOptions) {
        try {
            ParserRuleContext tree;
            SqlBaseLexer lexer = new SqlBaseLexer(new CaseInsensitiveStream((CharStream)CharStreams.fromString((String)sql)));
            CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
            SqlBaseParser parser = new SqlBaseParser((TokenStream)tokenStream);
            parser.setErrorHandler((ANTLRErrorStrategy)new DefaultErrorStrategy(){

                public Token recoverInline(Parser recognizer) throws RecognitionException {
                    if (this.nextTokensContext == null) {
                        throw new InputMismatchException(recognizer);
                    }
                    throw new InputMismatchException(recognizer, this.nextTokensState, this.nextTokensContext);
                }
            });
            parser.addParseListener(new PostProcessor(Arrays.asList(parser.getRuleNames())));
            lexer.removeErrorListeners();
            lexer.addErrorListener((ANTLRErrorListener)LEXER_ERROR_LISTENER);
            parser.removeErrorListeners();
            if (this.enhancedErrorHandlerEnabled) {
                parser.addErrorListener((ANTLRErrorListener)PARSER_ERROR_HANDLER);
            } else {
                parser.addErrorListener((ANTLRErrorListener)LEXER_ERROR_LISTENER);
            }
            try {
                ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
                tree = parseFunction.apply(parser);
            }
            catch (ParseCancellationException ex) {
                tokenStream.reset();
                parser.reset();
                ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.LL);
                tree = parseFunction.apply(parser);
            }
            return (Node)new AstBuilder(parsingOptions).visit((ParseTree)tree);
        }
        catch (StackOverflowError e) {
            throw new ParsingException(name + " is too large (stack overflow while parsing)");
        }
    }

    private class PostProcessor
    extends SqlBaseBaseListener {
        private final List<String> ruleNames;

        public PostProcessor(List<String> ruleNames) {
            this.ruleNames = ruleNames;
        }

        @Override
        public void exitQuotedIdentifier(SqlBaseParser.QuotedIdentifierContext context) {
            Token token = context.QUOTED_IDENTIFIER().getSymbol();
            if (token.getText().length() == 2) {
                throw new ParsingException("Zero-length delimited identifier not allowed", null, token.getLine(), token.getCharPositionInLine());
            }
        }

        @Override
        public void exitUnquotedIdentifier(SqlBaseParser.UnquotedIdentifierContext context) {
            String identifier = context.IDENTIFIER().getText();
            for (IdentifierSymbol identifierSymbol : EnumSet.complementOf(SqlParser.this.allowedIdentifierSymbols)) {
                char symbol = identifierSymbol.getSymbol();
                if (identifier.indexOf(symbol) < 0) continue;
                throw new ParsingException("identifiers must not contain '" + identifierSymbol.getSymbol() + "'", null, context.IDENTIFIER().getSymbol().getLine(), context.IDENTIFIER().getSymbol().getCharPositionInLine());
            }
        }

        @Override
        public void exitBackQuotedIdentifier(SqlBaseParser.BackQuotedIdentifierContext context) {
            Token token = context.BACKQUOTED_IDENTIFIER().getSymbol();
            throw new ParsingException("backquoted identifiers are not supported; use double quotes to quote identifiers", null, token.getLine(), token.getCharPositionInLine());
        }

        @Override
        public void exitDigitIdentifier(SqlBaseParser.DigitIdentifierContext context) {
            Token token = context.DIGIT_IDENTIFIER().getSymbol();
            throw new ParsingException("identifiers must not start with a digit; surround the identifier with double quotes", null, token.getLine(), token.getCharPositionInLine());
        }

        @Override
        public void exitNonReserved(SqlBaseParser.NonReservedContext context) {
            if (!(context.getChild(0) instanceof TerminalNode)) {
                int rule = ((ParserRuleContext)context.getChild(0)).getRuleIndex();
                throw new AssertionError((Object)("nonReserved can only contain tokens. Found nested rule: " + this.ruleNames.get(rule)));
            }
            context.getParent().removeLastChild();
            Token token = (Token)context.getChild(0).getPayload();
            context.getParent().addChild((Token)new CommonToken(new Pair((Object)token.getTokenSource(), (Object)token.getInputStream()), 233, token.getChannel(), token.getStartIndex(), token.getStopIndex()));
        }
    }
}

