/*
 * Decompiled with CFR 0.152.
 */
package io.hetu.core.transport.execution.buffer;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.hetu.core.transport.execution.buffer.PageCodecMarker;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class SerializedPage {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(SerializedPage.class).instanceSize();
    private final Slice slice;
    private final int positionCount;
    private final int uncompressedSizeInBytes;
    private final byte pageCodecMarkers;

    @JsonCreator
    public SerializedPage(@JsonProperty(value="sliceArray") byte[] sliceArray, @JsonProperty(value="pageCodecMarkers") byte pageCodecMarkers, @JsonProperty(value="positionCount") int positionCount, @JsonProperty(value="uncompressedSizeInBytes") int uncompressedSizeInBytes) {
        this(Slices.wrappedBuffer((byte[])sliceArray), PageCodecMarker.MarkerSet.fromByteValue(pageCodecMarkers), positionCount, uncompressedSizeInBytes);
    }

    public SerializedPage(Slice slice, PageCodecMarker.MarkerSet markers, int positionCount, int uncompressedSizeInBytes) {
        this.slice = Objects.requireNonNull(slice, "slice is null");
        this.positionCount = positionCount;
        Preconditions.checkArgument((uncompressedSizeInBytes >= 0 ? 1 : 0) != 0, (Object)"uncompressedSizeInBytes is negative");
        this.uncompressedSizeInBytes = uncompressedSizeInBytes;
        this.pageCodecMarkers = Objects.requireNonNull(markers, "markers is null").byteValue();
        if (!markers.contains(PageCodecMarker.ENCRYPTED)) {
            if (markers.contains(PageCodecMarker.COMPRESSED)) {
                Preconditions.checkArgument((uncompressedSizeInBytes > slice.length() ? 1 : 0) != 0, (Object)"compressed size must be smaller than uncompressed size when compressed");
            } else {
                Preconditions.checkArgument((uncompressedSizeInBytes == slice.length() ? 1 : 0) != 0, (Object)"uncompressed size must be equal to slice length when uncompressed");
            }
        }
    }

    public int getSizeInBytes() {
        return this.slice.length();
    }

    @JsonProperty
    public int getUncompressedSizeInBytes() {
        return this.uncompressedSizeInBytes;
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.slice.getRetainedSize();
    }

    @JsonProperty
    public int getPositionCount() {
        return this.positionCount;
    }

    @JsonProperty
    public byte[] getSliceArray() {
        return this.slice.getBytes();
    }

    public Slice getSlice() {
        return this.slice;
    }

    @JsonProperty
    public byte getPageCodecMarkers() {
        return this.pageCodecMarkers;
    }

    public boolean isCompressed() {
        return PageCodecMarker.COMPRESSED.isSet(this.pageCodecMarkers);
    }

    public boolean isEncrypted() {
        return PageCodecMarker.ENCRYPTED.isSet(this.pageCodecMarkers);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("positionCount", this.positionCount).add("pageCodecMarkers", (Object)PageCodecMarker.toSummaryString(this.pageCodecMarkers)).add("sizeInBytes", this.slice.length()).add("uncompressedSizeInBytes", this.uncompressedSizeInBytes).toString();
    }
}

