/*
 * Decompiled with CFR 0.152.
 */
package io.hetu.core.plugin.datacenter;

import com.google.common.collect.ImmutableMap;
import io.airlift.log.Logger;
import io.airlift.testing.Closeables;
import io.hetu.core.plugin.datacenter.DataCenterPlugin;
import io.prestosql.Session;
import io.prestosql.plugin.tpch.TpchPlugin;
import io.prestosql.server.testing.TestingPrestoServer;
import io.prestosql.spi.Plugin;
import io.prestosql.testing.TestingSession;
import io.prestosql.tests.DistributedQueryRunner;
import io.prestosql.tests.QueryAssertions;
import io.prestosql.tests.ResultWithQueryId;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

public class TestCrossRegionDynamicFilter {
    private static final Logger LOGGER = Logger.get(TestCrossRegionDynamicFilter.class);
    private final TestingPrestoServer remoteServer = new TestingPrestoServer((Map)ImmutableMap.builder().put((Object)"node-scheduler.include-coordinator", (Object)"true").put((Object)"hetu.data.center.split.count", (Object)"1").build());
    private final DistributedQueryRunner queryRunner = TestCrossRegionDynamicFilter.createDCQueryRunner(this.remoteServer, (Map<String, String>)ImmutableMap.of());
    private final Session enabledSession = TestingSession.testSessionBuilder().setCatalog("tpch").setSchema("tiny").setSystemProperty("enable_dynamic_filtering", "true").setSystemProperty("cross-region-dynamic-filter-enabled", "true").build();
    private final Session disabledSession = TestingSession.testSessionBuilder().setCatalog("tpch").setSchema("tiny").setSystemProperty("enable_dynamic_filtering", "false").setSystemProperty("cross-region-dynamic-filter-enabled", "false").build();

    @AfterClass(alwaysRun=true)
    public final void destroy() throws IOException {
        this.queryRunner.close();
        this.remoteServer.close();
    }

    @Test
    public void testJoinWithMultiFieldGroupBy() {
        this.assertQuery("SELECT orderstatus FROM dc.tpch.tiny.lineitem JOIN (SELECT DISTINCT orderkey, orderstatus FROM orders) T on dc.tpch.tiny.lineitem.orderkey = T.orderkey");
    }

    @Test
    public void testDistinctJoin() {
        this.assertQuery("SELECT COUNT(DISTINCT CAST(b.quantity AS BIGINT)), a.orderstatus FROM orders a JOIN dc.tpch.tiny.lineitem b ON a.orderkey = b.orderkey GROUP BY a.orderstatus");
    }

    @Test
    public void testJoinCoercion() {
        this.assertQuery("SELECT COUNT(*) FROM orders t JOIN (SELECT * FROM orders LIMIT 1) t2 ON sin(t2.custkey) = 0");
    }

    @Test
    public void testJoinCoercionOnEqualityComparison() {
        this.assertQuery("SELECT o.clerk, avg(o.shippriority), COUNT(l.linenumber) FROM orders o LEFT OUTER JOIN dc.tpch.tiny.lineitem l ON o.orderkey=l.orderkey AND o.shippriority=1 GROUP BY o.clerk");
    }

    @Test
    public void testJoinWithLessThanInJoinClause() {
        this.assertQuery("SELECT n.nationkey, r.regionkey FROM region r JOIN nation n ON n.regionkey = r.regionkey AND n.name < r.name");
        this.assertQuery("SELECT l.suppkey, n.nationkey, l.partkey, n.regionkey FROM nation n JOIN dc.tpch.tiny.lineitem l ON l.suppkey = n.nationkey AND l.partkey < n.regionkey");
        this.assertQuery("SELECT n.nationkey, r.regionkey FROM nation n JOIN region r ON n.regionkey = r.regionkey AND length(n.name) < length(substr(r.name, 5))");
    }

    @Test
    public void testJoinWithGreaterThanInJoinClause() {
        this.assertQuery("SELECT n.nationkey, r.regionkey FROM region r JOIN nation n ON n.regionkey = r.regionkey AND n.name > r.name AND r.regionkey = 0");
        this.assertQuery("SELECT l.suppkey, n.nationkey, l.partkey, n.regionkey FROM nation n JOIN dc.tpch.tiny.lineitem l ON l.suppkey = n.nationkey AND l.partkey > n.regionkey");
        this.assertQuery("SELECT n.nationkey, r.regionkey FROM nation n JOIN region r ON n.regionkey = r.regionkey AND length(n.name) > length(substr(r.name, 5))");
    }

    @Test
    public void testJoinWithRangePredicatesinJoinClause() {
        this.assertQuery("SELECT COUNT(*) FROM (SELECT * FROM dc.tpch.tiny.lineitem WHERE orderkey % 16 = 0 AND partkey % 2 = 0) lineitem JOIN (SELECT * FROM orders WHERE orderkey % 16 = 0 AND custkey % 2 = 0) orders ON lineitem.orderkey % 8 = orders.orderkey % 8 AND lineitem.linenumber % 2 = 0 AND orders.custkey % 8 < 7 AND lineitem.suppkey % 10 < orders.custkey % 7 AND lineitem.suppkey % 7 > orders.custkey % 7");
        this.assertQuery("SELECT COUNT(*) FROM (SELECT * FROM dc.tpch.tiny.lineitem WHERE orderkey % 16 = 0 AND partkey % 2 = 0) lineitem JOIN (SELECT * FROM orders WHERE orderkey % 16 = 0 AND custkey % 2 = 0) orders ON lineitem.orderkey % 8 = orders.orderkey % 8 AND lineitem.linenumber % 2 = 0 AND orders.custkey % 8 < lineitem.linenumber % 2 AND lineitem.suppkey % 10 < orders.custkey % 7 AND lineitem.suppkey % 7 > orders.custkey % 7");
    }

    @Test
    public void testJoinWithMultipleLessThanPredicatesDifferentOrders() {
        this.assertQuery("SELECT count(*) FROM dc.tpch.tiny.lineitem l JOIN nation n ON l.suppkey % 5 = n.nationkey % 5 AND l.partkey % 3 < n.regionkey AND l.partkey % 3 + 1 < n.regionkey AND l.partkey % 3 + 2 < n.regionkey");
        this.assertQuery("SELECT count(*) FROM dc.tpch.tiny.lineitem l JOIN nation n ON l.suppkey % 5 = n.nationkey % 5 AND l.partkey % 3 + 2 < n.regionkey AND l.partkey % 3 + 1 < n.regionkey AND l.partkey % 3 < n.regionkey");
        this.assertQuery("SELECT count(*) FROM dc.tpch.tiny.lineitem l JOIN nation n ON l.suppkey % 5 = n.nationkey % 5 AND l.partkey % 3 > n.regionkey AND l.partkey % 3 + 1 > n.regionkey AND l.partkey % 3 + 2 > n.regionkey");
        this.assertQuery("SELECT count(*) FROM dc.tpch.tiny.lineitem l JOIN nation n ON l.suppkey % 5 = n.nationkey % 5 AND l.partkey % 3 + 2 > n.regionkey AND l.partkey % 3 + 1 > n.regionkey AND l.partkey % 3 > n.regionkey");
    }

    @Test
    public void testJoinWithLessThanOnDatesInJoinClause() {
        this.assertQuery("SELECT o.orderkey, o.orderdate, l.shipdate FROM orders o JOIN dc.tpch.tiny.lineitem l ON l.orderkey = o.orderkey AND l.shipdate < o.orderdate + INTERVAL '10' DAY");
        this.assertQuery("SELECT o.orderkey, o.orderdate, l.shipdate FROM dc.tpch.tiny.lineitem l JOIN orders o ON l.orderkey = o.orderkey AND l.shipdate < DATE_ADD('DAY', 10, o.orderdate)");
        this.assertQuery("SELECT o.orderkey, o.orderdate, l.shipdate FROM orders o JOIN dc.tpch.tiny.lineitem l ON o.orderkey=l.orderkey AND o.orderdate + INTERVAL '2' DAY <= l.shipdate AND l.shipdate < o.orderdate + INTERVAL '7' DAY");
    }

    @Test
    public void testSimpleJoin() {
        this.assertQuery("SELECT COUNT(*) FROM dc.tpch.tiny.lineitem JOIN orders ON dc.tpch.tiny.lineitem.orderkey = orders.orderkey");
        this.assertQuery("SELECT COUNT(*) FROM (SELECT orderkey FROM dc.tpch.tiny.lineitem WHERE orderkey < 1000) a JOIN (SELECT orderkey FROM orders WHERE orderkey < 2000) b ON NOT (a.orderkey <= b.orderkey)");
    }

    @Test
    public void testJoinWithRightConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM dc.tpch.tiny.lineitem JOIN orders ON dc.tpch.tiny.lineitem.orderkey = 2");
    }

    @Test
    public void testJoinWithLeftConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM dc.tpch.tiny.lineitem JOIN orders ON orders.orderkey = 2");
    }

    @Test
    public void testSimpleJoinWithLeftConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM dc.tpch.tiny.lineitem JOIN orders ON dc.tpch.tiny.lineitem.orderkey = orders.orderkey AND orders.orderkey = 2");
    }

    @Test
    public void testSimpleJoinWithRightConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM dc.tpch.tiny.lineitem JOIN orders ON dc.tpch.tiny.lineitem.orderkey = orders.orderkey AND dc.tpch.tiny.lineitem.orderkey = 2");
    }

    @Test
    public void testJoinDoubleClauseWithLeftOverlap() {
        this.assertQuery("SELECT COUNT(*) FROM dc.tpch.tiny.lineitem JOIN orders ON dc.tpch.tiny.lineitem.orderkey = orders.orderkey AND dc.tpch.tiny.lineitem.orderkey = orders.custkey");
    }

    @Test
    public void testJoinDoubleClauseWithRightOverlap() {
        this.assertQuery("SELECT COUNT(*) FROM dc.tpch.tiny.lineitem JOIN orders ON dc.tpch.tiny.lineitem.orderkey = orders.orderkey AND orders.orderkey = dc.tpch.tiny.lineitem.partkey");
    }

    @Test
    public void testJoinWithAlias() {
        this.assertQuery("SELECT * FROM (dc.tpch.tiny.lineitem JOIN orders ON dc.tpch.tiny.lineitem.orderkey = orders.orderkey) x");
    }

    @Test
    public void testJoinWithConstantExpression() {
        this.assertQuery("SELECT COUNT(*) FROM dc.tpch.tiny.lineitem JOIN orders ON dc.tpch.tiny.lineitem.orderkey = orders.orderkey AND 123 = 123");
    }

    @Test
    public void testJoinWithConstantTrueExpressionWithCoercion() {
        this.assertQuery("SELECT count(*) > 0 FROM nation JOIN region ON (cast(1.2 AS real) = CAST(1.2 AS decimal(2,1)))");
    }

    @Test
    public void testJoinWithCanonicalizedConstantTrueExpressionWithCoercion() {
        this.assertQuery("SELECT count(*) > 0 FROM nation JOIN region ON CAST((CASE WHEN (TRUE IS NOT NULL) THEN '1.2' ELSE '1.2' END) AS real) = CAST(1.2 AS decimal(2,1))");
    }

    @Test
    public void testJoinWithConstantPredicatePushDown() {
        this.assertQuery("SELECT\n  a.orderstatus\n  , a.clerk\nFROM (\n  SELECT DISTINCT orderstatus, clerk FROM orders\n) a\nINNER JOIN (\n  SELECT DISTINCT orderstatus, clerk FROM orders\n) b\nON\n  a.orderstatus = b.orderstatus\n  and a.clerk = b.clerk\nwhere a.orderstatus = 'F'\n");
    }

    @Test
    public void testJoinWithInferredFalseJoinClause() {
        this.assertQuery("SELECT COUNT(*)\nFROM orders\nJOIN dc.tpch.tiny.lineitem\nON CAST(orders.orderkey AS VARCHAR) = CAST(dc.tpch.tiny.lineitem.orderkey AS VARCHAR)\nWHERE orders.orderkey = 1 AND dc.tpch.tiny.lineitem.orderkey = 2\n");
    }

    @Test
    public void testJoinUsing() {
        this.assertQuery("SELECT COUNT(*) FROM dc.tpch.tiny.lineitem JOIN orders USING (orderkey)");
    }

    @Test
    public void testJoinWithReversedComparison() {
        this.assertQuery("SELECT COUNT(*) FROM dc.tpch.tiny.lineitem JOIN orders ON orders.orderkey = dc.tpch.tiny.lineitem.orderkey");
    }

    @Test
    public void testJoinWithComplexExpressions() {
        this.assertQuery("SELECT SUM(custkey) FROM dc.tpch.tiny.lineitem JOIN orders ON dc.tpch.tiny.lineitem.orderkey = CAST(orders.orderkey AS BIGINT)");
    }

    @Test
    public void testJoinWithComplexExpressions2() {
        this.assertQuery("SELECT SUM(custkey) FROM dc.tpch.tiny.lineitem JOIN orders ON dc.tpch.tiny.lineitem.orderkey = CASE WHEN orders.custkey = 1 and orders.orderstatus = 'F' THEN orders.orderkey ELSE NULL END");
    }

    @Test
    public void testJoinWithComplexExpressions3() {
        this.assertQuery("SELECT SUM(custkey) FROM dc.tpch.tiny.lineitem JOIN orders ON dc.tpch.tiny.lineitem.orderkey + 1 = orders.orderkey + 1");
    }

    @Test
    public void testJoinWithNormalization() {
        this.assertQuery("SELECT COUNT(*) FROM nation a JOIN nation b on not ((a.nationkey + b.nationkey) <> b.nationkey)");
        this.assertQuery("SELECT COUNT(*) FROM nation a JOIN nation b on not (a.nationkey <> b.nationkey)");
        this.assertQuery("SELECT COUNT(*) FROM nation a JOIN nation b on not (a.nationkey = b.nationkey)");
        this.assertQuery("SELECT COUNT(*) FROM nation a JOIN nation b on not (not CAST(a.nationkey AS boolean))");
        this.assertQuery("SELECT COUNT(*) FROM nation a JOIN nation b on not not not (a.nationkey = b.nationkey)");
    }

    @Test
    public void testSelfJoin() {
        this.assertQuery("SELECT COUNT(*) FROM orders a JOIN orders b on a.orderkey = b.orderkey");
    }

    @Test
    public void testWildcardFromJoin() {
        this.assertQuery("SELECT * FROM (SELECT orderkey, partkey FROM dc.tpch.tiny.lineitem) a JOIN (SELECT orderkey, custkey FROM orders) b using (orderkey)");
    }

    @Test
    public void testQualifiedWildcardFromJoin() {
        this.assertQuery("SELECT a.*, b.* FROM (SELECT orderkey, partkey FROM dc.tpch.tiny.lineitem) a JOIN (SELECT orderkey, custkey FROM orders) b using (orderkey)");
    }

    @Test
    public void testJoinAggregations() {
        this.assertQuery("SELECT x + y FROM (   SELECT orderdate, COUNT(*) x FROM orders GROUP BY orderdate) a JOIN (   SELECT orderdate, COUNT(*) y FROM orders GROUP BY orderdate) b ON a.orderdate = b.orderdate");
    }

    @Test
    public void testNonEqualityJoin() {
        this.assertQuery("SELECT COUNT(*) FROM dc.tpch.tiny.lineitem JOIN orders ON dc.tpch.tiny.lineitem.orderkey = orders.orderkey AND dc.tpch.tiny.lineitem.quantity + length(orders.comment) > 7");
        this.assertQuery("SELECT COUNT(*) FROM dc.tpch.tiny.lineitem JOIN orders ON dc.tpch.tiny.lineitem.orderkey = orders.orderkey AND NOT dc.tpch.tiny.lineitem.quantity > 2");
        this.assertQuery("SELECT COUNT(*) FROM dc.tpch.tiny.lineitem JOIN orders ON NOT NOT dc.tpch.tiny.lineitem.orderkey = orders.orderkey AND NOT NOT dc.tpch.tiny.lineitem.quantity > 2");
        this.assertQuery("SELECT COUNT(*) FROM dc.tpch.tiny.lineitem JOIN orders ON dc.tpch.tiny.lineitem.orderkey = orders.orderkey AND NOT NOT NOT dc.tpch.tiny.lineitem.quantity > 2");
        this.assertQuery("SELECT COUNT(*) FROM dc.tpch.tiny.lineitem JOIN orders ON dc.tpch.tiny.lineitem.orderkey = orders.orderkey AND dc.tpch.tiny.lineitem.quantity > 2");
        this.assertQuery("SELECT COUNT(*) FROM dc.tpch.tiny.lineitem JOIN orders ON dc.tpch.tiny.lineitem.orderkey = orders.orderkey AND dc.tpch.tiny.lineitem.quantity <= 2");
        this.assertQuery("SELECT COUNT(*) FROM dc.tpch.tiny.lineitem JOIN orders ON dc.tpch.tiny.lineitem.orderkey = orders.orderkey AND dc.tpch.tiny.lineitem.quantity != 2");
        this.assertQuery("SELECT COUNT(*) FROM dc.tpch.tiny.lineitem JOIN orders ON dc.tpch.tiny.lineitem.orderkey = orders.orderkey AND dc.tpch.tiny.lineitem.shipdate > orders.orderdate");
        this.assertQuery("SELECT COUNT(*) FROM dc.tpch.tiny.lineitem JOIN orders ON dc.tpch.tiny.lineitem.orderkey = orders.orderkey AND orders.orderdate < dc.tpch.tiny.lineitem.shipdate");
        this.assertQuery("SELECT COUNT(*) FROM dc.tpch.tiny.lineitem JOIN orders ON dc.tpch.tiny.lineitem.orderkey = orders.orderkey AND orders.comment LIKE '%forges%'");
        this.assertQuery("SELECT COUNT(*) FROM dc.tpch.tiny.lineitem JOIN orders ON dc.tpch.tiny.lineitem.orderkey = orders.orderkey AND orders.comment LIKE dc.tpch.tiny.lineitem.comment");
        this.assertQuery("SELECT COUNT(*) FROM dc.tpch.tiny.lineitem JOIN orders ON dc.tpch.tiny.lineitem.orderkey = orders.orderkey AND dc.tpch.tiny.lineitem.comment LIKE '%forges%'");
        this.assertQuery("SELECT COUNT(*) FROM dc.tpch.tiny.lineitem JOIN orders ON dc.tpch.tiny.lineitem.orderkey = orders.orderkey AND dc.tpch.tiny.lineitem.comment LIKE orders.comment");
        this.assertQuery("SELECT COUNT(*) FROM dc.tpch.tiny.lineitem JOIN orders ON dc.tpch.tiny.lineitem.orderkey = orders.orderkey AND orders.comment NOT LIKE '%forges%'");
        this.assertQuery("SELECT COUNT(*) FROM dc.tpch.tiny.lineitem JOIN orders ON dc.tpch.tiny.lineitem.orderkey = orders.orderkey AND orders.comment NOT LIKE dc.tpch.tiny.lineitem.comment");
        this.assertQuery("SELECT COUNT(*) FROM dc.tpch.tiny.lineitem JOIN orders ON dc.tpch.tiny.lineitem.orderkey = orders.orderkey AND NOT (orders.comment LIKE '%forges%')");
        this.assertQuery("SELECT COUNT(*) FROM dc.tpch.tiny.lineitem JOIN orders ON dc.tpch.tiny.lineitem.orderkey = orders.orderkey AND NOT (orders.comment LIKE dc.tpch.tiny.lineitem.comment)");
        this.assertQuery("SELECT COUNT(*) FROM dc.tpch.tiny.lineitem JOIN orders ON dc.tpch.tiny.lineitem.orderkey = orders.orderkey AND dc.tpch.tiny.lineitem.quantity + length(orders.comment) > 7");
        this.assertQuery("SELECT COUNT(*) FROM dc.tpch.tiny.lineitem JOIN orders ON dc.tpch.tiny.lineitem.orderkey = orders.orderkey AND NULL");
    }

    @Test
    public void testNonEqualityLeftJoin() {
        this.assertQuery("SELECT COUNT(*) FROM       (SELECT * FROM dc.tpch.tiny.lineitem ORDER BY orderkey,linenumber LIMIT 5) l          LEFT OUTER JOIN       (SELECT * FROM orders ORDER BY orderkey LIMIT 5) o          ON       o.custkey != 1000 WHERE o.orderkey IS NULL");
        this.assertQuery("SELECT COUNT(*) FROM dc.tpch.tiny.lineitem LEFT OUTER JOIN orders ON dc.tpch.tiny.lineitem.orderkey = orders.orderkey AND orders.custkey > 1000 WHERE orders.orderkey IS NULL");
        this.assertQuery("SELECT COUNT(*) FROM dc.tpch.tiny.lineitem LEFT OUTER JOIN orders ON dc.tpch.tiny.lineitem.orderkey = orders.orderkey AND orders.custkey > 1000.0 WHERE orders.orderkey IS NULL");
        this.assertQuery("SELECT COUNT(*) FROM dc.tpch.tiny.lineitem LEFT OUTER JOIN orders ON dc.tpch.tiny.lineitem.orderkey = orders.orderkey AND orders.custkey > orders.totalprice WHERE orders.orderkey IS NULL");
        this.assertQuery("SELECT COUNT(*) FROM dc.tpch.tiny.lineitem LEFT OUTER JOIN orders ON dc.tpch.tiny.lineitem.orderkey = orders.orderkey AND orders.custkey > dc.tpch.tiny.lineitem.quantity WHERE orders.orderkey IS NULL");
        this.assertQuery("SELECT COUNT(*) FROM dc.tpch.tiny.lineitem LEFT OUTER JOIN orders ON dc.tpch.tiny.lineitem.orderkey = orders.orderkey AND dc.tpch.tiny.lineitem.quantity > 5 WHERE orders.orderkey IS NULL");
    }

    @Test
    public void testLeftJoinWithEmptyInnerTable() {
        this.assertQuery("SELECT * FROM dc.tpch.tiny.lineitem a LEFT JOIN (SELECT * FROM orders WHERE orderkey = rand()) b ON a.orderkey = b.orderkey");
        this.assertQuery("SELECT * FROM dc.tpch.tiny.lineitem a LEFT JOIN (SELECT * FROM orders WHERE orderkey = rand()) b ON a.orderkey > b.orderkey");
        this.assertQuery("SELECT * FROM dc.tpch.tiny.lineitem a LEFT JOIN (SELECT * FROM orders WHERE orderkey = rand()) b ON 1 = 1");
        this.assertQuery("SELECT * FROM dc.tpch.tiny.lineitem a LEFT JOIN (SELECT * FROM orders WHERE orderkey = rand()) b ON b.orderkey > 1");
        this.assertQuery("SELECT * FROM dc.tpch.tiny.lineitem a LEFT JOIN (SELECT * FROM orders WHERE orderkey = rand()) b ON b.orderkey > b.totalprice");
    }

    @Test
    public void testRightJoinWithEmptyInnerTable() {
        this.assertQuery("SELECT * FROM orders b RIGHT JOIN (SELECT * FROM orders WHERE orderkey = rand()) a ON a.orderkey = b.orderkey");
        this.assertQuery("SELECT * FROM orders b LEFT JOIN (SELECT * FROM orders WHERE orderkey = rand()) a ON a.orderkey > b.orderkey");
        this.assertQuery("SELECT * FROM orders b LEFT JOIN (SELECT * FROM orders WHERE orderkey = rand()) a ON 1 = 1");
        this.assertQuery("SELECT * FROM orders b LEFT JOIN (SELECT * FROM orders WHERE orderkey = rand()) a ON b.orderkey > 1");
        this.assertQuery("SELECT * FROM orders b LEFT JOIN (SELECT * FROM orders WHERE orderkey = rand()) a ON b.orderkey > b.totalprice");
    }

    @Test
    public void testNonEqualityRightJoin() {
        this.assertQuery("SELECT COUNT(*) FROM       (SELECT * FROM dc.tpch.tiny.lineitem ORDER BY orderkey,linenumber LIMIT 5) l          RIGHT OUTER JOIN       (SELECT * FROM orders ORDER BY orderkey LIMIT 5) o          ON       l.quantity != 5 WHERE l.orderkey IS NULL");
        this.assertQuery("SELECT COUNT(*) FROM dc.tpch.tiny.lineitem RIGHT OUTER JOIN orders ON dc.tpch.tiny.lineitem.orderkey = orders.orderkey AND dc.tpch.tiny.lineitem.quantity > 5 WHERE dc.tpch.tiny.lineitem.orderkey IS NULL");
        this.assertQuery("SELECT COUNT(*) FROM dc.tpch.tiny.lineitem RIGHT OUTER JOIN orders ON dc.tpch.tiny.lineitem.orderkey = orders.orderkey AND dc.tpch.tiny.lineitem.quantity > 5.0 WHERE dc.tpch.tiny.lineitem.orderkey IS NULL");
        this.assertQuery("SELECT COUNT(*) FROM dc.tpch.tiny.lineitem RIGHT OUTER JOIN orders ON dc.tpch.tiny.lineitem.orderkey = orders.orderkey AND dc.tpch.tiny.lineitem.quantity > dc.tpch.tiny.lineitem.suppkey WHERE dc.tpch.tiny.lineitem.orderkey IS NULL");
        this.assertQuery("SELECT COUNT(*) FROM dc.tpch.tiny.lineitem RIGHT OUTER JOIN orders ON dc.tpch.tiny.lineitem.orderkey = orders.orderkey AND dc.tpch.tiny.lineitem.quantity*1000 > orders.totalprice WHERE dc.tpch.tiny.lineitem.orderkey IS NULL");
        this.assertQuery("SELECT COUNT(*) FROM dc.tpch.tiny.lineitem RIGHT OUTER JOIN orders ON dc.tpch.tiny.lineitem.orderkey = orders.orderkey AND orders.totalprice > 1000 WHERE dc.tpch.tiny.lineitem.orderkey IS NULL");
    }

    @Test
    public void testNonEqualityFullJoin() {
        this.assertQuery("SELECT COUNT(*) FROM dc.tpch.tiny.lineitem FULL JOIN orders ON dc.tpch.tiny.lineitem.orderkey = orders.orderkey AND dc.tpch.tiny.lineitem.quantity > 5 WHERE dc.tpch.tiny.lineitem.orderkey IS NULL OR orders.orderkey IS NULL");
        this.assertQuery("SELECT COUNT(*) FROM dc.tpch.tiny.lineitem FULL OUTER JOIN orders ON dc.tpch.tiny.lineitem.orderkey = orders.orderkey AND orders.custkey > 1000 WHERE dc.tpch.tiny.lineitem.orderkey IS NULL OR orders.orderkey IS NULL");
        this.assertQuery("SELECT COUNT(*) FROM dc.tpch.tiny.lineitem FULL OUTER JOIN orders ON dc.tpch.tiny.lineitem.orderkey = orders.orderkey AND orders.custkey > dc.tpch.tiny.lineitem.quantity WHERE dc.tpch.tiny.lineitem.orderkey IS NULL OR orders.orderkey IS NULL");
    }

    @Test
    public void testJoinOnMultipleFields() {
        this.assertQuery("SELECT COUNT(*) FROM dc.tpch.tiny.lineitem JOIN orders ON dc.tpch.tiny.lineitem.orderkey = orders.orderkey AND dc.tpch.tiny.lineitem.shipdate = orders.orderdate");
    }

    @Test
    public void testJoinUsingMultipleFields() {
        this.assertQuery("SELECT COUNT(*) FROM dc.tpch.tiny.lineitem JOIN (SELECT orderkey, orderdate shipdate FROM orders) T USING (orderkey, shipdate)");
    }

    @Test
    public void testColocatedJoinWithLocalUnion() {
        this.assertQuery("SELECT count(*) FROM ((SELECT * FROM orders) union all (SELECT * FROM orders)) JOIN orders USING (orderkey)");
    }

    @Test
    public void testJoinWithNonJoinExpression() {
        this.assertQuery("SELECT COUNT(*) FROM dc.tpch.tiny.lineitem JOIN orders ON dc.tpch.tiny.lineitem.orderkey = orders.orderkey AND orders.custkey = 1");
    }

    @Test
    public void testJoinWithNullValues() {
        this.assertQuery("SELECT *\nFROM (\n  SELECT CASE WHEN orderkey % 3 = 0 THEN NULL ELSE orderkey END AS orderkey\n  FROM dc.tpch.tiny.lineitem\n  WHERE partkey % 512 = 0\n) AS lineitem \nJOIN (\n  SELECT CASE WHEN orderkey % 2 = 0 THEN NULL ELSE orderkey END AS orderkey\n  FROM orders\n  WHERE custkey % 512 = 0\n) AS orders\nON lineitem.orderkey = orders.orderkey");
    }

    @Test
    public void testLeftFilteredJoin() {
        this.assertQuery("SELECT custkey, linestatus, tax, totalprice, orderstatus FROM (SELECT * FROM dc.tpch.tiny.lineitem WHERE orderkey % 2 = 0) a JOIN orders ON a.orderkey = orders.orderkey");
    }

    @Test
    public void testRightFilteredJoin() {
        this.assertQuery("SELECT custkey, linestatus, tax, totalprice, orderstatus FROM dc.tpch.tiny.lineitem JOIN (SELECT *  FROM orders WHERE orderkey % 2 = 0) a ON dc.tpch.tiny.lineitem.orderkey = a.orderkey");
    }

    @Test
    public void testJoinWithFullyPushedDownJoinClause() {
        this.assertQuery("SELECT COUNT(*) FROM dc.tpch.tiny.lineitem JOIN orders ON orders.custkey = 1 AND dc.tpch.tiny.lineitem.orderkey = 1");
    }

    @Test
    public void testJoinPredicateMoveAround() {
        this.assertQuery("SELECT COUNT(*)\nFROM (SELECT * FROM dc.tpch.tiny.lineitem WHERE orderkey % 16 = 0 AND partkey % 2 = 0) lineitem\nJOIN (SELECT * FROM orders WHERE orderkey % 16 = 0 AND custkey % 2 = 0) orders\nON lineitem.orderkey % 8 = orders.orderkey % 8 AND lineitem.linenumber % 2 = 0\nWHERE orders.custkey % 8 < 7 AND orders.custkey % 8 = lineitem.orderkey % 8 AND lineitem.suppkey % 7 > orders.custkey % 7");
    }

    @Test
    public void testSimpleFullJoin() {
        this.assertQuery("SELECT COUNT(*) FROM dc.tpch.tiny.lineitem FULL JOIN orders ON dc.tpch.tiny.lineitem.orderkey = orders.orderkey");
        this.assertQuery("SELECT COUNT(*) FROM dc.tpch.tiny.lineitem FULL OUTER JOIN orders ON dc.tpch.tiny.lineitem.orderkey = orders.orderkey");
        this.assertQuery("SELECT COUNT(*) FROM dc.tpch.tiny.lineitem FULL JOIN orders ON dc.tpch.tiny.lineitem.orderkey = orders.custkey");
    }

    @Test
    public void testFullJoinNormalizedToLeft() {
        this.assertQuery("SELECT COUNT(*) FROM dc.tpch.tiny.lineitem FULL JOIN orders ON dc.tpch.tiny.lineitem.orderkey = orders.orderkey WHERE dc.tpch.tiny.lineitem.orderkey IS NOT NULL");
        this.assertQuery("SELECT COUNT(*) FROM dc.tpch.tiny.lineitem FULL JOIN orders ON dc.tpch.tiny.lineitem.orderkey = orders.custkey WHERE dc.tpch.tiny.lineitem.orderkey IS NOT NULL");
    }

    @Test
    public void testFullJoinNormalizedToRight() {
        this.assertQuery("SELECT COUNT(*) FROM dc.tpch.tiny.lineitem FULL JOIN orders ON dc.tpch.tiny.lineitem.orderkey = orders.orderkey WHERE orders.orderkey IS NOT NULL");
        this.assertQuery("SELECT COUNT(*) FROM dc.tpch.tiny.lineitem FULL JOIN orders ON dc.tpch.tiny.lineitem.orderkey = orders.custkey WHERE orders.custkey IS NOT NULL");
    }

    @Test
    public void testFullJoinWithRightConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM (SELECT * FROM dc.tpch.tiny.lineitem WHERE orderkey % 1024 = 0) lineitem FULL JOIN orders ON lineitem.orderkey = 1024");
    }

    @Test
    public void testFullJoinWithLeftConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM (SELECT * FROM dc.tpch.tiny.lineitem WHERE orderkey % 1024 = 0) lineitem FULL JOIN orders ON orders.orderkey = 1024");
    }

    @Test
    public void testSimpleFullJoinWithLeftConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM dc.tpch.tiny.lineitem FULL JOIN orders ON dc.tpch.tiny.lineitem.orderkey = orders.orderkey AND orders.orderkey = 2");
    }

    @Test
    public void testSimpleFullJoinWithRightConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM dc.tpch.tiny.lineitem FULL JOIN orders ON dc.tpch.tiny.lineitem.orderkey = orders.orderkey AND dc.tpch.tiny.lineitem.orderkey = 2");
    }

    @Test
    public void testOuterJoinWithNullsOnProbe() {
        this.assertQuery("SELECT DISTINCT a.orderkey FROM (SELECT CASE WHEN orderkey > 10 THEN orderkey END orderkey FROM orders WHERE orderkey < 100) a RIGHT OUTER JOIN (SELECT * FROM orders WHERE orderkey < 100) b ON a.orderkey = b.orderkey");
        this.assertQuery("SELECT DISTINCT a.orderkey FROM (SELECT CASE WHEN orderkey > 2 THEN orderkey END orderkey FROM orders WHERE orderkey < 100) a FULL OUTER JOIN (SELECT * FROM orders WHERE orderkey < 100) b ON a.orderkey = b.orderkey");
    }

    @Test
    public void testSimpleLeftJoin() {
        this.assertQuery("SELECT COUNT(*) FROM dc.tpch.tiny.lineitem LEFT JOIN orders ON dc.tpch.tiny.lineitem.orderkey = orders.orderkey");
        this.assertQuery("SELECT COUNT(*) FROM dc.tpch.tiny.lineitem LEFT OUTER JOIN orders ON dc.tpch.tiny.lineitem.orderkey = orders.orderkey");
    }

    @Test
    public void testLeftJoinNormalizedToInner() {
        this.assertQuery("SELECT COUNT(*) FROM dc.tpch.tiny.lineitem LEFT JOIN orders ON dc.tpch.tiny.lineitem.orderkey = orders.orderkey WHERE orders.orderkey IS NOT NULL");
    }

    @Test
    public void testLeftJoinWithRightConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM (SELECT * FROM dc.tpch.tiny.lineitem WHERE orderkey % 1024 = 0) lineitem LEFT JOIN orders ON lineitem.orderkey = 1024");
    }

    @Test
    public void testLeftJoinWithLeftConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM (SELECT * FROM dc.tpch.tiny.lineitem WHERE orderkey % 1024 = 0) lineitem LEFT JOIN orders ON orders.orderkey = 1024");
    }

    @Test
    public void testSimpleLeftJoinWithLeftConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM dc.tpch.tiny.lineitem LEFT JOIN orders ON dc.tpch.tiny.lineitem.orderkey = orders.orderkey AND orders.orderkey = 2");
    }

    @Test
    public void testSimpleLeftJoinWithRightConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM dc.tpch.tiny.lineitem LEFT JOIN orders ON dc.tpch.tiny.lineitem.orderkey = orders.orderkey AND dc.tpch.tiny.lineitem.orderkey = 2");
    }

    @Test
    public void testDoubleFilteredLeftJoinWithRightConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM (SELECT * FROM dc.tpch.tiny.lineitem WHERE orderkey % 1024 = 0) lineitem LEFT JOIN (SELECT * FROM orders WHERE orderkey % 1024 = 0) orders ON orders.orderkey = 1024");
    }

    @Test
    public void testDoubleFilteredLeftJoinWithLeftConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM (SELECT * FROM dc.tpch.tiny.lineitem WHERE orderkey % 1024 = 0) lineitem LEFT JOIN (SELECT * FROM orders WHERE orderkey % 1024 = 0) orders ON lineitem.orderkey = 1024");
    }

    @Test
    public void testLeftJoinDoubleClauseWithLeftOverlap() {
        this.assertQuery("SELECT COUNT(*) FROM dc.tpch.tiny.lineitem LEFT JOIN orders ON dc.tpch.tiny.lineitem.orderkey = orders.orderkey AND dc.tpch.tiny.lineitem.orderkey = orders.custkey");
    }

    @Test
    public void testLeftJoinDoubleClauseWithRightOverlap() {
        this.assertQuery("SELECT COUNT(*) FROM dc.tpch.tiny.lineitem LEFT JOIN orders ON dc.tpch.tiny.lineitem.orderkey = orders.orderkey AND orders.orderkey = dc.tpch.tiny.lineitem.partkey");
    }

    @Test
    public void testBuildFilteredLeftJoin() {
        this.assertQuery("SELECT * FROM dc.tpch.tiny.lineitem LEFT JOIN (SELECT * FROM orders WHERE orderkey % 2 = 0) a ON dc.tpch.tiny.lineitem.orderkey = a.orderkey");
    }

    @Test
    public void testProbeFilteredLeftJoin() {
        this.assertQuery("SELECT * FROM (SELECT * FROM dc.tpch.tiny.lineitem WHERE orderkey % 2 = 0) a LEFT JOIN orders ON a.orderkey = orders.orderkey");
    }

    @Test
    public void testLeftJoinPredicateMoveAround() {
        this.assertQuery("SELECT COUNT(*)\nFROM (SELECT * FROM dc.tpch.tiny.lineitem WHERE orderkey % 16 = 0 AND partkey % 2 = 0) lineitem\nLEFT JOIN (SELECT * FROM orders WHERE orderkey % 16 = 0 AND custkey % 2 = 0) orders\nON lineitem.orderkey % 8 = orders.orderkey % 8\nWHERE (orders.custkey % 8 < 7 OR orders.custkey % 8 IS NULL) AND orders.custkey % 8 = lineitem.orderkey % 8");
    }

    @Test
    public void testLeftJoinEqualityInference() {
        this.assertQuery("SELECT COUNT(*)\nFROM (SELECT * FROM dc.tpch.tiny.lineitem WHERE orderkey % 4 = 0 AND suppkey % 2 = partkey % 2 AND linenumber % 3 = orderkey % 3) lineitem\nLEFT JOIN (SELECT * FROM orders WHERE orderkey % 4 = 0) orders\nON lineitem.linenumber % 3 = orders.orderkey % 4 AND lineitem.orderkey % 3 = orders.custkey % 3\nWHERE lineitem.suppkey % 2 = lineitem.linenumber % 3");
    }

    @Test
    public void testLeftJoinWithNullValues() {
        this.assertQuery("SELECT *\nFROM (\n  SELECT CASE WHEN orderkey % 3 = 0 THEN NULL ELSE orderkey END AS orderkey\n  FROM dc.tpch.tiny.lineitem\n  WHERE partkey % 512 = 0\n) AS lineitem \nLEFT JOIN (\n  SELECT CASE WHEN orderkey % 2 = 0 THEN NULL ELSE orderkey END AS orderkey\n  FROM orders\n  WHERE custkey % 512 = 0\n) AS orders\nON lineitem.orderkey = orders.orderkey");
    }

    @Test
    public void testSimpleRightJoin() {
        this.assertQuery("SELECT COUNT(*) FROM dc.tpch.tiny.lineitem RIGHT JOIN orders ON dc.tpch.tiny.lineitem.orderkey = orders.orderkey");
        this.assertQuery("SELECT COUNT(*) FROM dc.tpch.tiny.lineitem RIGHT OUTER JOIN orders ON dc.tpch.tiny.lineitem.orderkey = orders.orderkey");
        this.assertQuery("SELECT COUNT(*) FROM dc.tpch.tiny.lineitem RIGHT JOIN orders ON dc.tpch.tiny.lineitem.orderkey = orders.custkey");
        this.assertQuery("SELECT COUNT(*) FROM dc.tpch.tiny.lineitem RIGHT OUTER JOIN orders ON dc.tpch.tiny.lineitem.orderkey = orders.custkey");
    }

    @Test
    public void testRightJoinNormalizedToInner() {
        this.assertQuery("SELECT COUNT(*) FROM dc.tpch.tiny.lineitem RIGHT JOIN orders ON dc.tpch.tiny.lineitem.orderkey = orders.orderkey WHERE dc.tpch.tiny.lineitem.orderkey IS NOT NULL");
        this.assertQuery("SELECT COUNT(*) FROM dc.tpch.tiny.lineitem RIGHT JOIN orders ON dc.tpch.tiny.lineitem.orderkey = orders.custkey WHERE dc.tpch.tiny.lineitem.orderkey IS NOT NULL");
    }

    @Test
    public void testRightJoinWithRightConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM (SELECT * FROM dc.tpch.tiny.lineitem WHERE orderkey % 1024 = 0) lineitem RIGHT JOIN orders ON lineitem.orderkey = 1024");
    }

    @Test
    public void testRightJoinWithLeftConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM (SELECT * FROM dc.tpch.tiny.lineitem WHERE orderkey % 1024 = 0) lineitem RIGHT JOIN orders ON orders.orderkey = 1024");
    }

    @Test
    public void testDoubleFilteredRightJoinWithRightConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM (SELECT * FROM dc.tpch.tiny.lineitem WHERE orderkey % 1024 = 0) lineitem RIGHT JOIN (SELECT * FROM orders WHERE orderkey % 1024 = 0) orders ON orders.orderkey = 1024");
    }

    @Test
    public void testDoubleFilteredRightJoinWithLeftConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM (SELECT * FROM dc.tpch.tiny.lineitem WHERE orderkey % 1024 = 0) lineitem RIGHT JOIN (SELECT * FROM orders WHERE orderkey % 1024 = 0) orders ON lineitem.orderkey = 1024");
    }

    @Test
    public void testSimpleRightJoinWithLeftConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM dc.tpch.tiny.lineitem RIGHT JOIN orders ON dc.tpch.tiny.lineitem.orderkey = orders.orderkey AND orders.orderkey = 2");
    }

    @Test
    public void testSimpleRightJoinWithRightConstantEquality() {
        this.assertQuery("SELECT COUNT(*) FROM dc.tpch.tiny.lineitem RIGHT JOIN orders ON dc.tpch.tiny.lineitem.orderkey = orders.orderkey AND dc.tpch.tiny.lineitem.orderkey = 2");
    }

    @Test
    public void testRightJoinDoubleClauseWithLeftOverlap() {
        this.assertQuery("SELECT COUNT(*) FROM dc.tpch.tiny.lineitem RIGHT JOIN orders ON dc.tpch.tiny.lineitem.orderkey = orders.orderkey AND dc.tpch.tiny.lineitem.orderkey = orders.custkey");
    }

    @Test
    public void testRightJoinDoubleClauseWithRightOverlap() {
        this.assertQuery("SELECT COUNT(*) FROM dc.tpch.tiny.lineitem RIGHT JOIN orders ON dc.tpch.tiny.lineitem.orderkey = orders.orderkey AND orders.orderkey = dc.tpch.tiny.lineitem.partkey");
    }

    @Test
    public void testBuildFilteredRightJoin() {
        this.assertQuery("SELECT custkey, linestatus, tax, totalprice, orderstatus FROM (SELECT * FROM dc.tpch.tiny.lineitem WHERE orderkey % 2 = 0) a RIGHT JOIN orders ON a.orderkey = orders.orderkey");
    }

    @Test
    public void testProbeFilteredRightJoin() {
        this.assertQuery("SELECT custkey, linestatus, tax, totalprice, orderstatus FROM dc.tpch.tiny.lineitem RIGHT JOIN (SELECT *  FROM orders WHERE orderkey % 2 = 0) a ON dc.tpch.tiny.lineitem.orderkey = a.orderkey");
    }

    @Test
    public void testRightJoinPredicateMoveAround() {
        this.assertQuery("SELECT COUNT(*)\nFROM (SELECT * FROM orders WHERE orderkey % 16 = 0 AND custkey % 2 = 0) orders\nRIGHT JOIN (SELECT * FROM dc.tpch.tiny.lineitem WHERE orderkey % 16 = 0 AND partkey % 2 = 0) lineitem\nON lineitem.orderkey % 8 = orders.orderkey % 8\nWHERE (orders.custkey % 8 < 7 OR orders.custkey % 8 IS NULL) AND orders.custkey % 8 = lineitem.orderkey % 8");
    }

    @Test
    public void testRightJoinEqualityInference() {
        this.assertQuery("SELECT COUNT(*)\nFROM (SELECT * FROM orders WHERE orderkey % 4 = 0) orders\nRIGHT JOIN (SELECT * FROM dc.tpch.tiny.lineitem WHERE orderkey % 4 = 0 AND suppkey % 2 = partkey % 2 AND linenumber % 3 = orderkey % 3) lineitem\nON lineitem.linenumber % 3 = orders.orderkey % 4 AND lineitem.orderkey % 3 = orders.custkey % 3\nWHERE lineitem.suppkey % 2 = lineitem.linenumber % 3");
    }

    @Test
    public void testRightJoinWithNullValues() {
        this.assertQuery("SELECT lineitem.orderkey, orders.orderkey\nFROM (\n  SELECT CASE WHEN orderkey % 3 = 0 THEN NULL ELSE orderkey END AS orderkey\n  FROM dc.tpch.tiny.lineitem\n  WHERE partkey % 512 = 0\n) AS lineitem \nRIGHT JOIN (\n  SELECT CASE WHEN orderkey % 2 = 0 THEN NULL ELSE orderkey END AS orderkey\n  FROM orders\n  WHERE custkey % 512 = 0\n) AS orders\nON lineitem.orderkey = orders.orderkey");
    }

    @Test
    public void testJoinWithStatefulFilterFunction() {
        long joinOutputRowCount = 60175L;
        this.assertQuery(String.format("SELECT count(*) FROM dc.tpch.tiny.lineitem l LEFT OUTER JOIN orders o ON l.orderkey = o.orderkey AND stateful_sleeping_sum(%s, 100, l.linenumber, o.shippriority) > 0", 10.0 / (double)joinOutputRowCount));
    }

    @Test
    public void testJoinWithGroupByAsProbe() {
        this.assertQuery("SELECT   b.orderkey,   b.custkey,   a.custkey FROM (   SELECT custkey  FROM orders   GROUP BY custkey) a JOIN orders b   ON a.custkey = b.custkey ");
    }

    @Test
    public void testJoinEffectivePredicateWithNoRanges() {
        this.assertQuery("SELECT * FROM orders a    JOIN (SELECT * FROM orders WHERE orderkey IS NULL) b    ON a.orderkey = b.orderkey");
    }

    @Test
    public void testJoinUnaliasedSubqueries() {
        this.assertQuery("SELECT COUNT(*) FROM (SELECT * FROM dc.tpch.tiny.lineitem) JOIN (SELECT * FROM orders) USING (orderkey)");
    }

    @Test
    public void testWithSelfJoin() {
        this.assertQuery("WITH x AS (SELECT DISTINCT orderkey FROM orders ORDER BY orderkey LIMIT 10)\nSELECT count(*) FROM x a JOIN x b USING (orderkey)");
    }

    @Test
    public void testJoinProjectionPushDown() {
        this.assertQuery("SELECT *\nFROM\n  (SELECT orderkey, abs(orderkey) a FROM orders) t\nJOIN\n  (SELECT orderkey, abs(orderkey) a FROM orders) u\nON\n  t.orderkey = u.orderkey");
    }

    @Test
    public void testRandCrossJoins() {
        this.assertQuery("SELECT COUNT(*) FROM (SELECT * FROM orders ORDER BY rand() LIMIT 5) a CROSS JOIN (SELECT * FROM dc.tpch.tiny.lineitem ORDER BY rand() LIMIT 5) b");
    }

    @Test
    public void testCrossJoins() {
        this.assertQuery("SELECT a.custkey, b.orderkey FROM (SELECT * FROM orders ORDER BY orderkey LIMIT 5) a CROSS JOIN (SELECT * FROM dc.tpch.tiny.lineitem ORDER BY orderkey LIMIT 5) b");
    }

    @Test
    public void testCrossJoinEmptyProbePage() {
        this.assertQuery("SELECT a.custkey, b.orderkey FROM (SELECT * FROM orders WHERE orderkey < 0) a CROSS JOIN (SELECT * FROM dc.tpch.tiny.lineitem WHERE orderkey < 100) b");
    }

    @Test
    public void testCrossJoinEmptyBuildPage() {
        this.assertQuery("SELECT a.custkey, b.orderkey FROM (SELECT * FROM orders WHERE orderkey < 100) a CROSS JOIN (SELECT * FROM dc.tpch.tiny.lineitem WHERE orderkey < 0) b");
    }

    @Test
    public void testImplicitCrossJoin() {
        this.assertQuery("SELECT * FROM (SELECT * FROM orders ORDER BY orderkey LIMIT 3) a, (SELECT * FROM orders ORDER BY orderkey LIMIT 4) b");
        this.assertQuery("SELECT * FROM (SELECT * FROM orders ORDER BY orderkey LIMIT 5) a, (SELECT * FROM orders ORDER BY orderkey LIMIT 2) b");
        this.assertQuery("SELECT * FROM (SELECT * FROM orders ORDER BY orderkey LIMIT 5) a, (SELECT * FROM orders ORDER BY orderkey LIMIT 5) b, (SELECT * FROM orders ORDER BY orderkey LIMIT 5) c ");
        this.assertQuery("SELECT l.orderkey, l.linenumber FROM orders o INNER JOIN dc.tpch.tiny.lineitem l ON o.custkey = l.linenumber WHERE o.custkey IN (5) AND l.orderkey IN (7522)");
        this.assertQuery("SELECT o.custkey FROM orders o INNER JOIN dc.tpch.tiny.lineitem l ON o.custkey = l.linenumber WHERE o.custkey IN (5) AND l.orderkey IN (7522)");
        this.assertQuery("SELECT COUNT(*) FROM orders o INNER JOIN dc.tpch.tiny.lineitem l ON o.custkey = l.linenumber WHERE o.custkey IN (5) AND l.orderkey IN (7522)");
    }

    @Test
    public void testSemiJoin() {
        this.assertQuery("SELECT linenumber, min(orderkey) FROM dc.tpch.tiny.lineitem GROUP BY linenumber HAVING min(orderkey) IN (SELECT orderkey FROM orders WHERE orderkey > 1)");
        this.assertQuery("SELECT *, o2.custkey\n  IN (\n    SELECT orderkey\n    FROM dc.tpch.tiny.lineitem\n    WHERE orderkey % 5 = 0)\nFROM (SELECT * FROM orders WHERE custkey % 256 = 0) o1\nJOIN (SELECT * FROM orders WHERE custkey % 256 = 0) o2\n  ON (o1.orderkey IN (SELECT orderkey FROM dc.tpch.tiny.lineitem WHERE orderkey % 4 = 0)) = (o2.orderkey IN (SELECT orderkey FROM dc.tpch.tiny.lineitem WHERE orderkey % 4 = 0))\nWHERE o1.orderkey\n  IN (\n    SELECT orderkey\n    FROM dc.tpch.tiny.lineitem\n    WHERE orderkey % 4 = 0)\nORDER BY o1.orderkey\n  IN (\n    SELECT orderkey\n    FROM dc.tpch.tiny.lineitem\n    WHERE orderkey % 7 = 0)");
        this.assertQuery("SELECT orderkey\n  IN (\n    SELECT orderkey\n    FROM dc.tpch.tiny.lineitem\n    WHERE partkey % 4 = 0),\n  SUM(\n    CASE\n      WHEN orderkey\n        IN (\n          SELECT orderkey\n          FROM dc.tpch.tiny.lineitem\n          WHERE suppkey % 4 = 0)\n      THEN 1\n      ELSE 0\n      END)\nFROM orders\nGROUP BY orderkey\n  IN (\n    SELECT orderkey\n    FROM dc.tpch.tiny.lineitem\n    WHERE partkey % 4 = 0)\nHAVING SUM(\n  CASE\n    WHEN orderkey\n      IN (\n        SELECT orderkey\n        FROM dc.tpch.tiny.lineitem\n        WHERE suppkey % 4 = 0)\n      THEN 1\n      ELSE 0\n      END) > 1");
    }

    @Test
    public void testJoinConstantPropagation() {
        this.assertQuery("SELECT x, y, COUNT(*)\nFROM (SELECT orderkey, 0 AS x FROM orders) a \nJOIN (SELECT orderkey, 1 AS y FROM orders) b \nON a.orderkey = b.orderkey\nGROUP BY 1, 2");
    }

    @Test
    public void testAntiJoin() {
        this.assertQuery("SELECT *, orderkey\n  NOT IN (\n    SELECT orderkey\n    FROM dc.tpch.tiny.lineitem\n    WHERE orderkey % 3 = 0)\nFROM orders");
    }

    @Test
    public void testSemiJoinLimitPushDown() {
        this.assertQuery("SELECT COUNT(*)\nFROM (\n  SELECT orderkey\n  IN (\n    SELECT orderkey\n    FROM dc.tpch.tiny.lineitem\n    WHERE orderkey % 2 = 0)\n  FROM orders\n  LIMIT 10)");
    }

    @Test
    public void testSemiJoinNullHandling() {
        this.assertQuery("SELECT orderkey\n  IN (\n    SELECT CASE WHEN orderkey % 3 = 0 THEN NULL ELSE orderkey END\n    FROM dc.tpch.tiny.lineitem)\nFROM orders");
        this.assertQuery("SELECT orderkey\n  IN (\n    SELECT orderkey\n    FROM dc.tpch.tiny.lineitem)\nFROM (\n  SELECT CASE WHEN orderkey % 3 = 0 THEN NULL ELSE orderkey END AS orderkey\n  FROM orders)");
        this.assertQuery("SELECT orderkey\n  IN (\n    SELECT CASE WHEN orderkey % 3 = 0 THEN NULL ELSE orderkey END\n    FROM dc.tpch.tiny.lineitem)\nFROM (\n  SELECT CASE WHEN orderkey % 4 = 0 THEN NULL ELSE orderkey END AS orderkey\n  FROM orders)");
    }

    @Test
    public void testSemiJoinWithGroupBy() {
        this.assertQuery("SELECT linenumber, min(orderkey), 6 IN (SELECT orderkey FROM orders WHERE orderkey < 7)FROM dc.tpch.tiny.lineitem GROUP BY linenumber");
        this.assertQuery("SELECT linenumber, min(orderkey), 6 IN (SELECT orderkey FROM orders WHERE orderkey < 7)FROM dc.tpch.tiny.lineitem GROUP BY linenumber, 6 IN (SELECT orderkey FROM orders WHERE orderkey < 7)");
        this.assertQuery("SELECT linenumber, min(orderkey) FROM dc.tpch.tiny.lineitem GROUP BY linenumber, 6 IN (SELECT orderkey FROM orders WHERE orderkey < 7)");
        this.assertQuery("SELECT linenumber, min(orderkey) FROM dc.tpch.tiny.lineitem GROUP BY linenumber HAVING 6 IN (SELECT orderkey FROM orders WHERE orderkey < 7)");
        this.assertQuery("SELECT linenumber, min(orderkey), 6 IN (SELECT orderkey FROM orders WHERE orderkey < 7)FROM dc.tpch.tiny.lineitem GROUP BY linenumber, 6 IN (SELECT orderkey FROM orders WHERE orderkey < 7)HAVING 6 IN (SELECT orderkey FROM orders WHERE orderkey < 7)");
        this.assertQuery("SELECT linenumber, min(orderkey), 6 IN (SELECT max(orderkey) FROM orders WHERE orderkey < 7)FROM dc.tpch.tiny.lineitem GROUP BY linenumber, 6 IN (SELECT sum(orderkey) FROM orders WHERE orderkey < 5)");
        this.assertQuery("SELECT linenumber, min(orderkey) FROM dc.tpch.tiny.lineitem GROUP BY linenumber, 6 IN (SELECT orderkey FROM orders WHERE orderkey < 7)HAVING 6 IN (SELECT orderkey FROM orders WHERE orderkey > 3)");
        this.assertQuery("SELECT linenumber, min(orderkey), 6 IN (SELECT orderkey FROM orders WHERE orderkey < 7)FROM dc.tpch.tiny.lineitem GROUP BY linenumber, 6 IN (SELECT orderkey FROM orders WHERE orderkey < 5)HAVING 6 IN (SELECT orderkey FROM orders WHERE orderkey > 3)");
    }

    @Test
    public void testSemiJoinUnionNullHandling() {
        this.assertQuery("SELECT orderkey\n  IN (\n    SELECT CASE WHEN orderkey % 500 = 0 THEN NULL ELSE orderkey END\n    FROM orders\n    WHERE orderkey % 200 = 0\n    UNION ALL\n    SELECT CASE WHEN orderkey % 600 = 0 THEN NULL ELSE orderkey END\n    FROM orders\n    WHERE orderkey % 300 = 0\n  )\nFROM (\n  SELECT orderkey\n  FROM dc.tpch.tiny.lineitem\n  WHERE orderkey % 100 = 0)");
    }

    @Test
    public void testSemiJoinAggregationNullHandling() {
        this.assertQuery("SELECT orderkey\n  IN (\n    SELECT CASE WHEN orderkey % 10 = 0 THEN NULL ELSE orderkey END\n    FROM dc.tpch.tiny.lineitem\n    WHERE orderkey % 2 = 0\n    GROUP BY orderkey\n  )\nFROM (\n  SELECT orderkey\n  FROM orders\n  WHERE orderkey % 3 = 0)");
    }

    @Test
    public void testSemiJoinUnionAggregationNullHandling() {
        this.assertQuery("SELECT orderkey\n  IN (\n    SELECT CASE WHEN orderkey % 500 = 0 THEN NULL ELSE orderkey END\n    FROM dc.tpch.tiny.lineitem\n    WHERE orderkey % 250 = 0\n    UNION ALL\n    SELECT CASE WHEN orderkey % 300 = 0 THEN NULL ELSE orderkey END\n    FROM dc.tpch.tiny.lineitem\n    WHERE orderkey % 200 = 0\n    GROUP BY orderkey\n  )\nFROM (\n  SELECT orderkey\n  FROM orders\n  WHERE orderkey % 100 = 0)\n");
    }

    @Test
    public void testSemiJoinAggregationUnionNullHandling() {
        this.assertQuery("SELECT orderkey\n  IN (\n    SELECT orderkey\n    FROM (\n      SELECT CASE WHEN orderkey % 500 = 0 THEN NULL ELSE orderkey END AS orderkey\n      FROM orders\n      WHERE orderkey % 200 = 0\n      UNION ALL\n      SELECT CASE WHEN orderkey % 600 = 0 THEN NULL ELSE orderkey END AS orderkey\n      FROM orders\n      WHERE orderkey % 300 = 0\n    )\n    GROUP BY orderkey\n  )\nFROM (\n  SELECT orderkey\n  FROM dc.tpch.tiny.lineitem\n  WHERE orderkey % 100 = 0)");
    }

    @Test
    public void testJoinPredicatePushdown() {
        this.assertQuery("SELECT COUNT(*)\nFROM dc.tpch.tiny.lineitem \nJOIN (\n  SELECT * FROM orders\n) orders \nON dc.tpch.tiny.lineitem.orderkey = orders.orderkey \nWHERE orders.orderkey % 4 = 0\n  AND dc.tpch.tiny.lineitem.suppkey > orders.orderkey");
    }

    @Test
    public void testLeftJoinAsInnerPredicatePushdown() {
        this.assertQuery("SELECT COUNT(*)\nFROM dc.tpch.tiny.lineitem \nLEFT JOIN (\n  SELECT * FROM orders WHERE orders.orderkey % 2 = 0\n) orders \nON dc.tpch.tiny.lineitem.orderkey = orders.orderkey \nWHERE orders.orderkey % 4 = 0\n  AND (dc.tpch.tiny.lineitem.suppkey % 2 = orders.orderkey % 2 OR orders.custkey IS NULL)");
    }

    @Test
    public void testPlainLeftJoinPredicatePushdown() {
        this.assertQuery("SELECT COUNT(*)\nFROM dc.tpch.tiny.lineitem \nLEFT JOIN (\n  SELECT * FROM orders WHERE orders.orderkey % 2 = 0\n) orders \nON dc.tpch.tiny.lineitem.orderkey = orders.orderkey \nWHERE dc.tpch.tiny.lineitem.orderkey % 4 = 0\n  AND (dc.tpch.tiny.lineitem.suppkey % 2 = orders.orderkey % 2 OR orders.orderkey IS NULL)");
    }

    @Test
    public void testLeftJoinPredicatePushdownWithSelfEquality() {
        this.assertQuery("SELECT COUNT(*)\nFROM dc.tpch.tiny.lineitem \nLEFT JOIN (\n  SELECT * FROM orders WHERE orders.orderkey % 2 = 0\n) orders \nON dc.tpch.tiny.lineitem.orderkey = orders.orderkey \nWHERE orders.orderkey = orders.orderkey\n  AND dc.tpch.tiny.lineitem.orderkey % 4 = 0\n  AND (dc.tpch.tiny.lineitem.suppkey % 2 = orders.orderkey % 2 OR orders.orderkey IS NULL)");
    }

    @Test
    public void testLeftJoinPredicatePushdownWithNullConstant() {
        this.assertQuery("SELECT count(*)\nFROM orders a\nLEFT OUTER JOIN orders b\n  ON a.clerk = b.clerk\nWHERE a.orderpriority='5-LOW'\n  AND b.orderpriority='1-URGENT'\n  AND b.clerk is null\n  AND a.orderkey % 4 = 0\n");
    }

    @Test
    public void testRightJoinAsInnerPredicatePushdown() {
        this.assertQuery("SELECT COUNT(*)\nFROM (\n  SELECT * FROM orders WHERE orders.orderkey % 2 = 0\n) orders\nRIGHT JOIN dc.tpch.tiny.lineitem\nON dc.tpch.tiny.lineitem.orderkey = orders.orderkey \nWHERE orders.orderkey % 4 = 0\n  AND (dc.tpch.tiny.lineitem.suppkey % 2 = orders.orderkey % 2 OR orders.custkey IS NULL)");
    }

    @Test
    public void testPlainRightJoinPredicatePushdown() {
        this.assertQuery("SELECT COUNT(*)\nFROM (\n  SELECT * FROM orders WHERE orders.orderkey % 2 = 0\n) orders \nRIGHT JOIN dc.tpch.tiny.lineitem\nON dc.tpch.tiny.lineitem.orderkey = orders.orderkey \nWHERE dc.tpch.tiny.lineitem.orderkey % 4 = 0\n  AND (dc.tpch.tiny.lineitem.suppkey % 2 = orders.orderkey % 2 OR orders.orderkey IS NULL)");
    }

    @Test
    public void testRightJoinPredicatePushdownWithSelfEquality() {
        this.assertQuery("SELECT COUNT(*)\nFROM (\n  SELECT * FROM orders WHERE orders.orderkey % 2 = 0\n) orders \nRIGHT JOIN dc.tpch.tiny.lineitem\nON dc.tpch.tiny.lineitem.orderkey = orders.orderkey \nWHERE orders.orderkey = orders.orderkey\n  AND dc.tpch.tiny.lineitem.orderkey % 4 = 0\n  AND (dc.tpch.tiny.lineitem.suppkey % 2 = orders.orderkey % 2 OR orders.orderkey IS NULL)");
    }

    @Test
    public void testPredicatePushdownJoinEqualityGroups() {
        this.assertQuery("SELECT *\nFROM (\n  SELECT custkey custkey1, custkey%4 custkey1a, custkey%8 custkey1b, custkey%16 custkey1c\n  FROM orders\n) orders1 \nJOIN (\n  SELECT custkey custkey2, custkey%4 custkey2a, custkey%8 custkey2b\n  FROM orders\n) orders2 ON orders1.custkey1 = orders2.custkey2\nWHERE custkey2a = custkey2b\n  AND custkey1 = custkey1a\n  AND custkey2 = custkey2a\n  AND custkey1a = custkey1c\n  AND custkey1b = custkey1c\n  AND custkey1b % 2 = 0");
    }

    @Test
    public void testSemiJoinPredicateMoveAround() {
        this.assertQuery("SELECT COUNT(*)\nFROM (SELECT * FROM orders WHERE custkey % 2 = 0 AND orderkey % 3 = 0)\nWHERE orderkey\n  IN (\n    SELECT CASE WHEN orderkey % 7 = 0 THEN NULL ELSE orderkey END\n    FROM dc.tpch.tiny.lineitem\n    WHERE partkey % 2 = 0)\n  AND\n    orderkey % 2 = 0");
    }

    @Test
    public void testRightJoinWithEmptyBuildSide() {
        this.assertQuery("WITH small_part AS (SELECT * FROM part WHERE name = 'a') SELECT dc.tpch.tiny.lineitem.orderkey FROM dc.tpch.tiny.lineitem RIGHT JOIN small_part ON dc.tpch.tiny.lineitem.partkey = small_part.partkey");
    }

    @Test
    public void testLeftJoinWithEmptyBuildSide() {
        this.assertQuery("WITH small_part AS (SELECT * FROM part WHERE name = 'a') SELECT dc.tpch.tiny.lineitem.orderkey FROM dc.tpch.tiny.lineitem LEFT JOIN small_part ON dc.tpch.tiny.lineitem.partkey = small_part.partkey");
    }

    @Test
    public void testFullJoinWithEmptyBuildSide() {
        this.assertQuery("WITH small_part AS (SELECT * FROM part WHERE name = 'a') SELECT dc.tpch.tiny.lineitem.orderkey FROM dc.tpch.tiny.lineitem FULL OUTER JOIN small_part ON dc.tpch.tiny.lineitem.partkey = small_part.partkey");
    }

    @Test
    public void testInnerJoinWithEmptyProbeSide() {
        this.assertQuery("WITH small_part AS (SELECT * FROM part WHERE name = 'a') SELECT dc.tpch.tiny.lineitem.orderkey FROM small_part INNER JOIN dc.tpch.tiny.lineitem ON small_part.partkey = dc.tpch.tiny.lineitem.partkey");
    }

    @Test
    public void testRightJoinWithEmptyProbeSide() {
        this.assertQuery("WITH small_part AS (SELECT * FROM part WHERE name = 'a') SELECT dc.tpch.tiny.lineitem.orderkey FROM small_part RIGHT JOIN dc.tpch.tiny.lineitem ON  small_part.partkey = dc.tpch.tiny.lineitem.partkey");
    }

    private void assertQuery(String sql) {
        long disabledTime = System.currentTimeMillis();
        ResultWithQueryId expected = this.queryRunner.executeWithQueryId(this.disabledSession, sql);
        disabledTime = System.currentTimeMillis() - disabledTime;
        long enabledTime = System.currentTimeMillis();
        ResultWithQueryId actual = this.queryRunner.executeWithQueryId(this.enabledSession, sql);
        enabledTime = System.currentTimeMillis() - enabledTime;
        LOGGER.info("Ran '%s' without cross region df in %d ms and with cross region df in %d ms", new Object[]{sql, disabledTime, enabledTime});
        QueryAssertions.assertEqualsIgnoreOrder((Iterable)((Iterable)actual.getResult()), (Iterable)((Iterable)expected.getResult()), (String)"incorrect result");
    }

    private static DistributedQueryRunner createDCQueryRunner(TestingPrestoServer hetuServer, Map<String, String> properties) throws Exception {
        hetuServer.installPlugin((Plugin)new TpchPlugin());
        hetuServer.createCatalog("tpch", "tpch");
        DistributedQueryRunner queryRunner = null;
        try {
            queryRunner = DistributedQueryRunner.builder((Session)TestingSession.testSessionBuilder().build()).setNodeCount(1).build();
            HashMap<String, String> connectorProperties = new HashMap<String, String>(properties);
            connectorProperties.putIfAbsent("connection-url", hetuServer.getBaseUrl().toString());
            connectorProperties.putIfAbsent("connection-user", "root");
            queryRunner.installPlugin((Plugin)new DataCenterPlugin());
            queryRunner.createDCCatalog("dc", "dc", connectorProperties);
            queryRunner.installPlugin((Plugin)new TpchPlugin());
            queryRunner.createCatalog("tpch", "tpch", properties);
            return queryRunner;
        }
        catch (Throwable e) {
            Closeables.closeAllSuppress((Throwable)e, (Closeable[])new Closeable[]{queryRunner});
            throw e;
        }
    }
}

