/*
 * Decompiled with CFR 0.152.
 */
package heretical.pointer.path.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import heretical.pointer.path.PointerCompiler;
import heretical.pointer.path.json.JSONPointer;
import java.lang.reflect.Type;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;

public class JSONPointerCompiler
implements PointerCompiler<JsonNode, ArrayNode> {
    private static Map<Type, Function<Object, JsonNode>> convert = new IdentityHashMap<Type, Function<Object, JsonNode>>();

    public JSONPointer compile(String path) {
        return new JSONPointer(path);
    }

    public PointerCompiler.Kind kind(JsonNode node) {
        if (node == null || node.isMissingNode()) {
            return null;
        }
        if (node.isArray()) {
            return PointerCompiler.Kind.Array;
        }
        if (node.isObject()) {
            return PointerCompiler.Kind.Map;
        }
        if (node.isValueNode()) {
            return PointerCompiler.Kind.Value;
        }
        throw new IllegalArgumentException("unknown node type: " + node.getNodeType());
    }

    public ArrayNode add(ArrayNode result, JsonNode node) {
        if (node != null) {
            result.add(node);
        }
        return result;
    }

    public ArrayNode addAll(ArrayNode into, ArrayNode from) {
        if (from == null) {
            return into;
        }
        return into.addAll(from);
    }

    public JsonNode first(ArrayNode node) {
        if (node == null) {
            return null;
        }
        return node.get(0);
    }

    public boolean isContainer(JsonNode node) {
        return node != null && node.isContainerNode();
    }

    public Iterator<Map.Entry<String, JsonNode>> entries(JsonNode node) {
        return node.fields();
    }

    public Iterable<JsonNode> iterable(JsonNode node) {
        return node;
    }

    public int size(JsonNode jsonNode) {
        if (jsonNode == null) {
            throw new IllegalArgumentException("jsonNode may not be null");
        }
        return jsonNode.size();
    }

    public ArrayNode resultNode() {
        return JsonNodeFactory.instance.arrayNode();
    }

    public JsonNode node(Object value) {
        if (value == null) {
            return JsonNodeFactory.instance.nullNode();
        }
        Class<?> from = value.getClass();
        if (JsonNode.class.isAssignableFrom(from)) {
            return (JsonNode)value;
        }
        return convert.getOrDefault(from, arg_0 -> ((JsonNodeFactory)JsonNodeFactory.instance).pojoNode(arg_0)).apply(value);
    }

    static {
        convert.put((Type)((Object)String.class), value -> JsonNodeFactory.instance.textNode((String)value));
        convert.put((Type)((Object)Integer.class), value -> JsonNodeFactory.instance.numberNode((Integer)value));
        convert.put(Integer.TYPE, value -> JsonNodeFactory.instance.numberNode((Integer)value));
        convert.put((Type)((Object)Long.class), value -> JsonNodeFactory.instance.numberNode((Long)value));
        convert.put(Long.TYPE, value -> JsonNodeFactory.instance.numberNode((Long)value));
        convert.put((Type)((Object)Float.class), value -> JsonNodeFactory.instance.numberNode((Float)value));
        convert.put(Float.TYPE, value -> JsonNodeFactory.instance.numberNode((Float)value));
        convert.put((Type)((Object)Double.class), value -> JsonNodeFactory.instance.numberNode((Double)value));
        convert.put(Double.TYPE, value -> JsonNodeFactory.instance.numberNode((Double)value));
        convert.put((Type)((Object)Boolean.class), value -> JsonNodeFactory.instance.booleanNode(((Boolean)value).booleanValue()));
        convert.put(Boolean.TYPE, value -> JsonNodeFactory.instance.booleanNode(((Boolean)value).booleanValue()));
    }
}

