/*
 * Decompiled with CFR 0.152.
 */
package heretical.pointer.path.json;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ContainerNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import heretical.pointer.path.Pointer;
import java.util.function.Function;
import java.util.function.Predicate;

public class JSONPointer
implements Pointer<JsonNode> {
    private static final JsonNodeFactory INSTANCE = JsonNodeFactory.instance;
    private final String path;
    private transient JsonPointer pointer;

    public JSONPointer(String path) {
        this.path = path;
        this.getPointer();
    }

    private JsonPointer getPointer() {
        if (this.pointer == null) {
            this.pointer = JsonPointer.compile((String)this.path);
        }
        return this.pointer;
    }

    public JsonNode at(JsonNode root) {
        JsonNode at = root.at(this.getPointer());
        if (at == null || at.isMissingNode()) {
            return null;
        }
        return at;
    }

    public JsonNode objectAt(JsonNode root) {
        if (this.getPointer().matches()) {
            return root;
        }
        return this.safeWith((JsonNode)this.parents(root, this.getPointer()), this.getPointer().last());
    }

    public JsonNode remove(JsonNode root) {
        JsonPointer last;
        JsonPointer head = this.getPointer().head();
        JsonNode parent = !head.matches() ? root.at(head) : root;
        JsonPointer jsonPointer = last = !this.getPointer().last().matches() ? this.getPointer().last() : this.getPointer();
        if (parent.isObject()) {
            return ((ObjectNode)parent).remove(last.getMatchingProperty());
        }
        if (parent.isArray()) {
            return ((ArrayNode)parent).remove(last.getMatchingIndex());
        }
        throw new IllegalStateException("parent node is of unknown object type: " + parent.getNodeType());
    }

    public void copy(JsonNode from, JsonNode into, Predicate<JsonNode> filter) {
        JsonPointer currentPointer = this.getPointer();
        JsonNode value = from.at(currentPointer);
        if (value == null || value.isMissingNode()) {
            return;
        }
        if (filter != null && !filter.test(value)) {
            return;
        }
        value = value.deepCopy();
        if (currentPointer.tail() == null) {
            ((ObjectNode)into).setAll((ObjectNode)value);
            return;
        }
        JsonNode currentNode = into;
        while (currentPointer.tail() != null) {
            int matchingIndex = currentPointer.getMatchingIndex();
            if (!currentPointer.tail().matches()) {
                currentNode = this.safeWith(currentNode, currentPointer);
                currentPointer = currentPointer.tail();
                continue;
            }
            if (matchingIndex == -1) {
                this.setOnObject((ObjectNode)currentNode, currentPointer, value, Function.identity());
                break;
            }
            this.addOnArray((ArrayNode)currentNode, value, Function.identity());
            break;
        }
    }

    protected JsonNode safeWith(JsonNode node, JsonPointer pointer) {
        if (node.isObject()) {
            node = pointer.tail().getMatchingIndex() == -1 ? node.with(pointer.getMatchingProperty()) : node.withArray(pointer.getMatchingProperty());
        } else if (node.isArray()) {
            node = pointer.tail().getMatchingIndex() == -1 ? ((ArrayNode)node).addObject() : ((ArrayNode)node).addArray();
        } else {
            throw new IllegalStateException("parent node is of unknown object type: " + node.getNodeType());
        }
        return node;
    }

    public void apply(JsonNode root, Function<JsonNode, JsonNode> transform) {
        JsonPointer last;
        ObjectNode parent;
        JsonPointer head = this.getPointer().head();
        Object object = parent = !head.matches() ? root.at(head) : (ObjectNode)root;
        if (parent == null || parent.isMissingNode()) {
            throw new IllegalArgumentException("parent is missing");
        }
        JsonPointer jsonPointer = last = !this.getPointer().last().matches() ? this.getPointer().last() : this.getPointer();
        if (parent.isObject() && parent.has(last.getMatchingProperty())) {
            this.setOnObject(parent, last, parent.get(last.getMatchingProperty()), transform);
        } else if (parent.isArray() && parent.has(last.getMatchingIndex())) {
            this.setOnArray((ArrayNode)parent, last, parent.get(last.getMatchingIndex()), transform);
        } else if (!parent.isObject() && !parent.isArray()) {
            throw new IllegalStateException("parent node is of unknown object type: " + parent.getNodeType());
        }
    }

    public void set(JsonNode root, JsonNode child, Function<JsonNode, JsonNode> transform) {
        ContainerNode parent = this.parents(root, this.getPointer());
        JsonPointer last = !this.getPointer().last().matches() ? this.getPointer().last() : this.getPointer();
        this.update((JsonNode)parent, last, child, transform, true);
    }

    public void add(JsonNode root, JsonNode child, Function<JsonNode, JsonNode> transform) {
        ContainerNode parent = this.parents(root, this.getPointer());
        JsonPointer last = !this.getPointer().last().matches() ? this.getPointer().last() : this.getPointer();
        this.update((JsonNode)parent, last, child, transform, false);
    }

    protected ContainerNode parents(JsonNode root, JsonPointer pointer) {
        JsonNode parent;
        JsonPointer head = pointer.head();
        JsonNode jsonNode = parent = !head.matches() ? root.at(head) : root;
        if (!parent.isContainerNode() && !parent.isMissingNode()) {
            throw new IllegalArgumentException("parent node at:" + head + ", is not a container node");
        }
        if (!parent.isMissingNode()) {
            return (ContainerNode)parent;
        }
        parent = pointer.last().mayMatchElement() ? INSTANCE.arrayNode() : INSTANCE.objectNode();
        ContainerNode ancestor = this.parents(root, head);
        this.update((JsonNode)ancestor, head.last(), parent, Function.identity(), true);
        return (ContainerNode)parent;
    }

    protected void update(JsonNode parent, JsonPointer location, JsonNode child, Function<JsonNode, JsonNode> transform, boolean isSet) {
        if (!parent.isContainerNode()) {
            throw new IllegalArgumentException("parent node must be a container node, got: " + parent.getNodeType());
        }
        if (!isSet) {
            this.addTo(parent, location, child);
            return;
        }
        if (parent.isObject()) {
            this.setOnObject((ObjectNode)parent, location, child, transform);
        } else if (parent.isArray()) {
            this.setOnArray((ArrayNode)parent, location, child, transform);
        } else {
            throw new IllegalStateException("parent node is of unknown object type: " + parent.getNodeType());
        }
    }

    protected void addTo(JsonNode parent, JsonPointer last, JsonNode child) {
        JsonNode container = null;
        if (parent instanceof ObjectNode) {
            container = parent.get(last.getMatchingProperty());
        } else if (parent instanceof ArrayNode) {
            container = parent.get(last.getMatchingIndex());
        }
        if (container == null || container.isMissingNode()) {
            container = INSTANCE.arrayNode();
            if (parent.isObject()) {
                this.setOnObject((ObjectNode)parent, last, container, Function.identity());
            } else if (parent.isArray()) {
                this.addOnArray((ArrayNode)parent, container, Function.identity());
            }
        }
        if (!container.isArray()) {
            throw new IllegalStateException("node referenced by pointer is not an array: " + this.getPointer());
        }
        this.addOnArray((ArrayNode)container, child, Function.identity());
    }

    protected void setOnArray(ArrayNode parent, JsonPointer location, JsonNode child, Function<JsonNode, JsonNode> transform) {
        int matchingIndex;
        int size = parent.size();
        if (size - 1 < (matchingIndex = location.getMatchingIndex())) {
            for (int i = 0; i < 1 + matchingIndex - size; ++i) {
                parent.addNull();
            }
        }
        parent.set(matchingIndex, transform.apply(child));
    }

    protected void setOnObject(ObjectNode parent, JsonPointer location, JsonNode child, Function<JsonNode, JsonNode> transform) {
        parent.set(location.getMatchingProperty(), transform.apply(child));
    }

    protected void addOnArray(ArrayNode parent, JsonNode child, Function<JsonNode, JsonNode> transform) {
        parent.add(transform.apply(child));
    }

    public String toString() {
        return this.getPointer().toString();
    }
}

