/*
 * Decompiled with CFR 0.152.
 */
package heretical.pointer.operation.json.transform;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import heretical.pointer.operation.Transform;
import java.util.Map;

public class JSONSetTextTransform
implements Transform<JsonNode> {
    String name = null;
    String defaultReplace = null;
    String replace = null;

    public JSONSetTextTransform() {
    }

    public JSONSetTextTransform(String replace) {
        this.replace = replace;
    }

    public JSONSetTextTransform(String name, String defaultReplace) {
        this.name = name;
        this.defaultReplace = defaultReplace;
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("name may not be null or empty");
        }
    }

    public JsonNode apply(JsonNode node) {
        if (node.getNodeType() != JsonNodeType.STRING) {
            throw new IllegalStateException("can only be applied to a TextNode");
        }
        return JsonNodeFactory.instance.textNode(this.replace);
    }

    public boolean isResettable() {
        return this.name != null;
    }

    public void reset(Map<String, Object> values) {
        this.replace = JSONSetTextTransform.asString(values.getOrDefault(this.name, this.defaultReplace));
    }

    private static String asString(Object object) {
        return object == null ? null : object.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("JSONSetTextTransform{");
        sb.append("name='").append(this.name).append('\'');
        sb.append(", defaultReplace='").append(this.defaultReplace).append('\'');
        sb.append(", replace='").append(this.replace).append('\'');
        sb.append(", resettable=").append(this.isResettable());
        sb.append('}');
        return sb.toString();
    }
}

