/*
 * Decompiled with CFR 0.152.
 */
package io.hengam.lib.utils.rx;

import android.annotation.SuppressLint;
import android.os.Handler;
import android.os.Message;
import io.reactivex.Scheduler;
import io.reactivex.disposables.Disposable;
import io.reactivex.disposables.Disposables;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.TimeUnit;

final class HandlerScheduler
extends Scheduler {
    private final Handler handler;
    private final boolean async;

    HandlerScheduler(Handler handler, boolean async) {
        this.handler = handler;
        this.async = async;
    }

    @SuppressLint(value={"NewApi"})
    public Disposable scheduleDirect(Runnable run, long delay, TimeUnit unit) {
        if (run == null) {
            throw new NullPointerException("run == null");
        }
        if (unit == null) {
            throw new NullPointerException("unit == null");
        }
        run = RxJavaPlugins.onSchedule((Runnable)run);
        ScheduledRunnable scheduled = new ScheduledRunnable(this.handler, run);
        Message message = Message.obtain((Handler)this.handler, (Runnable)scheduled);
        if (this.async) {
            message.setAsynchronous(true);
        }
        this.handler.sendMessageDelayed(message, unit.toMillis(delay));
        return scheduled;
    }

    public Scheduler.Worker createWorker() {
        return new HandlerWorker(this.handler, this.async);
    }

    private static final class ScheduledRunnable
    implements Runnable,
    Disposable {
        private final Handler handler;
        private final Runnable delegate;
        private volatile boolean disposed;

        ScheduledRunnable(Handler handler, Runnable delegate) {
            this.handler = handler;
            this.delegate = delegate;
        }

        @Override
        public void run() {
            try {
                this.delegate.run();
            }
            catch (Throwable t) {
                RxJavaPlugins.onError((Throwable)t);
            }
        }

        public void dispose() {
            this.handler.removeCallbacks((Runnable)this);
            this.disposed = true;
        }

        public boolean isDisposed() {
            return this.disposed;
        }
    }

    private static final class HandlerWorker
    extends Scheduler.Worker {
        private final Handler handler;
        private final boolean async;
        private volatile boolean disposed;

        HandlerWorker(Handler handler, boolean async) {
            this.handler = handler;
            this.async = async;
        }

        @SuppressLint(value={"NewApi"})
        public Disposable schedule(Runnable run, long delay, TimeUnit unit) {
            if (run == null) {
                throw new NullPointerException("run == null");
            }
            if (unit == null) {
                throw new NullPointerException("unit == null");
            }
            if (this.disposed) {
                return Disposables.disposed();
            }
            run = RxJavaPlugins.onSchedule((Runnable)run);
            ScheduledRunnable scheduled = new ScheduledRunnable(this.handler, run);
            Message message = Message.obtain((Handler)this.handler, (Runnable)scheduled);
            message.obj = this;
            if (this.async) {
                message.setAsynchronous(true);
            }
            this.handler.sendMessageDelayed(message, unit.toMillis(delay));
            if (this.disposed) {
                this.handler.removeCallbacks((Runnable)scheduled);
                return Disposables.disposed();
            }
            return scheduled;
        }

        public void dispose() {
            this.disposed = true;
            this.handler.removeCallbacksAndMessages((Object)this);
        }

        public boolean isDisposed() {
            return this.disposed;
        }
    }
}

