/*
 * Decompiled with CFR 0.152.
 */
package io.hengam.lib.utils;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Moshi;
import io.hengam.lib.utils.Days;
import io.hengam.lib.utils.Hours;
import io.hengam.lib.utils.Millis;
import io.hengam.lib.utils.Minutes;
import io.hengam.lib.utils.Seconds;
import io.hengam.lib.utils.Time;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/hengam/lib/utils/TimeAdapterFactory;", "Lcom/squareup/moshi/JsonAdapter$Factory;", "()V", "allTimeUnits", "", "Ljava/lang/Class;", "", "create", "Lcom/squareup/moshi/JsonAdapter;", "type", "Ljava/lang/reflect/Type;", "annotations", "", "moshi", "Lcom/squareup/moshi/Moshi;", "TimeAdapter", "utils_release"})
public final class TimeAdapterFactory
implements JsonAdapter.Factory {
    private static final Set<Class<? extends Annotation>> allTimeUnits;
    public static final TimeAdapterFactory INSTANCE;

    @Nullable
    public JsonAdapter<?> create(@NotNull Type type, @NotNull Set<? extends Annotation> annotations, @NotNull Moshi moshi) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull(annotations, (String)"annotations");
        Intrinsics.checkParameterIsNotNull((Object)moshi, (String)"moshi");
        if (Intrinsics.areEqual((Object)type, Time.class) ^ true) {
            return null;
        }
        for (Annotation annotation : annotations) {
            for (Class<? extends Annotation> timeUnit : allTimeUnits) {
                if (!Intrinsics.areEqual((Object)JvmClassMappingKt.getJavaClass((KClass)JvmClassMappingKt.getAnnotationClass((Annotation)annotation)), timeUnit)) continue;
                return new TimeAdapter(timeUnit);
            }
        }
        return new TimeAdapter(Millis.class);
    }

    private TimeAdapterFactory() {
    }

    static {
        TimeAdapterFactory timeAdapterFactory;
        INSTANCE = timeAdapterFactory = new TimeAdapterFactory();
        allTimeUnits = SetsKt.setOf((Object[])new Class[]{Millis.class, Seconds.class, Minutes.class, Hours.class, Days.class});
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001a\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lio/hengam/lib/utils/TimeAdapterFactory$TimeAdapter;", "Lcom/squareup/moshi/JsonAdapter;", "Lio/hengam/lib/utils/Time;", "timeUnit", "", "(Ljava/lang/Object;)V", "fromJson", "reader", "Lcom/squareup/moshi/JsonReader;", "toJson", "", "writer", "Lcom/squareup/moshi/JsonWriter;", "value", "utils_release"})
    public static final class TimeAdapter
    extends JsonAdapter<Time> {
        private final Object timeUnit;

        @Nullable
        public Time fromJson(@NotNull JsonReader reader) {
            TimeUnit timeUnit;
            Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
            long l = reader.nextLong();
            Object object = this.timeUnit;
            if (Intrinsics.areEqual((Object)object, Millis.class)) {
                timeUnit = TimeUnit.MILLISECONDS;
            } else if (Intrinsics.areEqual((Object)object, Seconds.class)) {
                timeUnit = TimeUnit.SECONDS;
            } else if (Intrinsics.areEqual((Object)object, Minutes.class)) {
                timeUnit = TimeUnit.MINUTES;
            } else if (Intrinsics.areEqual((Object)object, Hours.class)) {
                timeUnit = TimeUnit.HOURS;
            } else if (Intrinsics.areEqual((Object)object, Days.class)) {
                timeUnit = TimeUnit.DAYS;
            } else {
                throw (Throwable)new IllegalArgumentException("Invalid time unit annotation " + this.timeUnit);
            }
            return new Time(l, timeUnit);
        }

        public void toJson(@NotNull JsonWriter writer, @Nullable Time value) {
            Long l;
            Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
            Object object = this.timeUnit;
            if (Intrinsics.areEqual((Object)object, Millis.class)) {
                Time time = value;
                l = time != null ? Long.valueOf(time.toMillis()) : null;
            } else if (Intrinsics.areEqual((Object)object, Seconds.class)) {
                Time time = value;
                l = time != null ? Long.valueOf(time.toSeconds()) : null;
            } else if (Intrinsics.areEqual((Object)object, Minutes.class)) {
                Time time = value;
                l = time != null ? Long.valueOf(time.toMinutes()) : null;
            } else if (Intrinsics.areEqual((Object)object, Hours.class)) {
                Time time = value;
                l = time != null ? Long.valueOf(time.toHours()) : null;
            } else if (Intrinsics.areEqual((Object)object, Days.class)) {
                Time time = value;
                l = time != null ? Long.valueOf(time.toDays()) : null;
            } else {
                throw (Throwable)new IllegalArgumentException("Invalid time unit annotation " + this.timeUnit);
            }
            writer.value((Number)l);
        }

        public TimeAdapter(@NotNull Object timeUnit) {
            Intrinsics.checkParameterIsNotNull((Object)timeUnit, (String)"timeUnit");
            this.timeUnit = timeUnit;
        }
    }
}

