/*
 * Decompiled with CFR 0.152.
 */
package io.hengam.lib.sentry.tasks;

import android.content.SharedPreferences;
import androidx.work.Data;
import androidx.work.ExistingPeriodicWorkPolicy;
import androidx.work.ListenableWorker;
import androidx.work.NetworkType;
import io.hengam.lib.dagger.CoreComponent;
import io.hengam.lib.internal.ComponentNotAvailableException;
import io.hengam.lib.internal.HengamInternals;
import io.hengam.lib.internal.task.HengamTask;
import io.hengam.lib.internal.task.PeriodicTaskOptions;
import io.hengam.lib.messaging.StoredUpstreamMessage;
import io.hengam.lib.utils.HengamStorage;
import io.hengam.lib.utils.Time;
import io.hengam.lib.utils.TimeKt;
import io.hengam.lib.utils.TimeUtils;
import io.hengam.lib.utils.log.Plog;
import io.reactivex.Single;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\nH\u0002\u00a8\u0006\f"}, d2={"Lio/hengam/lib/sentry/tasks/SentryReportTask;", "Lio/hengam/lib/internal/task/HengamTask;", "()V", "perform", "Lio/reactivex/Single;", "Landroidx/work/ListenableWorker$Result;", "inputData", "Landroidx/work/Data;", "timeAgo", "", "Lio/hengam/lib/utils/Time;", "Options", "sentry_release"})
public final class SentryReportTask
extends HengamTask {
    @NotNull
    public final Single<ListenableWorker.Result> perform(@NotNull Data inputData) {
        Object object;
        Object object2;
        Object object3;
        Intrinsics.checkParameterIsNotNull((Object)inputData, (String)"inputData");
        CoreComponent coreComponent = (CoreComponent)HengamInternals.INSTANCE.getComponent(CoreComponent.class);
        if (coreComponent == null) {
            throw (Throwable)new ComponentNotAvailableException("core");
        }
        CoreComponent coreComponent2 = coreComponent;
        SharedPreferences sharedPreferences = coreComponent.sharedPreferences();
        Time time = TimeUtils.INSTANCE.now();
        long l = sharedPreferences.getLong("installation_birthday", time.toMillis());
        int n = sharedPreferences.getInt("sentry_report_count", 0);
        Object object4 = coreComponent2.messageStore().getAllMessages();
        Iterable iterable = (Iterable)object4;
        String string = "Messages";
        Object object52 = object3 = new Pair[3];
        Object object6 = iterable;
        Object object72 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        Object object82 = object6.iterator();
        while (object82.hasNext()) {
            object2 = object82.next();
            object = (StoredUpstreamMessage)object2;
            iterable = object72;
            object6 = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"type", (Object)object.getMessage().getMessageType()), TuplesKt.to((Object)"size", (Object)object.getMessageSize()), TuplesKt.to((Object)"time", (Object)this.timeAgo(time.minus(object.getMessage().getTime())))});
            iterable.add(object6);
        }
        iterable = (List)object72;
        object3[0] = TuplesKt.to((Object)string, (Object)iterable);
        object52[1] = TuplesKt.to((Object)"Message Count", (Object)object4.size());
        iterable = (Iterable)object4;
        string = "Total Message Size";
        object52 = object3 = object52;
        int n2 = 0;
        for (Object object82 : iterable) {
            object2 = (StoredUpstreamMessage)object82;
            int n3 = n2;
            n2 = object2.getMessageSize();
            n2 = n3 + n2;
        }
        int n4 = n2;
        object3[2] = TuplesKt.to((Object)string, (Object)n4);
        object4 = MapsKt.mapOf((Pair[])object52);
        Map map = (Map)HengamStorage.createStoredMap$default((HengamStorage)coreComponent2.storage(), (String)"collection_last_run_times", Long.class, null, (int)4, null);
        object72 = map;
        object82 = new LinkedHashMap(MapsKt.mapCapacity((int)map.size()));
        for (Object object72 : (Iterable)object72.entrySet()) {
            object2 = (Map.Entry)object72;
            object52 = object82;
            object3 = object2.getKey();
            object72 = (Map.Entry)object72;
            object72 = this.timeAgo(TimeKt.millis((long)(time.toMillis() - ((Number)object72.getValue()).longValue())));
            object52.put(object3, object72);
        }
        Object object9 = object82;
        map = coreComponent2.moshi().adapter(Object.class);
        SharedPreferences sharedPreferences2 = coreComponent2.context().getSharedPreferences("hengam_store", 0);
        Intrinsics.checkExpressionValueIsNotNull((Object)sharedPreferences2, (String)"core.context().getShared\u2026ME, Context.MODE_PRIVATE)");
        Map map2 = sharedPreferences2.getAll();
        Intrinsics.checkExpressionValueIsNotNull((Object)map2, (String)"core.context().getShared\u2026                     .all");
        object82 = map2;
        object2 = map2;
        object = new LinkedHashMap(MapsKt.mapCapacity((int)object82.size()));
        for (Object object52 : (Iterable)object2.entrySet()) {
            object3 = (Map.Entry)object52;
            object72 = object;
            object82 = object3.getKey();
            Object object10 = object72;
            object72 = (Map.Entry)object52;
            object3 = object82;
            object52 = object10;
            object72 = StringsKt.startsWith$default((String)(object72 = String.valueOf(object72.getValue())), (String)"{", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)object72, (String)"[", (boolean)false, (int)2, null) ? map.fromJson((String)object72) : object72;
            object52.put(object3, object72);
        }
        object72 = object;
        Plog.INSTANCE.getInfo().message("Sentry Report").reportToSentry().withData("Message Store", object4).withData("Prev Collection At", object9).withData("Storage", object72).withData("Config", (Object)coreComponent2.config().getAllConfig()).withData("Age", (Object)this.timeAgo(TimeKt.millis((long)(time.toMillis() - l)))).withData("Report Number", (Object)n).log();
        sharedPreferences.edit().putLong("installation_birthday", time.toMillis()).putInt("sentry_report_count", n + 1).apply();
        Single single = Single.just((Object)ListenableWorker.Result.success());
        Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"Single.just(ListenableWorker.Result.success())");
        return single;
    }

    /*
     * WARNING - void declaration
     */
    private final String timeAgo(Time timeAgo) {
        void var1_1;
        if (timeAgo.compareTo(TimeKt.seconds((long)1L)) < 0) {
            return timeAgo + " millis";
        }
        if (timeAgo.compareTo(TimeKt.minutes((long)1L)) < 0) {
            return timeAgo.toSeconds() + " seconds";
        }
        if (timeAgo.compareTo(TimeKt.hours((long)1L)) < 0) {
            return timeAgo.toMinutes() + " minutes";
        }
        if (timeAgo.compareTo(TimeKt.days((long)1L)) < 0) {
            return timeAgo.toHours() + " hours";
        }
        return var1_1.toDays() + " days";
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0003H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u0003H\u0016J\u0010\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\fH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/hengam/lib/sentry/tasks/SentryReportTask$Options;", "Lio/hengam/lib/internal/task/PeriodicTaskOptions;", "interval", "Lio/hengam/lib/utils/Time;", "(Lio/hengam/lib/utils/Time;)V", "existingWorkPolicy", "Landroidx/work/ExistingPeriodicWorkPolicy;", "flexibilityTime", "networkType", "Landroidx/work/NetworkType;", "repeatInterval", "task", "Lkotlin/reflect/KClass;", "Lio/hengam/lib/internal/task/HengamTask;", "taskId", "", "sentry_release"})
    public static final class a
    extends PeriodicTaskOptions {
        private final Time a;

        @NotNull
        public final NetworkType networkType() {
            return NetworkType.NOT_REQUIRED;
        }

        @NotNull
        public final KClass<? extends HengamTask> task() {
            return Reflection.getOrCreateKotlinClass(SentryReportTask.class);
        }

        @NotNull
        public final Time repeatInterval() {
            return this.a;
        }

        @NotNull
        public final ExistingPeriodicWorkPolicy existingWorkPolicy() {
            return ExistingPeriodicWorkPolicy.KEEP;
        }

        @NotNull
        public final String taskId() {
            return "hengam_sentry_report";
        }

        @NotNull
        public final Time flexibilityTime() {
            return TimeKt.hours((long)3L);
        }

        public a(@NotNull Time time) {
            Intrinsics.checkParameterIsNotNull((Object)time, (String)"interval");
            this.a = time;
        }
    }
}

