/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.exceptions;

import io.reactivex.annotations.NonNull;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;

public final class CompositeException
extends RuntimeException {
    private final List<Throwable> exceptions;
    private final String message;
    private Throwable cause;

    public CompositeException(Throwable ... throwableArray) {
        this(throwableArray == null ? Collections.singletonList(new NullPointerException("exceptions was null")) : Arrays.asList(throwableArray));
    }

    public CompositeException(@NonNull Iterable<? extends Throwable> object) {
        LinkedHashSet<Throwable> linkedHashSet = new LinkedHashSet<Throwable>();
        ArrayList<Throwable> arrayList = new ArrayList<Throwable>();
        if (object != null) {
            object = object.iterator();
            while (object.hasNext()) {
                Throwable throwable = (Throwable)object.next();
                if (throwable instanceof CompositeException) {
                    linkedHashSet.addAll(((CompositeException)throwable).getExceptions());
                    continue;
                }
                if (throwable != null) {
                    linkedHashSet.add(throwable);
                    continue;
                }
                linkedHashSet.add(new NullPointerException("Throwable was null!"));
            }
        } else {
            linkedHashSet.add(new NullPointerException("errors was null"));
        }
        if (linkedHashSet.isEmpty()) {
            throw new IllegalArgumentException("errors is empty");
        }
        arrayList.addAll(linkedHashSet);
        this.exceptions = Collections.unmodifiableList(arrayList);
        this.message = this.exceptions.size() + " exceptions occurred. ";
    }

    @NonNull
    public final List<Throwable> getExceptions() {
        return this.exceptions;
    }

    @Override
    @NonNull
    public final String getMessage() {
        return this.message;
    }

    @Override
    @NonNull
    public final synchronized Throwable getCause() {
        if (this.cause == null) {
            a a2 = new a();
            HashSet<Throwable> hashSet = new HashSet<Throwable>();
            Throwable throwable = a2;
            for (Throwable throwable2 : this.exceptions) {
                if (hashSet.contains(throwable2)) continue;
                hashSet.add(throwable2);
                Object object = this.getListOfCauses(throwable2);
                object = object.iterator();
                while (object.hasNext()) {
                    Throwable throwable3 = (Throwable)object.next();
                    if (hashSet.contains(throwable3)) {
                        throwable2 = new RuntimeException("Duplicate found in causal chain so cropping to prevent loop ...");
                        continue;
                    }
                    hashSet.add(throwable3);
                }
                try {
                    throwable.initCause(throwable2);
                }
                catch (Throwable throwable4) {}
                throwable = this.getRootCause(throwable);
            }
            this.cause = a2;
        }
        return this.cause;
    }

    @Override
    public final void printStackTrace() {
        this.printStackTrace(System.err);
    }

    @Override
    public final void printStackTrace(PrintStream printStream) {
        this.printStackTrace(new c(printStream));
    }

    @Override
    public final void printStackTrace(PrintWriter printWriter) {
        this.printStackTrace(new d(printWriter));
    }

    private void printStackTrace(b b2) {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append(this).append('\n');
        for (StackTraceElement stackTraceElement : this.getStackTrace()) {
            stringBuilder.append("\tat ").append(stackTraceElement).append('\n');
        }
        int n2 = 1;
        for (Throwable throwable : this.exceptions) {
            stringBuilder.append("  ComposedException ").append(n2).append(" :\n");
            this.appendStackTrace(stringBuilder, throwable, "\t");
            ++n2;
        }
        b2.a(stringBuilder.toString());
    }

    /*
     * WARNING - void declaration
     */
    private void appendStackTrace(StringBuilder stringBuilder, Throwable throwable, String object) {
        while (true) {
            void var3_4;
            stringBuilder.append((String)var3_4).append(throwable).append('\n');
            for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
                stringBuilder.append("\t\tat ").append(stackTraceElement).append('\n');
            }
            if (throwable.getCause() == null) break;
            stringBuilder.append("\tCaused by: ");
            String string = "";
            throwable = throwable.getCause();
        }
    }

    private List<Throwable> getListOfCauses(Throwable throwable) {
        ArrayList<Throwable> arrayList = new ArrayList<Throwable>();
        Throwable throwable2 = throwable.getCause();
        if (throwable2 == null || throwable2 == throwable) {
            return arrayList;
        }
        while (true) {
            arrayList.add(throwable2);
            throwable = throwable2.getCause();
            if (throwable == null || throwable == throwable2) {
                return arrayList;
            }
            throwable2 = throwable;
        }
    }

    final Throwable getRootCause(Throwable throwable) {
        Throwable throwable2 = throwable.getCause();
        if (throwable2 == null || throwable == throwable2) {
            return throwable;
        }
        while ((throwable = throwable2.getCause()) != null && throwable != throwable2) {
            throwable2 = throwable;
        }
        return throwable2;
    }

    static final class a
    extends RuntimeException {
        a() {
        }

        @Override
        public final String getMessage() {
            return "Chain of Causes for CompositeException In Order Received =>";
        }
    }

    static final class d
    extends b {
        private final PrintWriter a;

        d(PrintWriter printWriter) {
            this.a = printWriter;
        }

        @Override
        final void a(Object object) {
            this.a.println(object);
        }
    }

    static final class c
    extends b {
        private final PrintStream a;

        c(PrintStream printStream) {
            this.a = printStream;
        }

        @Override
        final void a(Object object) {
            this.a.println(object);
        }
    }

    static abstract class b {
        b() {
        }

        abstract void a(Object var1);
    }
}

