/*
 * Decompiled with CFR 0.152.
 */
package io.hengam.lib.notification.tasks;

import androidx.work.BackoffPolicy;
import androidx.work.Data;
import androidx.work.ExistingWorkPolicy;
import androidx.work.ListenableWorker;
import androidx.work.NetworkType;
import io.hengam.lib.internal.ComponentNotAvailableException;
import io.hengam.lib.internal.HengamConfig;
import io.hengam.lib.internal.HengamInternals;
import io.hengam.lib.internal.HengamMoshi;
import io.hengam.lib.internal.task.HengamTask;
import io.hengam.lib.internal.task.OneTimeTaskOptions;
import io.hengam.lib.notification.NotificationBuildException;
import io.hengam.lib.notification.h;
import io.hengam.lib.notification.l;
import io.hengam.lib.notification.messages.downstream.NotificationMessage;
import io.hengam.lib.notification.n;
import io.hengam.lib.notification.v;
import io.hengam.lib.notification.w;
import io.hengam.lib.utils.Time;
import io.hengam.lib.utils.TimeKt;
import io.hengam.lib.utils.UtilsKt;
import io.hengam.lib.utils.log.Plog;
import io.reactivex.Single;
import io.reactivex.functions.Function;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 $2\u00020\u0001:\u0003$%&B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\u00020\u00108\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0015\u001a\u00020\u00168\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006'"}, d2={"Lio/hengam/lib/notification/tasks/NotificationBuildTask;", "Lio/hengam/lib/internal/task/HengamTask;", "()V", "moshi", "Lio/hengam/lib/internal/HengamMoshi;", "getMoshi", "()Lio/hengam/lib/internal/HengamMoshi;", "setMoshi", "(Lio/hengam/lib/internal/HengamMoshi;)V", "notificationController", "Lio/hengam/lib/notification/NotificationController;", "getNotificationController", "()Lio/hengam/lib/notification/NotificationController;", "setNotificationController", "(Lio/hengam/lib/notification/NotificationController;)V", "notificationErrorHandler", "Lio/hengam/lib/notification/NotificationErrorHandler;", "getNotificationErrorHandler", "()Lio/hengam/lib/notification/NotificationErrorHandler;", "setNotificationErrorHandler", "(Lio/hengam/lib/notification/NotificationErrorHandler;)V", "notificationStatusReporter", "Lio/hengam/lib/notification/NotificationStatusReporter;", "getNotificationStatusReporter", "()Lio/hengam/lib/notification/NotificationStatusReporter;", "setNotificationStatusReporter", "(Lio/hengam/lib/notification/NotificationStatusReporter;)V", "onMaximumRetriesReached", "", "inputData", "Landroidx/work/Data;", "parseData", "Lio/hengam/lib/notification/messages/downstream/NotificationMessage;", "perform", "Lio/reactivex/Single;", "Landroidx/work/ListenableWorker$Result;", "Companion", "NotificationTaskException", "Options", "notification_release"})
public final class NotificationBuildTask
extends HengamTask {
    @Inject
    @NotNull
    public l notificationController;
    @Inject
    @NotNull
    public n notificationErrorHandler;
    @Inject
    @NotNull
    public w notificationStatusReporter;
    @Inject
    @NotNull
    public HengamMoshi moshi;
    @NotNull
    public static final String DATA_NOTIFICATION_MESSAGE = "notification_message";
    public static final a Companion = new a(0);

    @NotNull
    public final l getNotificationController() {
        l l2 = this.notificationController;
        if (l2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"notificationController");
        }
        return l2;
    }

    /*
     * WARNING - void declaration
     */
    public final void setNotificationController(@NotNull l l2) {
        void var1_1;
        Intrinsics.checkParameterIsNotNull((Object)l2, (String)"<set-?>");
        this.notificationController = var1_1;
    }

    @NotNull
    public final n getNotificationErrorHandler() {
        n n2 = this.notificationErrorHandler;
        if (n2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"notificationErrorHandler");
        }
        return n2;
    }

    /*
     * WARNING - void declaration
     */
    public final void setNotificationErrorHandler(@NotNull n n2) {
        void var1_1;
        Intrinsics.checkParameterIsNotNull((Object)n2, (String)"<set-?>");
        this.notificationErrorHandler = var1_1;
    }

    @NotNull
    public final w getNotificationStatusReporter() {
        w w2 = this.notificationStatusReporter;
        if (w2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"notificationStatusReporter");
        }
        return w2;
    }

    /*
     * WARNING - void declaration
     */
    public final void setNotificationStatusReporter(@NotNull w w2) {
        void var1_1;
        Intrinsics.checkParameterIsNotNull((Object)w2, (String)"<set-?>");
        this.notificationStatusReporter = var1_1;
    }

    @NotNull
    public final HengamMoshi getMoshi() {
        HengamMoshi hengamMoshi = this.moshi;
        if (hengamMoshi == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"moshi");
        }
        return hengamMoshi;
    }

    /*
     * WARNING - void declaration
     */
    public final void setMoshi(@NotNull HengamMoshi hengamMoshi) {
        void var1_1;
        Intrinsics.checkParameterIsNotNull((Object)hengamMoshi, (String)"<set-?>");
        this.moshi = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Single<ListenableWorker.Result> perform(@NotNull Data inputData) {
        Intrinsics.checkParameterIsNotNull((Object)inputData, (String)"inputData");
        final Ref.ObjectRef objectRef = new Ref.ObjectRef();
        new Ref.ObjectRef().element = null;
        try {
            io.hengam.lib.notification.a.b b2 = (io.hengam.lib.notification.a.b)HengamInternals.INSTANCE.getComponent(io.hengam.lib.notification.a.b.class);
            if (b2 == null) {
                throw (Throwable)new ComponentNotAvailableException("notification");
            }
            b2.a(this);
            objectRef.element = this.parseData(inputData);
            final String string = UtilsKt.ordinal((int)(inputData.getInt("%task_retry_count", -1) + 2));
            l l2 = this.notificationController;
            if (l2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"notificationController");
            }
            Single single = l2.b((NotificationMessage)objectRef.element).toSingle((Callable)c.a).onErrorReturn((Function)new Function<Throwable, ListenableWorker.Result>(){

                public final /* synthetic */ Object apply(Object object) {
                    Throwable throwable = (Throwable)object;
                    object = this;
                    Intrinsics.checkParameterIsNotNull((Object)throwable, (String)"ex");
                    if (throwable instanceof NotificationBuildException) {
                        Plog.INSTANCE.warn("Notification", "Building notification failed in the " + object.string + " attempt", throwable, new Pair[]{TuplesKt.to((Object)"Message Id", (Object)((NotificationMessage)object.objectRef.element).a)});
                        return ListenableWorker.Result.retry();
                    }
                    Plog.INSTANCE.error("Notification", (Throwable)new NotificationTaskException("Building notification failed with unrecoverable error", throwable), new Pair[]{TuplesKt.to((Object)"Message Id", (Object)((NotificationMessage)object.objectRef.element).a)});
                    return ListenableWorker.Result.failure();
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"notificationController.s\u2026      }\n                }");
            return single;
        }
        catch (Exception exception) {
            void var1_1;
            Plog.INSTANCE.error("Notification", (Throwable)new NotificationTaskException("Notification Build task failed with fatal error", exception), new Pair[]{TuplesKt.to((Object)"Message Data", (Object)var1_1.getString(DATA_NOTIFICATION_MESSAGE))});
            if ((NotificationMessage)objectRef.element != null) {
                n n2 = this.notificationErrorHandler;
                if (n2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"notificationErrorHandler");
                }
                n2.a((NotificationMessage)objectRef.element, h.UNKNOWN);
                w w2 = this.notificationStatusReporter;
                if (w2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"notificationStatusReporter");
                }
                w2.a((NotificationMessage)objectRef.element, v.FAILED);
            }
            Single single = Single.just((Object)ListenableWorker.Result.failure());
            Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"Single.just(ListenableWorker.Result.failure())");
            return single;
        }
    }

    public final void onMaximumRetriesReached(@NotNull Data inputData) {
        Intrinsics.checkParameterIsNotNull((Object)inputData, (String)"inputData");
        try {
            NotificationMessage notificationMessage;
            io.hengam.lib.notification.a.b b2 = (io.hengam.lib.notification.a.b)HengamInternals.INSTANCE.getComponent(io.hengam.lib.notification.a.b.class);
            if (b2 == null) {
                throw (Throwable)new ComponentNotAvailableException("notification");
            }
            b2.a(this);
            notificationMessage = this.parseData((Data)notificationMessage);
            Plog.INSTANCE.warn("Notification", "Maximum number of attempts reached for building notification, the notification will be discarded", new Pair[]{TuplesKt.to((Object)"Message Id", (Object)notificationMessage.a)});
            w w2 = this.notificationStatusReporter;
            if (w2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"notificationStatusReporter");
            }
            w2.a(notificationMessage, v.FAILED);
            return;
        }
        catch (Exception exception) {
            Plog.INSTANCE.error("Notification", (Throwable)exception, new Pair[0]);
            return;
        }
    }

    private final NotificationMessage parseData(Data inputData) {
        String string = inputData.getString(DATA_NOTIFICATION_MESSAGE);
        if (string == null) {
            throw (Throwable)new NotificationTaskException("NotificationBuildTask was run with no message data");
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"inputData.getString(DATA\u2026un with no message data\")");
        String string2 = string;
        HengamMoshi hengamMoshi = this.moshi;
        if (hengamMoshi == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"moshi");
        }
        NotificationMessage notificationMessage = (NotificationMessage)hengamMoshi.adapter(NotificationMessage.class).fromJson(string2);
        if (notificationMessage == null) {
            throw (Throwable)new NotificationTaskException("Could not parse message json data in Notification Build Task");
        }
        return notificationMessage;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lio/hengam/lib/notification/tasks/NotificationBuildTask$NotificationTaskException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "message", "", "cause", "", "(Ljava/lang/String;Ljava/lang/Throwable;)V", "notification_release"})
    public static final class NotificationTaskException
    extends Exception {
        /*
         * WARNING - void declaration
         */
        public NotificationTaskException(@NotNull String message, @Nullable Throwable cause) {
            void var2_2;
            void var1_1;
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            super((String)var1_1, (Throwable)var2_2);
        }

        public /* synthetic */ NotificationTaskException(String string) {
            this(string, null);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\n\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\n\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lio/hengam/lib/notification/tasks/NotificationBuildTask$Options;", "Lio/hengam/lib/internal/task/OneTimeTaskOptions;", "message", "Lio/hengam/lib/notification/messages/downstream/NotificationMessage;", "(Lio/hengam/lib/notification/messages/downstream/NotificationMessage;)V", "backoffDelay", "Lio/hengam/lib/utils/Time;", "backoffPolicy", "Landroidx/work/BackoffPolicy;", "existingWorkPolicy", "Landroidx/work/ExistingWorkPolicy;", "maxAttemptsCount", "", "networkType", "Landroidx/work/NetworkType;", "task", "Lkotlin/reflect/KClass;", "Lio/hengam/lib/notification/tasks/NotificationBuildTask;", "taskId", "", "notification_release"})
    public static final class b
    extends OneTimeTaskOptions {
        private final NotificationMessage a;

        @NotNull
        public final NetworkType networkType() {
            NotificationMessage notificationMessage = this.a;
            CharSequence charSequence = notificationMessage.g;
            if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) || !((charSequence = (CharSequence)notificationMessage.h) == null || StringsKt.isBlank((CharSequence)charSequence)) || !((charSequence = (CharSequence)notificationMessage.j) == null || StringsKt.isBlank((CharSequence)charSequence)) || !((charSequence = (CharSequence)notificationMessage.u) == null || StringsKt.isBlank((CharSequence)charSequence)) || !((charSequence = (CharSequence)notificationMessage.w) == null || StringsKt.isBlank((CharSequence)charSequence))) {
                return NetworkType.CONNECTED;
            }
            return NetworkType.NOT_REQUIRED;
        }

        @NotNull
        public final KClass<NotificationBuildTask> task() {
            return Reflection.getOrCreateKotlinClass(NotificationBuildTask.class);
        }

        @NotNull
        public final String taskId() {
            CharSequence charSequence = this.a.E;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                return this.a.a;
            }
            return this.a.E;
        }

        @NotNull
        public final ExistingWorkPolicy existingWorkPolicy() {
            return ExistingWorkPolicy.REPLACE;
        }

        public final int maxAttemptsCount() {
            HengamConfig hengamConfig = this.getHengamConfig();
            Intrinsics.checkParameterIsNotNull((Object)hengamConfig, (String)"receiver$0");
            return hengamConfig.getInteger("notif_build_max_attempts", 8);
        }

        @Nullable
        public final BackoffPolicy backoffPolicy() {
            HengamConfig hengamConfig = this.getHengamConfig();
            Intrinsics.checkParameterIsNotNull((Object)hengamConfig, (String)"receiver$0");
            return (BackoffPolicy)hengamConfig.getObject("notif_build_backoff_policy", BackoffPolicy.class, (Object)BackoffPolicy.LINEAR);
        }

        @Nullable
        public final Time backoffDelay() {
            Object object = this.getHengamConfig();
            Intrinsics.checkParameterIsNotNull((Object)object, (String)"receiver$0");
            object = object.getLong("notif_build_backoff_delay", -1L);
            Object object2 = ((Number)object).longValue() >= 0L ? object : null;
            if (object2 == null || (object2 = TimeKt.millis((long)((Number)object2).longValue())) == null) {
                object2 = TimeKt.seconds((long)20L);
            }
            return object2;
        }

        public b(@NotNull NotificationMessage notificationMessage) {
            Intrinsics.checkParameterIsNotNull((Object)notificationMessage, (String)"message");
            this.a = notificationMessage;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/hengam/lib/notification/tasks/NotificationBuildTask$Companion;", "", "()V", "DATA_NOTIFICATION_MESSAGE", "", "notification_release"})
    public static final class a {
        private a() {
        }

        public /* synthetic */ a(byte by) {
            this();
        }
    }
}

