/*
 * Decompiled with CFR 0.152.
 */
package io.hengam.lib.notification.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import io.hengam.lib.utils.HttpUtils;
import io.hengam.lib.utils.IdGenerator;
import io.hengam.lib.utils.Time;
import io.hengam.lib.utils.TimeKt;
import io.hengam.lib.utils.log.Plog;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0002\u0017\u0018B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nJ \u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\n2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u0014\u001a\u00020\u000f2\b\b\u0002\u0010\u0015\u001a\u00020\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lio/hengam/lib/notification/utils/ImageDownloader;", "", "context", "Landroid/content/Context;", "httpUtils", "Lio/hengam/lib/utils/HttpUtils;", "(Landroid/content/Context;Lio/hengam/lib/utils/HttpUtils;)V", "downloadImage", "Landroid/graphics/Bitmap;", "url", "", "reqWidth", "", "reqHeight", "downloadImageAndCache", "", "getCachedFile", "getImage", "loadImageFromCache", "Landroid/graphics/drawable/Drawable;", "purgeOutdatedCache", "expirationTime", "Lio/hengam/lib/utils/Time;", "Companion", "ImageDownloaderException", "notification_release"})
public final class ImageDownloader {
    private final Context b;
    private final HttpUtils c;
    public static final a a = new a(0);

    @NotNull
    public final Bitmap a(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"url");
        this.b(string);
        String string2 = this.c(string);
        if (string2 == null) {
            throw (Throwable)new ImageDownloaderException("Failed to retrieve saved image", 0);
        }
        Bitmap bitmap = BitmapFactory.decodeFile((String)string2);
        if (bitmap == null) {
            throw (Throwable)new ImageDownloaderException("Failed to decode image into a bitmap", 0);
        }
        return bitmap;
    }

    public final void b(@NotNull String object) {
        Intrinsics.checkParameterIsNotNull((Object)object, (String)"url");
        InputStream inputStream = this.c.requestBlockingStream((String)object);
        byte[] byArray = new byte[1024];
        int n2 = inputStream.read(byArray);
        File file = new File(this.b.getCacheDir(), "/images/");
        if (!file.exists()) {
            file.mkdir();
        }
        if ((file = new File(this.b.getCacheDir(), "/images/img" + ((String)object).hashCode())).exists()) {
            return;
        }
        object = new File(this.b.getCacheDir(), "/images/tmp" + ((String)object).hashCode() + '-' + IdGenerator.INSTANCE.generateId(5));
        FileOutputStream fileOutputStream = new FileOutputStream((File)object);
        while (n2 != -1) {
            fileOutputStream.write(byArray, 0, n2);
            n2 = inputStream.read(byArray);
        }
        fileOutputStream.flush();
        fileOutputStream.close();
        inputStream.close();
        FilesKt.copyTo$default((File)object, (File)file, (boolean)true, (int)0, (int)4, null);
        try {
            ((File)object).delete();
            return;
        }
        catch (Exception exception) {
            Plog.INSTANCE.warn("Notification", (Throwable)exception, new Pair[0]);
            return;
        }
    }

    @Nullable
    public final String c(@NotNull String object) {
        Intrinsics.checkParameterIsNotNull((Object)object, (String)"url");
        object = new File(this.b.getCacheDir(), "/images/img" + ((String)object).hashCode());
        if (((File)object).exists()) {
            return ((File)object).getAbsolutePath();
        }
        return null;
    }

    public final void a(@NotNull Time time) {
        Intrinsics.checkParameterIsNotNull((Object)time, (String)"expirationTime");
        try {
            Object object = new File(this.b.getCacheDir(), "/images/");
            if (!((File)object).exists()) {
                return;
            }
            object = ((File)object).listFiles();
            List list = new ArrayList();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"files");
            for (File file : object) {
                if ((new Date().getTime() - file.lastModified()) / 86400000L < time.toDays()) continue;
                File file2 = file;
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"it");
                list.add(file2);
                file.delete();
            }
            if (!list.isEmpty()) {
                Plog.INSTANCE.debug("Notification", "Deleting " + list.size() + " cached images", new Pair[0]);
                object = ((Iterable)list).iterator();
                while (object.hasNext()) {
                    ((File)object.next()).delete();
                }
                return;
            }
        }
        catch (Exception exception) {
            Plog.INSTANCE.warn("Notification", "Clearing cached images failed", (Throwable)exception, new Pair[0]);
        }
    }

    public static /* synthetic */ void a(ImageDownloader imageDownloader) {
        Time time = TimeKt.days((long)7L);
        imageDownloader.a(time);
    }

    /*
     * WARNING - void declaration
     */
    @Inject
    public ImageDownloader(@NotNull Context context, @NotNull HttpUtils httpUtils) {
        void var2_2;
        void var1_1;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)httpUtils, (String)"httpUtils");
        this.b = var1_1;
        this.c = var2_2;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lio/hengam/lib/notification/utils/ImageDownloader$ImageDownloaderException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "message", "", "cause", "", "(Ljava/lang/String;Ljava/lang/Throwable;)V", "notification_release"})
    public static final class ImageDownloaderException
    extends Exception {
        /*
         * WARNING - void declaration
         */
        private ImageDownloaderException(@NotNull String message) {
            void var1_1;
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            super((String)var1_1, null);
        }

        public /* synthetic */ ImageDownloaderException(String string, byte by) {
            this(string);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004J\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004\u00a8\u0006\r"}, d2={"Lio/hengam/lib/notification/utils/ImageDownloader$Companion;", "", "()V", "calculateInSampleSize", "", "options", "Landroid/graphics/BitmapFactory$Options;", "reqWidth", "reqHeight", "decodeSampledBitmapFromStream", "Landroid/graphics/Bitmap;", "stream", "Ljava/io/InputStream;", "notification_release"})
    public static final class a {
        private a() {
        }

        public /* synthetic */ a(byte by) {
            this();
        }
    }
}

