/*
 * Decompiled with CFR 0.152.
 */
package io.hengam.lib.datalytics.tasks;

import android.content.BroadcastReceiver;
import android.content.IntentFilter;
import androidx.work.Data;
import androidx.work.ExistingPeriodicWorkPolicy;
import androidx.work.ListenableWorker;
import androidx.work.NetworkType;
import io.hengam.lib.dagger.CoreComponent;
import io.hengam.lib.datalytics.geofence.GpsLocationReceiver;
import io.hengam.lib.internal.ComponentNotAvailableException;
import io.hengam.lib.internal.HengamConfig;
import io.hengam.lib.internal.HengamInternals;
import io.hengam.lib.internal.task.HengamTask;
import io.hengam.lib.internal.task.PeriodicTaskOptions;
import io.hengam.lib.utils.Time;
import io.hengam.lib.utils.TimeKt;
import io.hengam.lib.utils.log.Plog;
import io.reactivex.Single;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lio/hengam/lib/datalytics/tasks/GPSBroadcastRegisterTask;", "Lio/hengam/lib/internal/task/HengamTask;", "()V", "perform", "Lio/reactivex/Single;", "Landroidx/work/ListenableWorker$Result;", "inputData", "Landroidx/work/Data;", "Options", "datalytics_release"})
public final class GPSBroadcastRegisterTask
extends HengamTask {
    @NotNull
    public Single<ListenableWorker.Result> perform(@NotNull Data inputData) {
        Intrinsics.checkParameterIsNotNull((Object)inputData, (String)"inputData");
        Pair[] pairArray = (CoreComponent)HengamInternals.INSTANCE.getComponent(CoreComponent.class);
        if (pairArray != null) {
            GpsLocationReceiver gpsLocationReceiver;
            IntentFilter intentFilter;
            IntentFilter intentFilter2 = intentFilter;
            intentFilter = new IntentFilter("android.location.PROVIDERS_CHANGED");
            GpsLocationReceiver gpsLocationReceiver2 = gpsLocationReceiver;
            gpsLocationReceiver = new GpsLocationReceiver();
            pairArray.context().unregisterReceiver((BroadcastReceiver)gpsLocationReceiver2);
            Plog plog = Plog.INSTANCE;
            try {
                plog.info("Datalytics", "Geofence", "GpsLocationReceiver unRegistered in periodic task", new Pair[0]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Pair[] pairArray2 = new Pair[]{};
                Plog.INSTANCE.info("Datalytics", "Geofence", "receiver not registered before", pairArray2);
            }
            pairArray.context().registerReceiver((BroadcastReceiver)gpsLocationReceiver2, intentFilter2);
            pairArray = new Pair[]{};
            Plog.INSTANCE.info("Datalytics", "Geofence", "GpsLocationReceiver registered in periodic task", pairArray);
            Single single = Single.just((Object)ListenableWorker.Result.success());
            Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"Single.just(ListenableWorker.Result.success())");
            return single;
        }
        throw new ComponentNotAvailableException("core");
    }

    public static final class a
    extends PeriodicTaskOptions {
        @NotNull
        public Time repeatInterval() {
            HengamConfig hengamConfig = object.getHengamConfig();
            Intrinsics.checkParameterIsNotNull((Object)hengamConfig, (String)"$this$gpsPeriodicRegisterInterval");
            Object object = hengamConfig.getLong("gps_periodic_register_interval", 0L);
            if (!(((Number)object).longValue() > 0L)) {
                object = null;
            }
            if (object == null || (object = TimeKt.millis((long)((Number)object).longValue())) == null) {
                object = TimeKt.hours((long)2L);
            }
            return object;
        }

        @NotNull
        public NetworkType networkType() {
            return NetworkType.NOT_REQUIRED;
        }

        @NotNull
        public KClass<GPSBroadcastRegisterTask> task() {
            return Reflection.getOrCreateKotlinClass(GPSBroadcastRegisterTask.class);
        }

        @NotNull
        public String taskId() {
            return "hengam_periodic_gps_register";
        }

        @NotNull
        public ExistingPeriodicWorkPolicy existingWorkPolicy() {
            return ExistingPeriodicWorkPolicy.KEEP;
        }

        @NotNull
        public Time flexibilityTime() {
            return TimeKt.hours((long)2L);
        }
    }
}

