package io.hengam.lib.datalytics.tasks

import android.content.IntentFilter
import android.location.LocationManager
import androidx.work.Data
import androidx.work.ExistingPeriodicWorkPolicy
import androidx.work.ListenableWorker
import androidx.work.NetworkType
import io.hengam.lib.Hengam
import io.hengam.lib.dagger.CoreComponent
import io.hengam.lib.datalytics.geofence.GpsLocationReceiver
import io.hengam.lib.datalytics.LogTags
import io.hengam.lib.datalytics.gpsPeriodicRegisterInterval
import io.hengam.lib.internal.ComponentNotAvailableException
import io.hengam.lib.internal.HengamInternals
import io.hengam.lib.internal.task.PeriodicTaskOptions
import io.hengam.lib.internal.task.HengamTask
import io.hengam.lib.utils.Time
import io.hengam.lib.utils.hours
import io.hengam.lib.utils.log.Plog
import io.reactivex.Single

class GPSBroadcastRegisterTask : HengamTask() {
    override fun perform(inputData: Data): Single<ListenableWorker.Result> {

        val core = HengamInternals.getComponent(CoreComponent::class.java)

                ?: throw ComponentNotAvailableException(Hengam.CORE)

        val filter = IntentFilter(LocationManager.PROVIDERS_CHANGED_ACTION)
        val gpsLocationReceiver = GpsLocationReceiver()
        try {
            core.context().unregisterReceiver(gpsLocationReceiver)
            Plog.info(LogTags.T_DATALYTICS, LogTags.T_GEOFENCE, "GpsLocationReceiver unRegistered in periodic task")
        } catch (ex: IllegalArgumentException) {
            Plog.info(LogTags.T_DATALYTICS, LogTags.T_GEOFENCE, "receiver not registered before")
        }
        core.context().registerReceiver(gpsLocationReceiver, filter)
        Plog.info(LogTags.T_DATALYTICS, LogTags.T_GEOFENCE, "GpsLocationReceiver registered in periodic task")
        return Single.just(ListenableWorker.Result.success())
    }

    class Options : PeriodicTaskOptions() {
        override fun repeatInterval(): Time = hengamConfig.gpsPeriodicRegisterInterval
        override fun networkType() = NetworkType.NOT_REQUIRED
        override fun task() = GPSBroadcastRegisterTask::class
        override fun taskId() = "hengam_periodic_gps_register"
        override fun existingWorkPolicy() = ExistingPeriodicWorkPolicy.KEEP
        override fun flexibilityTime() = hours(2)
    }
}