package io.hengam.lib.datalytics.geofence

import android.content.BroadcastReceiver
import android.content.Context
import android.content.Intent
import android.content.IntentFilter
import android.location.LocationManager
import io.hengam.lib.Hengam
import io.hengam.lib.dagger.CoreComponent
import io.hengam.lib.datalytics.LogTags
import io.hengam.lib.datalytics.dagger.DaggerDatalyticsComponent
import io.hengam.lib.internal.ComponentNotAvailableException
import io.hengam.lib.internal.HengamInternals
import io.hengam.lib.internal.cpuThread
import io.hengam.lib.utils.log.Plog
import io.hengam.lib.utils.rx.justDo
import com.google.android.gms.location.LocationServices

class GpsLocationReceiver : BroadcastReceiver() {
    override fun onReceive(context: Context, intent: Intent) {
        try {
            if (intent.action=="android.location.PROVIDERS_CHANGED") {

                val locationManager = context.getSystemService(Context.LOCATION_SERVICE) as LocationManager
                if (locationManager.isProviderEnabled(LocationManager.GPS_PROVIDER)) {
                    Plog.debug(LogTags.T_DATALYTICS, LogTags.T_GEOFENCE,"GPS status changed to on")
                    //Gps is on
                    cpuThread {
                        val core = HengamInternals.getComponent(CoreComponent::class.java)
                                ?:  throw ComponentNotAvailableException(Hengam.CORE)

                        val datalyticsComponent = DaggerDatalyticsComponent.builder()
                                .coreComponent(core)
                                .build()

                        datalyticsComponent.geofenceManager().ensureGeofencesAreRegistered().justDo(LogTags.T_DATALYTICS, LogTags.T_GEOFENCE)
                        val fusedLocationClient = LocationServices.getFusedLocationProviderClient(core.context())
                        fusedLocationClient.lastLocation

                    }

                }
            }
        }
        catch (ex: Throwable)
        {
            Plog.error(LogTags.T_DATALYTICS, ex)
        }
    }
}

fun registerGPSLocationReceiver(context: Context)
{
    val filter = IntentFilter(LocationManager.PROVIDERS_CHANGED_ACTION)
    val gpsLocationReceiver = GpsLocationReceiver()
    try {
        context.unregisterReceiver(gpsLocationReceiver)
        Plog.info(LogTags.T_DATALYTICS, LogTags.T_GEOFENCE, "unRegister gpsLocationReceiver")

    } catch (ex: IllegalArgumentException) {
        Plog.info(LogTags.T_DATALYTICS, LogTags.T_GEOFENCE, "receiver not registered before")
    }
    Plog.info(LogTags.T_DATALYTICS, LogTags.T_GEOFENCE, "register gpsLocationReceiver")
    context.registerReceiver(gpsLocationReceiver, filter)
}