package io.hengam.lib.datalytics.geofence

import android.content.Context
import android.content.Intent
import android.support.v4.app.JobIntentService
import android.util.Log
import io.hengam.lib.Hengam
import io.hengam.lib.datalytics.LogTags
import io.hengam.lib.datalytics.dagger.DatalyticsComponent
import io.hengam.lib.internal.ComponentNotAvailableException
import io.hengam.lib.internal.HengamInternals
import io.hengam.lib.internal.cpuThread
import io.hengam.lib.utils.log.Plog
import com.google.android.gms.location.Geofence
import com.google.android.gms.location.GeofencingEvent

class GeofenceTransitionsJobIntentService : JobIntentService() {


    companion object {

        private const val JOB_ID = 573

        fun enqueueWork(context: Context, intent: Intent) {
            enqueueWork(
                    context,
                    GeofenceTransitionsJobIntentService::class.java, JOB_ID,
                    intent)
        }
    }

    override fun onHandleWork(intent: Intent) {
        try {
            cpuThread {
                try {
                    val datalyticsComponent = HengamInternals.getComponent(DatalyticsComponent::class.java)
                            ?: throw ComponentNotAvailableException(Hengam.DATALYTICS)
                    val geofencingEvent = GeofencingEvent.fromIntent(intent)
                    if (geofencingEvent.hasError()) {
                        Plog.warn(LogTags.T_DATALYTICS, LogTags.T_GEOFENCE, "Error received in geofence service: ${geofencingEvent.errorCode}")
                    } else {
                        geofencingEvent.triggeringGeofences.forEach { event ->
                            datalyticsComponent.geofenceManager().onGeofenceTriggered(event.requestId)
                        }
                    }
                } catch (ex: Exception) {
                    Plog.error(LogTags.T_DATALYTICS, LogTags.T_GEOFENCE, ex)
                }
            }
        } catch (ex: Throwable) {
            Plog.error(LogTags.T_DATALYTICS, LogTags.T_GEOFENCE, ex)
        }
    }
}