package io.hengam.lib.datalytics

import io.hengam.lib.datalytics.geofence.GeofenceManager
import io.hengam.lib.internal.HengamServiceApi
import javax.inject.Inject

class HengamDatalytics @Inject constructor(private val geofenceManager: GeofenceManager
) : HengamServiceApi {
    fun enableGeofencePeriodicTask() {
        geofenceManager.isGeofenceEnabledForOreoAndAbove = true
    }

    fun disableGeofencePeriodicTask() {
        geofenceManager.isGeofenceEnabledForOreoAndAbove = false
    }
}