/*
 * Decompiled with CFR 0.152.
 */
package io.hengam.lib.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.location.Location;
import android.os.Looper;
import com.google.android.gms.location.FusedLocationProviderClient;
import com.google.android.gms.location.LocationAvailability;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationResult;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import io.hengam.lib.AppManifest;
import io.hengam.lib.internal.SchedulersKt;
import io.hengam.lib.utils.GeoUtils;
import io.hengam.lib.utils.PermissionChecker;
import io.hengam.lib.utils.Time;
import io.hengam.lib.utils.TimeKt;
import io.hengam.lib.utils.log.Plog;
import io.hengam.lib.utils.rx.PublishRelay;
import io.reactivex.Maybe;
import io.reactivex.MaybeEmitter;
import io.reactivex.MaybeOnSubscribe;
import io.reactivex.MaybeSource;
import io.reactivex.Single;
import io.reactivex.SingleEmitter;
import io.reactivex.SingleOnSubscribe;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000eH\u0007J\u0018\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e2\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0007J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u0015H\u0007J\u0012\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u0011H\u0007R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0010\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lio/hengam/lib/utils/GeoUtils;", "Lcom/google/android/gms/location/LocationCallback;", "context", "Landroid/content/Context;", "fusedLocationProviderClient", "Lcom/google/android/gms/location/FusedLocationProviderClient;", "appManifest", "Lio/hengam/lib/AppManifest;", "(Landroid/content/Context;Lcom/google/android/gms/location/FusedLocationProviderClient;Lio/hengam/lib/AppManifest;)V", "locationResponseRelay", "Lio/hengam/lib/utils/rx/PublishRelay;", "Landroid/location/Location;", "kotlin.jvm.PlatformType", "getLastKnownLocation", "Lio/reactivex/Maybe;", "getLocation", "timeout", "Lio/hengam/lib/utils/Time;", "hasLocationPermissions", "", "isLastLocationAvailable", "Lio/reactivex/Single;", "onLocationResult", "", "locationResult", "Lcom/google/android/gms/location/LocationResult;", "requestLocationUpdates", "Companion", "core_release"})
public final class GeoUtils
extends LocationCallback {
    public static final long LOCATION_UPDATE_INTERVAL = 10000L;
    public static final long LOCATION_UPDATE_FASTEST_INTERVAL = 2000L;
    public static final Companion Companion = new Companion(null);
    public PublishRelay<Location> locationResponseRelay;
    public final Context context;
    public final FusedLocationProviderClient fusedLocationProviderClient;
    public final AppManifest appManifest;

    public static /* synthetic */ Maybe getLocation$default(GeoUtils geoUtils, Time time, int n2, Object object) {
        if ((n2 & 1) != 0) {
            time = TimeKt.seconds((long)10L);
        }
        return geoUtils.getLocation(time);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasLocationPermissions() {
        PermissionChecker permissionChecker = PermissionChecker.INSTANCE;
        Context context = geoUtils.context;
        if (permissionChecker.hasPermission(context, permissionChecker.getACCESS_COARSE_LOCATION())) return true;
        PermissionChecker permissionChecker2 = PermissionChecker.INSTANCE;
        GeoUtils geoUtils = geoUtils.context;
        if (!permissionChecker2.hasPermission((Context)geoUtils, permissionChecker2.getACCESS_FINE_LOCATION())) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Inject
    public GeoUtils(@NotNull Context context, @NotNull FusedLocationProviderClient fusedLocationProviderClient, @NotNull AppManifest appManifest) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkParameterIsNotNull((Object)var1_1, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)var2_2, (String)"fusedLocationProviderClient");
        Intrinsics.checkParameterIsNotNull((Object)var3_3, (String)"appManifest");
        this_.context = var1_1;
        this_.fusedLocationProviderClient = var2_2;
        this_.appManifest = var3_3;
        GeoUtils this_ = PublishRelay.create();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)this_), (String)"PublishRelay.create<Location>()");
        v0.locationResponseRelay = this_;
    }

    public static final /* synthetic */ PublishRelay access$getLocationResponseRelay$p(GeoUtils $this) {
        return $this.locationResponseRelay;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setLocationResponseRelay$p(GeoUtils $this, PublishRelay publishRelay) {
        void var1_1;
        $this.locationResponseRelay = var1_1;
    }

    public static final /* synthetic */ FusedLocationProviderClient access$getFusedLocationProviderClient$p(GeoUtils $this) {
        return $this.fusedLocationProviderClient;
    }

    /*
     * WARNING - void declaration
     */
    @SuppressLint(value={"MissingPermission"})
    @NotNull
    public final Maybe<Location> getLocation(@NotNull Time timeout) {
        void var1_1;
        Intrinsics.checkParameterIsNotNull((Object)var1_1, (String)"timeout");
        if (this_.hasLocationPermissions() && this_.appManifest.locationCollectionEnabled) {
            Maybe maybe = this_.isLastLocationAvailable().subscribeOn(SchedulersKt.cpuThread()).observeOn(SchedulersKt.cpuThread()).flatMapMaybe(new Function<T, MaybeSource<? extends R>>((GeoUtils)this_){
                public final /* synthetic */ GeoUtils this$0;
                {
                    this.this$0 = geoUtils;
                }

                @NotNull
                public final Maybe<Location> apply(@NotNull Boolean it) {
                    Maybe<Location> maybe;
                    Boolean bl = it;
                    Intrinsics.checkParameterIsNotNull((Object)bl, (String)"it");
                    if (bl.booleanValue()) {
                        maybe = maybe.this$0.getLastKnownLocation();
                    } else {
                        maybe = Maybe.empty();
                        Intrinsics.checkExpressionValueIsNotNull((Object)maybe, (String)"Maybe.empty()");
                    }
                    return maybe;
                }
            }).switchIfEmpty((MaybeSource)Maybe.defer(new Callable<MaybeSource<? extends T>>((GeoUtils)this_, (Time)var1_1){
                public final /* synthetic */ GeoUtils this$0;
                public final /* synthetic */ Time $timeout;
                {
                    this.this$0 = geoUtils;
                    this.$timeout = time;
                }

                public final Maybe<Location> call() {
                    getLocation.2 v02 = this;
                    v02.this$0.requestLocationUpdates(this.$timeout);
                    return GeoUtils.access$getLocationResponseRelay$p(v02.this$0).firstElement();
                }
            })).timeout(var1_1.toMillis(), TimeUnit.MILLISECONDS, SchedulersKt.cpuThread(), (MaybeSource)Maybe.empty()).doOnError((Consumer)getLocation.3.INSTANCE).onErrorComplete();
            Intrinsics.checkExpressionValueIsNotNull((Object)maybe, (String)"isLastLocationAvailable(\u2026       .onErrorComplete()");
            return maybe;
        }
        Pair[] this_ = new Pair[]{};
        Plog.INSTANCE.trace("Location", "Location collection is either disabled or denied. Ignoring...", this_);
        Maybe maybe = Maybe.empty();
        Intrinsics.checkExpressionValueIsNotNull((Object)maybe, (String)"Maybe.empty()");
        return maybe;
    }

    @SuppressLint(value={"MissingPermission"})
    @NotNull
    public final Maybe<Location> getLastKnownLocation() {
        if (this_.hasLocationPermissions() && this_.appManifest.locationCollectionEnabled) {
            Maybe maybe = Maybe.create(new MaybeOnSubscribe<T>((GeoUtils)this_){
                public final /* synthetic */ GeoUtils this$0;
                {
                    this.this$0 = geoUtils;
                }

                /*
                 * WARNING - void declaration
                 */
                public final void subscribe(@NotNull MaybeEmitter<Location> emitter) {
                    void var1_1;
                    Intrinsics.checkParameterIsNotNull((Object)var1_1, (String)"emitter");
                    GeoUtils.access$getFusedLocationProviderClient$p(this.this$0).getLastLocation().addOnSuccessListener(new OnSuccessListener<Location>((MaybeEmitter)var1_1){
                        public final /* synthetic */ MaybeEmitter $emitter;
                        {
                            this.$emitter = maybeEmitter;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void onSuccess(@Nullable Location location) {
                            void var1_1;
                            Plog plog = Plog.INSTANCE;
                            String string = "Location";
                            String string2 = "Last known location retrieved";
                            Pair[] pairArray = new Pair[2];
                            int n2 = 0;
                            String string3 = "Location";
                            Object object = location == null ? null : "" + var1_1.getLatitude() + ' ' + var1_1.getLongitude();
                            pairArray[n2] = TuplesKt.to((Object)string3, object);
                            n2 = 1;
                            string3 = "Time";
                            object = var1_1 != null ? Long.valueOf(var1_1.getTime()) : null;
                            pairArray[n2] = TuplesKt.to((Object)string3, (Object)object);
                            plog.trace(string, string2, pairArray);
                            if (var1_1 == null) {
                                this.$emitter.onComplete();
                            } else {
                                this.$emitter.onSuccess((Object)var1_1);
                            }
                        }
                    }).addOnFailureListener(new OnFailureListener((MaybeEmitter)var1_1){
                        public final /* synthetic */ MaybeEmitter $emitter;
                        {
                            this.$emitter = maybeEmitter;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void onFailure(@NotNull Exception exception) {
                            void var1_1;
                            Intrinsics.checkParameterIsNotNull((Object)var1_1, (String)"exception");
                            this.$emitter.tryOnError((Throwable)var1_1);
                        }
                    });
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)maybe, (String)"Maybe.create { emitter -\u2026or(exception) }\n        }");
            return maybe;
        }
        Pair[] this_ = new Pair[]{};
        Plog.INSTANCE.trace("Location", "Location collection is either disabled or denied. Ignoring...", this_);
        Maybe maybe = Maybe.empty();
        Intrinsics.checkExpressionValueIsNotNull((Object)maybe, (String)"Maybe.empty()");
        return maybe;
    }

    @SuppressLint(value={"MissingPermission"})
    @NotNull
    public final Single<Boolean> isLastLocationAvailable() {
        if (this_.hasLocationPermissions() && this_.appManifest.locationCollectionEnabled) {
            Single single = Single.create(new SingleOnSubscribe<T>((GeoUtils)this_){
                public final /* synthetic */ GeoUtils this$0;
                {
                    this.this$0 = geoUtils;
                }

                /*
                 * WARNING - void declaration
                 */
                public final void subscribe(@NotNull SingleEmitter<Boolean> emitter) {
                    void var1_1;
                    Intrinsics.checkParameterIsNotNull((Object)var1_1, (String)"emitter");
                    GeoUtils.access$getFusedLocationProviderClient$p(this.this$0).getLocationAvailability().addOnSuccessListener(new OnSuccessListener<LocationAvailability>((SingleEmitter)var1_1){
                        public final /* synthetic */ SingleEmitter $emitter;
                        {
                            this.$emitter = singleEmitter;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void onSuccess(LocationAvailability locationAvailability) {
                            void var1_1;
                            void v02 = var1_1;
                            Intrinsics.checkExpressionValueIsNotNull((Object)v02, (String)"locationAvailability");
                            this.$emitter.onSuccess((Object)v02.isLocationAvailable());
                        }
                    }).addOnFailureListener(new OnFailureListener((SingleEmitter)var1_1){
                        public final /* synthetic */ SingleEmitter $emitter;
                        {
                            this.$emitter = singleEmitter;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void onFailure(@NotNull Exception exception) {
                            void var1_1;
                            Intrinsics.checkParameterIsNotNull((Object)var1_1, (String)"exception");
                            this.$emitter.tryOnError((Throwable)var1_1);
                        }
                    });
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"Single.create { emitter \u2026or(exception) }\n        }");
            return single;
        }
        Pair[] this_ = new Pair[]{};
        Plog.INSTANCE.trace("Location", "Location collection is either disabled or denied. Ignoring...", this_);
        Single single = Single.just((Object)false);
        Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"Single.just(false)");
        return single;
    }

    /*
     * WARNING - void declaration
     */
    @SuppressLint(value={"MissingPermission"})
    public final void requestLocationUpdates(@NotNull Time timeout) {
        void var1_1;
        Intrinsics.checkParameterIsNotNull((Object)var1_1, (String)"timeout");
        LocationRequest locationRequest = new LocationRequest[]{};
        Plog.INSTANCE.trace("Location", "Requesting location update", (Pair[])locationRequest);
        LocationRequest locationRequest2 = locationRequest = LocationRequest.create();
        locationRequest2.setInterval(10000L);
        locationRequest2.setFastestInterval(2000L);
        locationRequest2.setPriority(102);
        locationRequest2.setNumUpdates(1);
        locationRequest.setExpirationDuration(var1_1.toMillis());
        this.fusedLocationProviderClient.requestLocationUpdates(locationRequest, (LocationCallback)this, Looper.getMainLooper());
    }

    /*
     * WARNING - void declaration
     */
    public void onLocationResult(@Nullable LocationResult locationResult) {
        void var1_1;
        SchedulersKt.cpuThread(new Function0<Unit>(this, (LocationResult)var1_1){
            public final /* synthetic */ GeoUtils this$0;
            public final /* synthetic */ LocationResult $locationResult;
            {
                this.this$0 = geoUtils;
                this.$locationResult = locationResult;
                super(0);
            }

            public final void invoke() {
                LocationResult locationResult = this_.$locationResult;
                if (locationResult != null && (locationResult = locationResult.getLastLocation()) != null) {
                    Pair[] pairArray = this_;
                    Pair[] pairArray2 = new Pair[2];
                    Pair[] this_ = pairArray2;
                    this_[0] = TuplesKt.to((Object)"Lat", (Object)locationResult.getLatitude());
                    pairArray2[1] = TuplesKt.to((Object)"Long", (Object)locationResult.getLongitude());
                    Plog.INSTANCE.debug("Location", "New location received " + System.currentTimeMillis(), this_);
                    GeoUtils.access$getLocationResponseRelay$p(pairArray.this$0).accept((Object)locationResult);
                }
            }
        });
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/hengam/lib/utils/GeoUtils$Companion;", "", "()V", "LOCATION_UPDATE_FASTEST_INTERVAL", "", "LOCATION_UPDATE_INTERVAL", "core_release"})
    public static final class Companion {
        public Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

