/*
 * Decompiled with CFR 0.152.
 */
package io.hengam.lib.tasks;

import androidx.work.Data;
import androidx.work.ExistingPeriodicWorkPolicy;
import androidx.work.ListenableWorker;
import androidx.work.NetworkType;
import io.hengam.lib.dagger.CoreComponent;
import io.hengam.lib.internal.ComponentNotAvailableException;
import io.hengam.lib.internal.HengamConfig;
import io.hengam.lib.internal.HengamInternals;
import io.hengam.lib.internal.task.HengamTask;
import io.hengam.lib.internal.task.PeriodicTaskOptions;
import io.hengam.lib.internal.task.TaskOptions;
import io.hengam.lib.internal.task.TaskScheduler;
import io.hengam.lib.tasks.UpstreamSenderTask;
import io.hengam.lib.utils.Time;
import io.hengam.lib.utils.TimeKt;
import io.hengam.lib.utils.log.Plog;
import io.reactivex.Single;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lio/hengam/lib/tasks/UpstreamFlushTask;", "Lio/hengam/lib/internal/task/HengamTask;", "()V", "perform", "Lio/reactivex/Single;", "Landroidx/work/ListenableWorker$Result;", "inputData", "Landroidx/work/Data;", "Options", "core_release"})
public final class UpstreamFlushTask
extends HengamTask {
    @Override
    @NotNull
    public Single<ListenableWorker.Result> perform(@NotNull Data inputData) {
        Intrinsics.checkParameterIsNotNull((Object)inputData, (String)"inputData");
        Pair[] pairArray = HengamInternals.INSTANCE.getComponent(CoreComponent.class);
        if (pairArray != null) {
            Pair[] pairArray2 = pairArray;
            pairArray = new Pair[]{};
            Plog.INSTANCE.debug("Messaging", "Flushing upstream messages", pairArray);
            TaskScheduler.scheduleTask$default(pairArray2.taskScheduler(), UpstreamSenderTask.a.a, null, null, 6, null);
            Single single = Single.just((Object)ListenableWorker.Result.success());
            Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"Single.just(ListenableWorker.Result.success())");
            return single;
        }
        throw new ComponentNotAvailableException("core");
    }

    public static final class a
    extends PeriodicTaskOptions {
        @Override
        @NotNull
        public NetworkType networkType() {
            return NetworkType.CONNECTED;
        }

        @Override
        @NotNull
        public KClass<? extends HengamTask> task() {
            return Reflection.getOrCreateKotlinClass(UpstreamFlushTask.class);
        }

        @Override
        @NotNull
        public Time repeatInterval() {
            HengamConfig hengamConfig = ((TaskOptions)object).getHengamConfig();
            Intrinsics.checkParameterIsNotNull((Object)hengamConfig, (String)"$this$upstreamFlushInterval");
            Object object = hengamConfig.getLong("upstream_flush_interval", -1L);
            if (!(((Number)object).longValue() >= 0L)) {
                object = null;
            }
            if (object == null || (object = TimeKt.millis((long)((Number)object).longValue())) == null) {
                object = TimeKt.days((long)1L);
            }
            return object;
        }

        @Override
        @NotNull
        public String taskId() {
            return "hengam_upstream_flush";
        }

        @Override
        @Nullable
        public ExistingPeriodicWorkPolicy existingWorkPolicy() {
            return ExistingPeriodicWorkPolicy.KEEP;
        }

        @Override
        @Nullable
        public Time backoffDelay() {
            return TimeKt.seconds((long)30L);
        }

        @Override
        @NotNull
        public Time flexibilityTime() {
            return TimeKt.hours((long)2L);
        }
    }
}

