/*
 * Decompiled with CFR 0.152.
 */
package io.hengam.lib.internal.task;

import android.content.Context;
import androidx.work.BackoffPolicy;
import androidx.work.Constraints;
import androidx.work.Data;
import androidx.work.ExistingPeriodicWorkPolicy;
import androidx.work.ExistingWorkPolicy;
import androidx.work.ListenableWorker;
import androidx.work.NetworkType;
import androidx.work.OneTimeWorkRequest;
import androidx.work.PeriodicWorkRequest;
import androidx.work.WorkManager;
import androidx.work.WorkRequest;
import io.hengam.lib.internal.HengamConfig;
import io.hengam.lib.internal.SchedulersKt;
import io.hengam.lib.internal.task.HengamTask;
import io.hengam.lib.internal.task.HengamTaskPerformer;
import io.hengam.lib.internal.task.OneTimeTaskOptions;
import io.hengam.lib.internal.task.PeriodicTaskOptions;
import io.hengam.lib.internal.task.StoredTaskInfo;
import io.hengam.lib.internal.task.TaskOptions;
import io.hengam.lib.internal.task.TaskScheduler;
import io.hengam.lib.tasks.UpstreamFlushTask;
import io.hengam.lib.utils.HengamStorage;
import io.hengam.lib.utils.PersistedList;
import io.hengam.lib.utils.PersistedMap;
import io.hengam.lib.utils.Time;
import io.hengam.lib.utils.TimeKt;
import io.hengam.lib.utils.log.Plog;
import io.hengam.lib.utils.rx.RxUtilsKt;
import io.reactivex.Single;
import io.reactivex.functions.Function;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.full.KClasses;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 %2\u00020\u0001:\u0001%B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014J\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J$\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u001b2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002J\u001a\u0010 \u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020!2\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010\u001bJ\u0006\u0010#\u001a\u00020\u0010J&\u0010$\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u001d2\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010\u001b2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u001fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lio/hengam/lib/internal/task/TaskScheduler;", "", "context", "Landroid/content/Context;", "hengamConfig", "Lio/hengam/lib/internal/HengamConfig;", "hengamStorage", "Lio/hengam/lib/utils/HengamStorage;", "(Landroid/content/Context;Lio/hengam/lib/internal/HengamConfig;Lio/hengam/lib/utils/HengamStorage;)V", "oneTimeTasks", "Lio/hengam/lib/utils/PersistedList;", "Lio/hengam/lib/internal/task/StoredTaskInfo;", "periodicTaskIntervals", "Lio/hengam/lib/utils/PersistedMap;", "", "cancelTask", "", "taskOptions", "Lio/hengam/lib/internal/task/TaskOptions;", "taskId", "", "performTask", "Lio/reactivex/Single;", "Landroidx/work/ListenableWorker$Result;", "task", "Lio/hengam/lib/internal/task/HengamTask;", "inputData", "Landroidx/work/Data;", "scheduleOneTimeTask", "Lio/hengam/lib/internal/task/OneTimeTaskOptions;", "initialDelay", "Lio/hengam/lib/utils/Time;", "schedulePeriodicTask", "Lio/hengam/lib/internal/task/PeriodicTaskOptions;", "data", "scheduleStoredTasks", "scheduleTask", "Companion", "core_release"})
public final class TaskScheduler {
    @NotNull
    public static final String DEFAULT_WORK_TAG = "hengam";
    public static final long ONE_TIME_TASK_FIRST_RETRY_DELAY = 30000L;
    public static final Companion Companion = new Companion(null);
    public final PersistedList<StoredTaskInfo> oneTimeTasks;
    public final PersistedMap<Long> periodicTaskIntervals;
    public final Context context;
    public final HengamConfig hengamConfig;

    public static /* synthetic */ void scheduleTask$default(TaskScheduler taskScheduler, OneTimeTaskOptions oneTimeTaskOptions, Data data, Time time, int n2, Object object) {
        if ((n2 & 2) != 0) {
            data = null;
        }
        if ((n2 & 4) != 0) {
            time = null;
        }
        taskScheduler.scheduleTask(oneTimeTaskOptions, data, time);
    }

    /*
     * WARNING - void declaration
     */
    private final Single<ListenableWorker.Result> performTask(HengamTask task, Data inputData) {
        void var2_2;
        Single single = task.perform((Data)var2_2).onErrorReturn((Function)performTask.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"task.perform(inputData)\n\u2026ult.retry()\n            }");
        return single;
    }

    private final void scheduleOneTimeTask(OneTimeTaskOptions taskOptions, Data inputData, Time initialDelay) {
        Object object;
        ExistingWorkPolicy existingWorkPolicy;
        String string;
        OneTimeTaskOptions oneTimeTaskOptions = taskOptions;
        Constraints constraints = new Pair[1];
        Constraints constraints2 = constraints;
        constraints[0] = TuplesKt.to((Object)"Task Id", (Object)string.getString("%task_id"));
        Plog.INSTANCE.trace("Task", "Scheduling one-time task", (Pair[])constraints2);
        oneTimeTaskOptions.setHengamConfig(taskScheduler.hengamConfig);
        constraints2 = new Constraints.Builder().setRequiredNetworkType(existingWorkPolicy.networkType()).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)constraints2, (String)"Constraints.Builder()\n  \u2026e())\n            .build()");
        OneTimeWorkRequest.Builder builder = (OneTimeWorkRequest.Builder)new OneTimeWorkRequest.Builder(HengamTaskPerformer.class).addTag(DEFAULT_WORK_TAG);
        String string2 = oneTimeTaskOptions.taskId();
        if (string2 == null) {
            string2 = existingWorkPolicy.task().getQualifiedName();
        }
        if (string2 == null) {
            string2 = "";
        }
        WorkRequest.Builder builder2 = ((OneTimeWorkRequest.Builder)builder.addTag(string2)).setConstraints(constraints2);
        Intrinsics.checkExpressionValueIsNotNull((Object)builder2, (String)"OneTimeWorkRequest.Build\u2026tConstraints(constraints)");
        constraints2 = (OneTimeWorkRequest.Builder)builder2;
        if (object != null) {
            long l2 = object.toSeconds();
            object = TimeUnit.SECONDS;
            constraints2.setInitialDelay(l2, (TimeUnit)((Object)object));
        }
        object = existingWorkPolicy.backoffPolicy();
        builder = existingWorkPolicy.backoffDelay();
        if (object != null || builder != null) {
            if (object == null) {
                object = BackoffPolicy.EXPONENTIAL;
            }
            long l3 = builder != null ? builder.toMillis() : 30000L;
            TimeUnit timeUnit = TimeUnit.MILLISECONDS;
            constraints2.setBackoffCriteria(object, l3, timeUnit);
        }
        constraints2.setInputData((Data)string);
        string = existingWorkPolicy.taskId();
        if (string == null) {
            WorkManager.getInstance((Context)taskScheduler.context).enqueue(constraints2.build());
        } else {
            TaskScheduler taskScheduler = WorkManager.getInstance((Context)taskScheduler.context);
            if ((existingWorkPolicy = existingWorkPolicy.existingWorkPolicy()) == null) {
                existingWorkPolicy = ExistingWorkPolicy.KEEP;
            }
            taskScheduler.beginUniqueWork(string, existingWorkPolicy, (OneTimeWorkRequest)constraints2.build()).enqueue();
        }
    }

    public static /* synthetic */ void scheduleOneTimeTask$default(TaskScheduler taskScheduler, OneTimeTaskOptions oneTimeTaskOptions, Data data, Time time, int n2, Object object) {
        if ((n2 & 4) != 0) {
            time = null;
        }
        taskScheduler.scheduleOneTimeTask(oneTimeTaskOptions, data, time);
    }

    public static /* synthetic */ void schedulePeriodicTask$default(TaskScheduler taskScheduler, PeriodicTaskOptions periodicTaskOptions, Data data, int n2, Object object) {
        if ((n2 & 2) != 0) {
            data = null;
        }
        taskScheduler.schedulePeriodicTask(periodicTaskOptions, data);
    }

    /*
     * WARNING - void declaration
     */
    @Inject
    public TaskScheduler(@NotNull Context context, @NotNull HengamConfig hengamConfig, @NotNull HengamStorage hengamStorage) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkParameterIsNotNull((Object)var1_1, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)var2_2, (String)"hengamConfig");
        Intrinsics.checkParameterIsNotNull((Object)var3_3, (String)"hengamStorage");
        this.context = var1_1;
        this.hengamConfig = var2_2;
        this.oneTimeTasks = HengamStorage.createStoredList$default((HengamStorage)var3_3, "onetime_tasks", StoredTaskInfo.class, null, 4, null);
        this.periodicTaskIntervals = HengamStorage.createStoredMap$default((HengamStorage)var3_3, "periodic_task_intervals", Long.class, null, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$scheduleOneTimeTask(TaskScheduler $this, OneTimeTaskOptions taskOptions, Data inputData, Time initialDelay) {
        void var3_3;
        void var2_2;
        void var1_1;
        $this.scheduleOneTimeTask((OneTimeTaskOptions)var1_1, (Data)var2_2, (Time)var3_3);
    }

    public static final /* synthetic */ PersistedList access$getOneTimeTasks$p(TaskScheduler $this) {
        return $this.oneTimeTasks;
    }

    /*
     * WARNING - void declaration
     */
    public final void scheduleTask(@NotNull OneTimeTaskOptions taskOptions, @Nullable Data data, @Nullable Time initialDelay) {
        Function1<ListenableWorker.Result, Unit> function1;
        String[] stringArray;
        Map map;
        void var1_1;
        void v02 = var1_1;
        Intrinsics.checkParameterIsNotNull((Object)var1_1, (String)"taskOptions");
        Object object = new Pair[]{};
        Plog.INSTANCE.trace("Task", "Executing one-time task: " + var1_1.taskId(), object);
        v02.setHengamConfig(this.hengamConfig);
        Object object2 = v02.existingWorkPolicy();
        Pair[] pairArray = v02.networkType();
        String string = v02.task().getQualifiedName();
        String string2 = v02.taskId();
        int n2 = v02.maxAttemptsCount();
        Time time = v02.backoffDelay();
        BackoffPolicy backoffPolicy = v02.backoffPolicy();
        Map map2 = data != null ? map.getKeyValueMap() : null;
        object = new StoredTaskInfo((ExistingWorkPolicy)object2, (NetworkType)pairArray, string, string2, n2, time, backoffPolicy, map2);
        this.oneTimeTasks.add(object);
        if (map != null) {
            Map map3 = map.getKeyValueMap();
            Intrinsics.checkExpressionValueIsNotNull((Object)map3, (String)"data.keyValueMap");
            map = MapsKt.toMutableMap((Map)map3);
            map.put("%max_attempts_count", var1_1.maxAttemptsCount());
            map.put("%task_id", var1_1.taskId());
            map.put("%task_class_name", var1_1.task().getQualifiedName());
            map = new Data.Builder().putAll(map).build();
            Intrinsics.checkExpressionValueIsNotNull((Object)map, (String)"Data.Builder().putAll(dataMap).build()");
        } else {
            Data.Builder builder;
            int n3 = 3;
            Pair[] pairArray2 = new Pair[3];
            object2 = pairArray2;
            object2[0] = TuplesKt.to((Object)"%max_attempts_count", (Object)var1_1.maxAttemptsCount());
            object2[1] = TuplesKt.to((Object)"%task_id", (Object)var1_1.taskId());
            pairArray2[2] = TuplesKt.to((Object)"%task_class_name", (Object)var1_1.task().getQualifiedName());
            pairArray = builder;
            builder = new Data.Builder();
            for (int i2 = 0; i2 < n3; ++i2) {
                Pair pair = object2[i2];
                string2 = (String)pair.getFirst();
                pairArray.put(string2, pair.getSecond());
            }
            map = pairArray.build();
            Intrinsics.checkExpressionValueIsNotNull((Object)map, (String)"dataBuilder.build()");
        }
        try {
            object2 = (HengamTask)KClasses.createInstance(var1_1.task());
        }
        catch (Exception exception) {
            Pair[] pairArray3 = new Pair[1];
            pairArray = pairArray3;
            pairArray3[0] = TuplesKt.to((Object)"Task", (Object)var1_1.taskId());
            Plog.INSTANCE.error("Task", "Could not instantiate the performer class of oneTimeTask. It will be scheduled to run by WorkManager", (Throwable)exception, pairArray);
            object2 = null;
        }
        if (object2 == null) {
            TaskScheduler taskScheduler = this;
            taskScheduler.scheduleOneTimeTask((OneTimeTaskOptions)var1_1, (Data)map, (Time)stringArray);
            taskScheduler.oneTimeTasks.remove(object);
            return;
        }
        object2 = this.performTask((HengamTask)object2, (Data)map).subscribeOn(SchedulersKt.cpuThread());
        long l2 = stringArray != null ? stringArray.getTime() : 0L;
        stringArray = TimeUnit.MILLISECONDS;
        Single single = object2.delaySubscription(l2, (TimeUnit)stringArray);
        Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"performTask(performer, i\u2026L, TimeUnit.MILLISECONDS)");
        String[] stringArray2 = new String[1];
        stringArray = stringArray2;
        stringArray2[0] = "Task";
        object2 = function1;
        function1 = new Function1<ListenableWorker.Result, Unit>(this, (OneTimeTaskOptions)var1_1, (Data)map, (StoredTaskInfo)object){
            public final /* synthetic */ TaskScheduler this$0;
            public final /* synthetic */ OneTimeTaskOptions $taskOptions;
            public final /* synthetic */ Data $inputData;
            public final /* synthetic */ StoredTaskInfo $taskInfo;
            {
                this.this$0 = taskScheduler;
                this.$taskOptions = oneTimeTaskOptions;
                this.$inputData = data;
                this.$taskInfo = storedTaskInfo;
                super(1);
            }

            public final void invoke(ListenableWorker.Result result) {
                Object object;
                if (Intrinsics.areEqual((Object)result, (Object)ListenableWorker.Result.retry())) {
                    scheduleTask.1 v02 = this;
                    Pair[] pairArray = new Pair[1];
                    object = pairArray;
                    pairArray[0] = TuplesKt.to((Object)"Task Id", (Object)this.$taskOptions.taskId());
                    Plog.INSTANCE.trace("Task", "Failure trying to run one-time task. Scheduling the task to be run by workManager", object);
                    scheduleTask.1 v2 = this;
                    object = v2.$taskOptions;
                    Data data = v2.$inputData;
                    TaskScheduler.access$scheduleOneTimeTask(v02.this$0, (OneTimeTaskOptions)object, data, TimeKt.millis((long)30000L));
                    TaskScheduler.access$getOneTimeTasks$p(v02.this$0).remove(this.$taskInfo);
                } else {
                    object = object instanceof ListenableWorker.Result.Failure ? "Failure" : (object instanceof ListenableWorker.Result.Success ? "Success" : "Unknown");
                    String string = "Task finished with result " + (String)object;
                    Pair[] pairArray = new Pair[1];
                    object = pairArray;
                    pairArray[0] = TuplesKt.to((Object)"Task Id", (Object)this.$taskOptions.taskId());
                    Plog.INSTANCE.trace("Task", string, object);
                    TaskScheduler.access$getOneTimeTasks$p(this.this$0).remove(this.$taskInfo);
                }
            }
        };
        RxUtilsKt.justDo((Single)single, (String[])stringArray, (Function1)object2);
    }

    public final void schedulePeriodicTask(@NotNull PeriodicTaskOptions taskOptions, @Nullable Data data) {
        Map map;
        Object object;
        Pair[] pairArray;
        PeriodicTaskOptions periodicTaskOptions = taskOptions;
        Intrinsics.checkParameterIsNotNull((Object)pairArray, (String)"taskOptions");
        periodicTaskOptions.setHengamConfig(this.hengamConfig);
        String string = periodicTaskOptions.taskId();
        Constraints constraints = new Constraints.Builder().setRequiredNetworkType(NetworkType.CONNECTED).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)constraints, (String)"Constraints.Builder()\n  \u2026\n                .build()");
        void v1 = pairArray;
        long l2 = v1.repeatInterval().getTime();
        TimeUnit timeUnit = v1.repeatInterval().getTimeUnit();
        WorkRequest.Builder builder = ((PeriodicWorkRequest.Builder)((PeriodicWorkRequest.Builder)new PeriodicWorkRequest.Builder(HengamTaskPerformer.class, l2, timeUnit).addTag(DEFAULT_WORK_TAG)).addTag(pairArray.taskId())).setConstraints(constraints);
        Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"PeriodicWorkRequest.Buil\u2026tConstraints(constraints)");
        constraints = (PeriodicWorkRequest.Builder)builder;
        Object object2 = periodicTaskOptions.backoffPolicy();
        Time time = TimeKt.seconds((long)30L);
        if (object2 != null || time != null) {
            if (object2 == null) {
                object2 = BackoffPolicy.EXPONENTIAL;
            }
            long l3 = time != null ? time.toMillis() : 30000L;
            object = TimeUnit.MILLISECONDS;
            constraints.setBackoffCriteria((BackoffPolicy)object2, l3, object);
        }
        if (map != null) {
            Map map2 = map.getKeyValueMap();
            Intrinsics.checkExpressionValueIsNotNull((Object)map2, (String)"data.keyValueMap");
            map = MapsKt.toMutableMap((Map)map2);
            map.put("%max_attempts_count", pairArray.maxAttemptsCount());
            map.put("%task_id", pairArray.taskId());
            map.put("%task_repeat_interval", pairArray.repeatInterval().toMillis());
            map.put("%task_flexibility_time", TimeKt.hours((long)2L).toMillis());
            map.put("%task_class_name", Reflection.getOrCreateKotlinClass(UpstreamFlushTask.class).getQualifiedName());
            constraints.setInputData(new Data.Builder().putAll(map).build());
        } else {
            Data.Builder builder2;
            int n2 = 5;
            Pair[] pairArray2 = new Pair[5];
            object2 = pairArray2;
            object2[0] = TuplesKt.to((Object)"%max_attempts_count", (Object)pairArray.maxAttemptsCount());
            object2[1] = TuplesKt.to((Object)"%task_id", (Object)pairArray.taskId());
            pairArray2[2] = TuplesKt.to((Object)"%task_repeat_interval", (Object)pairArray.repeatInterval().toMillis());
            pairArray2[3] = TuplesKt.to((Object)"%task_flexibility_time", (Object)TimeKt.hours((long)2L).toMillis());
            pairArray2[4] = TuplesKt.to((Object)"%task_class_name", (Object)Reflection.getOrCreateKotlinClass(UpstreamFlushTask.class).getQualifiedName());
            time = builder2;
            builder2 = new Data.Builder();
            for (int i2 = 0; i2 < n2; ++i2) {
                Pair pair = object2[i2];
                object = (String)pair.getFirst();
                time.put((String)object, pair.getSecond());
            }
            map = time.build();
            Intrinsics.checkExpressionValueIsNotNull((Object)map, (String)"dataBuilder.build()");
            constraints.setInputData((Data)map);
        }
        map = ExistingPeriodicWorkPolicy.KEEP;
        if (map == map) {
            object2 = (Long)this.periodicTaskIntervals.get(string);
            long l4 = pairArray.repeatInterval().toMillis();
            if (object2 == null || (Long)object2 != l4) {
                this.periodicTaskIntervals.put(string, l4);
            }
            if (object2 != null && (Long)object2 != l4) {
                map = ExistingPeriodicWorkPolicy.REPLACE;
                Pair[] pairArray3 = new Pair[2];
                pairArray = pairArray3;
                pairArray[0] = TuplesKt.to((Object)"Old Interval", (Object)TimeKt.millis((long)((Long)object2)).bestRepresentation());
                pairArray3[1] = TuplesKt.to((Object)"New Interval", (Object)TimeKt.millis((long)l4).bestRepresentation());
                Plog.INSTANCE.debug("Task", "Updated repeat interval for task " + string, pairArray);
            }
        }
        WorkManager.getInstance((Context)this.context).enqueueUniquePeriodicWork(string, (ExistingPeriodicWorkPolicy)map, (PeriodicWorkRequest)constraints.build());
    }

    /*
     * WARNING - void declaration
     */
    public final void cancelTask(@NotNull String taskId) {
        void var1_1;
        Intrinsics.checkParameterIsNotNull((Object)var1_1, (String)"taskId");
        WorkManager.getInstance((Context)this.context).cancelUniqueWork((String)var1_1);
    }

    public final void cancelTask(@NotNull TaskOptions taskOptions) {
        TaskOptions taskOptions2 = taskOptions;
        Intrinsics.checkParameterIsNotNull((Object)taskOptions2, (String)"taskOptions");
        String string = taskOptions2.taskId();
        if (string == null) {
            Pair[] pairArray = new Pair[]{};
            Plog.INSTANCE.warn("Task", "Cannot cancel task with no id", pairArray);
            return;
        }
        WorkManager.getInstance((Context)pairArray.context).cancelUniqueWork(string);
    }

    public final void scheduleStoredTasks() {
        ArrayList<StoredTaskInfo> arrayList;
        ArrayList<StoredTaskInfo> arrayList2 = arrayList;
        arrayList2();
        arrayList2.addAll(this.oneTimeTasks);
        this.oneTimeTasks.clear();
        for (StoredTaskInfo storedTaskInfo : arrayList) {
            Data.Builder builder;
            OneTimeTaskOptions oneTimeTaskOptions;
            if (storedTaskInfo.getTaskClassName() == null) continue;
            Class<?> clazz = Class.forName(storedTaskInfo.getTaskClassName());
            Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"Class.forName(task.taskClassName)");
            if (!KClasses.isSubclassOf((KClass)JvmClassMappingKt.getKotlinClass(clazz), (KClass)Reflection.getOrCreateKotlinClass(HengamTask.class))) continue;
            StoredTaskInfo storedTaskInfo2 = storedTaskInfo;
            OneTimeTaskOptions oneTimeTaskOptions2 = oneTimeTaskOptions;
            oneTimeTaskOptions = new OneTimeTaskOptions(storedTaskInfo){
                public final /* synthetic */ StoredTaskInfo $task;
                {
                    void var1_1;
                    this.$task = var1_1;
                }

                @NotNull
                public NetworkType networkType() {
                    return this.$task.getNetworkType();
                }

                @NotNull
                public KClass<? extends HengamTask> task() {
                    Class<?> clazz = Class.forName(this_.$task.getTaskClassName());
                    Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"Class.forName(task.taskClassName)");
                    scheduleStoredTasks.1 this_ = JvmClassMappingKt.getKotlinClass(clazz);
                    if (this_ != null) {
                        return this_;
                    }
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.reflect.KClass<out io.hengam.lib.internal.task.HengamTask>");
                }

                @Nullable
                public ExistingWorkPolicy existingWorkPolicy() {
                    return this.$task.getExistingWorkPolicy();
                }

                @Nullable
                public String taskId() {
                    return this.$task.getTaskId();
                }

                public int maxAttemptsCount() {
                    return this.$task.getMaxAttemptsCount();
                }

                @Nullable
                public Time backoffDelay() {
                    return this.$task.getBackoffDelay();
                }

                @Nullable
                public BackoffPolicy backoffPolicy() {
                    return this.$task.getBackoffPolicy();
                }
            };
            storedTaskInfo = builder;
            builder = new Data.Builder();
            LinkedHashMap linkedHashMap = storedTaskInfo2.getInputData();
            if (linkedHashMap == null) {
                LinkedHashMap linkedHashMap2;
                linkedHashMap = linkedHashMap2;
                linkedHashMap2 = new LinkedHashMap();
            }
            TaskScheduler.scheduleTask$default(this, oneTimeTaskOptions2, storedTaskInfo.putAll(linkedHashMap).build(), null, 4, null);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/hengam/lib/internal/task/TaskScheduler$Companion;", "", "()V", "DEFAULT_WORK_TAG", "", "ONE_TIME_TASK_FIRST_RETRY_DELAY", "", "core_release"})
    public static final class Companion {
        public Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

