/*
 * Decompiled with CFR 0.152.
 */
package io.hengam.lib.internal.task;

import android.content.Context;
import androidx.work.Data;
import androidx.work.ListenableWorker;
import androidx.work.RxWorker;
import androidx.work.WorkerParameters;
import io.hengam.lib.internal.SchedulersKt;
import io.hengam.lib.internal.task.HengamTask;
import io.hengam.lib.internal.task.HengamTaskPerformer;
import io.hengam.lib.utils.HengamAssertsKt;
import io.hengam.lib.utils.PersistedMap;
import io.hengam.lib.utils.TimeKt;
import io.hengam.lib.utils.TimeUtils;
import io.hengam.lib.utils.log.LogLevel;
import io.hengam.lib.utils.log.Plog;
import io.reactivex.Scheduler;
import io.reactivex.Single;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import java.util.Map;
import java.util.concurrent.Callable;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.reflect.full.KClasses;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0014J\b\u0010\u0016\u001a\u00020\bH\u0002J\b\u0010\u0017\u001a\u00020\bH\u0002R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\tR!\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lio/hengam/lib/internal/task/HengamTaskPerformer;", "Landroidx/work/RxWorker;", "context", "Landroid/content/Context;", "workerParams", "Landroidx/work/WorkerParameters;", "(Landroid/content/Context;Landroidx/work/WorkerParameters;)V", "isFinalAttempt", "", "()Z", "taskLastRunTimes", "Lio/hengam/lib/utils/PersistedMap;", "", "getTaskLastRunTimes", "()Lio/hengam/lib/utils/PersistedMap;", "taskLastRunTimes$delegate", "Lkotlin/Lazy;", "createWork", "Lio/reactivex/Single;", "Landroidx/work/ListenableWorker$Result;", "getBackgroundScheduler", "Lio/reactivex/Scheduler;", "isPeriodicTask", "shouldSkipPeriodicTaskExecution", "core_release"})
public final class HengamTaskPerformer
extends RxWorker {
    public static final /* synthetic */ KProperty[] $$delegatedProperties;
    public final Lazy taskLastRunTimes$delegate;

    static {
        $$delegatedProperties = new KProperty[]{Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(HengamTaskPerformer.class), "taskLastRunTimes", "getTaskLastRunTimes()Lio/hengam/lib/utils/PersistedMap;"))};
    }

    private final PersistedMap<Long> getTaskLastRunTimes() {
        KProperty cfr_ignored_0 = $$delegatedProperties[0];
        return (PersistedMap)this.taskLastRunTimes$delegate.getValue();
    }

    private final boolean isPeriodicTask() {
        Data data = this.getInputData();
        Intrinsics.checkExpressionValueIsNotNull((Object)data, (String)"inputData");
        Map map = data.getKeyValueMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)map, (String)"inputData.keyValueMap");
        return map.containsKey("%task_repeat_interval");
    }

    private final boolean shouldSkipPeriodicTaskExecution() {
        HengamTaskPerformer hengamTaskPerformer = this_;
        String string = hengamTaskPerformer.getInputData().getString("%task_id");
        Long l2 = (Long)hengamTaskPerformer.getTaskLastRunTimes().get(string);
        if (l2 != null) {
            long l3 = this_.getInputData().getLong("%task_repeat_interval", -1L);
            long l4 = this_.getInputData().getLong("%task_flexibility_time", -1L);
            if (l3 != -1L && l4 != -1L) {
                if (l3 - (TimeUtils.INSTANCE.nowMillis() - l2) > l4) {
                    Object this_ = shouldSkipPeriodicTaskExecution.1.INSTANCE;
                    Plog.INSTANCE.getWarn().message("Skipping periodic task " + string).withTag(new String[]{"Task"}).withData("Task name", (Object)string).withData("Repeat interval", (Object)l3).withData("Prev Collection", (Object)l2).useLogCatLevel(LogLevel.DEBUG).aggregate("skipping-periodic-tasks", TimeKt.millis((long)1000L), (Function1)this_).log();
                    return true;
                }
            } else {
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public HengamTaskPerformer(@NotNull Context context, @NotNull WorkerParameters workerParams) {
        void var2_2;
        void var1_1;
        Intrinsics.checkParameterIsNotNull((Object)var1_1, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)var2_2, (String)"workerParams");
        super((Context)var1_1, (WorkerParameters)var2_2);
        this.taskLastRunTimes$delegate = LazyKt.lazy((Function0)taskLastRunTimes.2.INSTANCE);
    }

    public final boolean isFinalAttempt() {
        int n2 = this.getInputData().getInt("%max_attempts_count", -1);
        return n2 == -1 || this.getRunAttemptCount() == n2 - 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public Single<ListenableWorker.Result> createWork() {
        block11: {
            String string;
            HengamTask hengamTask;
            Pair[] this_;
            Object object;
            block12: {
                Object object2;
                object = this_.getInputData().getString("%task_class_name");
                if (object == null) {
                    this_ = new Pair[]{};
                    Plog.INSTANCE.error("Task", "Task className was not provided in periodic task input data", this_);
                    Single single = Single.just((Object)ListenableWorker.Result.failure());
                    Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"Single.just(Result.failure())");
                    return single;
                }
                String string2 = object;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"inputData.getString(Heng\u2026sult.failure())\n        }");
                try {
                    Class<?> clazz = Class.forName(string2);
                    Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"Class.forName(taskClassName)");
                    KClass kClass = JvmClassMappingKt.getKotlinClass(clazz);
                    if (!KClasses.isSubclassOf((KClass)kClass, (KClass)Reflection.getOrCreateKotlinClass(HengamTask.class))) {
                        Plog.INSTANCE.error("Task", "Provided task class was not a hengam task class", new Pair[]{TuplesKt.to((Object)"Class Name", (Object)object)});
                        Single single = Single.just((Object)ListenableWorker.Result.failure());
                        Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"Single.just(Result.failure())");
                        return single;
                    }
                    object2 = KClasses.createInstance((KClass)kClass);
                    if (object2 == null) break block11;
                }
                catch (Exception exception) {
                    Pair[] pairArray = new Pair[1];
                    this_ = pairArray;
                    pairArray[0] = TuplesKt.to((Object)"Class Name", (Object)object);
                    Plog.INSTANCE.error("Task", "Unable to instantiate provided task class", this_);
                    Single single = Single.just((Object)ListenableWorker.Result.failure());
                    Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"Single.just(Result.failure())");
                    return single;
                }
                hengamTask = (HengamTask)object2;
                string = this_.getInputData().getString("%task_id");
                if (string != null) break block12;
                string = object;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"inputData.getString(Heng\u2026TASK_ID) ?: taskClassName");
            if (super.isPeriodicTask()) {
                object = this_.getInputData().getString("%task_id");
                if (object == null) {
                    this_ = new Pair[]{};
                    Plog.INSTANCE.error("Task", "Task name was not provided in periodic task input data", this_);
                    Single single = Single.just((Object)ListenableWorker.Result.failure());
                    Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"Single.just(Result.failure())");
                    return single;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"inputData.getString(Heng\u2026.failure())\n            }");
                if (super.shouldSkipPeriodicTaskExecution()) {
                    Single single = Single.just((Object)ListenableWorker.Result.success());
                    Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"Single.just(Result.success())");
                    return single;
                }
                super.getTaskLastRunTimes().put(object, TimeUtils.INSTANCE.nowMillis());
            }
            Data data = this_.getInputData();
            Intrinsics.checkExpressionValueIsNotNull((Object)data, (String)"inputData");
            Map map = data.getKeyValueMap();
            Intrinsics.checkExpressionValueIsNotNull((Object)map, (String)"inputData.keyValueMap");
            object = MapsKt.toMutableMap((Map)map);
            object.put("%task_retry_count", this_.getRunAttemptCount());
            object = new Data.Builder().putAll((Map)object).build();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"Data.Builder().putAll(dataMap).build()");
            Single single = Single.fromCallable(new Callable<T>((HengamTaskPerformer)this_, string, hengamTask, (Data)object){
                public final /* synthetic */ HengamTaskPerformer this$0;
                public final /* synthetic */ String $taskId;
                public final /* synthetic */ HengamTask $performer;
                public final /* synthetic */ Data $data;
                {
                    this.this$0 = hengamTaskPerformer;
                    this.$taskId = string;
                    this.$performer = hengamTask;
                    this.$data = data;
                }

                @NotNull
                public final Single<ListenableWorker.Result> call() {
                    Pair[] pairArray = new Pair[2];
                    Pair[] pairArray2 = pairArray;
                    pairArray2[0] = TuplesKt.to((Object)"Work Id", (Object)this.this$0.getId().toString());
                    pairArray[1] = TuplesKt.to((Object)"Attempt", (Object)(this.this$0.getRunAttemptCount() + 1));
                    Plog.INSTANCE.trace("Task", "Task " + this.$taskId + " started", pairArray2);
                    return this.$performer.perform(this.$data);
                }
            }).flatMap((Function)createWork.2.INSTANCE).observeOn(SchedulersKt.cpuThread()).doOnError(new Consumer<Throwable>(string){
                public final /* synthetic */ String $taskId;
                {
                    this.$taskId = string;
                }

                /*
                 * WARNING - void declaration
                 */
                public final void accept(Throwable it) {
                    void var1_1;
                    Pair[] pairArray = new Pair[]{};
                    Plog.INSTANCE.error("Task", "Error occurred in task " + pairArray.$taskId, (Throwable)var1_1, pairArray);
                }
            }).onErrorReturn((Function)createWork.4.INSTANCE).map(new Function<T, R>((HengamTaskPerformer)this_, hengamTask){
                public final /* synthetic */ HengamTaskPerformer this$0;
                public final /* synthetic */ HengamTask $performer;
                {
                    this.this$0 = hengamTaskPerformer;
                    this.$performer = hengamTask;
                }

                @NotNull
                public final ListenableWorker.Result apply(@NotNull ListenableWorker.Result result) {
                    ListenableWorker.Result result2;
                    ListenableWorker.Result result3 = result;
                    Intrinsics.checkParameterIsNotNull((Object)result3, (String)"result");
                    HengamAssertsKt.assertCpuThread();
                    if (Intrinsics.areEqual((Object)result3, (Object)ListenableWorker.Result.retry()) && this.this$0.getInputData().getInt("%max_attempts_count", -1) != -1 && this.this$0.getRunAttemptCount() + 2 >= this.this$0.getInputData().getInt("%max_attempts_count", -1)) {
                        Data data = this.this$0.getInputData();
                        Intrinsics.checkExpressionValueIsNotNull((Object)data, (String)"inputData");
                        this.$performer.onMaximumRetriesReached(data);
                        result2 = ListenableWorker.Result.failure();
                    }
                    return result2;
                }
            }).doOnSuccess(new Consumer<ListenableWorker.Result>((HengamTaskPerformer)this_, string){
                public final /* synthetic */ HengamTaskPerformer this$0;
                public final /* synthetic */ String $taskId;
                {
                    this.this$0 = hengamTaskPerformer;
                    this.$taskId = string;
                }

                public final void accept(ListenableWorker.Result result) {
                    Object object;
                    object = result instanceof ListenableWorker.Result.Retry ? "Retry" : (object instanceof ListenableWorker.Result.Failure ? "Failure" : (object instanceof ListenableWorker.Result.Success ? "Success" : "Unknown"));
                    String string = "Task " + this.$taskId + " finished with result " + (String)object;
                    Pair[] pairArray = new Pair[1];
                    object = pairArray;
                    pairArray[0] = TuplesKt.to((Object)"Id", (Object)this.this$0.getId().toString());
                    Plog.INSTANCE.trace("Task", string, object);
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"Single.fromCallable {\n  \u2026toString())\n            }");
            return single;
        }
        throw new TypeCastException("null cannot be cast to non-null type io.hengam.lib.internal.task.HengamTask");
    }

    @NotNull
    public Scheduler getBackgroundScheduler() {
        return SchedulersKt.cpuThread();
    }
}

