/*
 * Decompiled with CFR 0.152.
 */
package io.hengam.lib;

import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import androidx.annotation.Nullable;
import com.google.firebase.messaging.RemoteMessage;
import io.hengam.lib.RegistrationManager;
import io.hengam.lib.a0;
import io.hengam.lib.b0;
import io.hengam.lib.dagger.CoreComponent;
import io.hengam.lib.internal.HengamDebug;
import io.hengam.lib.internal.HengamException;
import io.hengam.lib.internal.HengamInternals;
import io.hengam.lib.internal.HengamServiceApi;
import io.hengam.lib.internal.SchedulersKt;
import io.hengam.lib.messaging.fcm.FcmHandler;
import io.hengam.lib.w;
import io.hengam.lib.x;
import io.hengam.lib.y;
import io.hengam.lib.z;
import io.reactivex.Completable;
import io.reactivex.functions.Action;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kotlin.jvm.internal.Intrinsics;

public class Hengam {
    public static final String CORE = "core";
    public static final String NOTIFICATION = "notification";
    public static final String ANALYTICS = "analytics";
    public static final String DATALYTICS = "datalytics";
    public static final String LOG_COLLECTION = "log_collection";
    public static final String SENTRY = "sentry";
    public static Handler uiThreadHandler;

    public static boolean isRegistered() {
        Object object = Hengam.getCoreComponentOrFail("Checking Hengam registration failed");
        if (object == null) {
            return false;
        }
        object = object.registrationManager();
        return (Boolean)((RegistrationManager)object).a.getValue(object, RegistrationManager.k[0]);
    }

    public static boolean isInitialized() {
        CoreComponent coreComponent = Hengam.getCoreComponentOrFail(null);
        if (coreComponent == null) {
            return false;
        }
        return coreComponent.hengamLifecycle().isPostInitComplete();
    }

    public static void setRegistrationCompleteListener(Callback callback) {
        Callback callback2;
        CoreComponent coreComponent = Hengam.getCoreComponentOrFail("Setting Hengam registration listener failed");
        if (coreComponent == null) {
            return;
        }
        coreComponent.hengamLifecycle().waitForRegistration().subscribe(new Action(){

            public void run() {
                Hengam.runOnUiThread(callback2);
            }
        });
    }

    public static void setInitializationCompleteListener(Callback callback) {
        Callback callback2;
        CoreComponent coreComponent = Hengam.getCoreComponentOrFail(null);
        if (coreComponent == null) {
            return;
        }
        coreComponent.hengamLifecycle().waitForPostInit().subscribe(new Action(){

            public void run() {
                Hengam.runOnUiThread(callback2);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public static void subscribeToTopic(String topic, Callback callback) {
        void var1_1;
        String string;
        final CoreComponent coreComponent = Hengam.getCoreComponentOrFail("Subscribing to topic failed");
        if (coreComponent == null) {
            return;
        }
        coreComponent.hengamLifecycle().waitForPostInit().subscribe(new Action((Callback)var1_1){
            public final /* synthetic */ Callback c;
            {
                this.c = callback;
            }

            public void run() {
                coreComponent.topicManager().a(string, true).subscribe(new Action(){

                    public void run() {
                        Hengam.runOnUiThread(c);
                    }
                });
            }
        });
    }

    public static void subscribeToTopic(String topic) {
        Hengam.subscribeToTopic(topic, null);
    }

    /*
     * WARNING - void declaration
     */
    public static void addTags(Map<String, String> tags, Callback callback) {
        void var1_1;
        Map<String, String> map;
        final CoreComponent coreComponent = Hengam.getCoreComponentOrFail("Setting the tag failed");
        if (coreComponent == null) {
            return;
        }
        Iterator<String> iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().contains(" ")) continue;
            Log.w((String)"Hengam", (String)"Attempted to set an invalid tag key, Tag key must not be contain any space");
            return;
        }
        int n2 = coreComponent.tagManager().b.size();
        if (map.size() + n2 > 10) {
            Log.w((String)"Hengam", (String)"You can't subscribe a user to more that 10 tags.");
            return;
        }
        coreComponent.hengamLifecycle().waitForPostInit().subscribe(new Action((Callback)var1_1){
            public final /* synthetic */ Callback c;
            {
                this.c = callback;
            }

            public void run() {
                b0 b02 = coreComponent.tagManager();
                Map map2 = map;
                if (b02 != null) {
                    Intrinsics.checkParameterIsNotNull((Object)map2, (String)"tags");
                    Completable completable = Completable.fromCallable(new w(b02, map2)).subscribeOn(SchedulersKt.cpuThread()).observeOn(SchedulersKt.cpuThread()).doOnSubscribe(new x(map2)).doOnError(new y(map2)).doOnComplete((Action)new z(map2)).doOnComplete((Action)new a0(b02, map2));
                    Intrinsics.checkExpressionValueIsNotNull((Object)completable, (String)"Completable.fromCallable\u2026{ tagStore.putAll(tags) }");
                    completable.subscribe(new Action(){

                        public void run() {
                            Hengam.runOnUiThread(c);
                        }
                    });
                    return;
                }
                throw null;
            }
        });
    }

    public static void addTags(Map<String, String> tags) {
        Hengam.addTags(tags, null);
    }

    /*
     * WARNING - void declaration
     */
    public static void removeTags(List<String> tags, Callback callback) {
        void var1_1;
        List<String> list;
        final CoreComponent coreComponent = Hengam.getCoreComponentOrFail("Setting the tag failed");
        if (coreComponent == null) {
            return;
        }
        coreComponent.hengamLifecycle().waitForPostInit().subscribe(new Action((Callback)var1_1){
            public final /* synthetic */ Callback c;
            {
                this.c = callback;
            }

            public void run() {
                coreComponent.tagManager().a(list).subscribe(new Action(){

                    public void run() {
                        Hengam.runOnUiThread(c);
                    }
                });
            }
        });
    }

    public static void removeTags(List<String> tags) {
        Hengam.removeTags(tags, null);
    }

    public static Map<String, String> getSubscribedTags() {
        CoreComponent coreComponent = Hengam.getCoreComponentOrFail("Setting the tag failed");
        if (coreComponent == null) {
            return null;
        }
        try {
            return coreComponent.tagManager().b;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Deprecated
    public static void subscribe(String topic) {
        Hengam.subscribeToTopic(topic);
    }

    /*
     * WARNING - void declaration
     */
    public static void unsubscribeFromTopic(String topic, Callback callback) {
        void var1_1;
        String string;
        final CoreComponent coreComponent = Hengam.getCoreComponentOrFail("Unsubscribing from topic failed");
        if (coreComponent == null) {
            return;
        }
        coreComponent.hengamLifecycle().waitForPostInit().subscribe(new Action((Callback)var1_1){
            public final /* synthetic */ Callback c;
            {
                this.c = callback;
            }

            public void run() {
                coreComponent.topicManager().b(string, true).subscribe(new Action(){

                    public void run() {
                        Hengam.runOnUiThread(c);
                    }
                });
            }
        });
    }

    public static void unsubscribeFromTopic(String topic) {
        Hengam.unsubscribeFromTopic(topic, null);
    }

    public static List<String> getSubscribedTopics() {
        ArrayList<String> arrayList;
        CoreComponent coreComponent = Hengam.getCoreComponentOrFail(null);
        if (coreComponent == null) {
            return new ArrayList<String>();
        }
        Iterator<String> iterator = coreComponent.topicManager().b.iterator();
        ArrayList<String> arrayList2 = arrayList;
        arrayList = new ArrayList<String>();
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (!string.endsWith("_" + coreComponent.appManifest().appId)) continue;
            arrayList2.add(string.replace("_" + coreComponent.appManifest().appId, ""));
        }
        return arrayList2;
    }

    @Deprecated
    public static void unsubscribe(String topic) {
        Hengam.unsubscribeFromTopic(topic);
    }

    public static String getGoogleAdvertisingId() {
        CoreComponent coreComponent = Hengam.getCoreComponentOrFail("Getting Google Advertisement Id failed");
        if (coreComponent == null) {
            return null;
        }
        if (!Hengam.isInitialized()) {
            return null;
        }
        return coreComponent.deviceIdHelper().getAdvertisementId();
    }

    @Deprecated
    public static String getAndroidId() {
        CoreComponent coreComponent = Hengam.getCoreComponentOrFail("Getting Android Id failed");
        if (coreComponent == null) {
            return null;
        }
        return coreComponent.deviceIdHelper().getAndroidId();
    }

    public static String getDeviceId() {
        CoreComponent coreComponent = Hengam.getCoreComponentOrFail("Getting Device Id failed");
        if (coreComponent == null) {
            return null;
        }
        return coreComponent.deviceIdHelper().getAndroidId();
    }

    public static void setCustomId(@Nullable String id) {
        String string;
        CoreComponent coreComponent = Hengam.getCoreComponentOrFail("Setting Custom Id failed");
        if (coreComponent == null) {
            return;
        }
        if (string != null && !string.isEmpty()) {
            coreComponent.userCredentials().setCustomId(string);
        } else {
            coreComponent.userCredentials().setCustomId("");
        }
    }

    public static String getCustomId() {
        CoreComponent coreComponent = Hengam.getCoreComponentOrFail("Getting Custom Id failed");
        if (coreComponent == null) {
            return null;
        }
        return coreComponent.userCredentials().getCustomId();
    }

    public static boolean setUserEmail(@Nullable String email) {
        String string;
        CoreComponent coreComponent = Hengam.getCoreComponentOrFail("Setting user email failed");
        if (coreComponent == null) {
            return false;
        }
        if (string != null && !string.isEmpty()) {
            if (!Pattern.compile("^[A-Z0-9._%+-]+@[A-Z0-9.-]+\\.[A-Z]{2,6}$", 2).matcher(string.trim()).matches()) {
                Log.w((String)"Hengam", (String)("Attempted to set an invalid email address '" + string + "'. The email will not be set."));
                return false;
            }
            coreComponent.userCredentials().setEmail(string.trim());
            return true;
        }
        coreComponent.userCredentials().setEmail("");
        return true;
    }

    public static String getUserEmail() {
        CoreComponent coreComponent = Hengam.getCoreComponentOrFail("Getting user email failed");
        if (coreComponent == null) {
            return null;
        }
        return coreComponent.userCredentials().getEmail();
    }

    public static boolean setUserPhoneNumber(@Nullable String phoneNumber) {
        String string;
        CoreComponent coreComponent = Hengam.getCoreComponentOrFail("Settings user phone number failed");
        if (coreComponent == null) {
            return false;
        }
        if (string != null && !string.isEmpty()) {
            if (!Pattern.compile("^[0-9\u06f0-\u06f9+() ]+$", 2).matcher(string.trim()).matches()) {
                Log.w((String)"Hengam", (String)("Attempted to set an invalid phone number '" + string + "'. The phone number will not be set."));
                return false;
            }
            coreComponent.userCredentials().setPhoneNumber(string);
            return true;
        }
        coreComponent.userCredentials().setPhoneNumber("");
        return true;
    }

    public static String getUserPhoneNumber() {
        CoreComponent coreComponent = Hengam.getCoreComponentOrFail("Getting user phone number failed");
        if (coreComponent == null) {
            return null;
        }
        return coreComponent.userCredentials().getPhoneNumber();
    }

    @Deprecated
    public static String getHengamId() {
        CoreComponent coreComponent = Hengam.getCoreComponentOrFail("Getting Hengam Id failed");
        if (coreComponent == null) {
            return "";
        }
        return coreComponent.deviceIdHelper().getHengamId();
    }

    public static void initialize() {
        Hengam.getCoreComponentOrFail("Initialization failed").hengamPrivacy().setUserConsent(true);
    }

    public static void setUserConsentGiven() {
        Hengam.setUserConsentGiven(true);
    }

    public static void setUserConsentGiven(boolean enabled) {
        boolean bl;
        Hengam.getCoreComponentOrFail("Applying user consent failed").hengamPrivacy().setSpecialDataCollectionAllowed(bl);
    }

    public static boolean getUserConsentStatus() {
        return Hengam.getCoreComponentOrFail("Applying user consent failed").hengamPrivacy().getAppListConsentProvided();
    }

    @Nullable
    public static <T extends HengamServiceApi> T getHengamService(Class<T> serviceClass) {
        Class<T> clazz;
        T t2 = HengamInternals.INSTANCE.getService(clazz);
        if (t2 == null) {
            Log.e((String)"Hengam", (String)("The Hengam service " + clazz.getSimpleName() + " is not available. This either means you have provided an invalid Hengam Service name, Hengam was not initialized successfully or you have not added the Hengam service to your gradle dependencies."));
        }
        return t2;
    }

    @Nullable
    public static HengamServiceApi getHengamService(String serviceName) {
        String string;
        HengamServiceApi hengamServiceApi = HengamInternals.INSTANCE.getService(string);
        if (hengamServiceApi == null) {
            Log.e((String)"Hengam", (String)("The Hengam service " + string + " is not available. This either means you have provided an invalid Hengam Service name, Hengam was not initialized successfully or you have not added the Hengam service to your gradle dependencies."));
        }
        return hengamServiceApi;
    }

    public static HengamDebug debugApi() {
        return new HengamDebug();
    }

    public static FcmHandler getFcmHandler() {
        CoreComponent coreComponent = Hengam.getCoreComponentOrFail("Getting FcmHandler failed");
        if (coreComponent != null && coreComponent.hengamPrivacy().getUserConsentProvided()) {
            return coreComponent.fcmHandler();
        }
        return new FcmHandler(){

            @Override
            public boolean onMessageReceived(RemoteMessage remoteMessage) {
                String string = (String)remoteMessage.getData().get("courier");
                return string != null && string.toLowerCase().equals("pushe");
            }

            @Override
            public void onDeletedMessages() {
            }

            @Override
            public void onMessageSent(String string) {
            }

            @Override
            public void onSendError(String string, Exception exception) {
            }

            @Override
            public void onNewToken(String string) {
            }
        };
    }

    public static CoreComponent getCoreComponentOrFail(String failMessage) {
        String string;
        CoreComponent coreComponent = HengamInternals.INSTANCE.getComponent(CoreComponent.class);
        if (coreComponent == null && string != null && !string.isEmpty()) {
            HengamException hengamException;
            HengamException hengamException2 = hengamException;
            hengamException = new HengamException("Unable to obtain the Hengam core component. This probably means Hengam initialization has failed.");
            Log.e((String)"Hengam", (String)string, (Throwable)hengamException2);
        }
        return coreComponent;
    }

    public static void runOnUiThread(Runnable runnable) {
        Runnable runnable2;
        if (runnable == null) {
            return;
        }
        if (uiThreadHandler == null) {
            uiThreadHandler = new Handler(Looper.getMainLooper());
        }
        uiThreadHandler.post(runnable2);
    }

    public static void runOnUiThread(Callback callback) {
        Callback callback2;
        if (callback == null) {
            return;
        }
        Hengam.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                callback2.onComplete();
            }
        });
    }

    public static interface Callback {
        public void onComplete();
    }
}

