/*
 * Decompiled with CFR 0.152.
 */
package io.hengam.lib.internal.task;

import androidx.work.BackoffPolicy;
import androidx.work.Constraints;
import androidx.work.Data;
import androidx.work.ExistingPeriodicWorkPolicy;
import androidx.work.ExistingWorkPolicy;
import androidx.work.ListenableWorker;
import androidx.work.NetworkType;
import androidx.work.OneTimeWorkRequest;
import androidx.work.PeriodicWorkRequest;
import androidx.work.WorkManager;
import androidx.work.WorkRequest;
import io.hengam.lib.internal.HengamConfig;
import io.hengam.lib.internal.SchedulersKt;
import io.hengam.lib.internal.task.HengamTask;
import io.hengam.lib.internal.task.HengamTaskPerformer;
import io.hengam.lib.internal.task.OneTimeTaskOptions;
import io.hengam.lib.internal.task.PeriodicTaskOptions;
import io.hengam.lib.internal.task.StoredTaskInfo;
import io.hengam.lib.internal.task.TaskOptions;
import io.hengam.lib.internal.task.TaskScheduler;
import io.hengam.lib.utils.HengamStorage;
import io.hengam.lib.utils.PersistedList;
import io.hengam.lib.utils.PersistedMap;
import io.hengam.lib.utils.Time;
import io.hengam.lib.utils.TimeKt;
import io.hengam.lib.utils.log.Plog;
import io.hengam.lib.utils.rx.RxUtilsKt;
import io.reactivex.Single;
import io.reactivex.functions.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.full.KClasses;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 #2\u00020\u0001:\u0001#B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012J\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J$\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u00192\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002J\u001a\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u001f2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\u0019J\u0006\u0010!\u001a\u00020\u000eJ&\u0010\"\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u001b2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\u00192\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u001dR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lio/hengam/lib/internal/task/TaskScheduler;", "", "hengamConfig", "Lio/hengam/lib/internal/HengamConfig;", "hengamStorage", "Lio/hengam/lib/utils/HengamStorage;", "(Lio/hengam/lib/internal/HengamConfig;Lio/hengam/lib/utils/HengamStorage;)V", "oneTimeTasks", "Lio/hengam/lib/utils/PersistedList;", "Lio/hengam/lib/internal/task/StoredTaskInfo;", "periodicTaskIntervals", "Lio/hengam/lib/utils/PersistedMap;", "", "cancelTask", "", "taskOptions", "Lio/hengam/lib/internal/task/TaskOptions;", "taskId", "", "performTask", "Lio/reactivex/Single;", "Landroidx/work/ListenableWorker$Result;", "task", "Lio/hengam/lib/internal/task/HengamTask;", "inputData", "Landroidx/work/Data;", "scheduleOneTimeTask", "Lio/hengam/lib/internal/task/OneTimeTaskOptions;", "initialDelay", "Lio/hengam/lib/utils/Time;", "schedulePeriodicTask", "Lio/hengam/lib/internal/task/PeriodicTaskOptions;", "data", "scheduleStoredTasks", "scheduleTask", "Companion", "core_release"})
public final class TaskScheduler {
    private final PersistedList<StoredTaskInfo> oneTimeTasks;
    private final PersistedMap<Long> periodicTaskIntervals;
    private final HengamConfig hengamConfig;
    @NotNull
    public static final String DEFAULT_WORK_TAG = "hengam";
    public static final long ONE_TIME_TASK_FIRST_RETRY_DELAY = 30000L;
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    public final void scheduleTask(@NotNull OneTimeTaskOptions taskOptions, @Nullable Data data, @Nullable Time initialDelay) {
        void var1_1;
        void var3_4;
        String string;
        Object object;
        Object object2;
        Object object3;
        Intrinsics.checkParameterIsNotNull((Object)taskOptions, (String)"taskOptions");
        Plog.INSTANCE.trace("Task", "Executing one-time task: " + taskOptions.taskId(), new Pair[0]);
        taskOptions.setHengamConfig(this.hengamConfig);
        Data data2 = data;
        StoredTaskInfo storedTaskInfo = new StoredTaskInfo(taskOptions.existingWorkPolicy(), taskOptions.networkType(), taskOptions.task().getQualifiedName(), taskOptions.taskId(), taskOptions.maxAttemptsCount(), taskOptions.backoffDelay(), taskOptions.backoffPolicy(), data2 != null ? data2.getKeyValueMap() : null);
        this.oneTimeTasks.add(storedTaskInfo);
        if (data != null) {
            Map map = object3.getKeyValueMap();
            Intrinsics.checkExpressionValueIsNotNull((Object)map, (String)"data.keyValueMap");
            object = object2 = MapsKt.toMutableMap((Map)map);
            string = "%max_attempts_count";
            object3 = taskOptions.maxAttemptsCount();
            object.put(string, object3);
            object = object2;
            string = "%task_id";
            object3 = taskOptions.taskId();
            object.put(string, object3);
            object = object2;
            string = "%task_class_name";
            object3 = taskOptions.task().getQualifiedName();
            object.put(string, object3);
            Data data3 = new Data.Builder().putAll((Map)object2).build();
            Intrinsics.checkExpressionValueIsNotNull((Object)data3, (String)"Data.Builder().putAll(dataMap).build()");
            object3 = data3;
        } else {
            object2 = new Data.Builder[]{TuplesKt.to((Object)"%max_attempts_count", (Object)taskOptions.maxAttemptsCount()), TuplesKt.to((Object)"%task_id", (Object)taskOptions.taskId()), TuplesKt.to((Object)"%task_class_name", (Object)taskOptions.task().getQualifiedName())};
            object = new Data.Builder();
            string = object2;
            for (int i2 = 0; i2 < 3; ++i2) {
                object2 = string[i2];
                object.put((String)object2.getFirst(), object2.getSecond());
            }
            Data data4 = object.build();
            Intrinsics.checkExpressionValueIsNotNull((Object)data4, (String)"dataBuilder.build()");
            object3 = data4;
        }
        try {
            object = (HengamTask)KClasses.createInstance(taskOptions.task());
        }
        catch (Exception exception) {
            Plog.INSTANCE.error("Task", "Could not instantiate the performer class of oneTimeTask. It will be scheduled to run by WorkManager", (Throwable)exception, new Pair[]{TuplesKt.to((Object)"Task", (Object)taskOptions.taskId())});
            object = null;
        }
        object2 = object;
        if (object2 == null) {
            this.scheduleOneTimeTask(taskOptions, (Data)object3, initialDelay);
            this.oneTimeTasks.remove(storedTaskInfo);
            return;
        }
        void v4 = var3_4;
        Single single = this.performTask((HengamTask)object2, (Data)object3).subscribeOn(SchedulersKt.cpuThread()).delaySubscription(v4 != null ? v4.getTime() : 0L, TimeUnit.MILLISECONDS);
        Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"performTask(performer, i\u2026L, TimeUnit.MILLISECONDS)");
        RxUtilsKt.justDo((Single)single, (String[])new String[]{"Task"}, (Function1)((Function1)new Function1<ListenableWorker.Result, Unit>(this, (OneTimeTaskOptions)var1_1, (Data)object3, storedTaskInfo){
            final /* synthetic */ TaskScheduler this$0;
            final /* synthetic */ OneTimeTaskOptions $taskOptions;
            final /* synthetic */ Data $inputData;
            final /* synthetic */ StoredTaskInfo $taskInfo;

            public final void invoke(ListenableWorker.Result result) {
                String string;
                if (Intrinsics.areEqual((Object)result, (Object)ListenableWorker.Result.retry())) {
                    Plog.INSTANCE.trace("Task", "Failure trying to run one-time task. Scheduling the task to be run by workManager", new Pair[]{TuplesKt.to((Object)"Task Id", (Object)this.$taskOptions.taskId())});
                    TaskScheduler.access$scheduleOneTimeTask(this.this$0, this.$taskOptions, this.$inputData, TimeKt.millis((long)30000L));
                    TaskScheduler.access$getOneTimeTasks$p(this.this$0).remove(this.$taskInfo);
                    return;
                }
                string = string instanceof ListenableWorker.Result.Failure ? "Failure" : (string instanceof ListenableWorker.Result.Success ? "Success" : "Unknown");
                Plog.INSTANCE.trace("Task", "Task finished with result ".concat(String.valueOf(string)), new Pair[]{TuplesKt.to((Object)"Task Id", (Object)this.$taskOptions.taskId())});
                TaskScheduler.access$getOneTimeTasks$p(this.this$0).remove(this.$taskInfo);
            }
            {
                this.this$0 = taskScheduler;
                this.$taskOptions = oneTimeTaskOptions;
                this.$inputData = data;
                this.$taskInfo = storedTaskInfo;
                super(1);
            }
        }));
    }

    public static /* synthetic */ void scheduleTask$default(TaskScheduler taskScheduler, OneTimeTaskOptions oneTimeTaskOptions, Data data, Time time, int n2, Object object) {
        if ((n2 & 2) != 0) {
            data = null;
        }
        if ((n2 & 4) != 0) {
            time = null;
        }
        taskScheduler.scheduleTask(oneTimeTaskOptions, data, time);
    }

    /*
     * WARNING - void declaration
     */
    private final Single<ListenableWorker.Result> performTask(HengamTask task, Data inputData) {
        void var2_2;
        Single single = task.perform((Data)var2_2).onErrorReturn((Function)performTask.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"task.perform(inputData)\n\u2026ult.retry()\n            }");
        return single;
    }

    /*
     * WARNING - void declaration
     */
    private final void scheduleOneTimeTask(OneTimeTaskOptions taskOptions, Data inputData, Time initialDelay) {
        void var1_1;
        String string;
        BackoffPolicy backoffPolicy;
        String string2;
        Plog.INSTANCE.trace("Task", "Scheduling one-time task", new Pair[]{TuplesKt.to((Object)"Task Id", (Object)inputData.getString("%task_id"))});
        taskOptions.setHengamConfig(this.hengamConfig);
        Constraints constraints = new Constraints.Builder().setRequiredNetworkType(taskOptions.networkType()).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)constraints, (String)"Constraints.Builder()\n  \u2026e())\n            .build()");
        Constraints constraints2 = constraints;
        OneTimeWorkRequest.Builder builder = (OneTimeWorkRequest.Builder)new OneTimeWorkRequest.Builder(HengamTaskPerformer.class).addTag(DEFAULT_WORK_TAG);
        String string3 = taskOptions.taskId();
        if (string3 == null) {
            string3 = string2 = taskOptions.task().getQualifiedName();
        }
        if (string3 == null) {
            string2 = "";
        }
        WorkRequest.Builder builder2 = ((OneTimeWorkRequest.Builder)builder.addTag(string2)).setConstraints(constraints2);
        Intrinsics.checkExpressionValueIsNotNull((Object)builder2, (String)"OneTimeWorkRequest.Build\u2026tConstraints(constraints)");
        constraints2 = (OneTimeWorkRequest.Builder)builder2;
        if (initialDelay != null) {
            constraints2.setInitialDelay(backoffPolicy.toSeconds(), TimeUnit.SECONDS);
        }
        backoffPolicy = taskOptions.backoffPolicy();
        Time time = taskOptions.backoffDelay();
        if (backoffPolicy != null || time != null) {
            BackoffPolicy backoffPolicy2 = backoffPolicy;
            if (backoffPolicy2 == null) {
                backoffPolicy2 = BackoffPolicy.EXPONENTIAL;
            }
            Time time2 = time;
            constraints2.setBackoffCriteria(backoffPolicy2, time2 != null ? time2.toMillis() : 30000L, TimeUnit.MILLISECONDS);
        }
        constraints2.setInputData((Data)string);
        string = taskOptions.taskId();
        if (string == null) {
            WorkManager.getInstance().enqueue(constraints2.build());
            return;
        }
        WorkManager workManager = WorkManager.getInstance();
        ExistingWorkPolicy existingWorkPolicy = var1_1.existingWorkPolicy();
        if (existingWorkPolicy == null) {
            existingWorkPolicy = ExistingWorkPolicy.KEEP;
        }
        workManager.beginUniqueWork(string, existingWorkPolicy, (OneTimeWorkRequest)constraints2.build()).enqueue();
    }

    static /* synthetic */ void scheduleOneTimeTask$default(TaskScheduler taskScheduler, OneTimeTaskOptions oneTimeTaskOptions, Data data, Time time, int n2, Object object) {
        if ((n2 & 4) != 0) {
            time = null;
        }
        taskScheduler.scheduleOneTimeTask(oneTimeTaskOptions, data, time);
    }

    /*
     * WARNING - void declaration
     */
    public final void schedulePeriodicTask(@NotNull PeriodicTaskOptions taskOptions, @Nullable Data data) {
        ExistingPeriodicWorkPolicy existingPeriodicWorkPolicy;
        Object object;
        Object object2;
        Data data2;
        Intrinsics.checkParameterIsNotNull((Object)taskOptions, (String)"taskOptions");
        taskOptions.setHengamConfig(this.hengamConfig);
        String string = taskOptions.taskId();
        Constraints constraints = new Constraints.Builder().setRequiredNetworkType(taskOptions.networkType()).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)constraints, (String)"Constraints.Builder()\n  \u2026\n                .build()");
        Constraints constraints2 = constraints;
        WorkRequest.Builder builder = ((PeriodicWorkRequest.Builder)((PeriodicWorkRequest.Builder)new PeriodicWorkRequest.Builder(HengamTaskPerformer.class, taskOptions.repeatInterval().getTime(), taskOptions.repeatInterval().getTimeUnit()).addTag(DEFAULT_WORK_TAG)).addTag(taskOptions.taskId())).setConstraints(constraints2);
        Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"PeriodicWorkRequest.Buil\u2026tConstraints(constraints)");
        constraints2 = (PeriodicWorkRequest.Builder)builder;
        Object object3 = taskOptions.backoffPolicy();
        Object object4 = taskOptions.backoffDelay();
        if (object3 != null || object4 != null) {
            Object object5 = object3;
            if (object5 == null) {
                object5 = BackoffPolicy.EXPONENTIAL;
            }
            Time time = object4;
            constraints2.setBackoffCriteria(object5, time != null ? time.toMillis() : 30000L, TimeUnit.MILLISECONDS);
        }
        if (data != null) {
            Map map = data2.getKeyValueMap();
            Intrinsics.checkExpressionValueIsNotNull((Object)map, (String)"data.keyValueMap");
            data2 = MapsKt.toMutableMap((Map)map);
            object3 = data2;
            object2 = "%max_attempts_count";
            Object object6 = taskOptions.maxAttemptsCount();
            object3.put(object2, object6);
            object3 = data2;
            object2 = "%task_id";
            object6 = taskOptions.taskId();
            object3.put(object2, object6);
            object3 = data2;
            object2 = "%task_repeat_interval";
            object6 = taskOptions.repeatInterval().toMillis();
            object3.put(object2, object6);
            object3 = data2;
            object2 = "%task_flexibility_time";
            object6 = taskOptions.flexibilityTime().toMillis();
            object3.put(object2, object6);
            object3 = data2;
            object2 = "%task_class_name";
            object6 = taskOptions.task().getQualifiedName();
            object3.put(object2, object6);
            constraints2.setInputData(new Data.Builder().putAll((Map)data2).build());
        } else {
            data2 = new Data[]{TuplesKt.to((Object)"%max_attempts_count", (Object)taskOptions.maxAttemptsCount()), TuplesKt.to((Object)"%task_id", (Object)taskOptions.taskId()), TuplesKt.to((Object)"%task_repeat_interval", (Object)taskOptions.repeatInterval().toMillis()), TuplesKt.to((Object)"%task_flexibility_time", (Object)taskOptions.flexibilityTime().toMillis()), TuplesKt.to((Object)"%task_class_name", (Object)taskOptions.task().getQualifiedName())};
            Constraints constraints3 = constraints2;
            object3 = new Data.Builder();
            object2 = data2;
            for (int i2 = 0; i2 < 5; ++i2) {
                object = object2[i2];
                object3.put((String)object.getFirst(), object.getSecond());
            }
            Data data3 = object3.build();
            Intrinsics.checkExpressionValueIsNotNull((Object)data3, (String)"dataBuilder.build()");
            data2 = data3;
            constraints3.setInputData(data2);
        }
        if ((existingPeriodicWorkPolicy = taskOptions.existingWorkPolicy()) == null) {
            existingPeriodicWorkPolicy = data2 = ExistingPeriodicWorkPolicy.KEEP;
        }
        if (existingPeriodicWorkPolicy == ExistingPeriodicWorkPolicy.KEEP) {
            void var1_1;
            object3 = (Long)this.periodicTaskIntervals.get(string);
            long l2 = var1_1.repeatInterval().toMillis();
            if (object3 == null || (Long)object3 != l2) {
                object4 = this.periodicTaskIntervals;
                object = l2;
                object4.put(string, object);
            }
            if (object3 != null && (Long)object3 != l2) {
                data2 = ExistingPeriodicWorkPolicy.REPLACE;
                Plog.INSTANCE.debug("Task", "Updated repeat interval for task ".concat(String.valueOf(string)), new Pair[]{TuplesKt.to((Object)"Old Interval", (Object)TimeKt.millis((long)((Long)object3)).bestRepresentation()), TuplesKt.to((Object)"New Interval", (Object)TimeKt.millis((long)l2).bestRepresentation())});
            }
        }
        WorkManager.getInstance().enqueueUniquePeriodicWork(string, (ExistingPeriodicWorkPolicy)data2, (PeriodicWorkRequest)constraints2.build());
    }

    public static /* synthetic */ void schedulePeriodicTask$default(TaskScheduler taskScheduler, PeriodicTaskOptions periodicTaskOptions, Data data, int n2, Object object) {
        if ((n2 & 2) != 0) {
            data = null;
        }
        taskScheduler.schedulePeriodicTask(periodicTaskOptions, data);
    }

    /*
     * WARNING - void declaration
     */
    public final void cancelTask(@NotNull String taskId) {
        void var1_1;
        Intrinsics.checkParameterIsNotNull((Object)taskId, (String)"taskId");
        WorkManager.getInstance().cancelUniqueWork((String)var1_1);
    }

    public final void cancelTask(@NotNull TaskOptions taskOptions) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)taskOptions, (String)"taskOptions");
        string = ((TaskOptions)((Object)string)).taskId();
        if (string == null) {
            Plog.INSTANCE.warn("Task", "Cannot cancel task with no id", new Pair[0]);
            return;
        }
        WorkManager.getInstance().cancelUniqueWork(string);
    }

    public final void scheduleStoredTasks() {
        Object object = new ArrayList();
        object.addAll((Collection)this.oneTimeTasks);
        this.oneTimeTasks.clear();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            object = (StoredTaskInfo)iterator.next();
            if (((StoredTaskInfo)object).getTaskClassName() == null) continue;
            Class<?> clazz = Class.forName(((StoredTaskInfo)object).getTaskClassName());
            Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"Class.forName(task.taskClassName)");
            if (!KClasses.isSubclassOf((KClass)JvmClassMappingKt.getKotlinClass(clazz), (KClass)Reflection.getOrCreateKotlinClass(HengamTask.class))) continue;
            Object object2 = this;
            OneTimeTaskOptions oneTimeTaskOptions = new OneTimeTaskOptions((StoredTaskInfo)object){
                final /* synthetic */ StoredTaskInfo $task;

                @NotNull
                public final NetworkType networkType() {
                    return this.$task.getNetworkType();
                }

                @NotNull
                public final KClass<? extends HengamTask> task() {
                    Class<?> clazz = Class.forName(this.$task.getTaskClassName());
                    Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"Class.forName(task.taskClassName)");
                    KClass kClass = JvmClassMappingKt.getKotlinClass(clazz);
                    if (kClass == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.reflect.KClass<out io.hengam.lib.internal.task.HengamTask>");
                    }
                    return kClass;
                }

                @Nullable
                public final ExistingWorkPolicy existingWorkPolicy() {
                    return this.$task.getExistingWorkPolicy();
                }

                @Nullable
                public final String taskId() {
                    return this.$task.getTaskId();
                }

                public final int maxAttemptsCount() {
                    return this.$task.getMaxAttemptsCount();
                }

                @Nullable
                public final Time backoffDelay() {
                    return this.$task.getBackoffDelay();
                }

                @Nullable
                public final BackoffPolicy backoffPolicy() {
                    return this.$task.getBackoffPolicy();
                }
                {
                    void var1_1;
                    this.$task = var1_1;
                }
            };
            Data.Builder builder = new Data.Builder();
            Map map = ((StoredTaskInfo)object).getInputData();
            if (map == null) {
                Data.Builder builder2 = builder;
                OneTimeTaskOptions oneTimeTaskOptions2 = oneTimeTaskOptions;
                object = object2;
                Map map2 = new LinkedHashMap();
                object2 = object;
                oneTimeTaskOptions = oneTimeTaskOptions2;
                builder = builder2;
                map = map2;
            }
            TaskScheduler.scheduleTask$default((TaskScheduler)object2, oneTimeTaskOptions, builder.putAll(map).build(), null, 4, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Inject
    public TaskScheduler(@NotNull HengamConfig hengamConfig, @NotNull HengamStorage hengamStorage) {
        void var2_2;
        void var1_1;
        Intrinsics.checkParameterIsNotNull((Object)hengamConfig, (String)"hengamConfig");
        Intrinsics.checkParameterIsNotNull((Object)hengamStorage, (String)"hengamStorage");
        this.hengamConfig = var1_1;
        this.oneTimeTasks = HengamStorage.createStoredList$default(hengamStorage, "onetime_tasks", StoredTaskInfo.class, null, 4, null);
        this.periodicTaskIntervals = HengamStorage.createStoredMap$default((HengamStorage)var2_2, "periodic_task_intervals", Long.class, null, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$scheduleOneTimeTask(TaskScheduler $this, OneTimeTaskOptions taskOptions, Data inputData, Time initialDelay) {
        void var3_3;
        void var2_2;
        void var1_1;
        $this.scheduleOneTimeTask((OneTimeTaskOptions)var1_1, (Data)var2_2, (Time)var3_3);
    }

    public static final /* synthetic */ PersistedList access$getOneTimeTasks$p(TaskScheduler $this) {
        return $this.oneTimeTasks;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/hengam/lib/internal/task/TaskScheduler$Companion;", "", "()V", "DEFAULT_WORK_TAG", "", "ONE_TIME_TASK_FIRST_RETRY_DELAY", "", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

