/*
 * Decompiled with CFR 0.152.
 */
package io.hengam.lib.utils.moshi;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonDataException;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.Types;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.jvm.functions.Function1;

public final class RuntimeJsonAdapterFactory<T>
implements JsonAdapter.Factory {
    private final Class<T> baseType;
    private final String labelKey;
    private final Map<String, Type> labelToType = new LinkedHashMap<String, Type>();
    private final Map<Type, String> typeToLabel = new LinkedHashMap<Type, String>();
    private final Map<Type, Function1<Moshi, JsonAdapter<? extends T>>> typeToAdapterProvider = new LinkedHashMap<Type, Function1<Moshi, JsonAdapter<? extends T>>>();
    private Function1<Moshi, JsonAdapter<? extends T>> defaultAdapterProvider;
    private T fallbackValue;

    /*
     * WARNING - void declaration
     */
    public static <T> RuntimeJsonAdapterFactory<T> of(Class<T> baseType, String labelKey) {
        void var1_1;
        Class<T> clazz;
        if (baseType == null) {
            throw new NullPointerException("baseType == null");
        }
        if (labelKey == null) {
            throw new NullPointerException("labelKey == null");
        }
        return new RuntimeJsonAdapterFactory<T>(clazz, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    RuntimeJsonAdapterFactory(Class<T> baseType, String labelKey) {
        void var2_2;
        void var1_1;
        this.baseType = var1_1;
        this.labelKey = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final RuntimeJsonAdapterFactory<T> registerSubtype(String label, Class<? extends T> subtype, Function1<Moshi, JsonAdapter<? extends T>> adapterProvider) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (subtype == null) {
            throw new NullPointerException("subtype == null");
        }
        if (label == null) {
            throw new NullPointerException("label == null");
        }
        if (this.labelToType.containsKey(label) || this.labelToType.containsValue(subtype)) {
            throw new IllegalArgumentException("Subtypes and labels must be unique.");
        }
        this.labelToType.put(label, subtype);
        this.typeToLabel.put(subtype, (String)var1_1);
        this.typeToAdapterProvider.put((Type)var2_2, (Function1<Moshi, JsonAdapter<T>>)var3_3);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final RuntimeJsonAdapterFactory<T> registerDefault(Function1<Moshi, JsonAdapter<? extends T>> adapterProvider) {
        void var1_1;
        this.defaultAdapterProvider = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final RuntimeJsonAdapterFactory<T> setFallbackValueOnError(T fallbackValue) {
        void var1_1;
        this.fallbackValue = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final RuntimeJsonAdapterFactory<T> registerSubtype(String label, Class<? extends T> subtype) {
        void var2_2;
        void var1_1;
        return this.registerSubtype((String)var1_1, (Class<? extends T>)var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    public final JsonAdapter<?> create(Type type, Set<? extends Annotation> annotations, Moshi moshi) {
        void var6_12;
        void var2_2;
        if (Types.getRawType((Type)type) != this.baseType || !var2_2.isEmpty()) {
            return null;
        }
        int n2 = this.labelToType.size();
        LinkedHashMap<Type, JsonAdapter<Object>> linkedHashMap = new LinkedHashMap<Type, JsonAdapter<Object>>(n2);
        LinkedHashMap<String, JsonAdapter<Object>> linkedHashMap2 = new LinkedHashMap<String, JsonAdapter<Object>>(n2);
        for (Map.Entry<String, Type> entry : this.labelToType.entrySet()) {
            String string = entry.getKey();
            Type object2 = entry.getValue();
            JsonAdapter jsonAdapter = this.typeToAdapterProvider.get(type);
            jsonAdapter = jsonAdapter == null ? moshi.adapter(object2) : (JsonAdapter)jsonAdapter.invoke((Object)moshi);
            linkedHashMap2.put(string, (JsonAdapter<Object>)jsonAdapter);
            linkedHashMap.put(object2, (JsonAdapter<Object>)jsonAdapter);
        }
        JsonAdapter jsonAdapter = moshi.adapter(Object.class);
        Object var6_10 = null;
        if (this.defaultAdapterProvider != null) {
            void var3_5;
            JsonAdapter jsonAdapter2 = (JsonAdapter)this.defaultAdapterProvider.invoke((Object)var3_5);
        }
        return new RuntimeJsonAdapter(this.labelKey, linkedHashMap2, linkedHashMap, this.typeToLabel, (JsonAdapter<Object>)jsonAdapter, (JsonAdapter<Object>)var6_12, this.fallbackValue).nullSafe();
    }

    static final class RuntimeJsonAdapter
    extends JsonAdapter<Object> {
        final String labelKey;
        final Map<String, JsonAdapter<Object>> labelToAdapter;
        final Map<Type, JsonAdapter<Object>> typeToAdapter;
        final Map<Type, String> typeToLabel;
        final JsonAdapter<Object> anyAdapter;
        final JsonAdapter<Object> defaultAdapter;
        final Object fallbackValue;

        /*
         * WARNING - void declaration
         */
        RuntimeJsonAdapter(String labelKey, Map<String, JsonAdapter<Object>> labelToAdapter, Map<Type, JsonAdapter<Object>> typeToAdapter, Map<Type, String> typeToLabel, JsonAdapter<Object> anyAdapter, JsonAdapter<Object> defaultAdapter, Object fallbackValue) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.labelKey = var1_1;
            this.labelToAdapter = var2_2;
            this.typeToAdapter = var3_3;
            this.typeToLabel = typeToLabel;
            this.anyAdapter = anyAdapter;
            this.defaultAdapter = defaultAdapter;
            this.fallbackValue = fallbackValue;
        }

        public final Object fromJson(JsonReader reader) {
            Object object = reader.peek();
            try {
                Object object2;
                if (object != JsonReader.Token.BEGIN_OBJECT) {
                    throw new JsonDataException("Expected BEGIN_OBJECT but was " + object + " at path " + reader.getPath());
                }
                object = ((Map)(object2 = object2.readJsonValue())).get(this.labelKey);
                if (object == null) {
                    throw new JsonDataException("Missing label for " + this.labelKey);
                }
                if (!(object instanceof String)) {
                    throw new JsonDataException("Label for '" + this.labelKey + "' must be a string but was " + object + ", a " + object.getClass());
                }
                JsonAdapter<Object> jsonAdapter = this.labelToAdapter.get(object);
                if (jsonAdapter == null) {
                    jsonAdapter = this.defaultAdapter;
                }
                if (jsonAdapter == null) {
                    throw new JsonDataException("Expected one of " + this.labelToAdapter.keySet() + " for key '" + this.labelKey + "' but found '" + object + "'. Register a subtype for this label.");
                }
                return jsonAdapter.fromJsonValue(object2);
            }
            catch (JsonDataException jsonDataException) {
                if (this.fallbackValue != null) {
                    return this.fallbackValue;
                }
                throw jsonDataException;
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void toJson(JsonWriter writer, Object value) {
            void var1_1;
            Map map;
            Class<?> clazz = value.getClass();
            Object object2 = this.typeToAdapter.get(clazz);
            if (object2 == null && this.defaultAdapter != null) {
                object2 = this.defaultAdapter;
            }
            if (object2 == null) {
                throw new IllegalArgumentException("Expected one of " + this.typeToAdapter.keySet() + " but found " + value + ", a " + value.getClass() + ". Register this subtype.");
            }
            writer.beginObject();
            writer.name(this.labelKey).value(this.typeToLabel.get(clazz));
            map = (Map)object2.toJsonValue((Object)map);
            for (Object object2 : map.keySet()) {
                if (object2.equals(this.labelKey)) continue;
                writer.name(object2);
                this.anyAdapter.toJson(writer, map.get(object2));
            }
            var1_1.endObject();
        }

        public final String toString() {
            return "RuntimeJsonAdapter(" + this.labelKey + ")";
        }
    }
}

