/*
 * Decompiled with CFR 0.152.
 */
package io.hengam.lib.tasks;

import androidx.work.Data;
import androidx.work.ExistingPeriodicWorkPolicy;
import androidx.work.ListenableWorker;
import androidx.work.NetworkType;
import io.hengam.lib.dagger.CoreComponent;
import io.hengam.lib.internal.ComponentNotAvailableException;
import io.hengam.lib.internal.HengamConfig;
import io.hengam.lib.internal.HengamInternals;
import io.hengam.lib.internal.task.HengamTask;
import io.hengam.lib.internal.task.PeriodicTaskOptions;
import io.hengam.lib.internal.task.TaskScheduler;
import io.hengam.lib.tasks.UpstreamSenderTask;
import io.hengam.lib.utils.Time;
import io.hengam.lib.utils.TimeKt;
import io.hengam.lib.utils.log.Plog;
import io.reactivex.Single;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lio/hengam/lib/tasks/UpstreamFlushTask;", "Lio/hengam/lib/internal/task/HengamTask;", "()V", "perform", "Lio/reactivex/Single;", "Landroidx/work/ListenableWorker$Result;", "inputData", "Landroidx/work/Data;", "Options", "core_release"})
public final class UpstreamFlushTask
extends HengamTask {
    @Override
    @NotNull
    public final Single<ListenableWorker.Result> perform(@NotNull Data inputData) {
        Intrinsics.checkParameterIsNotNull((Object)inputData, (String)"inputData");
        CoreComponent coreComponent = HengamInternals.INSTANCE.getComponent(CoreComponent.class);
        if (coreComponent == null) {
            throw (Throwable)new ComponentNotAvailableException("core");
        }
        CoreComponent coreComponent2 = coreComponent;
        Plog.INSTANCE.debug("Messaging", "Flushing upstream messages", new Pair[0]);
        TaskScheduler.scheduleTask$default(coreComponent2.taskScheduler(), UpstreamSenderTask.a.a, null, null, 6, null);
        Single single = Single.just((Object)ListenableWorker.Result.success());
        Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"Single.just(ListenableWorker.Result.success())");
        return single;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0016J\n\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0004H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u0004H\u0016J\u0010\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\fH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lio/hengam/lib/tasks/UpstreamFlushTask$Options;", "Lio/hengam/lib/internal/task/PeriodicTaskOptions;", "()V", "backoffDelay", "Lio/hengam/lib/utils/Time;", "existingWorkPolicy", "Landroidx/work/ExistingPeriodicWorkPolicy;", "flexibilityTime", "networkType", "Landroidx/work/NetworkType;", "repeatInterval", "task", "Lkotlin/reflect/KClass;", "Lio/hengam/lib/internal/task/HengamTask;", "taskId", "", "core_release"})
    public static final class a
    extends PeriodicTaskOptions {
        @Override
        @NotNull
        public final NetworkType networkType() {
            return NetworkType.CONNECTED;
        }

        @Override
        @NotNull
        public final KClass<? extends HengamTask> task() {
            return Reflection.getOrCreateKotlinClass(UpstreamFlushTask.class);
        }

        @Override
        @NotNull
        public final Time repeatInterval() {
            Object object = this.getHengamConfig();
            Intrinsics.checkParameterIsNotNull((Object)object, (String)"receiver$0");
            object = ((HengamConfig)object).getLong("upstream_flush_interval", -1L);
            Object object2 = ((Number)object).longValue() >= 0L ? object : null;
            if (object2 == null || (object2 = TimeKt.millis((long)((Number)object2).longValue())) == null) {
                object2 = TimeKt.days((long)1L);
            }
            return object2;
        }

        @Override
        @NotNull
        public final String taskId() {
            return "hengam_upstream_flush";
        }

        @Override
        @Nullable
        public final ExistingPeriodicWorkPolicy existingWorkPolicy() {
            return ExistingPeriodicWorkPolicy.KEEP;
        }

        @Override
        @Nullable
        public final Time backoffDelay() {
            return TimeKt.seconds((long)30L);
        }

        @Override
        @NotNull
        public final Time flexibilityTime() {
            return TimeKt.hours((long)2L);
        }
    }
}

