/*
 * Decompiled with CFR 0.152.
 */
package io.hengam.lib;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.firebase.messaging.RemoteMessage;
import io.hengam.lib.dagger.CoreComponent;
import io.hengam.lib.internal.HengamDebug;
import io.hengam.lib.internal.HengamException;
import io.hengam.lib.internal.HengamInternals;
import io.hengam.lib.internal.HengamServiceApi;
import io.hengam.lib.internal.SchedulersKt;
import io.hengam.lib.j;
import io.hengam.lib.messages.upstream.TagSubscriptionMessage;
import io.hengam.lib.messaging.PostOffice;
import io.hengam.lib.messaging.fcm.FcmHandler;
import io.hengam.lib.utils.log.Plog;
import io.reactivex.Completable;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;

public class Hengam {
    public static final String CORE = "core";
    public static final String NOTIFICATION = "notification";
    public static final String ANALYTICS = "analytics";
    public static final String DATALYTICS = "datalytics";
    public static final String LOG_COLLECTION = "log_collection";
    private static Handler uiThreadHandler = null;

    @Deprecated
    public static void initialize() {
    }

    public static boolean isRegistered() {
        CoreComponent coreComponent = Hengam.getCoreComponentOrFail("Checking Hengam registration failed");
        if (coreComponent == null) {
            return false;
        }
        return coreComponent.registrationManager().a();
    }

    public static boolean isInitialized() {
        CoreComponent coreComponent = Hengam.getCoreComponentOrFail(null);
        if (coreComponent == null) {
            return false;
        }
        return coreComponent.hengamLifecycle().isPostInitComplete();
    }

    public static void setRegistrationCompleteListener(Callback callback) {
        Callback callback2;
        CoreComponent coreComponent = Hengam.getCoreComponentOrFail("Setting Hengam registration listener failed");
        if (coreComponent == null) {
            return;
        }
        coreComponent.hengamLifecycle().waitForRegistration().subscribe(new Action(){

            public final void run() {
                Hengam.runOnUiThread(callback2);
            }
        });
    }

    public static void setInitializationCompleteListener(Callback callback) {
        Callback callback2;
        CoreComponent coreComponent = Hengam.getCoreComponentOrFail(null);
        if (coreComponent == null) {
            return;
        }
        coreComponent.hengamLifecycle().waitForPostInit().subscribe(new Action(){

            public final void run() {
                Hengam.runOnUiThread(callback2);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public static void subscribeToTopic(String topic, Callback callback) {
        void var1_1;
        String string;
        final CoreComponent coreComponent = Hengam.getCoreComponentOrFail("Subscribing to topic failed");
        if (coreComponent == null) {
            return;
        }
        coreComponent.hengamLifecycle().waitForPostInit().subscribe(new Action((Callback)var1_1){
            final /* synthetic */ Callback c;
            {
                this.c = callback;
            }

            public final void run() {
                coreComponent.topicManager().a(string, true).subscribe(new Action(){

                    public final void run() {
                        Hengam.runOnUiThread(c);
                    }
                });
            }
        });
    }

    public static void subscribeToTopic(String topic) {
        Hengam.subscribeToTopic(topic, null);
    }

    /*
     * WARNING - void declaration
     */
    public static void addTags(Map<String, String> tags, Callback callback) {
        void var1_1;
        Map<String, String> map;
        final CoreComponent coreComponent = Hengam.getCoreComponentOrFail("Setting the tag failed");
        if (coreComponent == null) {
            return;
        }
        int n2 = coreComponent.tagManager().b.size();
        if (tags.size() + n2 > 10) {
            Log.w((String)"Hengam", (String)"You can't subscribe a user to more that 10 tags.");
            return;
        }
        coreComponent.hengamLifecycle().waitForPostInit().subscribe(new Action((Callback)var1_1){
            final /* synthetic */ Callback c;
            {
                this.c = callback;
            }

            public final void run() {
                Map map2 = map;
                j j2 = coreComponent.tagManager();
                Intrinsics.checkParameterIsNotNull((Object)map2, (String)"tags");
                Completable completable = Completable.fromCallable((Callable)new Callable<Object>(j2, map2){
                    final /* synthetic */ j a;
                    final /* synthetic */ Map b;

                    public final /* synthetic */ Object call() {
                        j.a a2 = this;
                        PostOffice.sendMessage$default(a2.a.c, new TagSubscriptionMessage(a2.b, null, 2), null, false, false, null, null, 62, null);
                        return Unit.INSTANCE;
                    }
                    {
                        this.a = j2;
                        this.b = map;
                    }
                }).subscribeOn(SchedulersKt.cpuThread()).observeOn(SchedulersKt.cpuThread()).doOnSubscribe((Consumer)new Consumer<Disposable>(map2){
                    final /* synthetic */ Map a;

                    public final /* synthetic */ void accept(Object object) {
                        object = this;
                        Plog.INSTANCE.debug("Tag", "Subscribing to tags " + object.a, new Pair[0]);
                    }
                    {
                        this.a = map;
                    }
                }).doOnError((Consumer)new Consumer<Throwable>(map2){
                    final /* synthetic */ Map a;

                    public final /* synthetic */ void accept(Object object) {
                        Throwable throwable = (Throwable)object;
                        object = this;
                        Plog.INSTANCE.error("Tag", "Subscribing to tags failed", throwable, new Pair[]{TuplesKt.to((Object)"Tags", (Object)object.a)});
                    }
                    {
                        this.a = map;
                    }
                }).doOnComplete(new Action(map2){
                    final /* synthetic */ Map a;

                    public final void run() {
                        Plog.INSTANCE.info("Tag", "Successfully subscribed to tags " + this.a, new Pair[0]);
                    }
                    {
                        this.a = map;
                    }
                }).doOnComplete(new Action(j2, map2){
                    final /* synthetic */ j a;
                    final /* synthetic */ Map b;

                    public final void run() {
                        this.a.a.putAll(this.b);
                    }
                    {
                        this.a = j2;
                        this.b = map;
                    }
                });
                Intrinsics.checkExpressionValueIsNotNull((Object)completable, (String)"Completable.fromCallable\u2026{ tagStore.putAll(tags) }");
                completable.subscribe(new Action(){

                    public final void run() {
                        Hengam.runOnUiThread(c);
                    }
                });
            }
        });
    }

    public static void addTags(Map<String, String> tags) {
        Hengam.addTags(tags, null);
    }

    /*
     * WARNING - void declaration
     */
    public static void removeTags(List<String> tags, Callback callback) {
        void var1_1;
        List<String> list;
        final CoreComponent coreComponent = Hengam.getCoreComponentOrFail("Setting the tag failed");
        if (coreComponent == null) {
            return;
        }
        coreComponent.hengamLifecycle().waitForPostInit().subscribe(new Action((Callback)var1_1){
            final /* synthetic */ Callback c;
            {
                this.c = callback;
            }

            public final void run() {
                coreComponent.tagManager().a(list).subscribe(new Action(){

                    public final void run() {
                        Hengam.runOnUiThread(c);
                    }
                });
            }
        });
    }

    public static void removeTags(List<String> tags) {
        Hengam.removeTags(tags, null);
    }

    public static Map<String, String> getSubscribedTags() {
        CoreComponent coreComponent = Hengam.getCoreComponentOrFail("Setting the tag failed");
        if (coreComponent == null) {
            return null;
        }
        try {
            return coreComponent.tagManager().b;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Deprecated
    public static void subscribe(String topic) {
        Hengam.subscribeToTopic(topic);
    }

    /*
     * WARNING - void declaration
     */
    public static void unsubscribeFromTopic(String topic, Callback callback) {
        void var1_1;
        String string;
        final CoreComponent coreComponent = Hengam.getCoreComponentOrFail("Unsubscribing from topic failed");
        if (coreComponent == null) {
            return;
        }
        coreComponent.hengamLifecycle().waitForPostInit().subscribe(new Action((Callback)var1_1){
            final /* synthetic */ Callback c;
            {
                this.c = callback;
            }

            public final void run() {
                coreComponent.topicManager().b(string, true).subscribe(new Action(){

                    public final void run() {
                        Hengam.runOnUiThread(c);
                    }
                });
            }
        });
    }

    public static void unsubscribeFromTopic(String topic) {
        Hengam.unsubscribeFromTopic(topic, null);
    }

    public static List<String> getSubscribedTopics() {
        CoreComponent coreComponent = Hengam.getCoreComponentOrFail(null);
        if (coreComponent == null) {
            return new ArrayList<String>();
        }
        Iterator<String> iterator = coreComponent.topicManager().b.iterator();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (!string.endsWith("_" + coreComponent.appManifest().appId)) continue;
            arrayList.add(string.replace("_" + coreComponent.appManifest().appId, ""));
        }
        return arrayList;
    }

    @Deprecated
    public static void unsubscribe(String topic) {
        Hengam.unsubscribeFromTopic(topic);
    }

    public static String getGoogleAdvertisingId() {
        CoreComponent coreComponent = Hengam.getCoreComponentOrFail("Getting Google Advertisement Id failed");
        if (coreComponent == null) {
            return null;
        }
        if (!Hengam.isInitialized()) {
            return null;
        }
        return coreComponent.deviceIdHelper().getAdvertisementId();
    }

    public static String getAndroidId() {
        CoreComponent coreComponent = Hengam.getCoreComponentOrFail("Getting Android Id failed");
        if (coreComponent == null) {
            return null;
        }
        return coreComponent.deviceIdHelper().getAndroidId();
    }

    public static void setCustomId(@Nullable String id) {
        String string;
        CoreComponent coreComponent = Hengam.getCoreComponentOrFail("Setting Custom Id failed");
        if (coreComponent == null) {
            return;
        }
        if (id == null || id.isEmpty()) {
            coreComponent.userCredentials().setCustomId("");
            return;
        }
        coreComponent.userCredentials().setCustomId(string);
    }

    public static String getCustomId() {
        CoreComponent coreComponent = Hengam.getCoreComponentOrFail("Getting Custom Id failed");
        if (coreComponent == null) {
            return null;
        }
        return coreComponent.userCredentials().getCustomId();
    }

    public static boolean setUserEmail(@Nullable String email) {
        String string;
        CoreComponent coreComponent = Hengam.getCoreComponentOrFail("Setting user email failed");
        if (coreComponent == null) {
            return false;
        }
        if (email == null || email.isEmpty()) {
            coreComponent.userCredentials().setEmail("");
            return true;
        }
        if (!Pattern.compile("^[A-Z0-9._%+-]+@[A-Z0-9.-]+\\.[A-Z]{2,6}$", 2).matcher(email.trim()).matches()) {
            Log.w((String)"Hengam", (String)("Attempted to set an invalid email address '" + email + "'. The email will not be set."));
            return false;
        }
        coreComponent.userCredentials().setEmail(string.trim());
        return true;
    }

    public static String getUserEmail() {
        CoreComponent coreComponent = Hengam.getCoreComponentOrFail("Getting user email failed");
        if (coreComponent == null) {
            return null;
        }
        return coreComponent.userCredentials().getEmail();
    }

    public static boolean setUserPhoneNumber(@Nullable String phoneNumber) {
        String string;
        CoreComponent coreComponent = Hengam.getCoreComponentOrFail("Settings user phone number failed");
        if (coreComponent == null) {
            return false;
        }
        if (phoneNumber == null || phoneNumber.isEmpty()) {
            coreComponent.userCredentials().setPhoneNumber("");
            return true;
        }
        if (!Pattern.compile("^[0-9\u06f0-\u06f9+() ]+$", 2).matcher(phoneNumber.trim()).matches()) {
            Log.w((String)"Hengam", (String)("Attempted to set an invalid phone number '" + phoneNumber + "'. The phone number will not be set."));
            return false;
        }
        coreComponent.userCredentials().setPhoneNumber(string);
        return true;
    }

    public static String getUserPhoneNumber() {
        CoreComponent coreComponent = Hengam.getCoreComponentOrFail("Getting user phone number failed");
        if (coreComponent == null) {
            return null;
        }
        return coreComponent.userCredentials().getPhoneNumber();
    }

    @Deprecated
    public static String getHengamId() {
        CoreComponent coreComponent = Hengam.getCoreComponentOrFail("Getting Hengam Id");
        if (coreComponent == null) {
            return "";
        }
        return coreComponent.deviceIdHelper().getHengamId();
    }

    @Nullable
    public static <T extends HengamServiceApi> T getHengamService(Class<T> serviceClass) {
        T t2 = HengamInternals.INSTANCE.getService(serviceClass);
        if (t2 == null) {
            Class<T> clazz;
            Log.e((String)"Hengam", (String)("The Hengam service " + clazz.getSimpleName() + " is not available. This either means you have provided an invalid Hengam Service name, Hengam was not initialized successfully or you have not added the Hengam service to your gradle dependencies."));
        }
        return t2;
    }

    @Nullable
    public static HengamServiceApi getHengamService(String serviceName) {
        HengamServiceApi hengamServiceApi = HengamInternals.INSTANCE.getService(serviceName);
        if (hengamServiceApi == null) {
            String string;
            Log.e((String)"Hengam", (String)("The Hengam service " + string + " is not available. This either means you have provided an invalid Hengam Service name, Hengam was not initialized successfully or you have not added the Hengam service to your gradle dependencies."));
        }
        return hengamServiceApi;
    }

    public static HengamDebug debugApi() {
        return new HengamDebug();
    }

    public static FcmHandler getFcmHandler() {
        CoreComponent coreComponent = Hengam.getCoreComponentOrFail("Getting FcmHandler failed");
        if (coreComponent == null) {
            return new FcmHandler(){

                @Override
                public final boolean onMessageReceived(RemoteMessage remoteMessage) {
                    String string = (String)remoteMessage.getData().get("courier");
                    return string != null && string.toLowerCase().equals("pushe");
                }

                @Override
                public final void onDeletedMessages() {
                }

                @Override
                public final void onMessageSent(String messageId) {
                }

                @Override
                public final void onSendError(String messageId, Exception exception) {
                }

                @Override
                public final void onNewToken(String token) {
                }
            };
        }
        return coreComponent.fcmHandler();
    }

    private static CoreComponent getCoreComponentOrFail(String failMessage) {
        CoreComponent coreComponent = HengamInternals.INSTANCE.getComponent(CoreComponent.class);
        if (coreComponent == null && failMessage != null && !failMessage.isEmpty()) {
            String string;
            Log.e((String)"Hengam", (String)string, (Throwable)new HengamException("Unable to obtain the Hengam core component. This probably means Hengam initialization has failed."));
        }
        return coreComponent;
    }

    private static void runOnUiThread(Runnable runnable) {
        Runnable runnable2;
        if (runnable == null) {
            return;
        }
        if (uiThreadHandler == null) {
            uiThreadHandler = new Handler(Looper.getMainLooper());
        }
        uiThreadHandler.post(runnable2);
    }

    private static void runOnUiThread(Callback callback) {
        Callback callback2;
        if (callback == null) {
            return;
        }
        Hengam.runOnUiThread(new Runnable(){

            @Override
            public final void run() {
                callback2.onComplete();
            }
        });
    }

    public static interface Callback {
        public void onComplete();
    }
}

