/*
 * Decompiled with CFR 0.152.
 */
package io.hengam.lib.utils;

import io.reactivex.Single;
import io.reactivex.SingleEmitter;
import io.reactivex.SingleOnSubscribe;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\nB\u0007\b\u0007\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0005J\u000e\u0010\u0007\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0005\u00a8\u0006\u000b"}, d2={"Lio/hengam/lib/utils/HttpUtils;", "", "()V", "request", "Lio/reactivex/Single;", "", "url", "requestBlocking", "requestBlockingStream", "Ljava/io/InputStream;", "HttpError", "core_release"})
public final class HttpUtils {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Single<String> request(@NotNull String url) {
        void var1_1;
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Single single = Single.create((SingleOnSubscribe)new SingleOnSubscribe<T>(this, (String)var1_1){
            final /* synthetic */ HttpUtils this$0;
            final /* synthetic */ String $url;

            /*
             * WARNING - void declaration
             */
            public final void subscribe(@NotNull SingleEmitter<String> emitter) {
                Intrinsics.checkParameterIsNotNull(emitter, (String)"emitter");
                try {
                    emitter.onSuccess((Object)this.this$0.requestBlocking(this.$url));
                    return;
                }
                catch (Exception exception) {
                    void var1_1;
                    var1_1.tryOnError((Throwable)exception);
                    return;
                }
            }
            {
                this.this$0 = httpUtils;
                this.$url = string;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"Single.create { emitter \u2026)\n            }\n        }");
        return single;
    }

    @NotNull
    public final String requestBlocking(@NotNull String url) {
        HttpURLConnection httpURLConnection;
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        URLConnection uRLConnection = new URL((String)((Object)httpURLConnection)).openConnection();
        if (uRLConnection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.net.HttpURLConnection");
        }
        httpURLConnection = (HttpURLConnection)uRLConnection;
        if (httpURLConnection.getResponseCode() >= 400) {
            httpURLConnection.getInputStream().close();
            httpURLConnection.disconnect();
            int n2 = httpURLConnection.getResponseCode();
            String string = httpURLConnection.getResponseMessage();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"urlConnection.responseMessage");
            throw (Throwable)new HttpError(n2, string);
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
        StringWriter stringWriter = new StringWriter();
        char[] cArray = new char[4096];
        int n3 = bufferedReader.read(cArray);
        while (-1 != n3) {
            stringWriter.write(cArray, 0, n3);
            n3 = bufferedReader.read(cArray);
        }
        httpURLConnection.getInputStream().close();
        httpURLConnection.disconnect();
        String string = stringWriter.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sw.toString()");
        return string;
    }

    @NotNull
    public final InputStream requestBlockingStream(@NotNull String url) {
        HttpURLConnection httpURLConnection;
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        URLConnection uRLConnection = new URL((String)((Object)httpURLConnection)).openConnection();
        if (uRLConnection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.net.HttpURLConnection");
        }
        httpURLConnection = (HttpURLConnection)uRLConnection;
        if (httpURLConnection.getResponseCode() >= 400) {
            httpURLConnection.getInputStream().close();
            httpURLConnection.disconnect();
            int n2 = httpURLConnection.getResponseCode();
            String string = httpURLConnection.getResponseMessage();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"urlConnection.responseMessage");
            throw (Throwable)new HttpError(n2, string);
        }
        InputStream inputStream = httpURLConnection.getInputStream();
        Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"urlConnection.inputStream");
        return inputStream;
    }

    @Inject
    public HttpUtils() {
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lio/hengam/lib/utils/HttpUtils$HttpError;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "statusCode", "", "reason", "", "(ILjava/lang/String;)V", "getReason", "()Ljava/lang/String;", "getStatusCode", "()I", "core_release"})
    public static final class HttpError
    extends Exception {
        private final int statusCode;
        @NotNull
        private final String reason;

        public final int getStatusCode() {
            return this.statusCode;
        }

        @NotNull
        public final String getReason() {
            return this.reason;
        }

        /*
         * WARNING - void declaration
         */
        public HttpError(int statusCode, @NotNull String reason) {
            void var2_2;
            void var1_1;
            Intrinsics.checkParameterIsNotNull((Object)reason, (String)"reason");
            super("Http Error: " + statusCode + ' ' + reason);
            this.statusCode = var1_1;
            this.reason = var2_2;
        }
    }
}

