/*
 * Decompiled with CFR 0.152.
 */
package io.hengam.lib.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.telephony.TelephonyManager;
import io.hengam.lib.utils.NetworkType;
import io.hengam.lib.utils.PermissionChecker;
import io.hengam.lib.utils.WifiDetails;
import io.hengam.lib.utils.log.Plog;
import io.reactivex.Observable;
import io.reactivex.functions.Function;
import io.reactivex.functions.Predicate;
import javax.inject.Inject;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\"\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0007J\n\u0010\u001f\u001a\u0004\u0018\u00010\u0013H\u0007J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00130!H\u0007R\u001d\u0010\u0007\u001a\u0004\u0018\u00010\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\r\u001a\u0004\u0018\u00010\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\f\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\""}, d2={"Lio/hengam/lib/utils/NetworkInfoHelper;", "", "context", "Landroid/content/Context;", "telephonyManager", "Landroid/telephony/TelephonyManager;", "(Landroid/content/Context;Landroid/telephony/TelephonyManager;)V", "connectivityManager", "Landroid/net/ConnectivityManager;", "getConnectivityManager", "()Landroid/net/ConnectivityManager;", "connectivityManager$delegate", "Lkotlin/Lazy;", "wifiManager", "Landroid/net/wifi/WifiManager;", "getWifiManager", "()Landroid/net/wifi/WifiManager;", "wifiManager$delegate", "createWifiDetails", "Lio/hengam/lib/utils/WifiDetails;", "wifiInfo", "Landroid/net/wifi/WifiInfo;", "ssid", "", "bssid", "rssi", "", "getMobileNetwork", "Lio/hengam/lib/utils/NetworkType$Mobile;", "getNetworkType", "Lio/hengam/lib/utils/NetworkType;", "getWifiNetwork", "scanWifiNetworks", "Lio/reactivex/Observable;", "core_release"})
public final class NetworkInfoHelper {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final Lazy connectivityManager$delegate;
    private final Lazy wifiManager$delegate;
    private final Context context;
    private final TelephonyManager telephonyManager;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(NetworkInfoHelper.class), "connectivityManager", "getConnectivityManager()Landroid/net/ConnectivityManager;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(NetworkInfoHelper.class), "wifiManager", "getWifiManager()Landroid/net/wifi/WifiManager;"))};
    }

    private final ConnectivityManager getConnectivityManager() {
        return (ConnectivityManager)this.connectivityManager$delegate.getValue();
    }

    private final WifiManager getWifiManager() {
        return (WifiManager)this.wifiManager$delegate.getValue();
    }

    @SuppressLint(value={"MissingPermission"})
    @NotNull
    public final NetworkType getNetworkType() {
        try {
            if (!PermissionChecker.INSTANCE.hasPermission(this.context, PermissionChecker.INSTANCE.getACCESS_NETWORK_STATE())) {
                return NetworkType.Unknown.INSTANCE;
            }
            ConnectivityManager connectivityManager2 = this.getConnectivityManager();
            NetworkInfo networkInfo = connectivityManager2 != null ? connectivityManager2.getNetworkInfo(1) : null;
            ConnectivityManager connectivityManager3 = this.getConnectivityManager();
            NetworkInfo networkInfo2 = connectivityManager3 != null ? connectivityManager3.getNetworkInfo(0) : null;
            NetworkInfo networkInfo3 = networkInfo;
            if (networkInfo3 != null) {
                if (networkInfo3.isConnectedOrConnecting()) {
                    return new NetworkType.Wifi(this.getWifiNetwork());
                }
            }
            NetworkInfo networkInfo4 = networkInfo2;
            if (networkInfo4 != null) {
                if (networkInfo4.isConnectedOrConnecting()) {
                    return this.getMobileNetwork();
                }
            }
            return NetworkType.None.INSTANCE;
        }
        catch (Exception exception) {
            Plog.INSTANCE.error("Failed to get network type in NetworkInfoHelper", (Throwable)exception, new Pair[0]);
            return NetworkType.Unknown.INSTANCE;
        }
    }

    private final NetworkType.Mobile getMobileNetwork() {
        String string;
        Object object;
        TelephonyManager telephonyManager = this.telephonyManager;
        Object object2 = object = telephonyManager != null ? Integer.valueOf(telephonyManager.getNetworkType()) : null;
        if (object2 != null && (Integer)object2 == 1) {
            string = "gprs";
        } else {
            Integer n2 = object;
            if (n2 != null && n2 == 2) {
                string = "edge";
            } else {
                Object object3 = object;
                if (object3 != null && (Integer)object3 == 3) {
                    string = "umts";
                } else {
                    Object object4 = object;
                    if (object4 != null && (Integer)object4 == 4) {
                        string = "cdma";
                    } else {
                        Object object5 = object;
                        if (object5 != null && (Integer)object5 == 5) {
                            string = "evdo 0";
                        } else {
                            Object object6 = object;
                            if (object6 != null && (Integer)object6 == 6) {
                                string = "evdo a";
                            } else {
                                Object object7 = object;
                                if (object7 != null && (Integer)object7 == 7) {
                                    string = "1xrtt";
                                } else {
                                    Object object8 = object;
                                    if (object8 != null && (Integer)object8 == 8) {
                                        string = "hsdpa";
                                    } else {
                                        Object object9 = object;
                                        if (object9 != null && (Integer)object9 == 9) {
                                            string = "hsupa";
                                        } else {
                                            Object object10 = object;
                                            if (object10 != null && (Integer)object10 == 10) {
                                                string = "hspa";
                                            } else {
                                                Object object11 = object;
                                                if (object11 != null && (Integer)object11 == 11) {
                                                    string = "iden";
                                                } else {
                                                    Object object12 = object;
                                                    if (object12 != null && (Integer)object12 == 12) {
                                                        string = "evdo b";
                                                    } else {
                                                        Object object13 = object;
                                                        if (object13 != null && (Integer)object13 == 13) {
                                                            string = "lte";
                                                        } else {
                                                            Object object14 = object;
                                                            if (object14 != null && (Integer)object14 == 14) {
                                                                string = "ehrpd";
                                                            } else {
                                                                Object object15 = object;
                                                                string = object15 != null && (Integer)object15 == 15 ? "hspap" : "data";
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        object = string;
        TelephonyManager telephonyManager2 = this.telephonyManager;
        return new NetworkType.Mobile((String)object, telephonyManager2 != null ? telephonyManager2.getNetworkOperatorName() : null);
    }

    @SuppressLint(value={"MissingPermission"})
    @Nullable
    public final WifiDetails getWifiNetwork() {
        WifiManager wifiManager2;
        boolean bl;
        boolean bl2 = bl = Build.VERSION.SDK_INT < 28 || PermissionChecker.INSTANCE.hasPermission(this.context, PermissionChecker.INSTANCE.getACCESS_COARSE_LOCATION()) || PermissionChecker.INSTANCE.hasPermission(this.context, PermissionChecker.INSTANCE.getACCESS_FINE_LOCATION());
        if (PermissionChecker.INSTANCE.hasPermission(this.context, PermissionChecker.INSTANCE.getACCESS_WIFI_STATE()) && bl && (wifiManager2 = this.getWifiManager()) != null && (wifiManager2 = wifiManager2.getConnectionInfo()) != null) {
            WifiManager wifiManager3 = wifiManager2;
            return this.createWifiDetails((WifiInfo)wifiManager3);
        }
        return null;
    }

    @SuppressLint(value={"MissingPermission"})
    @NotNull
    public final Observable<WifiDetails> scanWifiNetworks() {
        boolean bl;
        boolean bl2 = bl = Build.VERSION.SDK_INT < 23 || PermissionChecker.INSTANCE.hasPermission(this.context, PermissionChecker.INSTANCE.getACCESS_COARSE_LOCATION()) || PermissionChecker.INSTANCE.hasPermission(this.context, PermissionChecker.INSTANCE.getACCESS_FINE_LOCATION());
        if (PermissionChecker.INSTANCE.hasPermission(this.context, PermissionChecker.INSTANCE.getACCESS_WIFI_STATE()) && bl) {
            WifiDetails wifiDetails = new WifiDetails("empty", "empty", 0);
            Object object = this.getWifiManager();
            Observable observable = Observable.fromIterable((Iterable)(object != null && (object = object.getScanResults()) != null ? (Iterable)object : (Iterable)CollectionsKt.emptyList())).map(new Function<T, R>(this, wifiDetails){
                final /* synthetic */ NetworkInfoHelper this$0;
                final /* synthetic */ WifiDetails $emptyDetails;

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final WifiDetails apply(@NotNull ScanResult it) {
                    void var1_1;
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    String string = it.SSID;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.SSID");
                    String string2 = it.BSSID;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"it.BSSID");
                    WifiDetails wifiDetails = NetworkInfoHelper.access$createWifiDetails(this.this$0, string, string2, var1_1.level);
                    if (wifiDetails == null) {
                        wifiDetails = this.$emptyDetails;
                    }
                    return wifiDetails;
                }
                {
                    this.this$0 = networkInfoHelper;
                    this.$emptyDetails = wifiDetails;
                }
            }).filter((Predicate)new Predicate<WifiDetails>(wifiDetails){
                final /* synthetic */ WifiDetails $emptyDetails;

                /*
                 * WARNING - void declaration
                 */
                public final boolean test(@NotNull WifiDetails it) {
                    void var1_1;
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return Intrinsics.areEqual((Object)var1_1, (Object)this.$emptyDetails) ^ true;
                }
                {
                    this.$emptyDetails = wifiDetails;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"Observable.fromIterable(\u2026er { it != emptyDetails }");
            return observable;
        }
        Observable observable = Observable.empty();
        Intrinsics.checkExpressionValueIsNotNull((Object)observable, (String)"Observable.empty()");
        return observable;
    }

    /*
     * WARNING - void declaration
     */
    private final WifiDetails createWifiDetails(String ssid2, String bssid, int rssi) {
        void var3_4;
        void var2_3;
        void var1_1;
        String string;
        if (StringsKt.isBlank((CharSequence)ssid2) || Intrinsics.areEqual((Object)ssid2, (Object)"<unknown ssid>")) {
            return null;
        }
        if (StringsKt.startsWith$default((String)ssid2, (String)"\"", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)ssid2, (String)"\"", (boolean)false, (int)2, null)) {
            String string2 = ssid2;
            int ssid2 = ssid2.length() - 1;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(1, ssid2);
            string = string4;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        } else {
            string = var1_1;
        }
        var1_1 = string;
        return new WifiDetails((String)var1_1, (String)var2_3, (int)var3_4);
    }

    /*
     * WARNING - void declaration
     */
    private final WifiDetails createWifiDetails(WifiInfo wifiInfo) {
        void var1_1;
        String string;
        String string2 = wifiInfo.getSSID();
        if (string2 == null) {
            string2 = "";
        }
        if ((string = wifiInfo.getBSSID()) == null) {
            string = "";
        }
        return this.createWifiDetails(string2, string, var1_1.getRssi());
    }

    /*
     * WARNING - void declaration
     */
    @Inject
    public NetworkInfoHelper(@NotNull Context context, @Nullable TelephonyManager telephonyManager) {
        void var2_2;
        void var1_1;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = var1_1;
        this.telephonyManager = var2_2;
        this.connectivityManager$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ConnectivityManager>(this){
            final /* synthetic */ NetworkInfoHelper this$0;

            @Nullable
            public final ConnectivityManager invoke() {
                Object object = NetworkInfoHelper.access$getContext$p(this.this$0).getSystemService("connectivity");
                if (!(object instanceof ConnectivityManager)) {
                    object = null;
                }
                return (ConnectivityManager)object;
            }
            {
                this.this$0 = networkInfoHelper;
                super(0);
            }
        }));
        this.wifiManager$delegate = LazyKt.lazy((Function0)((Function0)new Function0<WifiManager>(this){
            final /* synthetic */ NetworkInfoHelper this$0;

            @Nullable
            public final WifiManager invoke() {
                Object object = NetworkInfoHelper.access$getContext$p(this.this$0).getApplicationContext().getSystemService("wifi");
                if (!(object instanceof WifiManager)) {
                    object = null;
                }
                return (WifiManager)object;
            }
            {
                this.this$0 = networkInfoHelper;
                super(0);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ WifiDetails access$createWifiDetails(NetworkInfoHelper $this, String ssid, String bssid, int rssi) {
        void var3_3;
        void var2_2;
        void var1_1;
        return $this.createWifiDetails((String)var1_1, (String)var2_2, (int)var3_3);
    }

    public static final /* synthetic */ Context access$getContext$p(NetworkInfoHelper $this) {
        return $this.context;
    }
}

