/*
 * Decompiled with CFR 0.152.
 */
package io.hengam.lib.utils;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.os.Looper;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import io.hengam.lib.AppManifest;
import io.hengam.lib.utils.PermissionChecker;
import io.hengam.lib.utils.log.LogLevel;
import io.hengam.lib.utils.log.Plog;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.UUID;
import javax.inject.Inject;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000e\b\u0007\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0013\u001a\u00020\bH\u0002J\b\u0010\u0014\u001a\u00020\bH\u0003R\u001b\u0010\u0007\u001a\u00020\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u001b\u0010\r\u001a\u00020\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\f\u001a\u0004\b\u000e\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0010\u001a\u00020\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\f\u001a\u0004\b\u0011\u0010\n\u00a8\u0006\u0016"}, d2={"Lio/hengam/lib/utils/DeviceIDHelper;", "", "context", "Landroid/content/Context;", "appManifest", "Lio/hengam/lib/AppManifest;", "(Landroid/content/Context;Lio/hengam/lib/AppManifest;)V", "advertisementId", "", "getAdvertisementId", "()Ljava/lang/String;", "advertisementId$delegate", "Lkotlin/Lazy;", "androidId", "getAndroidId", "androidId$delegate", "hengamId", "getHengamId", "hengamId$delegate", "retrieveAdvertisementId", "retrieveHengamId", "Companion", "core_release"})
public final class DeviceIDHelper {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    private final Lazy advertisementId$delegate;
    @NotNull
    private final Lazy androidId$delegate;
    @NotNull
    private final Lazy hengamId$delegate;
    private final Context context;
    private final AppManifest appManifest;
    @NotNull
    public static final String HENGAM_ID_PREFIX = "pid_";
    public static final int HENGAM_ID_SIZE = 10;
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(DeviceIDHelper.class), "advertisementId", "getAdvertisementId()Ljava/lang/String;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(DeviceIDHelper.class), "androidId", "getAndroidId()Ljava/lang/String;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(DeviceIDHelper.class), "hengamId", "getHengamId()Ljava/lang/String;"))};
        Companion = new Companion(null);
    }

    @NotNull
    public final String getAdvertisementId() {
        return (String)this.advertisementId$delegate.getValue();
    }

    @NotNull
    public final String getAndroidId() {
        return (String)this.androidId$delegate.getValue();
    }

    @NotNull
    public final String getHengamId() {
        return (String)this.hengamId$delegate.getValue();
    }

    private final String retrieveAdvertisementId() {
        Object object;
        if (this.appManifest.getDisableAdvertisementId()) {
            return "";
        }
        if (Intrinsics.areEqual((Object)Looper.myLooper(), (Object)Looper.getMainLooper())) {
            Plog.INSTANCE.error("Utils", "Attempted to retrieve Advertising Id in main thread", new Pair[0]);
            return "";
        }
        try {
            AdvertisingIdClient.Info info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.context);
            Intrinsics.checkExpressionValueIsNotNull((Object)info, (String)"AdvertisingIdClient.getAdvertisingIdInfo(context)");
            String string = info.getId();
            if (string == null) {
                string = "";
            }
            object = string;
        }
        catch (Exception exception) {
            object = exception;
            Exception exception2 = exception;
            if (exception instanceof ClassNotFoundException) {
                Plog.INSTANCE.getWarn().message("Error trying to retrieve advertisement id. Probably missing \"com.google.android.gms:play-services-ads\" dependency in gradle file.").useLogCatLevel(LogLevel.ERROR).log();
            } else if (exception2 instanceof IOException || exception2 instanceof GooglePlayServicesNotAvailableException || exception2 instanceof GooglePlayServicesRepairableException) {
                Plog.INSTANCE.getWarn().message("Error trying to retrieve advertisement id.").withError((Throwable)object).useLogCatLevel(LogLevel.ERROR).log();
            } else {
                Plog.INSTANCE.error("Unknown error occurred while retrieving advertising id", (Throwable)object, new Pair[0]);
            }
            object = "";
        }
        return object;
    }

    @SuppressLint(value={"MissingPermission"})
    private final String retrieveHengamId() {
        Object object;
        Object object2 = this.context.getSharedPreferences("device_id.xml", 0).getString("device_id", "");
        try {
            UUID uUID;
            if (object2 != null && ((CharSequence)object2).length() > 0) {
                uUID = UUID.fromString((String)object2);
            } else if (Build.VERSION.SDK_INT >= 26) {
                object = this.getAdvertisementId();
                if (((CharSequence)object).length() > 0) {
                    object2 = object;
                    Charset charset = Charset.forName("utf8");
                    Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"Charset.forName(charsetName)");
                    object = charset;
                    Object object3 = object2;
                    if (object3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    byte[] byArray = ((String)object3).getBytes((Charset)object);
                    Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                    uUID = UUID.nameUUIDFromBytes(byArray);
                } else {
                    uUID = UUID.randomUUID();
                }
            } else if (Intrinsics.areEqual((Object)this.getAndroidId(), (Object)"9774d56d682e549c") ^ true) {
                object = this.getAndroidId();
                Charset charset = Charset.forName("utf8");
                Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"Charset.forName(charsetName)");
                object2 = charset;
                Object object4 = object;
                if (object4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray = ((String)object4).getBytes((Charset)object2);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                uUID = UUID.nameUUIDFromBytes(byArray);
            } else if (PermissionChecker.INSTANCE.hasPermission(this.context, "android.permission.READ_PHONE_STATE")) {
                Object object5 = this.context.getSystemService("phone");
                if (object5 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type android.telephony.TelephonyManager");
                }
                object = ((TelephonyManager)object5).getDeviceId();
                if (object != null) {
                    object2 = object;
                    Charset charset = Charset.forName("utf8");
                    Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"Charset.forName(charsetName)");
                    object = charset;
                    byte[] byArray = ((String)object2).getBytes((Charset)object);
                    Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                    uUID = UUID.nameUUIDFromBytes(byArray);
                } else {
                    uUID = UUID.randomUUID();
                }
            } else {
                uUID = UUID.randomUUID();
            }
            object = uUID;
        }
        catch (Exception exception) {
            object = UUID.randomUUID();
        }
        String string = ((UUID)object).toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"uuid.toString()");
        object = string;
        if (string.length() > 16) {
            object2 = object;
            object = new StringBuilder(HENGAM_ID_PREFIX);
            Object object6 = object2;
            if (object6 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string2 = ((String)object6).substring(4, 16);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            object2 = string2;
            return ((StringBuilder)object).append((String)object2).toString();
        }
        object2 = object;
        object = new StringBuilder(HENGAM_ID_PREFIX);
        Object object7 = object2;
        if (object7 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = ((String)object7).substring(0, 12);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        object2 = string3;
        return ((StringBuilder)object).append((String)object2).toString();
    }

    /*
     * WARNING - void declaration
     */
    @Inject
    public DeviceIDHelper(@NotNull Context context, @NotNull AppManifest appManifest) {
        void var2_2;
        void var1_1;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)appManifest, (String)"appManifest");
        this.context = var1_1;
        this.appManifest = var2_2;
        this.advertisementId$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ DeviceIDHelper this$0;

            @NotNull
            public final String invoke() {
                return DeviceIDHelper.access$retrieveAdvertisementId(this.this$0);
            }
            {
                this.this$0 = deviceIDHelper;
                super(0);
            }
        }));
        this.androidId$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ DeviceIDHelper this$0;

            public final String invoke() {
                String string;
                try {
                    string = Settings.Secure.getString((ContentResolver)DeviceIDHelper.access$getContext$p(this.this$0).getContentResolver(), (String)"android_id");
                }
                catch (Exception exception) {
                    Plog.INSTANCE.error("Error obtaining Android Id", (Throwable)exception, new Pair[0]);
                    string = "unknown";
                }
                return string;
            }
            {
                this.this$0 = deviceIDHelper;
                super(0);
            }
        }));
        this.hengamId$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ DeviceIDHelper this$0;

            @NotNull
            public final String invoke() {
                return DeviceIDHelper.access$retrieveHengamId(this.this$0);
            }
            {
                this.this$0 = deviceIDHelper;
                super(0);
            }
        }));
    }

    public static final /* synthetic */ String access$retrieveAdvertisementId(DeviceIDHelper $this) {
        return $this.retrieveAdvertisementId();
    }

    public static final /* synthetic */ Context access$getContext$p(DeviceIDHelper $this) {
        return $this.context;
    }

    public static final /* synthetic */ String access$retrieveHengamId(DeviceIDHelper $this) {
        return $this.retrieveHengamId();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/hengam/lib/utils/DeviceIDHelper$Companion;", "", "()V", "HENGAM_ID_PREFIX", "", "HENGAM_ID_SIZE", "", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

