/*
 * Decompiled with CFR 0.152.
 */
package io.hengam.lib.utils;

import android.annotation.SuppressLint;
import android.app.usage.UsageStatsManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.Signature;
import android.os.Build;
import android.os.Bundle;
import io.hengam.lib.messages.common.ApplicationDetail;
import io.hengam.lib.utils.UtilsKt;
import io.hengam.lib.utils.log.Plog;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\t\u001a\u00020\u0006J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b2\b\b\u0002\u0010\t\u001a\u00020\u0006J\u0014\u0010\f\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0006J\u001b\u0010\r\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0006H\u0007\u00a2\u0006\u0002\u0010\u000fJ\u0006\u0010\u0010\u001a\u00020\u0011J\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u000bJ\u0010\u0010\u0013\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\u0006J\u0014\u0010\u0014\u001a\u0004\u0018\u00010\u00152\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0006J\u0010\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\t\u001a\u00020\u0006J\u0006\u0010\u0018\u001a\u00020\u0017J\u0010\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lio/hengam/lib/utils/ApplicationInfoHelper;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "getAppStandByBucket", "", "getApplicationDetails", "Lio/hengam/lib/messages/common/ApplicationDetail;", "packageName", "getApplicationSignature", "", "getApplicationVersion", "getApplicationVersionCode", "", "(Ljava/lang/String;)Ljava/lang/Long;", "getHostingApplicationVersionCode", "", "getInstalledApplications", "getInstallerPackageName", "getManifestMetaData", "Landroid/os/Bundle;", "isAppHidden", "", "isFreshInstall", "packageInfoToApplicationDetail", "info", "Landroid/content/pm/PackageInfo;", "Companion", "core_release"})
public final class ApplicationInfoHelper {
    private final Context context;
    @NotNull
    public static final String INSTALLER_DIRECT = "direct";
    public static final Companion Companion = new Companion(null);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final String getApplicationVersion(@Nullable String packageName) {
        PackageManager packageManager = this.context.getPackageManager();
        try {
            String string;
            PackageManager packageManager2 = packageManager;
            PackageManager packageManager3 = packageManager2;
            if (packageManager2 == null) return null;
            String string2 = string;
            if (string2 == null) {
                string2 = this.context.getPackageName();
            }
            PackageInfo packageInfo = packageManager3.getPackageInfo(string2, 0);
            packageManager3 = packageInfo;
            if (packageInfo == null) return null;
            String string3 = packageManager3.versionName;
            return string3;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    @Nullable
    public static /* synthetic */ String getApplicationVersion$default(ApplicationInfoHelper applicationInfoHelper, String string, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = null;
        }
        return applicationInfoHelper.getApplicationVersion(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final Bundle getManifestMetaData(@Nullable String packageName) {
        PackageManager packageManager = this.context.getPackageManager();
        try {
            Bundle bundle;
            PackageManager packageManager2 = packageManager;
            PackageManager packageManager3 = packageManager2;
            if (packageManager2 == null) return null;
            String string = bundle;
            if (string == null) {
                string = this.context.getPackageName();
            }
            ApplicationInfo applicationInfo = packageManager3.getApplicationInfo(string, 128);
            packageManager3 = applicationInfo;
            if (applicationInfo == null) return null;
            Bundle bundle2 = packageManager3.metaData;
            return bundle2;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    @Nullable
    public static /* synthetic */ Bundle getManifestMetaData$default(ApplicationInfoHelper applicationInfoHelper, String string, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = null;
        }
        return applicationInfoHelper.getManifestMetaData(string);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SuppressLint(value={"NewApi"})
    @Nullable
    public final Long getApplicationVersionCode(@Nullable String packageName) {
        PackageManager packageManager = this.context.getPackageManager();
        try {
            void var1_1;
            Long l2;
            if (Build.VERSION.SDK_INT >= 26) {
                Long l3;
                try {
                    PackageManager packageManager2 = packageManager;
                    PackageManager packageManager3 = packageManager2;
                    if (packageManager2 == null) return null;
                    String string = packageName;
                    if (string == null) {
                        string = this.context.getPackageName();
                    }
                    PackageInfo packageInfo = packageManager3.getPackageInfo(string, 0);
                    packageManager3 = packageInfo;
                    if (packageInfo == null) return null;
                    Long l4 = packageManager3.getLongVersionCode();
                    l3 = l4;
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    PackageManager packageManager4 = packageManager;
                    PackageManager packageManager5 = packageManager4;
                    if (packageManager4 == null) return null;
                    String string = packageName;
                    if (string == null) {
                        string = this.context.getPackageName();
                    }
                    PackageInfo packageInfo = packageManager5.getPackageInfo(string, 0);
                    packageManager5 = packageInfo;
                    if (packageInfo == null) return null;
                    Long l5 = packageManager5.versionCode;
                    l3 = l5;
                }
                l2 = l3;
                return l2;
            }
            PackageManager packageManager6 = packageManager;
            PackageManager packageManager7 = packageManager6;
            if (packageManager6 == null) return null;
            String string = var1_1;
            if (string == null) {
                string = this.context.getPackageName();
            }
            PackageInfo packageInfo = packageManager7.getPackageInfo(string, 0);
            packageManager7 = packageInfo;
            if (packageInfo == null) return null;
            l2 = packageManager7.versionCode;
            return l2;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    @SuppressLint(value={"NewApi"})
    @Nullable
    public static /* synthetic */ Long getApplicationVersionCode$default(ApplicationInfoHelper applicationInfoHelper, String string, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = null;
        }
        return applicationInfoHelper.getApplicationVersionCode(string);
    }

    @Nullable
    public final ApplicationDetail getApplicationDetails(@NotNull String packageName) {
        ApplicationDetail applicationDetail;
        Intrinsics.checkParameterIsNotNull((Object)packageName, (String)"packageName");
        PackageManager packageManager = this.context.getPackageManager();
        try {
            PackageInfo packageInfo = packageManager.getPackageInfo((String)((Object)applicationDetail), 0);
            Intrinsics.checkExpressionValueIsNotNull((Object)packageInfo, (String)"pm.getPackageInfo(packageName, 0)");
            applicationDetail = this.packageInfoToApplicationDetail(packageInfo);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            applicationDetail = null;
        }
        return applicationDetail;
    }

    @Nullable
    public static /* synthetic */ ApplicationDetail getApplicationDetails$default(ApplicationInfoHelper applicationInfoHelper, String string, int n2, Object object) {
        if ((n2 & 1) != 0) {
            String string2 = applicationInfoHelper.context.getPackageName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"context.packageName");
            string = string2;
        }
        return applicationInfoHelper.getApplicationDetails(string);
    }

    @NotNull
    public final List<ApplicationDetail> getInstalledApplications() {
        List list = this.context.getPackageManager().getInstalledPackages(0);
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"context.packageManager.getInstalledPackages(0)");
        Iterable iterable = list;
        Object object = iterable;
        iterable = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = object.next();
            object2 = (PackageInfo)object2;
            Iterable iterable2 = iterable;
            Object object3 = object2;
            Intrinsics.checkExpressionValueIsNotNull(object3, (String)"it");
            object2 = this.packageInfoToApplicationDetail((PackageInfo)object3);
            iterable2.add(object2);
        }
        return (List)iterable;
    }

    /*
     * WARNING - void declaration
     */
    private final ApplicationDetail packageInfoToApplicationDetail(PackageInfo info) {
        void var1_1;
        String string = info.packageName;
        String string2 = info.versionName;
        String string3 = info.packageName;
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"info.packageName");
        String string4 = this.getInstallerPackageName(string3);
        Long l2 = info.firstInstallTime;
        Long l3 = info.lastUpdateTime;
        String string5 = ((Object)this.context.getPackageManager().getApplicationLabel(info.applicationInfo)).toString();
        String string6 = info.packageName;
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"info.packageName");
        List<String> list = this.getApplicationSignature(string6);
        String string7 = var1_1.packageName;
        Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"info.packageName");
        return new ApplicationDetail(string, string2, string4, l2, l3, string5, list, this.isAppHidden(string7));
    }

    @NotNull
    public final String getInstallerPackageName(@NotNull String packageName) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)packageName, (String)"packageName");
        try {
            String string2 = this.context.getPackageManager().getInstallerPackageName(string);
            if (string2 == null) {
                string2 = INSTALLER_DIRECT;
            }
            string = string2;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Plog.INSTANCE.warn("Utils", "Error getting installer source. Setting installer to direct", new Pair[0]);
            string = INSTALLER_DIRECT;
        }
        return string;
    }

    @NotNull
    public static /* synthetic */ String getInstallerPackageName$default(ApplicationInfoHelper applicationInfoHelper, String string, int n2, Object object) {
        if ((n2 & 1) != 0) {
            String string2 = applicationInfoHelper.context.getPackageName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"context.packageName");
            string = string2;
        }
        return applicationInfoHelper.getInstallerPackageName(string);
    }

    public final boolean isAppHidden(@NotNull String packageName) {
        List list3;
        Intrinsics.checkParameterIsNotNull((Object)packageName, (String)"packageName");
        PackageManager packageManager = this.context.getPackageManager();
        Intent intent = new Intent();
        intent.addCategory("android.intent.category.LAUNCHER");
        intent.setPackage((String)((Object)list3));
        try {
            List list2 = packageManager.queryIntentActivities(intent, 131584);
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"pm.queryIntentActivities\u2026PackageManager.MATCH_ALL)");
            list3 = list2;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        if (list3 == null || list3.isEmpty()) {
            return true;
        }
        for (List list3 : list3) {
            if (!Intrinsics.areEqual((Object)((ResolveInfo)list3).activityInfo.packageName, (Object)this.context.getPackageName())) continue;
            String string = ((ResolveInfo)list3).activityInfo.packageName;
            String string2 = ((ResolveInfo)list3).activityInfo.name;
            int n2 = this.context.getPackageManager().getComponentEnabledSetting(new ComponentName(string, string2));
            if (n2 == 0) {
                ActivityInfo activityInfo = ((ResolveInfo)list3).activityInfo;
                Intrinsics.checkExpressionValueIsNotNull((Object)activityInfo, (String)"resolveInfo.activityInfo");
                return !activityInfo.isEnabled();
            }
            if (2 == n2) {
                return true;
            }
            if (4 != n2) continue;
            return true;
        }
        return false;
    }

    public static /* synthetic */ boolean isAppHidden$default(ApplicationInfoHelper applicationInfoHelper, String string, int n2, Object object) {
        if ((n2 & 1) != 0) {
            String string2 = applicationInfoHelper.context.getPackageName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"context.packageName");
            string = string2;
        }
        return applicationInfoHelper.isAppHidden(string);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getApplicationSignature(@NotNull String packageName) {
        Intrinsics.checkParameterIsNotNull((Object)packageName, (String)"packageName");
        try {
            Object object;
            if (Build.VERSION.SDK_INT >= 28) {
                List list;
                MessageDigest messageDigest;
                Object object2;
                Signature[] signatureArray;
                object = this.context.getPackageManager().getPackageInfo((String)packageName, (int)0x8000000).signingInfo;
                if (this.context.getPackageManager().getPackageInfo((String)packageName, (int)0x8000000).signingInfo.hasMultipleSigners()) {
                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"sig");
                    Signature[] signatureArray2 = object.getApkContentsSigners();
                    Intrinsics.checkExpressionValueIsNotNull((Object)signatureArray2, (String)"sig.apkContentsSigners");
                    object = signatureArray2;
                    signatureArray = signatureArray2;
                    object = new ArrayList(((Signature[])object).length);
                    for (Object object3 : signatureArray) {
                        object2 = object;
                        messageDigest = MessageDigest.getInstance("SHA");
                        messageDigest.update(object3.toByteArray());
                        byte[] byArray = messageDigest.digest();
                        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"digest.digest()");
                        String string = UtilsKt.bytesToHex(byArray);
                        if (string == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string2 = string.toUpperCase();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toUpperCase()");
                        object3 = string2;
                        object2.add(object3);
                    }
                    list = (List)object;
                } else {
                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"sig");
                    Signature[] signatureArray3 = object.getSigningCertificateHistory();
                    Intrinsics.checkExpressionValueIsNotNull((Object)signatureArray3, (String)"sig.signingCertificateHistory");
                    object = signatureArray3;
                    signatureArray = signatureArray3;
                    object = new ArrayList(((Signature[])object).length);
                    for (Object object3 : signatureArray) {
                        object2 = object;
                        messageDigest = MessageDigest.getInstance("SHA");
                        messageDigest.update(object3.toByteArray());
                        byte[] byArray = messageDigest.digest();
                        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"digest.digest()");
                        String string = UtilsKt.bytesToHex(byArray);
                        if (string == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string3 = string.toUpperCase();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toUpperCase()");
                        object3 = string3;
                        object2.add(object3);
                    }
                    list = (List)object;
                }
                object = list;
            } else {
                Signature[] signatureArray = this.context.getPackageManager().getPackageInfo((String)packageName, (int)64).signatures;
                Intrinsics.checkExpressionValueIsNotNull((Object)this.context.getPackageManager().getPackageInfo((String)packageName, (int)64).signatures, (String)"sig");
                object = signatureArray;
                Signature[] signatureArray4 = signatureArray;
                object = new ArrayList(((Signature[])object).length);
                for (Object object4 : signatureArray4) {
                    Object object5 = object;
                    MessageDigest messageDigest = MessageDigest.getInstance("SHA");
                    messageDigest.update(object4.toByteArray());
                    byte[] byArray = messageDigest.digest();
                    Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"digest.digest()");
                    String string = UtilsKt.bytesToHex(byArray);
                    if (string == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string4 = string.toUpperCase();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toUpperCase()");
                    object4 = string4;
                    object5.add(object4);
                }
                object = (List)object;
            }
            return object;
        }
        catch (Exception exception) {
            void var1_1;
            Plog.INSTANCE.warn("Failed to get App signature of " + (String)var1_1 + ". ", (Throwable)exception, new Pair[0]);
            return CollectionsKt.emptyList();
        }
    }

    @NotNull
    public static /* synthetic */ List getApplicationSignature$default(ApplicationInfoHelper applicationInfoHelper, String string, int n2, Object object) {
        if ((n2 & 1) != 0) {
            String string2 = applicationInfoHelper.context.getPackageName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"context.packageName");
            string = string2;
        }
        return applicationInfoHelper.getApplicationSignature(string);
    }

    public final boolean isFreshInstall() {
        boolean bl;
        try {
            PackageInfo packageInfo = this.context.getPackageManager().getPackageInfo(this.context.getPackageName(), 0);
            long l2 = packageInfo.firstInstallTime;
            long l3 = packageInfo.lastUpdateTime;
            bl = l2 == l3;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            bl = true;
        }
        return bl;
    }

    @Nullable
    public final String getAppStandByBucket() {
        String string;
        try {
            String string2;
            if (Build.VERSION.SDK_INT >= 28) {
                Object object = this.context.getSystemService("usagestats");
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type android.app.usage.UsageStatsManager");
                }
                switch (((UsageStatsManager)object).getAppStandbyBucket()) {
                    case 5: {
                        string2 = "EXEMPTED";
                        break;
                    }
                    case 10: {
                        string2 = "ACTIVE";
                        break;
                    }
                    case 20: {
                        string2 = "WORKING_SET";
                        break;
                    }
                    case 30: {
                        string2 = "FREQUENT";
                        break;
                    }
                    case 40: {
                        string2 = "RARE";
                        break;
                    }
                    case 50: {
                        string2 = "NEVER";
                        break;
                    }
                    default: {
                        string2 = null;
                        break;
                    }
                }
            } else {
                string2 = null;
            }
            string = string2;
        }
        catch (Exception exception) {
            string = null;
        }
        return string;
    }

    public final int getHostingApplicationVersionCode() {
        return this.context.getPackageManager().getPackageInfo((String)this.context.getPackageName(), (int)0).versionCode;
    }

    /*
     * WARNING - void declaration
     */
    @Inject
    public ApplicationInfoHelper(@NotNull Context context) {
        void var1_1;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = var1_1;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/hengam/lib/utils/ApplicationInfoHelper$Companion;", "", "()V", "INSTALLER_DIRECT", "", "core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

