/*
 * Decompiled with CFR 0.152.
 */
package io.hengam.lib.messaging.fcm;

import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.InstanceIdResult;
import io.hengam.lib.internal.SchedulersKt;
import io.hengam.lib.messaging.fcm.FcmTokenException;
import io.hengam.lib.messaging.fcm.TokenState;
import io.hengam.lib.messaging.fcm.i;
import io.hengam.lib.utils.HengamAssertsKt;
import io.hengam.lib.utils.HengamStorage;
import io.hengam.lib.utils.PersistedItem;
import io.hengam.lib.utils.log.LogLevel;
import io.hengam.lib.utils.log.Plog;
import io.hengam.lib.utils.rx.BehaviorRelay;
import io.reactivex.Observable;
import io.reactivex.Single;
import io.reactivex.SingleEmitter;
import io.reactivex.SingleOnSubscribe;
import java.io.IOException;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010 \u001a\u00020!J\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00160#J\u0006\u0010$\u001a\u00020!J\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00160&J\u001a\u0010'\u001a\u00020!2\u0006\u0010\u0017\u001a\u00020\u00162\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR+\u0010\f\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\r\u0010\n\"\u0004\b\u000e\u0010\u000fR+\u0010\u0012\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b8F@BX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\u0011\u001a\u0004\b\u0013\u0010\n\"\u0004\b\u0014\u0010\u000fR+\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\u00168F@BX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\u0011\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001c\u0010\u001d\u001a\u0010\u0012\f\u0012\n \u001f*\u0004\u0018\u00010\u00160\u00160\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lio/hengam/lib/messaging/fcm/FcmTokenStore;", "", "fcmServiceManager", "Lio/hengam/lib/messaging/fcm/FcmServiceManager;", "hengamStorage", "Lio/hengam/lib/utils/HengamStorage;", "(Lio/hengam/lib/messaging/fcm/FcmServiceManager;Lio/hengam/lib/utils/HengamStorage;)V", "instanceId", "", "getInstanceId", "()Ljava/lang/String;", "<set-?>", "storedInstanceId", "getStoredInstanceId", "setStoredInstanceId", "(Ljava/lang/String;)V", "storedInstanceId$delegate", "Lio/hengam/lib/utils/PersistedItem;", "token", "getToken", "setToken", "token$delegate", "Lio/hengam/lib/messaging/fcm/TokenState;", "tokenState", "getTokenState", "()Lio/hengam/lib/messaging/fcm/TokenState;", "setTokenState", "(Lio/hengam/lib/messaging/fcm/TokenState;)V", "tokenState$delegate", "tokenStateRelay", "Lio/hengam/lib/utils/rx/BehaviorRelay;", "kotlin.jvm.PlatformType", "invalidateToken", "", "observeTokenState", "Lio/reactivex/Observable;", "refreshFirebaseToken", "revalidateTokenState", "Lio/reactivex/Single;", "updateToken", "core_release"})
public final class FcmTokenStore {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    private final PersistedItem token$delegate;
    @NotNull
    private final PersistedItem tokenState$delegate;
    private final BehaviorRelay<TokenState> tokenStateRelay;
    private final PersistedItem storedInstanceId$delegate;
    private final i fcmServiceManager;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(FcmTokenStore.class), "token", "getToken()Ljava/lang/String;")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(FcmTokenStore.class), "tokenState", "getTokenState()Lio/hengam/lib/messaging/fcm/TokenState;")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(FcmTokenStore.class), "storedInstanceId", "getStoredInstanceId()Ljava/lang/String;"))};
    }

    @NotNull
    public final String getToken() {
        return (String)this.token$delegate.getValue(this, $$delegatedProperties[0]);
    }

    /*
     * WARNING - void declaration
     */
    private final void setToken(String string) {
        void var1_1;
        this.token$delegate.setValue(this, $$delegatedProperties[0], var1_1);
    }

    @NotNull
    public final TokenState getTokenState() {
        return (TokenState)((Object)this.tokenState$delegate.getValue(this, $$delegatedProperties[1]));
    }

    /*
     * WARNING - void declaration
     */
    private final void setTokenState(TokenState tokenState) {
        void var1_1;
        this.tokenState$delegate.setValue(this, $$delegatedProperties[1], var1_1);
    }

    private final String getStoredInstanceId() {
        return (String)this.storedInstanceId$delegate.getValue(this, $$delegatedProperties[2]);
    }

    /*
     * WARNING - void declaration
     */
    private final void setStoredInstanceId(String string) {
        void var1_1;
        this.storedInstanceId$delegate.setValue(this, $$delegatedProperties[2], var1_1);
    }

    @NotNull
    public final String getInstanceId() {
        CharSequence charSequence = this.getStoredInstanceId();
        if (!StringsKt.isBlank((CharSequence)charSequence)) {
            return charSequence;
        }
        FirebaseInstanceId firebaseInstanceId = this.fcmServiceManager.b();
        String string = firebaseInstanceId != null ? firebaseInstanceId.getId() : null;
        charSequence = string;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            this.setStoredInstanceId(string);
        }
        return this.getStoredInstanceId();
    }

    /*
     * WARNING - void declaration
     */
    public final void updateToken(@NotNull TokenState tokenState, @Nullable String token) {
        void var1_1;
        Intrinsics.checkParameterIsNotNull((Object)((Object)tokenState), (String)"tokenState");
        if (token != null) {
            void var2_2;
            this.setToken((String)var2_2);
        }
        this.setTokenState(tokenState);
        this.tokenStateRelay.accept((Object)var1_1);
    }

    public static /* synthetic */ void updateToken$default(FcmTokenStore fcmTokenStore, TokenState tokenState, String string, int n2, Object object) {
        if ((n2 & 2) != 0) {
            string = null;
        }
        fcmTokenStore.updateToken(tokenState, string);
    }

    @NotNull
    public final Single<TokenState> revalidateTokenState() {
        HengamAssertsKt.assertCpuThread();
        if (!this.fcmServiceManager.b) {
            Single single = Single.just((Object)((Object)TokenState.UNAVAILABLE));
            Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"Single.just(TokenState.UNAVAILABLE)");
            return single;
        }
        if (this.fcmServiceManager.c == null) {
            Single single = Single.just((Object)((Object)TokenState.UNAVAILABLE));
            Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"Single.just(TokenState.UNAVAILABLE)");
            return single;
        }
        Single single = Single.create((SingleOnSubscribe)new SingleOnSubscribe<T>(){

            /*
             * WARNING - void declaration
             */
            public final void subscribe(@NotNull SingleEmitter<TokenState> emitter) {
                Intrinsics.checkParameterIsNotNull(emitter, (String)"emitter");
                FirebaseInstanceId firebaseInstanceId = fcmServiceManager.b();
                if (firebaseInstanceId != null && (firebaseInstanceId = firebaseInstanceId.getInstanceId()) != null) {
                    void var1_1;
                    firebaseInstanceId.addOnCompleteListener((OnCompleteListener)new OnCompleteListener<InstanceIdResult>((SingleEmitter)var1_1){
                        final /* synthetic */ SingleEmitter b;

                        /*
                         * WARNING - void declaration
                         */
                        public final void onComplete(@NotNull Task<InstanceIdResult> task) {
                            void var1_1;
                            Intrinsics.checkParameterIsNotNull(task, (String)"task");
                            if (!task.isSuccessful()) {
                                if (task.getException() instanceof IOException) {
                                    Exception exception = task.getException();
                                    if (Intrinsics.areEqual((Object)(exception != null ? exception.getMessage() : null), (Object)"SERVICE_NOT_AVAILABLE")) {
                                        this.b.onSuccess((Object)this.getTokenState());
                                        return;
                                    }
                                }
                                this.b.tryOnError((Throwable)new FcmTokenException("Request for Fcm InstanceId and Token failed", task.getException()));
                                return;
                            }
                            SchedulersKt.cpuThread((Function0<Unit>)((Function0)new Function0<Unit>((Task)var1_1){
                                final /* synthetic */ Task b;

                                public final /* synthetic */ Object invoke() {
                                    1 var1_1 = this;
                                    Task task = var1_1.b;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)task, (String)"task");
                                    InstanceIdResult instanceIdResult = (InstanceIdResult)task.getResult();
                                    if (instanceIdResult == null) {
                                        b.tryOnError((Throwable)new FcmTokenException("null token received from FCM"));
                                    } else if (StringsKt.isBlank((CharSequence)var1_1.this.getToken())) {
                                        Plog.INSTANCE.getInfo().message("FCM token obtained").withTag(new String[]{"FCM"}).withData("Token", (Object)instanceIdResult.getToken()).useLogCatLevel(LogLevel.DEBUG).log();
                                        var1_1.this.updateToken(TokenState.GENERATED, instanceIdResult.getToken());
                                        b.onSuccess((Object)TokenState.GENERATED);
                                    } else if (Intrinsics.areEqual((Object)instanceIdResult.getToken(), (Object)var1_1.this.getToken()) ^ true) {
                                        Plog.INSTANCE.warn("FCM", "The saved FCM token has been invalidated, using new token", new Pair[]{TuplesKt.to((Object)"Old Token", (Object)var1_1.this.getToken()), TuplesKt.to((Object)"New Token", (Object)instanceIdResult.getToken())});
                                        var1_1.this.updateToken(TokenState.GENERATED, instanceIdResult.getToken());
                                        b.onSuccess((Object)TokenState.GENERATED);
                                    } else {
                                        b.onSuccess((Object)var1_1.this.getTokenState());
                                    }
                                    return Unit.INSTANCE;
                                }
                                {
                                    this.b = task;
                                    super(0);
                                }
                            }));
                        }
                        {
                            this.b = singleEmitter;
                        }
                    });
                    return;
                }
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"Single.create<TokenState\u2026}\n            }\n        }");
        return single;
    }

    @NotNull
    public final Observable<TokenState> observeTokenState() {
        if (!this.tokenStateRelay.hasValue()) {
            this.tokenStateRelay.accept((Object)TokenState.NO_TOKEN);
        }
        return (Observable)this.tokenStateRelay;
    }

    public final void refreshFirebaseToken() {
        HengamAssertsKt.assertCpuThread();
        FirebaseInstanceId firebaseInstanceId = this.fcmServiceManager.b();
        if (firebaseInstanceId != null && (firebaseInstanceId = firebaseInstanceId.getInstanceId()) != null) {
            firebaseInstanceId.addOnCompleteListener((OnCompleteListener)new OnCompleteListener<InstanceIdResult>(){

                /*
                 * WARNING - void declaration
                 */
                public final void onComplete(@NotNull Task<InstanceIdResult> result) {
                    void var1_1;
                    Intrinsics.checkParameterIsNotNull(result, (String)"result");
                    SchedulersKt.cpuThread((Function0<Unit>)((Function0)new Function0<Unit>((Task)var1_1){
                        final /* synthetic */ Task b;

                        public final /* synthetic */ Object invoke() {
                            1 var1_1 = this;
                            Task task = var1_1.b;
                            Intrinsics.checkExpressionValueIsNotNull((Object)task, (String)"result");
                            if (task.getException() != null) {
                                Task task2 = var1_1.b;
                                Intrinsics.checkExpressionValueIsNotNull((Object)task2, (String)"result");
                                Plog.INSTANCE.error("FCM", (Throwable)new FcmTokenException("Error receiving FCM token", task2.getException()), new Pair[0]);
                            } else {
                                Task task3 = var1_1.b;
                                Intrinsics.checkExpressionValueIsNotNull((Object)task3, (String)"result");
                                InstanceIdResult instanceIdResult = (InstanceIdResult)task3.getResult();
                                String string = instanceIdResult != null ? instanceIdResult.getToken() : null;
                                if (string == null) {
                                    Plog.INSTANCE.error("FCM", "Null token received from FCM", new Pair[0]);
                                } else if (Intrinsics.areEqual((Object)var1_1.this.getToken(), (Object)string) ^ true) {
                                    Plog.INSTANCE.info("FCM", "New FCM token received", new Pair[]{TuplesKt.to((Object)"Token", (Object)string), TuplesKt.to((Object)"Old Token", (Object)var1_1.this.getToken())});
                                    var1_1.this.updateToken(TokenState.GENERATED, string);
                                }
                            }
                            return Unit.INSTANCE;
                        }
                        {
                            this.b = task;
                            super(0);
                        }
                    }));
                }
            });
            return;
        }
    }

    public final void invalidateToken() {
        this.updateToken(TokenState.NO_TOKEN, "");
        this.refreshFirebaseToken();
    }

    /*
     * WARNING - void declaration
     */
    @Inject
    public FcmTokenStore(@NotNull i fcmServiceManager, @NotNull HengamStorage hengamStorage) {
        void var2_2;
        void var1_1;
        Intrinsics.checkParameterIsNotNull((Object)fcmServiceManager, (String)"fcmServiceManager");
        Intrinsics.checkParameterIsNotNull((Object)hengamStorage, (String)"hengamStorage");
        this.fcmServiceManager = var1_1;
        this.token$delegate = hengamStorage.storedString("fcm_token", "");
        this.tokenState$delegate = hengamStorage.storedObject("fcm_token_state", TokenState.NO_TOKEN, TokenState.class);
        BehaviorRelay behaviorRelay = BehaviorRelay.create();
        Intrinsics.checkExpressionValueIsNotNull((Object)behaviorRelay, (String)"BehaviorRelay.create<TokenState>()");
        this.tokenStateRelay = behaviorRelay;
        this.storedInstanceId$delegate = var2_2.storedString("fcm_instance_id", "");
    }

    public static final /* synthetic */ TokenState access$getTokenState$p(FcmTokenStore $this) {
        return $this.getTokenState();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setTokenState$p(FcmTokenStore $this, TokenState tokenState) {
        void var1_1;
        $this.setTokenState((TokenState)var1_1);
    }

    public static final /* synthetic */ String access$getToken$p(FcmTokenStore $this) {
        return $this.getToken();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setToken$p(FcmTokenStore $this, String string) {
        void var1_1;
        $this.setToken((String)var1_1);
    }
}

