/*
 * Decompiled with CFR 0.152.
 */
package io.hengam.lib.internal.task;

import android.content.Context;
import androidx.work.Data;
import androidx.work.ListenableWorker;
import androidx.work.RxWorker;
import androidx.work.WorkerParameters;
import io.hengam.lib.internal.SchedulersKt;
import io.hengam.lib.internal.task.HengamTask;
import io.hengam.lib.internal.task.HengamTaskPerformer;
import io.hengam.lib.utils.HengamAssertsKt;
import io.hengam.lib.utils.PersistedMap;
import io.hengam.lib.utils.TimeKt;
import io.hengam.lib.utils.TimeUtils;
import io.hengam.lib.utils.log.LogLevel;
import io.hengam.lib.utils.log.Plog;
import io.reactivex.Scheduler;
import io.reactivex.Single;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import java.util.Map;
import java.util.concurrent.Callable;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.reflect.full.KClasses;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0014J\b\u0010\u0016\u001a\u00020\bH\u0002J\b\u0010\u0017\u001a\u00020\bH\u0002R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\tR!\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lio/hengam/lib/internal/task/HengamTaskPerformer;", "Landroidx/work/RxWorker;", "context", "Landroid/content/Context;", "workerParams", "Landroidx/work/WorkerParameters;", "(Landroid/content/Context;Landroidx/work/WorkerParameters;)V", "isFinalAttempt", "", "()Z", "taskLastRunTimes", "Lio/hengam/lib/utils/PersistedMap;", "", "getTaskLastRunTimes", "()Lio/hengam/lib/utils/PersistedMap;", "taskLastRunTimes$delegate", "Lkotlin/Lazy;", "createWork", "Lio/reactivex/Single;", "Landroidx/work/ListenableWorker$Result;", "getBackgroundScheduler", "Lio/reactivex/Scheduler;", "isPeriodicTask", "shouldSkipPeriodicTaskExecution", "core_release"})
public final class HengamTaskPerformer
extends RxWorker {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final Lazy taskLastRunTimes$delegate;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(HengamTaskPerformer.class), "taskLastRunTimes", "getTaskLastRunTimes()Lio/hengam/lib/utils/PersistedMap;"))};
    }

    private final PersistedMap<Long> getTaskLastRunTimes() {
        return (PersistedMap)this.taskLastRunTimes$delegate.getValue();
    }

    public final boolean isFinalAttempt() {
        int n2 = this.getInputData().getInt("%max_attempts_count", -1);
        return n2 == -1 || this.getRunAttemptCount() == n2 - 1;
    }

    @NotNull
    public final Single<ListenableWorker.Result> createWork() {
        Object object;
        Map map;
        HengamTask hengamTask;
        Object object2;
        String string = this.getInputData().getString("%task_class_name");
        if (string == null) {
            Plog.INSTANCE.error("Task", "Task className was not provided in periodic task input data", new Pair[0]);
            Single single = Single.just((Object)ListenableWorker.Result.failure());
            Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"Single.just(Result.failure())");
            return single;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"inputData.getString(Heng\u2026sult.failure())\n        }");
        Object object3 = string;
        try {
            Class<?> clazz = Class.forName((String)object3);
            Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"Class.forName(taskClassName)");
            object2 = JvmClassMappingKt.getKotlinClass(clazz);
            if (!KClasses.isSubclassOf((KClass)object2, (KClass)Reflection.getOrCreateKotlinClass(HengamTask.class))) {
                Plog.INSTANCE.error("Task", "Provided task class was not a hengam task class", new Pair[]{TuplesKt.to((Object)"Class Name", (Object)object3)});
                Single single = Single.just((Object)ListenableWorker.Result.failure());
                Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"Single.just(Result.failure())");
                return single;
            }
            Object object4 = KClasses.createInstance((KClass)object2);
            if (object4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type io.hengam.lib.internal.task.HengamTask");
            }
            hengamTask = (HengamTask)object4;
        }
        catch (Exception exception) {
            Plog.INSTANCE.error("Task", "Unable to instantiate provided task class", new Pair[]{TuplesKt.to((Object)"Class Name", (Object)object3)});
            Single single = Single.just((Object)ListenableWorker.Result.failure());
            Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"Single.just(Result.failure())");
            return single;
        }
        String string2 = this.getInputData().getString("%task_id");
        if (string2 == null) {
            string2 = object3;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"inputData.getString(Heng\u2026TASK_ID) ?: taskClassName");
        object2 = string2;
        if (this.isPeriodicTask()) {
            String string3 = this.getInputData().getString("%task_id");
            if (string3 == null) {
                Plog.INSTANCE.error("Task", "Task name was not provided in periodic task input data", new Pair[0]);
                Single single = Single.just((Object)ListenableWorker.Result.failure());
                Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"Single.just(Result.failure())");
                return single;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"inputData.getString(Heng\u2026.failure())\n            }");
            object3 = string3;
            if (this.shouldSkipPeriodicTaskExecution()) {
                Single single = Single.just((Object)ListenableWorker.Result.success());
                Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"Single.just(Result.success())");
                return single;
            }
            map = this.getTaskLastRunTimes();
            object = TimeUtils.INSTANCE.nowMillis();
            map.put(object3, object);
        }
        Data data = this.getInputData();
        Intrinsics.checkExpressionValueIsNotNull((Object)data, (String)"inputData");
        Map map2 = data.getKeyValueMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)map2, (String)"inputData.keyValueMap");
        object3 = MapsKt.toMutableMap((Map)map2);
        map = object3;
        object = "%task_retry_count";
        Integer n2 = this.getRunAttemptCount();
        map.put(object, n2);
        Data data2 = new Data.Builder().putAll((Map)object3).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)data2, (String)"Data.Builder().putAll(dataMap).build()");
        map = data2;
        Single single = Single.fromCallable((Callable)new Callable<T>(this, (String)object2, hengamTask, (Data)map){
            final /* synthetic */ HengamTaskPerformer this$0;
            final /* synthetic */ String $taskId;
            final /* synthetic */ HengamTask $performer;
            final /* synthetic */ Data $data;

            @NotNull
            public final Single<ListenableWorker.Result> call() {
                Plog.INSTANCE.trace("Task", "Task " + this.$taskId + " started", new Pair[]{TuplesKt.to((Object)"Work Id", (Object)this.this$0.getId().toString()), TuplesKt.to((Object)"Attempt", (Object)(this.this$0.getRunAttemptCount() + 1))});
                return this.$performer.perform(this.$data);
            }
            {
                this.this$0 = hengamTaskPerformer;
                this.$taskId = string;
                this.$performer = hengamTask;
                this.$data = data;
            }
        }).flatMap((Function)createWork.2.INSTANCE).observeOn(SchedulersKt.cpuThread()).doOnError((Consumer)new Consumer<Throwable>((String)object2){
            final /* synthetic */ String $taskId;

            /*
             * WARNING - void declaration
             */
            public final void accept(Throwable it) {
                void var1_1;
                Plog.INSTANCE.error("Task", "Error occurred in task " + this.$taskId, (Throwable)var1_1, new Pair[0]);
            }
            {
                this.$taskId = string;
            }
        }).onErrorReturn((Function)createWork.4.INSTANCE).map(new Function<T, R>(this, hengamTask){
            final /* synthetic */ HengamTaskPerformer this$0;
            final /* synthetic */ HengamTask $performer;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final ListenableWorker.Result apply(@NotNull ListenableWorker.Result result) {
                void var1_1;
                Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
                HengamAssertsKt.assertCpuThread();
                if (Intrinsics.areEqual((Object)result, (Object)ListenableWorker.Result.retry()) && this.this$0.getInputData().getInt("%max_attempts_count", -1) != -1 && this.this$0.getRunAttemptCount() + 2 >= this.this$0.getInputData().getInt("%max_attempts_count", -1)) {
                    Data data = this.this$0.getInputData();
                    Intrinsics.checkExpressionValueIsNotNull((Object)data, (String)"inputData");
                    this.$performer.onMaximumRetriesReached(data);
                    return ListenableWorker.Result.failure();
                }
                return var1_1;
            }
            {
                this.this$0 = hengamTaskPerformer;
                this.$performer = hengamTask;
            }
        }).doOnSuccess((Consumer)new Consumer<ListenableWorker.Result>(this, (String)object2){
            final /* synthetic */ HengamTaskPerformer this$0;
            final /* synthetic */ String $taskId;

            public final void accept(ListenableWorker.Result result) {
                String string;
                string = result instanceof ListenableWorker.Result.Retry ? "Retry" : (string instanceof ListenableWorker.Result.Failure ? "Failure" : (string instanceof ListenableWorker.Result.Success ? "Success" : "Unknown"));
                Plog.INSTANCE.trace("Task", "Task " + this.$taskId + " finished with result " + string, new Pair[]{TuplesKt.to((Object)"Id", (Object)this.this$0.getId().toString())});
            }
            {
                this.this$0 = hengamTaskPerformer;
                this.$taskId = string;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)single, (String)"Single.fromCallable {\n  \u2026toString())\n            }");
        return single;
    }

    private final boolean isPeriodicTask() {
        Data data = this.getInputData();
        Intrinsics.checkExpressionValueIsNotNull((Object)data, (String)"inputData");
        Map map = data.getKeyValueMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)map, (String)"inputData.keyValueMap");
        Map map2 = map;
        String string = "%task_repeat_interval";
        return map2.containsKey(string);
    }

    private final boolean shouldSkipPeriodicTaskExecution() {
        String string = this.getInputData().getString("%task_id");
        Long l2 = (Long)((Map)this.getTaskLastRunTimes()).get(string);
        if (l2 != null) {
            long l3 = this.getInputData().getLong("%task_repeat_interval", -1L);
            long l4 = this.getInputData().getLong("%task_flexibility_time", -1L);
            if (l3 == -1L || l4 == -1L) {
                return false;
            }
            if (l3 - (TimeUtils.INSTANCE.nowMillis() - l2) > l4) {
                Plog.INSTANCE.getWarn().message("Skipping periodic task ".concat(String.valueOf(string))).withTag(new String[]{"Task"}).withData("Task name", (Object)string).withData("Repeat interval", (Object)l3).withData("Prev Collection", (Object)l2).useLogCatLevel(LogLevel.DEBUG).aggregate("skipping-periodic-tasks", TimeKt.millis((long)1000L), (Function1)shouldSkipPeriodicTaskExecution.1.INSTANCE).log();
                return true;
            }
        }
        return false;
    }

    @NotNull
    protected final Scheduler getBackgroundScheduler() {
        return SchedulersKt.cpuThread();
    }

    /*
     * WARNING - void declaration
     */
    public HengamTaskPerformer(@NotNull Context context, @NotNull WorkerParameters workerParams) {
        void var2_2;
        void var1_1;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)workerParams, (String)"workerParams");
        super((Context)var1_1, (WorkerParameters)var2_2);
        this.taskLastRunTimes$delegate = LazyKt.lazy((Function0)taskLastRunTimes.2.INSTANCE);
    }
}

