/*
 * Decompiled with CFR 0.152.
 */
package io.hengam.lib;

import android.os.Bundle;
import android.util.Base64;
import android.util.Log;
import io.hengam.lib.HengamManifestException;
import io.hengam.lib.utils.ApplicationInfoHelper;
import io.hengam.lib.utils.log.LogLevel;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 .2\u00020\u0001:\u0001.B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010&\u001a\u00020'J\u001f\u0010(\u001a\u0004\u0018\u00010\f2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u0006H\u0002\u00a2\u0006\u0002\u0010,J\b\u0010-\u001a\u00020'H\u0002R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\b\"\u0004\b\u0013\u0010\nR\u001e\u0010\u0014\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0019\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001e\u0010 \u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0019\u001a\u0004\b!\u0010\u0016\"\u0004\b\"\u0010\u0018R\u001c\u0010#\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\b\"\u0004\b%\u0010\n\u00a8\u0006/"}, d2={"Lio/hengam/lib/AppManifest;", "", "applicationInfoHelper", "Lio/hengam/lib/utils/ApplicationInfoHelper;", "(Lio/hengam/lib/utils/ApplicationInfoHelper;)V", "appId", "", "getAppId", "()Ljava/lang/String;", "setAppId", "(Ljava/lang/String;)V", "disableAdvertisementId", "", "getDisableAdvertisementId", "()Z", "setDisableAdvertisementId", "(Z)V", "fcmSenderId", "getFcmSenderId", "setFcmSenderId", "logDataEnabled", "getLogDataEnabled", "()Ljava/lang/Boolean;", "setLogDataEnabled", "(Ljava/lang/Boolean;)V", "Ljava/lang/Boolean;", "logLevel", "Lio/hengam/lib/utils/log/LogLevel;", "getLogLevel", "()Lio/hengam/lib/utils/log/LogLevel;", "setLogLevel", "(Lio/hengam/lib/utils/log/LogLevel;)V", "logTagsEnabled", "getLogTagsEnabled", "setLogTagsEnabled", "validator", "getValidator", "setValidator", "extractManifestData", "", "readBooleanValue", "bundle", "Landroid/os/Bundle;", "key", "(Landroid/os/Bundle;Ljava/lang/String;)Ljava/lang/Boolean;", "validateHengamPlusAppId", "Companion", "core_release"})
public final class AppManifest {
    @NotNull
    public String appId;
    @Nullable
    private String fcmSenderId;
    @Nullable
    private String validator;
    private boolean disableAdvertisementId;
    @Nullable
    private LogLevel logLevel;
    @Nullable
    private Boolean logDataEnabled;
    @Nullable
    private Boolean logTagsEnabled;
    private final ApplicationInfoHelper applicationInfoHelper;
    public static final a Companion = new a(0);

    @NotNull
    public final String getAppId() {
        String string = this.appId;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"appId");
        }
        return string;
    }

    @Nullable
    public final String getFcmSenderId() {
        return this.fcmSenderId;
    }

    public final boolean getDisableAdvertisementId() {
        return this.disableAdvertisementId;
    }

    @Nullable
    public final LogLevel getLogLevel() {
        return this.logLevel;
    }

    @Nullable
    public final Boolean getLogDataEnabled() {
        return this.logDataEnabled;
    }

    @Nullable
    public final Boolean getLogTagsEnabled() {
        return this.logTagsEnabled;
    }

    public final void extractManifestData() {
        LogLevel logLevel;
        CharSequence charSequence;
        String string;
        Bundle bundle = ApplicationInfoHelper.getManifestMetaData$default(this.applicationInfoHelper, null, 1, null);
        Object object = bundle != null ? bundle.getString("hengam_token", null) : null;
        if (object == null) {
            Log.w((String)"Hengam", (String)"Unable to find hengam_token in application manifest");
            throw (Throwable)new HengamManifestException("Unable to find hengam_token in application manifest");
        }
        if (StringsKt.isBlank((CharSequence)((CharSequence)object))) {
            Log.w((String)"Hengam", (String)"Invalid hengam_token provided in application manifest");
            throw (Throwable)new HengamManifestException("Invalid hengam_token provided in application manifest");
        }
        byte[] byArray = Base64.decode((String)object, (int)2);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"Base64.decode(encodedToken, Base64.NO_WRAP)");
        object = byArray;
        object = new String((byte[])object, Charsets.UTF_8);
        if (StringsKt.isBlank((CharSequence)((CharSequence)object))) {
            Log.w((String)"Hengam", (String)"Invalid hengam_token provided in application manifest");
            throw (Throwable)new HengamManifestException("Invalid hengam_token provided in application manifest");
        }
        object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])new String[]{"#", "-", "@"}, (boolean)false, (int)0, (int)6, null);
        System.out.println(object);
        if (!(object.size() >= 3 && new Regex(string = "^[a-zA-Z0-9.]+$").matches(charSequence = (CharSequence)object.get(0)) && new Regex(string = "^[a-z][a-z][a-z]$").matches(charSequence = (CharSequence)object.get(1)) && new Regex(string = "^[0-9]+$").matches(charSequence = (CharSequence)object.get(2)))) {
            throw (Throwable)new HengamManifestException("Invalid hengam_token provided in application manifest");
        }
        this.appId = (String)object.get(0);
        this.validator = (String)object.get(1);
        this.fcmSenderId = (String)object.get(2);
        this.validateHengamPlusAppId();
        Boolean bl = this.readBooleanValue(bundle, "hengam_disable_advertisement_id");
        this.disableAdvertisementId = bl != null ? bl : false;
        String string2 = bundle.getString("hengam_log_level", "");
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"bundle.getString(MANIFEST_KEY_LOG_LEVEL, \"\")");
        charSequence = string2;
        object = this;
        CharSequence charSequence2 = charSequence;
        if (charSequence2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = ((String)charSequence2).toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        switch (string3) {
            case "trace": {
                logLevel = LogLevel.TRACE;
                break;
            }
            case "debug": {
                logLevel = LogLevel.DEBUG;
                break;
            }
            case "info": {
                logLevel = LogLevel.INFO;
                break;
            }
            case "warn": {
                logLevel = LogLevel.WARN;
                break;
            }
            case "error": {
                logLevel = LogLevel.ERROR;
                break;
            }
            case "wtf": {
                logLevel = LogLevel.WTF;
                break;
            }
            default: {
                logLevel = null;
            }
        }
        ((AppManifest)object).logLevel = logLevel;
        this.logDataEnabled = this.readBooleanValue(bundle, "hengam_log_data_enabled");
        this.logTagsEnabled = this.readBooleanValue(bundle, "hengam_log_tags_enabled");
    }

    private final Boolean readBooleanValue(Bundle bundle, String key) {
        HengamManifestException hengamManifestException;
        Object object = bundle.get(key);
        hengamManifestException = new HengamManifestException("Invalid value for key '" + (String)((Object)hengamManifestException) + "' in manifest, should be either 'true' or 'false'");
        Object object2 = object;
        if (object2 instanceof Boolean) {
            return (Boolean)object;
        }
        if (object2 instanceof String) {
            boolean bl;
            String string = (String)object;
            if (string == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string2 = string.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
            object = string2;
            int n2 = -1;
            switch (string2.hashCode()) {
                case 48: {
                    if (!((String)object).equals("0")) break;
                    n2 = 1;
                    break;
                }
                case 49: {
                    if (!((String)object).equals("1")) break;
                    n2 = 2;
                    break;
                }
                case 3521: {
                    if (!((String)object).equals("no")) break;
                    n2 = 1;
                    break;
                }
                case 119527: {
                    if (!((String)object).equals("yes")) break;
                    n2 = 2;
                    break;
                }
                case 3569038: {
                    if (!((String)object).equals("true")) break;
                    n2 = 2;
                    break;
                }
                case 97196323: {
                    if (!((String)object).equals("false")) break;
                    n2 = 1;
                    break;
                }
            }
            switch (n2) {
                case 2: {
                    bl = true;
                    break;
                }
                case 1: {
                    bl = false;
                    break;
                }
                default: {
                    throw (Throwable)hengamManifestException;
                }
            }
            return bl;
        }
        if (object2 instanceof Integer) {
            boolean bl;
            if (Intrinsics.areEqual((Object)object, (Object)1)) {
                bl = true;
            } else if (Intrinsics.areEqual((Object)object, (Object)0)) {
                bl = false;
            } else {
                throw (Throwable)hengamManifestException;
            }
            return bl;
        }
        if (object2 == null) {
            return null;
        }
        throw (Throwable)hengamManifestException;
    }

    private final void validateHengamPlusAppId() {
        String string = this.appId;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"appId");
        }
        int n2 = string.length() / 3;
        StringBuilder stringBuilder = new StringBuilder("");
        Ref.IntRef intRef = new Ref.IntRef();
        for (int i2 = 0; i2 < 3; ++i2) {
            int n3;
            intRef.element = 0;
            int n4 = i2 * n2;
            if (i2 == 2) {
                String string2 = this.appId;
                if (string2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"appId");
                }
                n3 = string2.length();
            } else {
                n3 = (i2 + 1) * n2;
            }
            int n5 = n3;
            String string3 = this.appId;
            if (string3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"appId");
            }
            CharSequence charSequence = string3.subSequence(n4, n5);
            for (n5 = 0; n5 < charSequence.length(); ++n5) {
                char c2 = charSequence.charAt(n5);
                intRef.element += (byte)c2;
            }
            stringBuilder.append((char)(intRef.element % 26 + 97));
        }
        if (Intrinsics.areEqual((Object)stringBuilder.toString(), (Object)this.validator) ^ true) {
            throw (Throwable)new HengamManifestException("Provided token in the application manifest does not contain a valid appId");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Inject
    public AppManifest(@NotNull ApplicationInfoHelper applicationInfoHelper) {
        void var1_1;
        Intrinsics.checkParameterIsNotNull((Object)applicationInfoHelper, (String)"applicationInfoHelper");
        this.applicationInfoHelper = var1_1;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lio/hengam/lib/AppManifest$Companion;", "", "()V", "ALPHABET_COUNT", "", "APP_ID_VALIDATORS_COUNT", "FIRST_LETTER_CODE", "MANIFEST_KEY_DISABLE_ADVERTISEMENT_ID", "", "MANIFEST_KEY_HENGAM_TOKEN", "MANIFEST_KEY_LOG_DATA_ENABLED", "MANIFEST_KEY_LOG_LEVEL", "MANIFEST_KEY_LOG_TAGS_ENABLED", "core_release"})
    public static final class a {
        private a() {
        }

        public /* synthetic */ a(byte by) {
            this();
        }
    }
}

