/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.websocket;

public enum WsOpCode {
    CONTINUATION(0),
    TEXT(1),
    BINARY(2),
    CLOSE(8),
    PING(9),
    PONG(10);

    private static final WsOpCode[] OP_CODES;
    private final int code;

    private WsOpCode(int code) {
        this.code = code;
    }

    public static WsOpCode get(int code) {
        WsOpCode opCode = OP_CODES[code];
        if (opCode == null) {
            throw new IllegalArgumentException("Requested code " + code + " is invalid, there is no OpCode for it.");
        }
        return opCode;
    }

    public int code() {
        return this.code;
    }

    static {
        OP_CODES = new WsOpCode[16];
        WsOpCode[] wsOpCodeArray = WsOpCode.values();
        int n = wsOpCodeArray.length;
        for (int i = 0; i < n; ++i) {
            WsOpCode value;
            WsOpCode.OP_CODES[value.code] = value = wsOpCodeArray[i];
        }
    }
}

