/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.websocket;

import io.helidon.common.LazyValue;
import io.helidon.common.buffers.BufferData;
import io.helidon.common.buffers.DataReader;
import io.helidon.common.socket.SocketContext;
import io.helidon.websocket.AbstractWsFrame;
import io.helidon.websocket.WsCloseException;
import io.helidon.websocket.WsOpCode;
import java.nio.charset.StandardCharsets;

public final class ServerWsFrame
extends AbstractWsFrame {
    private static final System.Logger LOGGER = System.getLogger(ServerWsFrame.class.getName());

    ServerWsFrame(WsOpCode opCode, BufferData data, boolean fin, boolean isPayload) {
        super((LazyValue<BufferData>)LazyValue.create((Object)data), data.available(), fin, isPayload, opCode);
    }

    public static ServerWsFrame data(String text, boolean last) {
        BufferData bufferData = BufferData.create((byte[])text.getBytes(StandardCharsets.UTF_8));
        return new ServerWsFrame(WsOpCode.TEXT, bufferData, last, true);
    }

    public static ServerWsFrame data(BufferData bufferData, boolean last) {
        return new ServerWsFrame(WsOpCode.BINARY, bufferData, last, true);
    }

    public static ServerWsFrame control(WsOpCode opCode, BufferData bufferData) {
        if (bufferData.available() > 125) {
            throw new IllegalArgumentException("Control frames cannot have more than 125 bytes");
        }
        return new ServerWsFrame(opCode, bufferData, true, false);
    }

    public static ServerWsFrame read(SocketContext ctx, DataReader dataReader, int maxFrameLength) {
        AbstractWsFrame.FrameHeader header = ServerWsFrame.readFrameHeader(dataReader, maxFrameLength);
        if (header.masked()) {
            throw new WsCloseException("Masked server frame", 1002);
        }
        BufferData payload = ServerWsFrame.readPayload(dataReader, header);
        ServerWsFrame frame = new ServerWsFrame(header.opCode(), payload, header.fin(), ServerWsFrame.isPayload(header));
        if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
            ctx.log(LOGGER, System.Logger.Level.TRACE, "ws server frame recv %s", new Object[]{frame});
        }
        return frame;
    }

    @Override
    public boolean masked() {
        return false;
    }

    @Override
    public int[] maskingKey() {
        throw new IllegalStateException("Server WebSocket frames must not have masking key");
    }
}

