/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.testing.junit5;

import io.helidon.common.Builder;
import io.helidon.webclient.api.WebClient;
import io.helidon.webclient.http1.Http1Client;
import io.helidon.webserver.ListenerConfig;
import io.helidon.webserver.WebServerConfig;
import io.helidon.webserver.http.HttpRouting;
import io.helidon.webserver.http.HttpRules;
import io.helidon.webserver.spi.ServerFeature;
import io.helidon.webserver.testing.junit5.DirectClient;
import io.helidon.webserver.testing.junit5.DirectWebClient;
import io.helidon.webserver.testing.junit5.Junit5Util;
import io.helidon.webserver.testing.junit5.spi.DirectJunitExtension;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;

public class Http1DirectJunitExtension
implements DirectJunitExtension {
    private final Map<String, DirectClient> clients = new HashMap<String, DirectClient>();
    private final Map<String, DirectWebClient> webClients = new HashMap<String, DirectWebClient>();

    @Override
    public void afterAll(ExtensionContext context) {
        this.clients.values().forEach(DirectClient::close);
        this.webClients.values().forEach(DirectWebClient::close);
    }

    @Override
    public void beforeEach(ExtensionContext context) {
        this.clients.values().forEach(client -> client.clientTlsPrincipal(null).clientTlsCertificates(null).clientHost("helidon-unit").clientPort(65000).serverHost("helidon-unit-server").serverPort(8080));
        this.webClients.values().forEach(client -> client.clientTlsPrincipal(null).clientTlsCertificates(null).clientHost("helidon-unit").clientPort(65000).serverHost("helidon-unit-server").serverPort(8080));
    }

    @Override
    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Class<?> paramType = parameterContext.getParameter().getType();
        if (DirectClient.class.equals(paramType)) {
            return true;
        }
        if (Http1Client.class.equals(paramType)) {
            return true;
        }
        return WebClient.class.equals(paramType);
    }

    @Override
    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext, Class<?> paramType) {
        if (DirectClient.class.equals(paramType) || Http1Client.class.equals(paramType)) {
            String socketName = Junit5Util.socketName(parameterContext.getParameter());
            DirectClient directClient = this.clients.get(socketName);
            if (directClient == null) {
                if ("@default".equals(socketName)) {
                    throw new IllegalStateException("There is no default routing specified. Please add static method annotated with @SetUpRoute that accepts HttpRouting.Builder, or HttpRules");
                }
                throw new IllegalStateException("There is no routing specified for socket \"" + socketName + "\". Please add static method annotated with @SetUpRoute that accepts HttpRouting.Builder, or HttpRules, and add @Socket(\"" + socketName + "\") annotation to the parameter");
            }
            return directClient;
        }
        if (WebClient.class.equals(paramType)) {
            String socketName = Junit5Util.socketName(parameterContext.getParameter());
            WebClient directClient = this.webClients.get(socketName);
            if (directClient == null) {
                if ("@default".equals(socketName)) {
                    throw new IllegalStateException("There is no default routing specified. Please add static method annotated with @SetUpRoute that accepts HttpRouting.Builder, or HttpRules");
                }
                throw new IllegalStateException("There is no default routing specified for socket \"" + socketName + "\". Please add static method annotated with @SetUpRoute that accepts HttpRouting.Builder, or HttpRules, and add @Socket(\"" + socketName + "\") annotation to the parameter");
            }
            return directClient;
        }
        throw new ParameterResolutionException("Cannot resolve parameter: " + String.valueOf(parameterContext));
    }

    @Override
    public Optional<DirectJunitExtension.ParamHandler<?>> setUpRouteParamHandler(List<ServerFeature> features, Class<?> type) {
        if (HttpRouting.Builder.class.equals(type) || HttpRules.class.equals(type)) {
            return Optional.of(new RoutingParamHandler(this.clients, this.webClients, features));
        }
        return Optional.empty();
    }

    private static final class RoutingParamHandler
    implements DirectJunitExtension.ParamHandler<HttpRouting.Builder> {
        private final Map<String, DirectClient> clients;
        private final Map<String, DirectWebClient> webClients;
        private final List<ServerFeature> features;

        private RoutingParamHandler(Map<String, DirectClient> clients, Map<String, DirectWebClient> webClients, List<ServerFeature> features) {
            this.clients = clients;
            this.webClients = webClients;
            this.features = features;
        }

        @Override
        public HttpRouting.Builder get(String socketName) {
            return HttpRouting.builder();
        }

        @Override
        public void handle(Method method, String socketName, HttpRouting.Builder value) {
            HttpRouting routing = (HttpRouting)value.copy().build();
            routing.beforeStart();
            DirectFeatureContext featureContext = new DirectFeatureContext(socketName, value);
            for (ServerFeature feature : this.features) {
                feature.setup((ServerFeature.ServerFeatureContext)featureContext);
            }
            if (this.clients.putIfAbsent(socketName, new DirectClient(value)) != null) {
                throw new IllegalStateException("Method " + String.valueOf(method) + " defines HTTP routing for socket \"" + socketName + "\" that is already defined for class \"" + method.getDeclaringClass().getName() + "\".");
            }
            if (this.webClients.putIfAbsent(socketName, new DirectWebClient(value)) != null) {
                throw new IllegalStateException("Method " + String.valueOf(method) + " defines HTTP routing for socket \"" + socketName + "\" that is already defined for class \"" + method.getDeclaringClass().getName() + "\".");
            }
        }

        private static class DirectFeatureContext
        implements ServerFeature.ServerFeatureContext {
            private final String socketName;
            private final HttpRouting.Builder routing;

            DirectFeatureContext(String socketName, HttpRouting.Builder routing) {
                this.socketName = socketName;
                this.routing = routing;
            }

            public WebServerConfig serverConfig() {
                return WebServerConfig.create();
            }

            public Set<String> sockets() {
                return "@default".equals(this.socketName) ? Set.of() : Set.of(this.socketName);
            }

            public boolean socketExists(String socketName) {
                return socketName.equals(this.socketName);
            }

            public ServerFeature.SocketBuilders socket(String socketName) {
                if (!socketName.equals(this.socketName)) {
                    if ("@default".equals(socketName)) {
                        return this.defaultListener();
                    }
                    throw new NoSuchElementException("Socket " + socketName + " is not defined");
                }
                return new DirectSocketBuilders(this.routing);
            }

            private ServerFeature.SocketBuilders defaultListener() {
                if ("@default".equals(this.socketName)) {
                    return new DirectSocketBuilders(this.routing);
                }
                return new DirectSocketBuilders(HttpRouting.builder());
            }
        }
    }

    private static class DirectSocketBuilders
    implements ServerFeature.SocketBuilders {
        private final HttpRouting.Builder routing;

        DirectSocketBuilders(HttpRouting.Builder routing) {
            this.routing = routing;
        }

        public ListenerConfig listener() {
            return ListenerConfig.create();
        }

        public HttpRouting.Builder httpRouting() {
            return this.routing;
        }

        public ServerFeature.RoutingBuilders routingBuilders() {
            return new ServerFeature.RoutingBuilders(){

                public boolean hasRouting(Class<?> builderType) {
                    return false;
                }

                public <T extends Builder<T, ?>> T routingBuilder(Class<T> builderType) {
                    if (builderType == HttpRouting.Builder.class) {
                        return (T)((Builder)builderType.cast(routing));
                    }
                    throw new NoSuchElementException("Routing not available for type: " + String.valueOf(builderType));
                }
            };
        }
    }
}

