/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.testing.junit5;

import io.helidon.common.HelidonServiceLoader;
import io.helidon.common.config.GlobalConfig;
import io.helidon.common.context.Contexts;
import io.helidon.webserver.WebServer;
import io.helidon.webserver.WebServerConfig;
import io.helidon.webserver.spi.ServerFeature;
import io.helidon.webserver.testing.junit5.Junit5Util;
import io.helidon.webserver.testing.junit5.JunitExtensionBase;
import io.helidon.webserver.testing.junit5.RoutingTest;
import io.helidon.webserver.testing.junit5.SetUpRoute;
import io.helidon.webserver.testing.junit5.spi.DirectJunitExtension;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;

class HelidonRoutingJunitExtension
extends JunitExtensionBase
implements BeforeAllCallback,
AfterAllCallback,
InvocationInterceptor,
BeforeEachCallback,
AfterEachCallback,
ParameterResolver {
    private final List<DirectJunitExtension> extensions = HelidonServiceLoader.create(ServiceLoader.load(DirectJunitExtension.class)).asList();
    private WebServerConfig serverConfig;

    HelidonRoutingJunitExtension() {
    }

    public void beforeAll(ExtensionContext context) {
        super.beforeAll(context);
        Class testClass = context.getRequiredTestClass();
        super.testClass(testClass);
        RoutingTest testAnnot = testClass.getAnnotation(RoutingTest.class);
        if (testAnnot == null) {
            throw new IllegalStateException("Invalid test class for this extension: " + String.valueOf(testClass) + ", missing " + RoutingTest.class.getName() + " annotation");
        }
        WebServerConfig.Builder builder = (WebServerConfig.Builder)((WebServerConfig.Builder)WebServer.builder().config(GlobalConfig.config().get("server"))).host("localhost");
        this.extensions.forEach(it -> it.beforeAll(context));
        this.setupFeatures(builder);
        this.setupServer(builder);
        this.serverConfig = builder.buildPrototype();
        this.initRoutings();
    }

    @Override
    public void afterAll(ExtensionContext context) {
        this.extensions.forEach(it -> it.afterAll(context));
        super.afterAll(context);
    }

    public void beforeEach(ExtensionContext context) {
        this.extensions.forEach(it -> it.beforeAll(context));
    }

    public void afterEach(ExtensionContext context) {
        this.extensions.forEach(it -> it.afterEach(context));
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        for (DirectJunitExtension extension : this.extensions) {
            if (!extension.supportsParameter(parameterContext, extensionContext)) continue;
            return true;
        }
        Class<?> paramType = parameterContext.getParameter().getType();
        return Contexts.context().orElseGet(Contexts::globalContext).get(paramType).isPresent();
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Class<?> paramType = parameterContext.getParameter().getType();
        for (DirectJunitExtension extension : this.extensions) {
            if (!extension.supportsParameter(parameterContext, extensionContext)) continue;
            return extension.resolveParameter(parameterContext, extensionContext, paramType);
        }
        return Contexts.context().orElseGet(Contexts::globalContext).get(paramType).orElseThrow(() -> new ParameterResolutionException("Failed to resolve parameter of type " + paramType.getName()));
    }

    private void initRoutings() {
        List features = this.serverConfig.features();
        Junit5Util.withStaticMethods(this.testClass(), SetUpRoute.class, (setUpRoute, method) -> {
            String socketName = setUpRoute.value();
            SetUpRouteHandler methodConsumer = this.createRoutingMethodCall(features, (Method)method);
            methodConsumer.handle(socketName);
        });
    }

    private SetUpRouteHandler createRoutingMethodCall(List<ServerFeature> features, Method method) {
        ArrayList handlers = new ArrayList();
        for (Parameter parameter : method.getParameters()) {
            boolean found = false;
            for (DirectJunitExtension extension : this.extensions) {
                Optional<DirectJunitExtension.ParamHandler<?>> paramHandler = extension.setUpRouteParamHandler(features, parameter.getType());
                if (!paramHandler.isPresent()) continue;
                handlers.add(paramHandler.get());
                found = true;
                break;
            }
            if (found) continue;
            throw new IllegalArgumentException("Method " + String.valueOf(method) + " has a parameter " + String.valueOf(parameter.getType()) + " that is not supported by any available testing extension");
        }
        return socketName -> {
            int i;
            Object[] values = new Object[handlers.size()];
            for (i = 0; i < handlers.size(); ++i) {
                values[i] = ((DirectJunitExtension.ParamHandler)handlers.get(i)).get(socketName);
            }
            try {
                method.setAccessible(true);
                method.invoke(null, values);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalStateException("Cannot invoke @SetUpRoute method", e);
            }
            for (i = 0; i < values.length; ++i) {
                Object value = values[i];
                DirectJunitExtension.ParamHandler handler = (DirectJunitExtension.ParamHandler)handlers.get(i);
                handler.handle(method, socketName, value);
            }
        };
    }

    private static interface SetUpRouteHandler {
        public void handle(String var1);
    }
}

