/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.testing.junit5;

import io.helidon.common.buffers.DataReader;
import io.helidon.common.buffers.DataWriter;
import io.helidon.common.context.Context;
import io.helidon.common.socket.HelidonSocket;
import io.helidon.common.socket.PeerInfo;
import io.helidon.http.encoding.ContentEncodingContext;
import io.helidon.http.media.MediaContext;
import io.helidon.webserver.ConnectionContext;
import io.helidon.webserver.ListenerConfig;
import io.helidon.webserver.ListenerContext;
import io.helidon.webserver.Router;
import io.helidon.webserver.http.DirectHandlers;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

class DirectClientServerContext
implements ConnectionContext,
ListenerContext {
    private final DataReader serverReader;
    private final DataWriter serverWriter;
    private final ExecutorService executorService;
    private final Router router;
    private final HelidonSocket serverSocket;
    private final ListenerConfig listenerConfiguration;

    DirectClientServerContext(Router router, HelidonSocket serverSocket, DataReader serverReader, DataWriter serverWriter) {
        this.router = router;
        this.serverSocket = serverSocket;
        this.serverReader = serverReader;
        this.serverWriter = serverWriter;
        this.executorService = Executors.newThreadPerTaskExecutor(Thread.ofVirtual().name("direct-test-server", 1L).factory());
        PeerInfo peerInfo = serverSocket.localPeer();
        this.listenerConfiguration = ((ListenerConfig.Builder)((ListenerConfig.Builder)((ListenerConfig.Builder)((ListenerConfig.Builder)((ListenerConfig.Builder)((ListenerConfig.Builder)((ListenerConfig.Builder)ListenerConfig.builder().name("@default")).host(peerInfo.host())).port(peerInfo.port())).listenerContext(Context.builder().id("test-direct-listener").build())).mediaContext(MediaContext.create())).contentEncoding(ContentEncodingContext.create())).directHandlers(DirectHandlers.create())).build();
    }

    public PeerInfo remotePeer() {
        return this.serverSocket.remotePeer();
    }

    public PeerInfo localPeer() {
        return this.serverSocket.localPeer();
    }

    public boolean isSecure() {
        return this.serverSocket.isSecure();
    }

    public String socketId() {
        return this.serverSocket.socketId();
    }

    public String childSocketId() {
        return this.serverSocket.childSocketId();
    }

    public ListenerContext listenerContext() {
        return this;
    }

    public ExecutorService executor() {
        return this.executorService;
    }

    public DataWriter dataWriter() {
        return this.serverWriter;
    }

    public DataReader dataReader() {
        return this.serverReader;
    }

    public Router router() {
        return this.router;
    }

    public Context context() {
        return (Context)this.listenerConfiguration.listenerContext().get();
    }

    public MediaContext mediaContext() {
        return (MediaContext)this.listenerConfiguration.mediaContext().get();
    }

    public ContentEncodingContext contentEncodingContext() {
        return (ContentEncodingContext)this.listenerConfiguration.contentEncoding().get();
    }

    public DirectHandlers directHandlers() {
        return (DirectHandlers)this.listenerConfiguration.directHandlers().get();
    }

    public ListenerConfig config() {
        return this.listenerConfiguration;
    }

    public HelidonSocket serverSocket() {
        return this.serverSocket;
    }
}

