/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.testing.junit5;

import io.helidon.testing.junit5.TestJunitExtension;
import io.helidon.webserver.WebServerConfig;
import io.helidon.webserver.spi.ServerFeature;
import io.helidon.webserver.testing.junit5.AfterStop;
import io.helidon.webserver.testing.junit5.Junit5Util;
import io.helidon.webserver.testing.junit5.SetUpFeatures;
import io.helidon.webserver.testing.junit5.SetUpServer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

abstract class JunitExtensionBase
extends TestJunitExtension
implements AfterAllCallback {
    private Class<?> testClass;

    JunitExtensionBase() {
    }

    public void afterAll(ExtensionContext extensionContext) {
        this.callAfterStop();
        super.afterAll(extensionContext);
    }

    void setupServer(WebServerConfig.Builder builder) {
        Junit5Util.withStaticMethods(this.testClass(), SetUpServer.class, (setUpServer, method) -> {
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (parameterTypes.length != 1) {
                throw new IllegalArgumentException("Method " + String.valueOf(method) + " annotated with " + SetUpServer.class.getSimpleName() + " does not have exactly one parameter (WebServerConfig.Builder)");
            }
            if (!parameterTypes[0].equals(WebServerConfig.Builder.class)) {
                throw new IllegalArgumentException("Method " + String.valueOf(method) + " annotated with " + SetUpServer.class.getSimpleName() + " does not have exactly one parameter (WebServerConfig.Builder)");
            }
            if (!Modifier.isStatic(method.getModifiers())) {
                throw new IllegalArgumentException("Method " + String.valueOf(method) + " annotated with " + SetUpServer.class.getSimpleName() + " is not static");
            }
            try {
                method.setAccessible(true);
                method.invoke(null, builder);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalStateException("Could not invoke method " + String.valueOf(method), e);
            }
        });
    }

    void setupFeatures(WebServerConfig.Builder builder) {
        Junit5Util.withStaticMethods(this.testClass(), SetUpFeatures.class, (setUpFeatures, method) -> {
            List features;
            Object result;
            Class<?>[] parameterTypes;
            if (!setUpFeatures.value()) {
                builder.featuresDiscoverServices(false);
            }
            if ((parameterTypes = method.getParameterTypes()).length != 0) {
                throw new IllegalArgumentException("Method " + String.valueOf(method) + " annotated with " + SetUpFeatures.class.getSimpleName() + " has parameter(s), which is not allowed. It should return  List<ServerFeature>.");
            }
            if (!Modifier.isStatic(method.getModifiers())) {
                throw new IllegalArgumentException("Method " + String.valueOf(method) + " annotated with " + SetUpFeatures.class.getSimpleName() + " is not static");
            }
            try {
                method.setAccessible(true);
                result = method.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalStateException("Could not invoke method " + String.valueOf(method), e);
            }
            try {
                features = (List)result;
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("Method " + String.valueOf(method) + " annotated with " + SetUpFeatures.class.getSimpleName() + " returned a result that is not a List. Supported is List<? extends ServerFeature>.", e);
            }
            try {
                for (ServerFeature feature : features) {
                    builder.addFeature(feature);
                }
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("Method " + String.valueOf(method) + " annotated with " + SetUpFeatures.class.getSimpleName() + " returned a result that is a List, but an element was not a ServerFeature.", e);
            }
        });
    }

    void testClass(Class<?> testClass) {
        this.testClass = testClass;
    }

    Class<?> testClass() {
        return this.testClass;
    }

    private void callAfterStop() {
        if (this.testClass == null) {
            return;
        }
        ArrayList<Method> toInvoke = new ArrayList<Method>();
        Method[] methods = this.testClass.getMethods();
        for (Method method : methods) {
            AfterStop annotation = method.getAnnotation(AfterStop.class);
            if (annotation == null) continue;
            if (method.getParameterCount() != 0) {
                throw new IllegalStateException("Method " + String.valueOf(method) + " is annotated with @AfterStop, but it has parameters");
            }
            if (Modifier.isStatic(method.getModifiers())) {
                method.setAccessible(true);
                toInvoke.add(method);
                continue;
            }
            throw new IllegalStateException("Method " + String.valueOf(method) + " is annotated with @AfterStop, but it is not static");
        }
        for (Method method : toInvoke) {
            try {
                method.invoke(this.testClass, new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to invoke method: " + String.valueOf(method), e);
            }
        }
    }
}

